package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;
import java.util.UUID;

@JsonPropertyOrder({
    "@odata.type", 
    "SystemUserId", 
    "AzureActiveDirectoryObjectId", 
    "Name"})
@JsonInclude(Include.NON_NULL)
public class UserDetails implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("SystemUserId")
    protected UUID systemUserId;

    @JsonProperty("AzureActiveDirectoryObjectId")
    protected UUID azureActiveDirectoryObjectId;

    @JsonProperty("Name")
    protected String name;

    protected UserDetails() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.UserDetails";
    }

    @Property(name="SystemUserId")
    @JsonIgnore
    public Optional<UUID> getSystemUserId() {
        return Optional.ofNullable(systemUserId);
    }

    public UserDetails withSystemUserId(UUID systemUserId) {
        UserDetails _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.UserDetails");
        _x.systemUserId = systemUserId;
        return _x;
    }

    @Property(name="AzureActiveDirectoryObjectId")
    @JsonIgnore
    public Optional<UUID> getAzureActiveDirectoryObjectId() {
        return Optional.ofNullable(azureActiveDirectoryObjectId);
    }

    public UserDetails withAzureActiveDirectoryObjectId(UUID azureActiveDirectoryObjectId) {
        UserDetails _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.UserDetails");
        _x.azureActiveDirectoryObjectId = azureActiveDirectoryObjectId;
        return _x;
    }

    @Property(name="Name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public UserDetails withName(String name) {
        Checks.checkIsAscii(name);
        UserDetails _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.UserDetails");
        _x.name = name;
        return _x;
    }

    public UserDetails withUnmappedField(String name, String value) {
        UserDetails _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private UUID systemUserId;
        private UUID azureActiveDirectoryObjectId;
        private String name;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder systemUserId(UUID systemUserId) {
            this.systemUserId = systemUserId;
            this.changedFields = changedFields.add("SystemUserId");
            return this;
        }

        public Builder azureActiveDirectoryObjectId(UUID azureActiveDirectoryObjectId) {
            this.azureActiveDirectoryObjectId = azureActiveDirectoryObjectId;
            this.changedFields = changedFields.add("AzureActiveDirectoryObjectId");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("Name");
            return this;
        }

        public UserDetails build() {
            UserDetails _x = new UserDetails();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.UserDetails";
            _x.systemUserId = systemUserId;
            _x.azureActiveDirectoryObjectId = azureActiveDirectoryObjectId;
            _x.name = name;
            return _x;
        }
    }

    private UserDetails _copy() {
        UserDetails _x = new UserDetails();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.systemUserId = systemUserId;
        _x.azureActiveDirectoryObjectId = azureActiveDirectoryObjectId;
        _x.name = name;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("UserDetails[");
        b.append("SystemUserId=");
        b.append(this.systemUserId);
        b.append(", ");
        b.append("AzureActiveDirectoryObjectId=");
        b.append(this.azureActiveDirectoryObjectId);
        b.append(", ");
        b.append("Name=");
        b.append(this.name);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
