package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;

@JsonPropertyOrder({
    "@odata.type", 
    "OldRolePrivileges", 
    "NewRolePrivileges", 
    "InvalidNewPrivileges"})
@JsonInclude(Include.NON_NULL)
public class RolePrivilegeAuditDetail extends AuditDetail implements ODataType {

    @JsonProperty("OldRolePrivileges")
    protected List<RolePrivilege> oldRolePrivileges;

    @JsonProperty("OldRolePrivileges@nextLink")
    protected String oldRolePrivilegesNextLink;

    @JsonProperty("NewRolePrivileges")
    protected List<RolePrivilege> newRolePrivileges;

    @JsonProperty("NewRolePrivileges@nextLink")
    protected String newRolePrivilegesNextLink;

    @JsonProperty("InvalidNewPrivileges")
    protected List<UUID> invalidNewPrivileges;

    @JsonProperty("InvalidNewPrivileges@nextLink")
    protected String invalidNewPrivilegesNextLink;

    protected RolePrivilegeAuditDetail() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.RolePrivilegeAuditDetail";
    }

    @Property(name="OldRolePrivileges")
    @JsonIgnore
    public CollectionPage<RolePrivilege> getOldRolePrivileges() {
        return new CollectionPage<RolePrivilege>(contextPath, RolePrivilege.class, this.oldRolePrivileges, Optional.ofNullable(oldRolePrivilegesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="OldRolePrivileges")
    @JsonIgnore
    public CollectionPage<RolePrivilege> getOldRolePrivileges(HttpRequestOptions options) {
        return new CollectionPage<RolePrivilege>(contextPath, RolePrivilege.class, this.oldRolePrivileges, Optional.ofNullable(oldRolePrivilegesNextLink), Collections.emptyList(), options);
    }

    @Property(name="NewRolePrivileges")
    @JsonIgnore
    public CollectionPage<RolePrivilege> getNewRolePrivileges() {
        return new CollectionPage<RolePrivilege>(contextPath, RolePrivilege.class, this.newRolePrivileges, Optional.ofNullable(newRolePrivilegesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="NewRolePrivileges")
    @JsonIgnore
    public CollectionPage<RolePrivilege> getNewRolePrivileges(HttpRequestOptions options) {
        return new CollectionPage<RolePrivilege>(contextPath, RolePrivilege.class, this.newRolePrivileges, Optional.ofNullable(newRolePrivilegesNextLink), Collections.emptyList(), options);
    }

    @Property(name="InvalidNewPrivileges")
    @JsonIgnore
    public CollectionPage<UUID> getInvalidNewPrivileges() {
        return new CollectionPage<UUID>(contextPath, UUID.class, this.invalidNewPrivileges, Optional.ofNullable(invalidNewPrivilegesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="InvalidNewPrivileges")
    @JsonIgnore
    public CollectionPage<UUID> getInvalidNewPrivileges(HttpRequestOptions options) {
        return new CollectionPage<UUID>(contextPath, UUID.class, this.invalidNewPrivileges, Optional.ofNullable(invalidNewPrivilegesNextLink), Collections.emptyList(), options);
    }

    public RolePrivilegeAuditDetail withUnmappedField(String name, String value) {
        RolePrivilegeAuditDetail _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderRolePrivilegeAuditDetail() {
        return new Builder();
    }

    public static final class Builder {
        private List<RolePrivilege> oldRolePrivileges;
        private String oldRolePrivilegesNextLink;
        private List<RolePrivilege> newRolePrivileges;
        private String newRolePrivilegesNextLink;
        private List<UUID> invalidNewPrivileges;
        private String invalidNewPrivilegesNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder oldRolePrivileges(List<RolePrivilege> oldRolePrivileges) {
            this.oldRolePrivileges = oldRolePrivileges;
            this.changedFields = changedFields.add("OldRolePrivileges");
            return this;
        }

        public Builder oldRolePrivileges(RolePrivilege... oldRolePrivileges) {
            return oldRolePrivileges(Arrays.asList(oldRolePrivileges));
        }

        public Builder oldRolePrivilegesNextLink(String oldRolePrivilegesNextLink) {
            this.oldRolePrivilegesNextLink = oldRolePrivilegesNextLink;
            this.changedFields = changedFields.add("OldRolePrivileges");
            return this;
        }

        public Builder newRolePrivileges(List<RolePrivilege> newRolePrivileges) {
            this.newRolePrivileges = newRolePrivileges;
            this.changedFields = changedFields.add("NewRolePrivileges");
            return this;
        }

        public Builder newRolePrivileges(RolePrivilege... newRolePrivileges) {
            return newRolePrivileges(Arrays.asList(newRolePrivileges));
        }

        public Builder newRolePrivilegesNextLink(String newRolePrivilegesNextLink) {
            this.newRolePrivilegesNextLink = newRolePrivilegesNextLink;
            this.changedFields = changedFields.add("NewRolePrivileges");
            return this;
        }

        public Builder invalidNewPrivileges(List<UUID> invalidNewPrivileges) {
            this.invalidNewPrivileges = invalidNewPrivileges;
            this.changedFields = changedFields.add("InvalidNewPrivileges");
            return this;
        }

        public Builder invalidNewPrivileges(UUID... invalidNewPrivileges) {
            return invalidNewPrivileges(Arrays.asList(invalidNewPrivileges));
        }

        public Builder invalidNewPrivilegesNextLink(String invalidNewPrivilegesNextLink) {
            this.invalidNewPrivilegesNextLink = invalidNewPrivilegesNextLink;
            this.changedFields = changedFields.add("InvalidNewPrivileges");
            return this;
        }

        public RolePrivilegeAuditDetail build() {
            RolePrivilegeAuditDetail _x = new RolePrivilegeAuditDetail();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.RolePrivilegeAuditDetail";
            _x.oldRolePrivileges = oldRolePrivileges;
            _x.oldRolePrivilegesNextLink = oldRolePrivilegesNextLink;
            _x.newRolePrivileges = newRolePrivileges;
            _x.newRolePrivilegesNextLink = newRolePrivilegesNextLink;
            _x.invalidNewPrivileges = invalidNewPrivileges;
            _x.invalidNewPrivilegesNextLink = invalidNewPrivilegesNextLink;
            return _x;
        }
    }

    private RolePrivilegeAuditDetail _copy() {
        RolePrivilegeAuditDetail _x = new RolePrivilegeAuditDetail();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.oldRolePrivileges = oldRolePrivileges;
        _x.newRolePrivileges = newRolePrivileges;
        _x.invalidNewPrivileges = invalidNewPrivileges;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("RolePrivilegeAuditDetail[");
        b.append("OldRolePrivileges=");
        b.append(this.oldRolePrivileges);
        b.append(", ");
        b.append("NewRolePrivileges=");
        b.append(this.newRolePrivileges);
        b.append(", ");
        b.append("InvalidNewPrivileges=");
        b.append(this.invalidNewPrivileges);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
