package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "MissingComponents"})
@JsonInclude(Include.NON_NULL)
public class RetrieveMissingComponentsResponse implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("MissingComponents")
    protected List<MissingComponent> missingComponents;

    @JsonProperty("MissingComponents@nextLink")
    protected String missingComponentsNextLink;

    protected RetrieveMissingComponentsResponse() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.RetrieveMissingComponentsResponse";
    }

    @Property(name="MissingComponents")
    @JsonIgnore
    public CollectionPage<MissingComponent> getMissingComponents() {
        return new CollectionPage<MissingComponent>(contextPath, MissingComponent.class, this.missingComponents, Optional.ofNullable(missingComponentsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="MissingComponents")
    @JsonIgnore
    public CollectionPage<MissingComponent> getMissingComponents(HttpRequestOptions options) {
        return new CollectionPage<MissingComponent>(contextPath, MissingComponent.class, this.missingComponents, Optional.ofNullable(missingComponentsNextLink), Collections.emptyList(), options);
    }

    public RetrieveMissingComponentsResponse withUnmappedField(String name, String value) {
        RetrieveMissingComponentsResponse _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<MissingComponent> missingComponents;
        private String missingComponentsNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder missingComponents(List<MissingComponent> missingComponents) {
            this.missingComponents = missingComponents;
            this.changedFields = changedFields.add("MissingComponents");
            return this;
        }

        public Builder missingComponents(MissingComponent... missingComponents) {
            return missingComponents(Arrays.asList(missingComponents));
        }

        public Builder missingComponentsNextLink(String missingComponentsNextLink) {
            this.missingComponentsNextLink = missingComponentsNextLink;
            this.changedFields = changedFields.add("MissingComponents");
            return this;
        }

        public RetrieveMissingComponentsResponse build() {
            RetrieveMissingComponentsResponse _x = new RetrieveMissingComponentsResponse();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.RetrieveMissingComponentsResponse";
            _x.missingComponents = missingComponents;
            _x.missingComponentsNextLink = missingComponentsNextLink;
            return _x;
        }
    }

    private RetrieveMissingComponentsResponse _copy() {
        RetrieveMissingComponentsResponse _x = new RetrieveMissingComponentsResponse();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.missingComponents = missingComponents;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("RetrieveMissingComponentsResponse[");
        b.append("MissingComponents=");
        b.append(this.missingComponents);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
