package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;
import java.util.UUID;

@JsonPropertyOrder({
    "@odata.type", 
    "ResourceId", 
    "ResourceSpecId"})
@JsonInclude(Include.NON_NULL)
public class RequiredResource implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("ResourceId")
    protected UUID resourceId;

    @JsonProperty("ResourceSpecId")
    protected UUID resourceSpecId;

    protected RequiredResource() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.RequiredResource";
    }

    @Property(name="ResourceId")
    @JsonIgnore
    public Optional<UUID> getResourceId() {
        return Optional.ofNullable(resourceId);
    }

    public RequiredResource withResourceId(UUID resourceId) {
        RequiredResource _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.RequiredResource");
        _x.resourceId = resourceId;
        return _x;
    }

    @Property(name="ResourceSpecId")
    @JsonIgnore
    public Optional<UUID> getResourceSpecId() {
        return Optional.ofNullable(resourceSpecId);
    }

    public RequiredResource withResourceSpecId(UUID resourceSpecId) {
        RequiredResource _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.RequiredResource");
        _x.resourceSpecId = resourceSpecId;
        return _x;
    }

    public RequiredResource withUnmappedField(String name, String value) {
        RequiredResource _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private UUID resourceId;
        private UUID resourceSpecId;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder resourceId(UUID resourceId) {
            this.resourceId = resourceId;
            this.changedFields = changedFields.add("ResourceId");
            return this;
        }

        public Builder resourceSpecId(UUID resourceSpecId) {
            this.resourceSpecId = resourceSpecId;
            this.changedFields = changedFields.add("ResourceSpecId");
            return this;
        }

        public RequiredResource build() {
            RequiredResource _x = new RequiredResource();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.RequiredResource";
            _x.resourceId = resourceId;
            _x.resourceSpecId = resourceSpecId;
            return _x;
        }
    }

    private RequiredResource _copy() {
        RequiredResource _x = new RequiredResource();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.resourceId = resourceId;
        _x.resourceSpecId = resourceSpecId;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("RequiredResource[");
        b.append("ResourceId=");
        b.append(this.resourceId);
        b.append(", ");
        b.append("ResourceSpecId=");
        b.append(this.resourceSpecId);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
