package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;
import java.util.UUID;

@JsonPropertyOrder({
    "@odata.type", 
    "EntityLogicalName", 
    "ViewId", 
    "CustomFilter", 
    "RelationshipName", 
    "FetchXml", 
    "LayoutJson", 
    "PagingInfo"})
@JsonInclude(Include.NON_NULL)
public class LookupEntityInfo implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("EntityLogicalName")
    protected String entityLogicalName;

    @JsonProperty("ViewId")
    protected UUID viewId;

    @JsonProperty("CustomFilter")
    protected String customFilter;

    @JsonProperty("RelationshipName")
    protected String relationshipName;

    @JsonProperty("FetchXml")
    protected String fetchXml;

    @JsonProperty("LayoutJson")
    protected String layoutJson;

    @JsonProperty("PagingInfo")
    protected PagingInfo pagingInfo;

    protected LookupEntityInfo() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.LookupEntityInfo";
    }

    @Property(name="EntityLogicalName")
    @JsonIgnore
    public Optional<String> getEntityLogicalName() {
        return Optional.ofNullable(entityLogicalName);
    }

    public LookupEntityInfo withEntityLogicalName(String entityLogicalName) {
        Checks.checkIsAscii(entityLogicalName);
        LookupEntityInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.LookupEntityInfo");
        _x.entityLogicalName = entityLogicalName;
        return _x;
    }

    @Property(name="ViewId")
    @JsonIgnore
    public Optional<UUID> getViewId() {
        return Optional.ofNullable(viewId);
    }

    public LookupEntityInfo withViewId(UUID viewId) {
        LookupEntityInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.LookupEntityInfo");
        _x.viewId = viewId;
        return _x;
    }

    @Property(name="CustomFilter")
    @JsonIgnore
    public Optional<String> getCustomFilter() {
        return Optional.ofNullable(customFilter);
    }

    public LookupEntityInfo withCustomFilter(String customFilter) {
        Checks.checkIsAscii(customFilter);
        LookupEntityInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.LookupEntityInfo");
        _x.customFilter = customFilter;
        return _x;
    }

    @Property(name="RelationshipName")
    @JsonIgnore
    public Optional<String> getRelationshipName() {
        return Optional.ofNullable(relationshipName);
    }

    public LookupEntityInfo withRelationshipName(String relationshipName) {
        Checks.checkIsAscii(relationshipName);
        LookupEntityInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.LookupEntityInfo");
        _x.relationshipName = relationshipName;
        return _x;
    }

    @Property(name="FetchXml")
    @JsonIgnore
    public Optional<String> getFetchXml() {
        return Optional.ofNullable(fetchXml);
    }

    public LookupEntityInfo withFetchXml(String fetchXml) {
        Checks.checkIsAscii(fetchXml);
        LookupEntityInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.LookupEntityInfo");
        _x.fetchXml = fetchXml;
        return _x;
    }

    @Property(name="LayoutJson")
    @JsonIgnore
    public Optional<String> getLayoutJson() {
        return Optional.ofNullable(layoutJson);
    }

    public LookupEntityInfo withLayoutJson(String layoutJson) {
        Checks.checkIsAscii(layoutJson);
        LookupEntityInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.LookupEntityInfo");
        _x.layoutJson = layoutJson;
        return _x;
    }

    @Property(name="PagingInfo")
    @JsonIgnore
    public Optional<PagingInfo> getPagingInfo() {
        return Optional.ofNullable(pagingInfo);
    }

    public LookupEntityInfo withPagingInfo(PagingInfo pagingInfo) {
        LookupEntityInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.LookupEntityInfo");
        _x.pagingInfo = pagingInfo;
        return _x;
    }

    public LookupEntityInfo withUnmappedField(String name, String value) {
        LookupEntityInfo _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String entityLogicalName;
        private UUID viewId;
        private String customFilter;
        private String relationshipName;
        private String fetchXml;
        private String layoutJson;
        private PagingInfo pagingInfo;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder entityLogicalName(String entityLogicalName) {
            this.entityLogicalName = entityLogicalName;
            this.changedFields = changedFields.add("EntityLogicalName");
            return this;
        }

        public Builder viewId(UUID viewId) {
            this.viewId = viewId;
            this.changedFields = changedFields.add("ViewId");
            return this;
        }

        public Builder customFilter(String customFilter) {
            this.customFilter = customFilter;
            this.changedFields = changedFields.add("CustomFilter");
            return this;
        }

        public Builder relationshipName(String relationshipName) {
            this.relationshipName = relationshipName;
            this.changedFields = changedFields.add("RelationshipName");
            return this;
        }

        public Builder fetchXml(String fetchXml) {
            this.fetchXml = fetchXml;
            this.changedFields = changedFields.add("FetchXml");
            return this;
        }

        public Builder layoutJson(String layoutJson) {
            this.layoutJson = layoutJson;
            this.changedFields = changedFields.add("LayoutJson");
            return this;
        }

        public Builder pagingInfo(PagingInfo pagingInfo) {
            this.pagingInfo = pagingInfo;
            this.changedFields = changedFields.add("PagingInfo");
            return this;
        }

        public LookupEntityInfo build() {
            LookupEntityInfo _x = new LookupEntityInfo();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.LookupEntityInfo";
            _x.entityLogicalName = entityLogicalName;
            _x.viewId = viewId;
            _x.customFilter = customFilter;
            _x.relationshipName = relationshipName;
            _x.fetchXml = fetchXml;
            _x.layoutJson = layoutJson;
            _x.pagingInfo = pagingInfo;
            return _x;
        }
    }

    private LookupEntityInfo _copy() {
        LookupEntityInfo _x = new LookupEntityInfo();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.entityLogicalName = entityLogicalName;
        _x.viewId = viewId;
        _x.customFilter = customFilter;
        _x.relationshipName = relationshipName;
        _x.fetchXml = fetchXml;
        _x.layoutJson = layoutJson;
        _x.pagingInfo = pagingInfo;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("LookupEntityInfo[");
        b.append("EntityLogicalName=");
        b.append(this.entityLogicalName);
        b.append(", ");
        b.append("ViewId=");
        b.append(this.viewId);
        b.append(", ");
        b.append("CustomFilter=");
        b.append(this.customFilter);
        b.append(", ");
        b.append("RelationshipName=");
        b.append(this.relationshipName);
        b.append(", ");
        b.append("FetchXml=");
        b.append(this.fetchXml);
        b.append(", ");
        b.append("LayoutJson=");
        b.append(this.layoutJson);
        b.append(", ");
        b.append("PagingInfo=");
        b.append(this.pagingInfo);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
