package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "Columns"})
@JsonInclude(Include.NON_NULL)
public class GetHeaderColumnsImportFileResponse implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("Columns")
    protected List<String> columns;

    @JsonProperty("Columns@nextLink")
    protected String columnsNextLink;

    protected GetHeaderColumnsImportFileResponse() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.GetHeaderColumnsImportFileResponse";
    }

    @Property(name="Columns")
    @JsonIgnore
    public CollectionPage<String> getColumns() {
        return new CollectionPage<String>(contextPath, String.class, this.columns, Optional.ofNullable(columnsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="Columns")
    @JsonIgnore
    public CollectionPage<String> getColumns(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.columns, Optional.ofNullable(columnsNextLink), Collections.emptyList(), options);
    }

    public GetHeaderColumnsImportFileResponse withUnmappedField(String name, String value) {
        GetHeaderColumnsImportFileResponse _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<String> columns;
        private String columnsNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder columns(List<String> columns) {
            this.columns = columns;
            this.changedFields = changedFields.add("Columns");
            return this;
        }

        public Builder columns(String... columns) {
            return columns(Arrays.asList(columns));
        }

        public Builder columnsNextLink(String columnsNextLink) {
            this.columnsNextLink = columnsNextLink;
            this.changedFields = changedFields.add("Columns");
            return this;
        }

        public GetHeaderColumnsImportFileResponse build() {
            GetHeaderColumnsImportFileResponse _x = new GetHeaderColumnsImportFileResponse();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.GetHeaderColumnsImportFileResponse";
            _x.columns = columns;
            _x.columnsNextLink = columnsNextLink;
            return _x;
        }
    }

    private GetHeaderColumnsImportFileResponse _copy() {
        GetHeaderColumnsImportFileResponse _x = new GetHeaderColumnsImportFileResponse();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.columns = columns;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("GetHeaderColumnsImportFileResponse[");
        b.append("Columns=");
        b.append(this.columns);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
