package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;
import java.util.UUID;

@JsonPropertyOrder({
    "@odata.type", 
    "AsyncOperationId", 
    "ExportJobId"})
@JsonInclude(Include.NON_NULL)
public class ExportSolutionAsyncResponse implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("AsyncOperationId")
    protected UUID asyncOperationId;

    @JsonProperty("ExportJobId")
    protected UUID exportJobId;

    protected ExportSolutionAsyncResponse() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.ExportSolutionAsyncResponse";
    }

    @Property(name="AsyncOperationId")
    @JsonIgnore
    public Optional<UUID> getAsyncOperationId() {
        return Optional.ofNullable(asyncOperationId);
    }

    public ExportSolutionAsyncResponse withAsyncOperationId(UUID asyncOperationId) {
        ExportSolutionAsyncResponse _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ExportSolutionAsyncResponse");
        _x.asyncOperationId = asyncOperationId;
        return _x;
    }

    @Property(name="ExportJobId")
    @JsonIgnore
    public Optional<UUID> getExportJobId() {
        return Optional.ofNullable(exportJobId);
    }

    public ExportSolutionAsyncResponse withExportJobId(UUID exportJobId) {
        ExportSolutionAsyncResponse _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ExportSolutionAsyncResponse");
        _x.exportJobId = exportJobId;
        return _x;
    }

    public ExportSolutionAsyncResponse withUnmappedField(String name, String value) {
        ExportSolutionAsyncResponse _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private UUID asyncOperationId;
        private UUID exportJobId;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder asyncOperationId(UUID asyncOperationId) {
            this.asyncOperationId = asyncOperationId;
            this.changedFields = changedFields.add("AsyncOperationId");
            return this;
        }

        public Builder exportJobId(UUID exportJobId) {
            this.exportJobId = exportJobId;
            this.changedFields = changedFields.add("ExportJobId");
            return this;
        }

        public ExportSolutionAsyncResponse build() {
            ExportSolutionAsyncResponse _x = new ExportSolutionAsyncResponse();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.ExportSolutionAsyncResponse";
            _x.asyncOperationId = asyncOperationId;
            _x.exportJobId = exportJobId;
            return _x;
        }
    }

    private ExportSolutionAsyncResponse _copy() {
        ExportSolutionAsyncResponse _x = new ExportSolutionAsyncResponse();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.asyncOperationId = asyncOperationId;
        _x.exportJobId = exportJobId;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ExportSolutionAsyncResponse[");
        b.append("AsyncOperationId=");
        b.append(this.asyncOperationId);
        b.append(", ");
        b.append("ExportJobId=");
        b.append(this.exportJobId);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
