package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;

@JsonPropertyOrder({
    "@odata.type", 
    "RelationshipIds", 
    "AttributeId"})
@JsonInclude(Include.NON_NULL)
public class CreateCustomerRelationshipsResponse implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("RelationshipIds")
    protected List<UUID> relationshipIds;

    @JsonProperty("RelationshipIds@nextLink")
    protected String relationshipIdsNextLink;

    @JsonProperty("AttributeId")
    protected UUID attributeId;

    protected CreateCustomerRelationshipsResponse() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.CreateCustomerRelationshipsResponse";
    }

    @Property(name="RelationshipIds")
    @JsonIgnore
    public CollectionPage<UUID> getRelationshipIds() {
        return new CollectionPage<UUID>(contextPath, UUID.class, this.relationshipIds, Optional.ofNullable(relationshipIdsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="RelationshipIds")
    @JsonIgnore
    public CollectionPage<UUID> getRelationshipIds(HttpRequestOptions options) {
        return new CollectionPage<UUID>(contextPath, UUID.class, this.relationshipIds, Optional.ofNullable(relationshipIdsNextLink), Collections.emptyList(), options);
    }

    @Property(name="AttributeId")
    @JsonIgnore
    public Optional<UUID> getAttributeId() {
        return Optional.ofNullable(attributeId);
    }

    public CreateCustomerRelationshipsResponse withAttributeId(UUID attributeId) {
        CreateCustomerRelationshipsResponse _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.CreateCustomerRelationshipsResponse");
        _x.attributeId = attributeId;
        return _x;
    }

    public CreateCustomerRelationshipsResponse withUnmappedField(String name, String value) {
        CreateCustomerRelationshipsResponse _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<UUID> relationshipIds;
        private String relationshipIdsNextLink;
        private UUID attributeId;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder relationshipIds(List<UUID> relationshipIds) {
            this.relationshipIds = relationshipIds;
            this.changedFields = changedFields.add("RelationshipIds");
            return this;
        }

        public Builder relationshipIds(UUID... relationshipIds) {
            return relationshipIds(Arrays.asList(relationshipIds));
        }

        public Builder relationshipIdsNextLink(String relationshipIdsNextLink) {
            this.relationshipIdsNextLink = relationshipIdsNextLink;
            this.changedFields = changedFields.add("RelationshipIds");
            return this;
        }

        public Builder attributeId(UUID attributeId) {
            this.attributeId = attributeId;
            this.changedFields = changedFields.add("AttributeId");
            return this;
        }

        public CreateCustomerRelationshipsResponse build() {
            CreateCustomerRelationshipsResponse _x = new CreateCustomerRelationshipsResponse();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.CreateCustomerRelationshipsResponse";
            _x.relationshipIds = relationshipIds;
            _x.relationshipIdsNextLink = relationshipIdsNextLink;
            _x.attributeId = attributeId;
            return _x;
        }
    }

    private CreateCustomerRelationshipsResponse _copy() {
        CreateCustomerRelationshipsResponse _x = new CreateCustomerRelationshipsResponse();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.relationshipIds = relationshipIds;
        _x.attributeId = attributeId;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("CreateCustomerRelationshipsResponse[");
        b.append("RelationshipIds=");
        b.append(this.relationshipIds);
        b.append(", ");
        b.append("AttributeId=");
        b.append(this.attributeId);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
