package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;
import java.util.UUID;

@JsonPropertyOrder({
    "@odata.type", 
    "DisplayName", 
    "SchemaName", 
    "ComponentType", 
    "ComponentSubType", 
    "ComponentId", 
    "ParentEntityId", 
    "ParentEntityName"})
@JsonInclude(Include.NON_NULL)
public class Component implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("DisplayName")
    protected String displayName;

    @JsonProperty("SchemaName")
    protected String schemaName;

    @JsonProperty("ComponentType")
    protected Integer componentType;

    @JsonProperty("ComponentSubType")
    protected Integer componentSubType;

    @JsonProperty("ComponentId")
    protected UUID componentId;

    @JsonProperty("ParentEntityId")
    protected UUID parentEntityId;

    @JsonProperty("ParentEntityName")
    protected String parentEntityName;

    protected Component() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.Component";
    }

    @Property(name="DisplayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public Component withDisplayName(String displayName) {
        Checks.checkIsAscii(displayName);
        Component _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.Component");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="SchemaName")
    @JsonIgnore
    public Optional<String> getSchemaName() {
        return Optional.ofNullable(schemaName);
    }

    public Component withSchemaName(String schemaName) {
        Checks.checkIsAscii(schemaName);
        Component _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.Component");
        _x.schemaName = schemaName;
        return _x;
    }

    @Property(name="ComponentType")
    @JsonIgnore
    public Optional<Integer> getComponentType() {
        return Optional.ofNullable(componentType);
    }

    public Component withComponentType(Integer componentType) {
        Component _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.Component");
        _x.componentType = componentType;
        return _x;
    }

    @Property(name="ComponentSubType")
    @JsonIgnore
    public Optional<Integer> getComponentSubType() {
        return Optional.ofNullable(componentSubType);
    }

    public Component withComponentSubType(Integer componentSubType) {
        Component _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.Component");
        _x.componentSubType = componentSubType;
        return _x;
    }

    @Property(name="ComponentId")
    @JsonIgnore
    public Optional<UUID> getComponentId() {
        return Optional.ofNullable(componentId);
    }

    public Component withComponentId(UUID componentId) {
        Component _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.Component");
        _x.componentId = componentId;
        return _x;
    }

    @Property(name="ParentEntityId")
    @JsonIgnore
    public Optional<UUID> getParentEntityId() {
        return Optional.ofNullable(parentEntityId);
    }

    public Component withParentEntityId(UUID parentEntityId) {
        Component _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.Component");
        _x.parentEntityId = parentEntityId;
        return _x;
    }

    @Property(name="ParentEntityName")
    @JsonIgnore
    public Optional<String> getParentEntityName() {
        return Optional.ofNullable(parentEntityName);
    }

    public Component withParentEntityName(String parentEntityName) {
        Checks.checkIsAscii(parentEntityName);
        Component _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.Component");
        _x.parentEntityName = parentEntityName;
        return _x;
    }

    public Component withUnmappedField(String name, String value) {
        Component _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String displayName;
        private String schemaName;
        private Integer componentType;
        private Integer componentSubType;
        private UUID componentId;
        private UUID parentEntityId;
        private String parentEntityName;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("DisplayName");
            return this;
        }

        public Builder schemaName(String schemaName) {
            this.schemaName = schemaName;
            this.changedFields = changedFields.add("SchemaName");
            return this;
        }

        public Builder componentType(Integer componentType) {
            this.componentType = componentType;
            this.changedFields = changedFields.add("ComponentType");
            return this;
        }

        public Builder componentSubType(Integer componentSubType) {
            this.componentSubType = componentSubType;
            this.changedFields = changedFields.add("ComponentSubType");
            return this;
        }

        public Builder componentId(UUID componentId) {
            this.componentId = componentId;
            this.changedFields = changedFields.add("ComponentId");
            return this;
        }

        public Builder parentEntityId(UUID parentEntityId) {
            this.parentEntityId = parentEntityId;
            this.changedFields = changedFields.add("ParentEntityId");
            return this;
        }

        public Builder parentEntityName(String parentEntityName) {
            this.parentEntityName = parentEntityName;
            this.changedFields = changedFields.add("ParentEntityName");
            return this;
        }

        public Component build() {
            Component _x = new Component();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.Component";
            _x.displayName = displayName;
            _x.schemaName = schemaName;
            _x.componentType = componentType;
            _x.componentSubType = componentSubType;
            _x.componentId = componentId;
            _x.parentEntityId = parentEntityId;
            _x.parentEntityName = parentEntityName;
            return _x;
        }
    }

    private Component _copy() {
        Component _x = new Component();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.displayName = displayName;
        _x.schemaName = schemaName;
        _x.componentType = componentType;
        _x.componentSubType = componentSubType;
        _x.componentId = componentId;
        _x.parentEntityId = parentEntityId;
        _x.parentEntityName = parentEntityName;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Component[");
        b.append("DisplayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("SchemaName=");
        b.append(this.schemaName);
        b.append(", ");
        b.append("ComponentType=");
        b.append(this.componentType);
        b.append(", ");
        b.append("ComponentSubType=");
        b.append(this.componentSubType);
        b.append(", ");
        b.append("ComponentId=");
        b.append(this.componentId);
        b.append(", ");
        b.append("ParentEntityId=");
        b.append(this.parentEntityId);
        b.append(", ");
        b.append("ParentEntityName=");
        b.append(this.parentEntityName);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
