package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;
import java.util.UUID;

@JsonPropertyOrder({
    "@odata.type", 
    "FileId", 
    "FileSizeInBytes"})
@JsonInclude(Include.NON_NULL)
public class CommitFileBlocksUploadResponse implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("FileId")
    protected UUID fileId;

    @JsonProperty("FileSizeInBytes")
    protected Long fileSizeInBytes;

    protected CommitFileBlocksUploadResponse() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.CommitFileBlocksUploadResponse";
    }

    @Property(name="FileId")
    @JsonIgnore
    public Optional<UUID> getFileId() {
        return Optional.ofNullable(fileId);
    }

    public CommitFileBlocksUploadResponse withFileId(UUID fileId) {
        CommitFileBlocksUploadResponse _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.CommitFileBlocksUploadResponse");
        _x.fileId = fileId;
        return _x;
    }

    @Property(name="FileSizeInBytes")
    @JsonIgnore
    public Optional<Long> getFileSizeInBytes() {
        return Optional.ofNullable(fileSizeInBytes);
    }

    public CommitFileBlocksUploadResponse withFileSizeInBytes(Long fileSizeInBytes) {
        CommitFileBlocksUploadResponse _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.CommitFileBlocksUploadResponse");
        _x.fileSizeInBytes = fileSizeInBytes;
        return _x;
    }

    public CommitFileBlocksUploadResponse withUnmappedField(String name, String value) {
        CommitFileBlocksUploadResponse _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private UUID fileId;
        private Long fileSizeInBytes;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder fileId(UUID fileId) {
            this.fileId = fileId;
            this.changedFields = changedFields.add("FileId");
            return this;
        }

        public Builder fileSizeInBytes(Long fileSizeInBytes) {
            this.fileSizeInBytes = fileSizeInBytes;
            this.changedFields = changedFields.add("FileSizeInBytes");
            return this;
        }

        public CommitFileBlocksUploadResponse build() {
            CommitFileBlocksUploadResponse _x = new CommitFileBlocksUploadResponse();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.CommitFileBlocksUploadResponse";
            _x.fileId = fileId;
            _x.fileSizeInBytes = fileSizeInBytes;
            return _x;
        }
    }

    private CommitFileBlocksUploadResponse _copy() {
        CommitFileBlocksUploadResponse _x = new CommitFileBlocksUploadResponse();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.fileId = fileId;
        _x.fileSizeInBytes = fileSizeInBytes;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("CommitFileBlocksUploadResponse[");
        b.append("FileId=");
        b.append(this.fileId);
        b.append(", ");
        b.append("FileSizeInBytes=");
        b.append(this.fileSizeInBytes);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
