package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;
import java.util.UUID;

@JsonPropertyOrder({
    "@odata.type", 
    "AnnotationId", 
    "FileSizeInBytes"})
@JsonInclude(Include.NON_NULL)
public class CommitAnnotationBlocksUploadResponse implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("AnnotationId")
    protected UUID annotationId;

    @JsonProperty("FileSizeInBytes")
    protected Integer fileSizeInBytes;

    protected CommitAnnotationBlocksUploadResponse() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.CommitAnnotationBlocksUploadResponse";
    }

    @Property(name="AnnotationId")
    @JsonIgnore
    public Optional<UUID> getAnnotationId() {
        return Optional.ofNullable(annotationId);
    }

    public CommitAnnotationBlocksUploadResponse withAnnotationId(UUID annotationId) {
        CommitAnnotationBlocksUploadResponse _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.CommitAnnotationBlocksUploadResponse");
        _x.annotationId = annotationId;
        return _x;
    }

    @Property(name="FileSizeInBytes")
    @JsonIgnore
    public Optional<Integer> getFileSizeInBytes() {
        return Optional.ofNullable(fileSizeInBytes);
    }

    public CommitAnnotationBlocksUploadResponse withFileSizeInBytes(Integer fileSizeInBytes) {
        CommitAnnotationBlocksUploadResponse _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.CommitAnnotationBlocksUploadResponse");
        _x.fileSizeInBytes = fileSizeInBytes;
        return _x;
    }

    public CommitAnnotationBlocksUploadResponse withUnmappedField(String name, String value) {
        CommitAnnotationBlocksUploadResponse _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private UUID annotationId;
        private Integer fileSizeInBytes;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder annotationId(UUID annotationId) {
            this.annotationId = annotationId;
            this.changedFields = changedFields.add("AnnotationId");
            return this;
        }

        public Builder fileSizeInBytes(Integer fileSizeInBytes) {
            this.fileSizeInBytes = fileSizeInBytes;
            this.changedFields = changedFields.add("FileSizeInBytes");
            return this;
        }

        public CommitAnnotationBlocksUploadResponse build() {
            CommitAnnotationBlocksUploadResponse _x = new CommitAnnotationBlocksUploadResponse();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.CommitAnnotationBlocksUploadResponse";
            _x.annotationId = annotationId;
            _x.fileSizeInBytes = fileSizeInBytes;
            return _x;
        }
    }

    private CommitAnnotationBlocksUploadResponse _copy() {
        CommitAnnotationBlocksUploadResponse _x = new CommitAnnotationBlocksUploadResponse();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.annotationId = annotationId;
        _x.fileSizeInBytes = fileSizeInBytes;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("CommitAnnotationBlocksUploadResponse[");
        b.append("AnnotationId=");
        b.append(this.annotationId);
        b.append(", ");
        b.append("FileSizeInBytes=");
        b.append(this.fileSizeInBytes);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
