package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.enums.ChannelAccessProfilePrivilegeDepth;

@JsonPropertyOrder({
    "@odata.type", 
    "ChannelAccessProfilePrivilegeId", 
    "PrivilegeDepth", 
    "PrivilegeName"})
@JsonInclude(Include.NON_NULL)
public class ChannelAccessProfilePrivilege implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("ChannelAccessProfilePrivilegeId")
    protected UUID channelAccessProfilePrivilegeId;

    @JsonProperty("PrivilegeDepth")
    protected ChannelAccessProfilePrivilegeDepth privilegeDepth;

    @JsonProperty("PrivilegeName")
    protected String privilegeName;

    protected ChannelAccessProfilePrivilege() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.ChannelAccessProfilePrivilege";
    }

    @Property(name="ChannelAccessProfilePrivilegeId")
    @JsonIgnore
    public Optional<UUID> getChannelAccessProfilePrivilegeId() {
        return Optional.ofNullable(channelAccessProfilePrivilegeId);
    }

    public ChannelAccessProfilePrivilege withChannelAccessProfilePrivilegeId(UUID channelAccessProfilePrivilegeId) {
        ChannelAccessProfilePrivilege _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ChannelAccessProfilePrivilege");
        _x.channelAccessProfilePrivilegeId = channelAccessProfilePrivilegeId;
        return _x;
    }

    @Property(name="PrivilegeDepth")
    @JsonIgnore
    public Optional<ChannelAccessProfilePrivilegeDepth> getPrivilegeDepth() {
        return Optional.ofNullable(privilegeDepth);
    }

    public ChannelAccessProfilePrivilege withPrivilegeDepth(ChannelAccessProfilePrivilegeDepth privilegeDepth) {
        ChannelAccessProfilePrivilege _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ChannelAccessProfilePrivilege");
        _x.privilegeDepth = privilegeDepth;
        return _x;
    }

    @Property(name="PrivilegeName")
    @JsonIgnore
    public Optional<String> getPrivilegeName() {
        return Optional.ofNullable(privilegeName);
    }

    public ChannelAccessProfilePrivilege withPrivilegeName(String privilegeName) {
        Checks.checkIsAscii(privilegeName);
        ChannelAccessProfilePrivilege _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ChannelAccessProfilePrivilege");
        _x.privilegeName = privilegeName;
        return _x;
    }

    public ChannelAccessProfilePrivilege withUnmappedField(String name, String value) {
        ChannelAccessProfilePrivilege _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private UUID channelAccessProfilePrivilegeId;
        private ChannelAccessProfilePrivilegeDepth privilegeDepth;
        private String privilegeName;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder channelAccessProfilePrivilegeId(UUID channelAccessProfilePrivilegeId) {
            this.channelAccessProfilePrivilegeId = channelAccessProfilePrivilegeId;
            this.changedFields = changedFields.add("ChannelAccessProfilePrivilegeId");
            return this;
        }

        public Builder privilegeDepth(ChannelAccessProfilePrivilegeDepth privilegeDepth) {
            this.privilegeDepth = privilegeDepth;
            this.changedFields = changedFields.add("PrivilegeDepth");
            return this;
        }

        public Builder privilegeName(String privilegeName) {
            this.privilegeName = privilegeName;
            this.changedFields = changedFields.add("PrivilegeName");
            return this;
        }

        public ChannelAccessProfilePrivilege build() {
            ChannelAccessProfilePrivilege _x = new ChannelAccessProfilePrivilege();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.ChannelAccessProfilePrivilege";
            _x.channelAccessProfilePrivilegeId = channelAccessProfilePrivilegeId;
            _x.privilegeDepth = privilegeDepth;
            _x.privilegeName = privilegeName;
            return _x;
        }
    }

    private ChannelAccessProfilePrivilege _copy() {
        ChannelAccessProfilePrivilege _x = new ChannelAccessProfilePrivilege();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.channelAccessProfilePrivilegeId = channelAccessProfilePrivilegeId;
        _x.privilegeDepth = privilegeDepth;
        _x.privilegeName = privilegeName;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ChannelAccessProfilePrivilege[");
        b.append("ChannelAccessProfilePrivilegeId=");
        b.append(this.channelAccessProfilePrivilegeId);
        b.append(", ");
        b.append("PrivilegeDepth=");
        b.append(this.privilegeDepth);
        b.append(", ");
        b.append("PrivilegeName=");
        b.append(this.privilegeName);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
