/*
 * Decompiled with CFR 0.152.
 */
package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;
import java.util.Optional;
import java.util.UUID;
import microsoft.dynamics.crm.entity.Crmbaseentity;
import microsoft.dynamics.crm.entity.collection.request.ActivitymimeattachmentCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;

@JsonPropertyOrder(value={"@odata.type", "mimetype", "filename", "prefix", "attachmentid", "body", "body_binary", "filesize", "subject", "versionnumber"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Attachment
extends Crmbaseentity
implements ODataEntityType {
    @JsonProperty(value="mimetype")
    protected String mimetype;
    @JsonProperty(value="filename")
    protected String filename;
    @JsonProperty(value="prefix")
    protected String prefix;
    @JsonProperty(value="attachmentid")
    protected UUID attachmentid;
    @JsonProperty(value="body")
    protected String body;
    @JsonProperty(value="body_binary")
    protected byte[] body_binary;
    @JsonProperty(value="filesize")
    protected Integer filesize;
    @JsonProperty(value="subject")
    protected String subject;
    @JsonProperty(value="versionnumber")
    protected Long versionnumber;

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.attachment";
    }

    protected Attachment() {
    }

    public static Builder builderAttachment() {
        return new Builder();
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return this.changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && this.attachmentid != null) {
            this.contextPath = this.contextPath.clearQueries().addKeys(new NameValue[]{new NameValue((Object)this.attachmentid, UUID.class)});
        }
    }

    @Property(name="mimetype")
    @JsonIgnore
    public Optional<String> getMimetype() {
        return Optional.ofNullable(this.mimetype);
    }

    public Attachment withMimetype(String mimetype) {
        Checks.checkIsAscii((String)mimetype);
        Attachment _x = this._copy();
        _x.changedFields = this.changedFields.add("mimetype");
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.attachment");
        _x.mimetype = mimetype;
        return _x;
    }

    @Property(name="filename")
    @JsonIgnore
    public Optional<String> getFilename() {
        return Optional.ofNullable(this.filename);
    }

    public Attachment withFilename(String filename) {
        Checks.checkIsAscii((String)filename);
        Attachment _x = this._copy();
        _x.changedFields = this.changedFields.add("filename");
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.attachment");
        _x.filename = filename;
        return _x;
    }

    @Property(name="prefix")
    @JsonIgnore
    public Optional<String> getPrefix() {
        return Optional.ofNullable(this.prefix);
    }

    public Attachment withPrefix(String prefix) {
        Checks.checkIsAscii((String)prefix);
        Attachment _x = this._copy();
        _x.changedFields = this.changedFields.add("prefix");
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.attachment");
        _x.prefix = prefix;
        return _x;
    }

    @Property(name="attachmentid")
    @JsonIgnore
    public Optional<UUID> getAttachmentid() {
        return Optional.ofNullable(this.attachmentid);
    }

    public Attachment withAttachmentid(UUID attachmentid) {
        Attachment _x = this._copy();
        _x.changedFields = this.changedFields.add("attachmentid");
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.attachment");
        _x.attachmentid = attachmentid;
        return _x;
    }

    @Property(name="body")
    @JsonIgnore
    public Optional<String> getBody() {
        return Optional.ofNullable(this.body);
    }

    public Attachment withBody(String body) {
        Checks.checkIsAscii((String)body);
        Attachment _x = this._copy();
        _x.changedFields = this.changedFields.add("body");
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.attachment");
        _x.body = body;
        return _x;
    }

    @Property(name="body_binary")
    @JsonIgnore
    public Optional<byte[]> getBody_binary() {
        return Optional.ofNullable(this.body_binary);
    }

    public Attachment withBody_binary(byte[] body_binary) {
        Attachment _x = this._copy();
        _x.changedFields = this.changedFields.add("body_binary");
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.attachment");
        _x.body_binary = body_binary;
        return _x;
    }

    @Property(name="filesize")
    @JsonIgnore
    public Optional<Integer> getFilesize() {
        return Optional.ofNullable(this.filesize);
    }

    public Attachment withFilesize(Integer filesize) {
        Attachment _x = this._copy();
        _x.changedFields = this.changedFields.add("filesize");
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.attachment");
        _x.filesize = filesize;
        return _x;
    }

    @Property(name="subject")
    @JsonIgnore
    public Optional<String> getSubject() {
        return Optional.ofNullable(this.subject);
    }

    public Attachment withSubject(String subject) {
        Checks.checkIsAscii((String)subject);
        Attachment _x = this._copy();
        _x.changedFields = this.changedFields.add("subject");
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.attachment");
        _x.subject = subject;
        return _x;
    }

    @Property(name="versionnumber")
    @JsonIgnore
    public Optional<Long> getVersionnumber() {
        return Optional.ofNullable(this.versionnumber);
    }

    public Attachment withVersionnumber(Long versionnumber) {
        Attachment _x = this._copy();
        _x.changedFields = this.changedFields.add("versionnumber");
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.attachment");
        _x.versionnumber = versionnumber;
        return _x;
    }

    @Override
    public Attachment withUnmappedField(String name, String value) {
        Attachment _x = this._copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="Attachment_SyncErrors")
    @JsonIgnore
    public SyncerrorCollectionRequest getAttachment_SyncErrors() {
        return new SyncerrorCollectionRequest(this.contextPath.addSegment("Attachment_SyncErrors"), RequestHelper.getValue((UnmappedFields)this.unmappedFields, (String)"Attachment_SyncErrors"));
    }

    @NavigationProperty(name="attachment_activity_mime_attachments")
    @JsonIgnore
    public ActivitymimeattachmentCollectionRequest getAttachment_activity_mime_attachments() {
        return new ActivitymimeattachmentCollectionRequest(this.contextPath.addSegment("attachment_activity_mime_attachments"), RequestHelper.getValue((UnmappedFields)this.unmappedFields, (String)"attachment_activity_mime_attachments"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (this.unmappedFields == null) {
            this.unmappedFields = new UnmappedFieldsImpl();
        }
        this.unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return this.unmappedFields == null ? UnmappedFieldsImpl.EMPTY : this.unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return this.unmappedFields();
    }

    @Override
    public Attachment patch() {
        RequestHelper.patch((ODataEntityType)this, (ContextPath)this.contextPath, (RequestOptions)RequestOptions.EMPTY);
        Attachment _x = this._copy();
        _x.changedFields = null;
        return _x;
    }

    @Override
    public Attachment put() {
        RequestHelper.put((ODataEntityType)this, (ContextPath)this.contextPath, (RequestOptions)RequestOptions.EMPTY);
        Attachment _x = this._copy();
        _x.changedFields = null;
        return _x;
    }

    private Attachment _copy() {
        Attachment _x = new Attachment();
        _x.contextPath = this.contextPath;
        _x.changedFields = this.changedFields;
        _x.unmappedFields = this.unmappedFields.copy();
        _x.odataType = this.odataType;
        _x.mimetype = this.mimetype;
        _x.filename = this.filename;
        _x.prefix = this.prefix;
        _x.attachmentid = this.attachmentid;
        _x.body = this.body;
        _x.body_binary = this.body_binary;
        _x.filesize = this.filesize;
        _x.subject = this.subject;
        _x.versionnumber = this.versionnumber;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Attachment[");
        b.append("mimetype=");
        b.append(this.mimetype);
        b.append(", ");
        b.append("filename=");
        b.append(this.filename);
        b.append(", ");
        b.append("prefix=");
        b.append(this.prefix);
        b.append(", ");
        b.append("attachmentid=");
        b.append(this.attachmentid);
        b.append(", ");
        b.append("body=");
        b.append(this.body);
        b.append(", ");
        b.append("body_binary=");
        b.append(this.body_binary);
        b.append(", ");
        b.append("filesize=");
        b.append(this.filesize);
        b.append(", ");
        b.append("subject=");
        b.append(this.subject);
        b.append(", ");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(this.unmappedFields);
        b.append(",odataType=");
        b.append(this.odataType);
        return b.toString();
    }

    public static final class Builder {
        private String mimetype;
        private String filename;
        private String prefix;
        private UUID attachmentid;
        private String body;
        private byte[] body_binary;
        private Integer filesize;
        private String subject;
        private Long versionnumber;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
        }

        public Builder mimetype(String mimetype) {
            this.mimetype = mimetype;
            this.changedFields = this.changedFields.add("mimetype");
            return this;
        }

        public Builder filename(String filename) {
            this.filename = filename;
            this.changedFields = this.changedFields.add("filename");
            return this;
        }

        public Builder prefix(String prefix) {
            this.prefix = prefix;
            this.changedFields = this.changedFields.add("prefix");
            return this;
        }

        public Builder attachmentid(UUID attachmentid) {
            this.attachmentid = attachmentid;
            this.changedFields = this.changedFields.add("attachmentid");
            return this;
        }

        public Builder body(String body) {
            this.body = body;
            this.changedFields = this.changedFields.add("body");
            return this;
        }

        public Builder body_binary(byte[] body_binary) {
            this.body_binary = body_binary;
            this.changedFields = this.changedFields.add("body_binary");
            return this;
        }

        public Builder filesize(Integer filesize) {
            this.filesize = filesize;
            this.changedFields = this.changedFields.add("filesize");
            return this;
        }

        public Builder subject(String subject) {
            this.subject = subject;
            this.changedFields = this.changedFields.add("subject");
            return this;
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = this.changedFields.add("versionnumber");
            return this;
        }

        public Attachment build() {
            Attachment _x = new Attachment();
            _x.contextPath = null;
            _x.changedFields = this.changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.attachment";
            _x.mimetype = this.mimetype;
            _x.filename = this.filename;
            _x.prefix = this.prefix;
            _x.attachmentid = this.attachmentid;
            _x.body = this.body;
            _x.body_binary = this.body_binary;
            _x.filesize = this.filesize;
            _x.subject = this.subject;
            _x.versionnumber = this.versionnumber;
            return _x;
        }
    }
}

