/*
 * Decompiled with CFR 0.152.
 */
package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;
import java.util.Optional;

@JsonPropertyOrder(value={"@odata.type", "Label", "Value"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class DependentOptionMetadata
implements ODataType {
    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;
    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;
    @JsonProperty(value="@odata.type")
    protected String odataType;
    @JsonProperty(value="Label")
    protected String label;
    @JsonProperty(value="Value")
    protected Integer value;

    protected DependentOptionMetadata() {
    }

    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.DependentOptionMetadata";
    }

    @Property(name="Label")
    @JsonIgnore
    public Optional<String> getLabel() {
        return Optional.ofNullable(this.label);
    }

    public DependentOptionMetadata withLabel(String label) {
        Checks.checkIsAscii((String)label);
        DependentOptionMetadata _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.DependentOptionMetadata");
        _x.label = label;
        return _x;
    }

    @Property(name="Value")
    @JsonIgnore
    public Optional<Integer> getValue() {
        return Optional.ofNullable(this.value);
    }

    public DependentOptionMetadata withValue(Integer value) {
        DependentOptionMetadata _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.DependentOptionMetadata");
        _x.value = value;
        return _x;
    }

    public DependentOptionMetadata withUnmappedField(String name, String value) {
        DependentOptionMetadata _x = this._copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (this.unmappedFields == null) {
            this.unmappedFields = new UnmappedFieldsImpl();
        }
        this.unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return this.unmappedFields == null ? UnmappedFieldsImpl.EMPTY : this.unmappedFields;
    }

    public UnmappedFields getUnmappedFields() {
        return this.unmappedFields();
    }

    public void postInject(boolean addKeysToContextPath) {
    }

    public static Builder builder() {
        return new Builder();
    }

    private DependentOptionMetadata _copy() {
        DependentOptionMetadata _x = new DependentOptionMetadata();
        _x.contextPath = this.contextPath;
        _x.unmappedFields = this.unmappedFields.copy();
        _x.odataType = this.odataType;
        _x.label = this.label;
        _x.value = this.value;
        return _x;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DependentOptionMetadata[");
        b.append("Label=");
        b.append(this.label);
        b.append(", ");
        b.append("Value=");
        b.append(this.value);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(this.unmappedFields);
        b.append(",odataType=");
        b.append(this.odataType);
        return b.toString();
    }

    public static final class Builder {
        private String label;
        private Integer value;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
        }

        public Builder label(String label) {
            this.label = label;
            this.changedFields = this.changedFields.add("Label");
            return this;
        }

        public Builder value(Integer value) {
            this.value = value;
            this.changedFields = this.changedFields.add("Value");
            return this;
        }

        public DependentOptionMetadata build() {
            DependentOptionMetadata _x = new DependentOptionMetadata();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.DependentOptionMetadata";
            _x.label = this.label;
            _x.value = this.value;
            return _x;
        }
    }
}

