/*
 * Decompiled with CFR 0.152.
 */
package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;
import java.util.Optional;
import java.util.UUID;

@JsonPropertyOrder(value={"@odata.type", "DisplayName", "SchemaName", "ComponentType", "ComponentSubType", "ComponentId", "ParentEntityId", "ParentEntityName"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Component
implements ODataType {
    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;
    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;
    @JsonProperty(value="@odata.type")
    protected String odataType;
    @JsonProperty(value="DisplayName")
    protected String displayName;
    @JsonProperty(value="SchemaName")
    protected String schemaName;
    @JsonProperty(value="ComponentType")
    protected Integer componentType;
    @JsonProperty(value="ComponentSubType")
    protected Integer componentSubType;
    @JsonProperty(value="ComponentId")
    protected UUID componentId;
    @JsonProperty(value="ParentEntityId")
    protected UUID parentEntityId;
    @JsonProperty(value="ParentEntityName")
    protected String parentEntityName;

    protected Component() {
    }

    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.Component";
    }

    @Property(name="DisplayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(this.displayName);
    }

    public Component withDisplayName(String displayName) {
        Checks.checkIsAscii((String)displayName);
        Component _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.Component");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="SchemaName")
    @JsonIgnore
    public Optional<String> getSchemaName() {
        return Optional.ofNullable(this.schemaName);
    }

    public Component withSchemaName(String schemaName) {
        Checks.checkIsAscii((String)schemaName);
        Component _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.Component");
        _x.schemaName = schemaName;
        return _x;
    }

    @Property(name="ComponentType")
    @JsonIgnore
    public Optional<Integer> getComponentType() {
        return Optional.ofNullable(this.componentType);
    }

    public Component withComponentType(Integer componentType) {
        Component _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.Component");
        _x.componentType = componentType;
        return _x;
    }

    @Property(name="ComponentSubType")
    @JsonIgnore
    public Optional<Integer> getComponentSubType() {
        return Optional.ofNullable(this.componentSubType);
    }

    public Component withComponentSubType(Integer componentSubType) {
        Component _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.Component");
        _x.componentSubType = componentSubType;
        return _x;
    }

    @Property(name="ComponentId")
    @JsonIgnore
    public Optional<UUID> getComponentId() {
        return Optional.ofNullable(this.componentId);
    }

    public Component withComponentId(UUID componentId) {
        Component _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.Component");
        _x.componentId = componentId;
        return _x;
    }

    @Property(name="ParentEntityId")
    @JsonIgnore
    public Optional<UUID> getParentEntityId() {
        return Optional.ofNullable(this.parentEntityId);
    }

    public Component withParentEntityId(UUID parentEntityId) {
        Component _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.Component");
        _x.parentEntityId = parentEntityId;
        return _x;
    }

    @Property(name="ParentEntityName")
    @JsonIgnore
    public Optional<String> getParentEntityName() {
        return Optional.ofNullable(this.parentEntityName);
    }

    public Component withParentEntityName(String parentEntityName) {
        Checks.checkIsAscii((String)parentEntityName);
        Component _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.Component");
        _x.parentEntityName = parentEntityName;
        return _x;
    }

    public Component withUnmappedField(String name, String value) {
        Component _x = this._copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (this.unmappedFields == null) {
            this.unmappedFields = new UnmappedFieldsImpl();
        }
        this.unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return this.unmappedFields == null ? UnmappedFieldsImpl.EMPTY : this.unmappedFields;
    }

    public UnmappedFields getUnmappedFields() {
        return this.unmappedFields();
    }

    public void postInject(boolean addKeysToContextPath) {
    }

    public static Builder builder() {
        return new Builder();
    }

    private Component _copy() {
        Component _x = new Component();
        _x.contextPath = this.contextPath;
        _x.unmappedFields = this.unmappedFields.copy();
        _x.odataType = this.odataType;
        _x.displayName = this.displayName;
        _x.schemaName = this.schemaName;
        _x.componentType = this.componentType;
        _x.componentSubType = this.componentSubType;
        _x.componentId = this.componentId;
        _x.parentEntityId = this.parentEntityId;
        _x.parentEntityName = this.parentEntityName;
        return _x;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Component[");
        b.append("DisplayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("SchemaName=");
        b.append(this.schemaName);
        b.append(", ");
        b.append("ComponentType=");
        b.append(this.componentType);
        b.append(", ");
        b.append("ComponentSubType=");
        b.append(this.componentSubType);
        b.append(", ");
        b.append("ComponentId=");
        b.append(this.componentId);
        b.append(", ");
        b.append("ParentEntityId=");
        b.append(this.parentEntityId);
        b.append(", ");
        b.append("ParentEntityName=");
        b.append(this.parentEntityName);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(this.unmappedFields);
        b.append(",odataType=");
        b.append(this.odataType);
        return b.toString();
    }

    public static final class Builder {
        private String displayName;
        private String schemaName;
        private Integer componentType;
        private Integer componentSubType;
        private UUID componentId;
        private UUID parentEntityId;
        private String parentEntityName;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = this.changedFields.add("DisplayName");
            return this;
        }

        public Builder schemaName(String schemaName) {
            this.schemaName = schemaName;
            this.changedFields = this.changedFields.add("SchemaName");
            return this;
        }

        public Builder componentType(Integer componentType) {
            this.componentType = componentType;
            this.changedFields = this.changedFields.add("ComponentType");
            return this;
        }

        public Builder componentSubType(Integer componentSubType) {
            this.componentSubType = componentSubType;
            this.changedFields = this.changedFields.add("ComponentSubType");
            return this;
        }

        public Builder componentId(UUID componentId) {
            this.componentId = componentId;
            this.changedFields = this.changedFields.add("ComponentId");
            return this;
        }

        public Builder parentEntityId(UUID parentEntityId) {
            this.parentEntityId = parentEntityId;
            this.changedFields = this.changedFields.add("ParentEntityId");
            return this;
        }

        public Builder parentEntityName(String parentEntityName) {
            this.parentEntityName = parentEntityName;
            this.changedFields = this.changedFields.add("ParentEntityName");
            return this;
        }

        public Component build() {
            Component _x = new Component();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.Component";
            _x.displayName = this.displayName;
            _x.schemaName = this.schemaName;
            _x.componentType = this.componentType;
            _x.componentSubType = this.componentSubType;
            _x.componentId = this.componentId;
            _x.parentEntityId = this.parentEntityId;
            _x.parentEntityName = this.parentEntityName;
            return _x;
        }
    }
}

