package microsoft.dynamics.crm.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum LookupFormat implements Enum {

    @JsonProperty("None")
    NONE("None", "0"),

    @JsonProperty("Connection")
    CONNECTION("Connection", "1"),

    @JsonProperty("Regarding")
    REGARDING("Regarding", "2"),

    @JsonProperty("Text")
    TEXT("Text", "3");

    private final String name;
    private final String value;

    private LookupFormat(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
