package microsoft.dynamics.crm.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum IntegerFormat implements Enum {

    @JsonProperty("None")
    NONE("None", "0"),

    @JsonProperty("Duration")
    DURATION("Duration", "1"),

    @JsonProperty("TimeZone")
    TIME_ZONE("TimeZone", "2"),

    @JsonProperty("Language")
    LANGUAGE("Language", "3"),

    @JsonProperty("Locale")
    LOCALE("Locale", "4");

    private final String name;
    private final String value;

    private IntegerFormat(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
