package microsoft.dynamics.crm.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum DateTimeFormat implements Enum {

    @JsonProperty("DateOnly")
    DATE_ONLY("DateOnly", "0"),

    @JsonProperty("DateAndTime")
    DATE_AND_TIME("DateAndTime", "1");

    private final String name;
    private final String value;

    private DateTimeFormat(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
