package microsoft.dynamics.crm.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.Solutioncomponentattributeconfiguration;
import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.BulkdeletefailureCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.DuplicaterecordCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.MailboxtrackingfolderCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PrincipalobjectattributeaccessCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ProcesssessionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;

@JsonIgnoreType
public class SolutioncomponentattributeconfigurationRequest extends EntityRequest<Solutioncomponentattributeconfiguration> {

    public SolutioncomponentattributeconfigurationRequest(ContextPath contextPath, Optional<Object> value) {
        super(Solutioncomponentattributeconfiguration.class, contextPath, value, false);
    }

    public SystemuserRequest createdby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), Optional.empty());
    }

    public SystemuserRequest createdonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), Optional.empty());
    }

    public SystemuserRequest modifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), Optional.empty());
    }

    public SystemuserRequest modifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), Optional.empty());
    }

    public OrganizationRequest organizationid() {
        return new OrganizationRequest(contextPath.addSegment("organizationid"), Optional.empty());
    }

    public SyncerrorRequest solutioncomponentattributeconfiguration_SyncErrors(UUID syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("solutioncomponentattributeconfiguration_SyncErrors").addKeys(new NameValue(syncerrorid, UUID.class)), Optional.empty());
    }

    public SyncerrorCollectionRequest solutioncomponentattributeconfiguration_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("solutioncomponentattributeconfiguration_SyncErrors"), Optional.empty());
    }

    public DuplicaterecordRequest solutioncomponentattributeconfiguration_DuplicateMatchingRecord(UUID duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("solutioncomponentattributeconfiguration_DuplicateMatchingRecord").addKeys(new NameValue(duplicateid, UUID.class)), Optional.empty());
    }

    public DuplicaterecordCollectionRequest solutioncomponentattributeconfiguration_DuplicateMatchingRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("solutioncomponentattributeconfiguration_DuplicateMatchingRecord"), Optional.empty());
    }

    public DuplicaterecordRequest solutioncomponentattributeconfiguration_DuplicateBaseRecord(UUID duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("solutioncomponentattributeconfiguration_DuplicateBaseRecord").addKeys(new NameValue(duplicateid, UUID.class)), Optional.empty());
    }

    public DuplicaterecordCollectionRequest solutioncomponentattributeconfiguration_DuplicateBaseRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("solutioncomponentattributeconfiguration_DuplicateBaseRecord"), Optional.empty());
    }

    public AsyncoperationRequest solutioncomponentattributeconfiguration_AsyncOperations(UUID asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("solutioncomponentattributeconfiguration_AsyncOperations").addKeys(new NameValue(asyncoperationid, UUID.class)), Optional.empty());
    }

    public AsyncoperationCollectionRequest solutioncomponentattributeconfiguration_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("solutioncomponentattributeconfiguration_AsyncOperations"), Optional.empty());
    }

    public MailboxtrackingfolderRequest solutioncomponentattributeconfiguration_MailboxTrackingFolders(UUID mailboxtrackingfolderid) {
        return new MailboxtrackingfolderRequest(contextPath.addSegment("solutioncomponentattributeconfiguration_MailboxTrackingFolders").addKeys(new NameValue(mailboxtrackingfolderid, UUID.class)), Optional.empty());
    }

    public MailboxtrackingfolderCollectionRequest solutioncomponentattributeconfiguration_MailboxTrackingFolders() {
        return new MailboxtrackingfolderCollectionRequest(
                        contextPath.addSegment("solutioncomponentattributeconfiguration_MailboxTrackingFolders"), Optional.empty());
    }

    public ProcesssessionRequest solutioncomponentattributeconfiguration_ProcessSession(UUID processsessionid) {
        return new ProcesssessionRequest(contextPath.addSegment("solutioncomponentattributeconfiguration_ProcessSession").addKeys(new NameValue(processsessionid, UUID.class)), Optional.empty());
    }

    public ProcesssessionCollectionRequest solutioncomponentattributeconfiguration_ProcessSession() {
        return new ProcesssessionCollectionRequest(
                        contextPath.addSegment("solutioncomponentattributeconfiguration_ProcessSession"), Optional.empty());
    }

    public BulkdeletefailureRequest solutioncomponentattributeconfiguration_BulkDeleteFailures(UUID bulkdeletefailureid) {
        return new BulkdeletefailureRequest(contextPath.addSegment("solutioncomponentattributeconfiguration_BulkDeleteFailures").addKeys(new NameValue(bulkdeletefailureid, UUID.class)), Optional.empty());
    }

    public BulkdeletefailureCollectionRequest solutioncomponentattributeconfiguration_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(
                        contextPath.addSegment("solutioncomponentattributeconfiguration_BulkDeleteFailures"), Optional.empty());
    }

    public PrincipalobjectattributeaccessRequest solutioncomponentattributeconfiguration_PrincipalObjectAttributeAccesses(UUID principalobjectattributeaccessid) {
        return new PrincipalobjectattributeaccessRequest(contextPath.addSegment("solutioncomponentattributeconfiguration_PrincipalObjectAttributeAccesses").addKeys(new NameValue(principalobjectattributeaccessid, UUID.class)), Optional.empty());
    }

    public PrincipalobjectattributeaccessCollectionRequest solutioncomponentattributeconfiguration_PrincipalObjectAttributeAccesses() {
        return new PrincipalobjectattributeaccessCollectionRequest(
                        contextPath.addSegment("solutioncomponentattributeconfiguration_PrincipalObjectAttributeAccesses"), Optional.empty());
    }

    public AttributeRequest attributeId() {
        return new AttributeRequest(contextPath.addSegment("AttributeId"), Optional.empty());
    }

    public SolutioncomponentconfigurationRequest solutioncomponentconfigurationid() {
        return new SolutioncomponentconfigurationRequest(contextPath.addSegment("solutioncomponentconfigurationid"), Optional.empty());
    }

}
