package microsoft.dynamics.crm.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.Principal;
import microsoft.dynamics.crm.entity.collection.request.AccountCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ActioncardCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ActioncarduserstateCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ActivitypointerCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.AnnotationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.AppointmentCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.CallbackregistrationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.CanvasappCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.CategoryCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ConnectionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ConnectionreferenceCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ConnectorCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ContactCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.DuplicateruleCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.EmailCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.EmailserverprofileCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.EnvironmentvariabledefinitionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.EnvironmentvariablevalueCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ExchangesyncidmappingCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ExportsolutionuploadCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.FaxCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.FeedbackCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.FlowsessionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Ggw_crewCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Ggw_eventCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Ggw_teamCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Ggw_team_applicationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.GoalCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.GoalrollupqueryCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ImportCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ImportdataCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ImportfileCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ImportlogCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ImportmapCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.InteractionforemailCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.KnowledgearticleCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.LetterCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.MailboxCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.MailboxtrackingfolderCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.MailmergetemplateCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Msdyn_aibdatasetCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Msdyn_aibdatasetfileCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Msdyn_aibdatasetrecordCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Msdyn_aibdatasetscontainerCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Msdyn_aibfileCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Msdyn_aibfileattacheddataCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Msdyn_aiconfigurationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Msdyn_aifptrainingdocumentCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Msdyn_aimodelCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Msdyn_aiodimageCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Msdyn_aiodlabelCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Msdyn_aiodtrainingboundingboxCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Msdyn_aiodtrainingimageCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Msdyn_aitemplateCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Msdyn_analysiscomponentCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Msdyn_analysisjobCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Msdyn_analysisresultCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Msdyn_analysisresultdetailCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Msdyn_dataflowCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Msdyn_knowledgearticleimageCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Msdyn_knowledgearticletemplateCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Msdyn_richtextfileCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Msdyn_serviceconfigurationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Msdyn_slakpiCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Msdyn_solutionhealthruleCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Msdyn_solutionhealthruleargumentCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PersonaldocumenttemplateCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PhonecallCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PostfollowCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PrincipalentitymapCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ProcesssessionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ProcessstageparameterCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.QueueCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.RecurrenceruleCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.RecurringappointmentmasterCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ReportCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SharepointdocumentlocationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SharepointsiteCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SlaCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SlakpiinstanceCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SocialactivityCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SocialprofileCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.StagesolutionuploadCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.TaskCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.TemplateCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.UserformCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.UserqueryCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.UserqueryvisualizationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.WorkflowCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.WorkflowbinaryCollectionRequest;

@JsonIgnoreType
public class PrincipalRequest extends EntityRequest<Principal> {

    public PrincipalRequest(ContextPath contextPath, Optional<Object> value) {
        super(Principal.class, contextPath, value, false);
    }

    public ExchangesyncidmappingRequest owner_exchangesyncidmapping(UUID exchangesyncidmappingid) {
        return new ExchangesyncidmappingRequest(contextPath.addSegment("owner_exchangesyncidmapping").addKeys(new NameValue(exchangesyncidmappingid, UUID.class)), Optional.empty());
    }

    public ExchangesyncidmappingCollectionRequest owner_exchangesyncidmapping() {
        return new ExchangesyncidmappingCollectionRequest(
                        contextPath.addSegment("owner_exchangesyncidmapping"), Optional.empty());
    }

    public InteractionforemailRequest owner_new_interactionforemail(UUID interactionforemailid) {
        return new InteractionforemailRequest(contextPath.addSegment("owner_new_interactionforemail").addKeys(new NameValue(interactionforemailid, UUID.class)), Optional.empty());
    }

    public InteractionforemailCollectionRequest owner_new_interactionforemail() {
        return new InteractionforemailCollectionRequest(
                        contextPath.addSegment("owner_new_interactionforemail"), Optional.empty());
    }

    public KnowledgearticleRequest owner_knowledgearticle(UUID knowledgearticleid) {
        return new KnowledgearticleRequest(contextPath.addSegment("owner_knowledgearticle").addKeys(new NameValue(knowledgearticleid, UUID.class)), Optional.empty());
    }

    public KnowledgearticleCollectionRequest owner_knowledgearticle() {
        return new KnowledgearticleCollectionRequest(
                        contextPath.addSegment("owner_knowledgearticle"), Optional.empty());
    }

    public SharepointsiteRequest owner_sharepointsite(UUID sharepointsiteid) {
        return new SharepointsiteRequest(contextPath.addSegment("owner_sharepointsite").addKeys(new NameValue(sharepointsiteid, UUID.class)), Optional.empty());
    }

    public SharepointsiteCollectionRequest owner_sharepointsite() {
        return new SharepointsiteCollectionRequest(
                        contextPath.addSegment("owner_sharepointsite"), Optional.empty());
    }

    public SharepointdocumentlocationRequest owner_sharepointdocumentlocation(UUID sharepointdocumentlocationid) {
        return new SharepointdocumentlocationRequest(contextPath.addSegment("owner_sharepointdocumentlocation").addKeys(new NameValue(sharepointdocumentlocationid, UUID.class)), Optional.empty());
    }

    public SharepointdocumentlocationCollectionRequest owner_sharepointdocumentlocation() {
        return new SharepointdocumentlocationCollectionRequest(
                        contextPath.addSegment("owner_sharepointdocumentlocation"), Optional.empty());
    }

    public GoalRequest owner_goal(UUID goalid) {
        return new GoalRequest(contextPath.addSegment("owner_goal").addKeys(new NameValue(goalid, UUID.class)), Optional.empty());
    }

    public GoalCollectionRequest owner_goal() {
        return new GoalCollectionRequest(
                        contextPath.addSegment("owner_goal"), Optional.empty());
    }

    public MailboxRequest owner_mailbox(UUID mailboxid) {
        return new MailboxRequest(contextPath.addSegment("owner_mailbox").addKeys(new NameValue(mailboxid, UUID.class)), Optional.empty());
    }

    public MailboxCollectionRequest owner_mailbox() {
        return new MailboxCollectionRequest(
                        contextPath.addSegment("owner_mailbox"), Optional.empty());
    }

    public PersonaldocumenttemplateRequest owner_personaldocumenttemplates(UUID personaldocumenttemplateid) {
        return new PersonaldocumenttemplateRequest(contextPath.addSegment("owner_personaldocumenttemplates").addKeys(new NameValue(personaldocumenttemplateid, UUID.class)), Optional.empty());
    }

    public PersonaldocumenttemplateCollectionRequest owner_personaldocumenttemplates() {
        return new PersonaldocumenttemplateCollectionRequest(
                        contextPath.addSegment("owner_personaldocumenttemplates"), Optional.empty());
    }

    public AccountRequest owner_accounts(UUID accountid) {
        return new AccountRequest(contextPath.addSegment("owner_accounts").addKeys(new NameValue(accountid, UUID.class)), Optional.empty());
    }

    public AccountCollectionRequest owner_accounts() {
        return new AccountCollectionRequest(
                        contextPath.addSegment("owner_accounts"), Optional.empty());
    }

    public GoalrollupqueryRequest owner_goalrollupquery(UUID goalrollupqueryid) {
        return new GoalrollupqueryRequest(contextPath.addSegment("owner_goalrollupquery").addKeys(new NameValue(goalrollupqueryid, UUID.class)), Optional.empty());
    }

    public GoalrollupqueryCollectionRequest owner_goalrollupquery() {
        return new GoalrollupqueryCollectionRequest(
                        contextPath.addSegment("owner_goalrollupquery"), Optional.empty());
    }

    public PostfollowRequest owner_postfollows(UUID postfollowid) {
        return new PostfollowRequest(contextPath.addSegment("owner_postfollows").addKeys(new NameValue(postfollowid, UUID.class)), Optional.empty());
    }

    public PostfollowCollectionRequest owner_postfollows() {
        return new PostfollowCollectionRequest(
                        contextPath.addSegment("owner_postfollows"), Optional.empty());
    }

    public WorkflowRequest owner_workflows(UUID workflowid) {
        return new WorkflowRequest(contextPath.addSegment("owner_workflows").addKeys(new NameValue(workflowid, UUID.class)), Optional.empty());
    }

    public WorkflowCollectionRequest owner_workflows() {
        return new WorkflowCollectionRequest(
                        contextPath.addSegment("owner_workflows"), Optional.empty());
    }

    public UserqueryRequest owner_userquerys(UUID userqueryid) {
        return new UserqueryRequest(contextPath.addSegment("owner_userquerys").addKeys(new NameValue(userqueryid, UUID.class)), Optional.empty());
    }

    public UserqueryCollectionRequest owner_userquerys() {
        return new UserqueryCollectionRequest(
                        contextPath.addSegment("owner_userquerys"), Optional.empty());
    }

    public ImportmapRequest owner_importmaps(UUID importmapid) {
        return new ImportmapRequest(contextPath.addSegment("owner_importmaps").addKeys(new NameValue(importmapid, UUID.class)), Optional.empty());
    }

    public ImportmapCollectionRequest owner_importmaps() {
        return new ImportmapCollectionRequest(
                        contextPath.addSegment("owner_importmaps"), Optional.empty());
    }

    public RecurrenceruleRequest owner_recurrencerules(UUID ruleid) {
        return new RecurrenceruleRequest(contextPath.addSegment("owner_recurrencerules").addKeys(new NameValue(ruleid, UUID.class)), Optional.empty());
    }

    public RecurrenceruleCollectionRequest owner_recurrencerules() {
        return new RecurrenceruleCollectionRequest(
                        contextPath.addSegment("owner_recurrencerules"), Optional.empty());
    }

    public MailmergetemplateRequest owner_mailmergetemplates(UUID mailmergetemplateid) {
        return new MailmergetemplateRequest(contextPath.addSegment("owner_mailmergetemplates").addKeys(new NameValue(mailmergetemplateid, UUID.class)), Optional.empty());
    }

    public MailmergetemplateCollectionRequest owner_mailmergetemplates() {
        return new MailmergetemplateCollectionRequest(
                        contextPath.addSegment("owner_mailmergetemplates"), Optional.empty());
    }

    public DuplicateruleRequest owner_duplicaterules(UUID duplicateruleid) {
        return new DuplicateruleRequest(contextPath.addSegment("owner_duplicaterules").addKeys(new NameValue(duplicateruleid, UUID.class)), Optional.empty());
    }

    public DuplicateruleCollectionRequest owner_duplicaterules() {
        return new DuplicateruleCollectionRequest(
                        contextPath.addSegment("owner_duplicaterules"), Optional.empty());
    }

    public ReportRequest owner_reports(UUID reportid) {
        return new ReportRequest(contextPath.addSegment("owner_reports").addKeys(new NameValue(reportid, UUID.class)), Optional.empty());
    }

    public ReportCollectionRequest owner_reports() {
        return new ReportCollectionRequest(
                        contextPath.addSegment("owner_reports"), Optional.empty());
    }

    public ActivitypointerRequest owner_activitypointers(UUID activityid) {
        return new ActivitypointerRequest(contextPath.addSegment("owner_activitypointers").addKeys(new NameValue(activityid, UUID.class)), Optional.empty());
    }

    public ActivitypointerCollectionRequest owner_activitypointers() {
        return new ActivitypointerCollectionRequest(
                        contextPath.addSegment("owner_activitypointers"), Optional.empty());
    }

    public MailboxtrackingfolderRequest owner_mailboxtrackingfolder(UUID mailboxtrackingfolderid) {
        return new MailboxtrackingfolderRequest(contextPath.addSegment("owner_mailboxtrackingfolder").addKeys(new NameValue(mailboxtrackingfolderid, UUID.class)), Optional.empty());
    }

    public MailboxtrackingfolderCollectionRequest owner_mailboxtrackingfolder() {
        return new MailboxtrackingfolderCollectionRequest(
                        contextPath.addSegment("owner_mailboxtrackingfolder"), Optional.empty());
    }

    public PrincipalentitymapRequest owner_principalentitymap(UUID principalentitymapid) {
        return new PrincipalentitymapRequest(contextPath.addSegment("owner_principalentitymap").addKeys(new NameValue(principalentitymapid, UUID.class)), Optional.empty());
    }

    public PrincipalentitymapCollectionRequest owner_principalentitymap() {
        return new PrincipalentitymapCollectionRequest(
                        contextPath.addSegment("owner_principalentitymap"), Optional.empty());
    }

    public ImportdataRequest owner_importdatas(UUID importdataid) {
        return new ImportdataRequest(contextPath.addSegment("owner_importdatas").addKeys(new NameValue(importdataid, UUID.class)), Optional.empty());
    }

    public ImportdataCollectionRequest owner_importdatas() {
        return new ImportdataCollectionRequest(
                        contextPath.addSegment("owner_importdatas"), Optional.empty());
    }

    public CategoryRequest owner_categories(UUID categoryid) {
        return new CategoryRequest(contextPath.addSegment("owner_categories").addKeys(new NameValue(categoryid, UUID.class)), Optional.empty());
    }

    public CategoryCollectionRequest owner_categories() {
        return new CategoryCollectionRequest(
                        contextPath.addSegment("owner_categories"), Optional.empty());
    }

    public QueueRequest owner_queues(UUID queueid) {
        return new QueueRequest(contextPath.addSegment("owner_queues").addKeys(new NameValue(queueid, UUID.class)), Optional.empty());
    }

    public QueueCollectionRequest owner_queues() {
        return new QueueCollectionRequest(
                        contextPath.addSegment("owner_queues"), Optional.empty());
    }

    public ActioncardRequest owner_actioncards(UUID actioncardid) {
        return new ActioncardRequest(contextPath.addSegment("owner_actioncards").addKeys(new NameValue(actioncardid, UUID.class)), Optional.empty());
    }

    public ActioncardCollectionRequest owner_actioncards() {
        return new ActioncardCollectionRequest(
                        contextPath.addSegment("owner_actioncards"), Optional.empty());
    }

    public UserqueryvisualizationRequest owner_userqueryvisualizations(UUID userqueryvisualizationid) {
        return new UserqueryvisualizationRequest(contextPath.addSegment("owner_userqueryvisualizations").addKeys(new NameValue(userqueryvisualizationid, UUID.class)), Optional.empty());
    }

    public UserqueryvisualizationCollectionRequest owner_userqueryvisualizations() {
        return new UserqueryvisualizationCollectionRequest(
                        contextPath.addSegment("owner_userqueryvisualizations"), Optional.empty());
    }

    public FeedbackRequest owner_feedback(UUID feedbackid) {
        return new FeedbackRequest(contextPath.addSegment("owner_feedback").addKeys(new NameValue(feedbackid, UUID.class)), Optional.empty());
    }

    public FeedbackCollectionRequest owner_feedback() {
        return new FeedbackCollectionRequest(
                        contextPath.addSegment("owner_feedback"), Optional.empty());
    }

    public AnnotationRequest owner_annotations(UUID annotationid) {
        return new AnnotationRequest(contextPath.addSegment("owner_annotations").addKeys(new NameValue(annotationid, UUID.class)), Optional.empty());
    }

    public AnnotationCollectionRequest owner_annotations() {
        return new AnnotationCollectionRequest(
                        contextPath.addSegment("owner_annotations"), Optional.empty());
    }

    public UserformRequest owner_userform(UUID userformid) {
        return new UserformRequest(contextPath.addSegment("owner_userform").addKeys(new NameValue(userformid, UUID.class)), Optional.empty());
    }

    public UserformCollectionRequest owner_userform() {
        return new UserformCollectionRequest(
                        contextPath.addSegment("owner_userform"), Optional.empty());
    }

    public AsyncoperationRequest owner_asyncoperations(UUID asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("owner_asyncoperations").addKeys(new NameValue(asyncoperationid, UUID.class)), Optional.empty());
    }

    public AsyncoperationCollectionRequest owner_asyncoperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("owner_asyncoperations"), Optional.empty());
    }

    public SocialprofileRequest owner_SocialProfile(UUID socialprofileid) {
        return new SocialprofileRequest(contextPath.addSegment("owner_SocialProfile").addKeys(new NameValue(socialprofileid, UUID.class)), Optional.empty());
    }

    public SocialprofileCollectionRequest owner_SocialProfile() {
        return new SocialprofileCollectionRequest(
                        contextPath.addSegment("owner_SocialProfile"), Optional.empty());
    }

    public ProcesssessionRequest owner_processsessions(UUID processsessionid) {
        return new ProcesssessionRequest(contextPath.addSegment("owner_processsessions").addKeys(new NameValue(processsessionid, UUID.class)), Optional.empty());
    }

    public ProcesssessionCollectionRequest owner_processsessions() {
        return new ProcesssessionCollectionRequest(
                        contextPath.addSegment("owner_processsessions"), Optional.empty());
    }

    public SlaRequest owner_slas(UUID slaid) {
        return new SlaRequest(contextPath.addSegment("owner_slas").addKeys(new NameValue(slaid, UUID.class)), Optional.empty());
    }

    public SlaCollectionRequest owner_slas() {
        return new SlaCollectionRequest(
                        contextPath.addSegment("owner_slas"), Optional.empty());
    }

    public SlakpiinstanceRequest slakpiinstance_owner(UUID slakpiinstanceid) {
        return new SlakpiinstanceRequest(contextPath.addSegment("slakpiinstance_owner").addKeys(new NameValue(slakpiinstanceid, UUID.class)), Optional.empty());
    }

    public SlakpiinstanceCollectionRequest slakpiinstance_owner() {
        return new SlakpiinstanceCollectionRequest(
                        contextPath.addSegment("slakpiinstance_owner"), Optional.empty());
    }

    public EmailserverprofileRequest owner_emailserverprofile(UUID emailserverprofileid) {
        return new EmailserverprofileRequest(contextPath.addSegment("owner_emailserverprofile").addKeys(new NameValue(emailserverprofileid, UUID.class)), Optional.empty());
    }

    public EmailserverprofileCollectionRequest owner_emailserverprofile() {
        return new EmailserverprofileCollectionRequest(
                        contextPath.addSegment("owner_emailserverprofile"), Optional.empty());
    }

    public TemplateRequest owner_templates(UUID templateid) {
        return new TemplateRequest(contextPath.addSegment("owner_templates").addKeys(new NameValue(templateid, UUID.class)), Optional.empty());
    }

    public TemplateCollectionRequest owner_templates() {
        return new TemplateCollectionRequest(
                        contextPath.addSegment("owner_templates"), Optional.empty());
    }

    public ContactRequest owner_contacts(UUID contactid) {
        return new ContactRequest(contextPath.addSegment("owner_contacts").addKeys(new NameValue(contactid, UUID.class)), Optional.empty());
    }

    public ContactCollectionRequest owner_contacts() {
        return new ContactCollectionRequest(
                        contextPath.addSegment("owner_contacts"), Optional.empty());
    }

    public ImportRequest owner_imports(UUID importid) {
        return new ImportRequest(contextPath.addSegment("owner_imports").addKeys(new NameValue(importid, UUID.class)), Optional.empty());
    }

    public ImportCollectionRequest owner_imports() {
        return new ImportCollectionRequest(
                        contextPath.addSegment("owner_imports"), Optional.empty());
    }

    public ConnectionRequest owner_connections(UUID connectionid) {
        return new ConnectionRequest(contextPath.addSegment("owner_connections").addKeys(new NameValue(connectionid, UUID.class)), Optional.empty());
    }

    public ConnectionCollectionRequest owner_connections() {
        return new ConnectionCollectionRequest(
                        contextPath.addSegment("owner_connections"), Optional.empty());
    }

    public ImportfileRequest owner_importfiles(UUID importfileid) {
        return new ImportfileRequest(contextPath.addSegment("owner_importfiles").addKeys(new NameValue(importfileid, UUID.class)), Optional.empty());
    }

    public ImportfileCollectionRequest owner_importfiles() {
        return new ImportfileCollectionRequest(
                        contextPath.addSegment("owner_importfiles"), Optional.empty());
    }

    public ImportlogRequest owner_importlogs(UUID importlogid) {
        return new ImportlogRequest(contextPath.addSegment("owner_importlogs").addKeys(new NameValue(importlogid, UUID.class)), Optional.empty());
    }

    public ImportlogCollectionRequest owner_importlogs() {
        return new ImportlogCollectionRequest(
                        contextPath.addSegment("owner_importlogs"), Optional.empty());
    }

    public SyncerrorRequest owner_SyncError(UUID syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("owner_SyncError").addKeys(new NameValue(syncerrorid, UUID.class)), Optional.empty());
    }

    public SyncerrorCollectionRequest owner_SyncError() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("owner_SyncError"), Optional.empty());
    }

    public EmailRequest owner_emails(UUID activityid) {
        return new EmailRequest(contextPath.addSegment("owner_emails").addKeys(new NameValue(activityid, UUID.class)), Optional.empty());
    }

    public EmailCollectionRequest owner_emails() {
        return new EmailCollectionRequest(
                        contextPath.addSegment("owner_emails"), Optional.empty());
    }

    public FaxRequest owner_faxes(UUID activityid) {
        return new FaxRequest(contextPath.addSegment("owner_faxes").addKeys(new NameValue(activityid, UUID.class)), Optional.empty());
    }

    public FaxCollectionRequest owner_faxes() {
        return new FaxCollectionRequest(
                        contextPath.addSegment("owner_faxes"), Optional.empty());
    }

    public LetterRequest owner_letters(UUID activityid) {
        return new LetterRequest(contextPath.addSegment("owner_letters").addKeys(new NameValue(activityid, UUID.class)), Optional.empty());
    }

    public LetterCollectionRequest owner_letters() {
        return new LetterCollectionRequest(
                        contextPath.addSegment("owner_letters"), Optional.empty());
    }

    public PhonecallRequest owner_phonecalls(UUID activityid) {
        return new PhonecallRequest(contextPath.addSegment("owner_phonecalls").addKeys(new NameValue(activityid, UUID.class)), Optional.empty());
    }

    public PhonecallCollectionRequest owner_phonecalls() {
        return new PhonecallCollectionRequest(
                        contextPath.addSegment("owner_phonecalls"), Optional.empty());
    }

    public TaskRequest owner_tasks(UUID activityid) {
        return new TaskRequest(contextPath.addSegment("owner_tasks").addKeys(new NameValue(activityid, UUID.class)), Optional.empty());
    }

    public TaskCollectionRequest owner_tasks() {
        return new TaskCollectionRequest(
                        contextPath.addSegment("owner_tasks"), Optional.empty());
    }

    public RecurringappointmentmasterRequest owner_recurringappointmentmasters(UUID activityid) {
        return new RecurringappointmentmasterRequest(contextPath.addSegment("owner_recurringappointmentmasters").addKeys(new NameValue(activityid, UUID.class)), Optional.empty());
    }

    public RecurringappointmentmasterCollectionRequest owner_recurringappointmentmasters() {
        return new RecurringappointmentmasterCollectionRequest(
                        contextPath.addSegment("owner_recurringappointmentmasters"), Optional.empty());
    }

    public SocialactivityRequest owner_socialactivities(UUID activityid) {
        return new SocialactivityRequest(contextPath.addSegment("owner_socialactivities").addKeys(new NameValue(activityid, UUID.class)), Optional.empty());
    }

    public SocialactivityCollectionRequest owner_socialactivities() {
        return new SocialactivityCollectionRequest(
                        contextPath.addSegment("owner_socialactivities"), Optional.empty());
    }

    public AppointmentRequest owner_appointments(UUID activityid) {
        return new AppointmentRequest(contextPath.addSegment("owner_appointments").addKeys(new NameValue(activityid, UUID.class)), Optional.empty());
    }

    public AppointmentCollectionRequest owner_appointments() {
        return new AppointmentCollectionRequest(
                        contextPath.addSegment("owner_appointments"), Optional.empty());
    }

    public ActioncarduserstateRequest actionCardUserState_Owner(UUID actioncarduserstateid) {
        return new ActioncarduserstateRequest(contextPath.addSegment("ActionCardUserState_Owner").addKeys(new NameValue(actioncarduserstateid, UUID.class)), Optional.empty());
    }

    public ActioncarduserstateCollectionRequest actionCardUserState_Owner() {
        return new ActioncarduserstateCollectionRequest(
                        contextPath.addSegment("ActionCardUserState_Owner"), Optional.empty());
    }

    public CallbackregistrationRequest owner_callbackregistration(UUID callbackregistrationid) {
        return new CallbackregistrationRequest(contextPath.addSegment("owner_callbackregistration").addKeys(new NameValue(callbackregistrationid, UUID.class)), Optional.empty());
    }

    public CallbackregistrationCollectionRequest owner_callbackregistration() {
        return new CallbackregistrationCollectionRequest(
                        contextPath.addSegment("owner_callbackregistration"), Optional.empty());
    }

    public CanvasappRequest owner_canvasapp(UUID canvasappid) {
        return new CanvasappRequest(contextPath.addSegment("owner_canvasapp").addKeys(new NameValue(canvasappid, UUID.class)), Optional.empty());
    }

    public CanvasappCollectionRequest owner_canvasapp() {
        return new CanvasappCollectionRequest(
                        contextPath.addSegment("owner_canvasapp"), Optional.empty());
    }

    public StagesolutionuploadRequest owner_stagesolutionupload(UUID stagesolutionuploadid) {
        return new StagesolutionuploadRequest(contextPath.addSegment("owner_stagesolutionupload").addKeys(new NameValue(stagesolutionuploadid, UUID.class)), Optional.empty());
    }

    public StagesolutionuploadCollectionRequest owner_stagesolutionupload() {
        return new StagesolutionuploadCollectionRequest(
                        contextPath.addSegment("owner_stagesolutionupload"), Optional.empty());
    }

    public ExportsolutionuploadRequest owner_exportsolutionupload(UUID exportsolutionuploadid) {
        return new ExportsolutionuploadRequest(contextPath.addSegment("owner_exportsolutionupload").addKeys(new NameValue(exportsolutionuploadid, UUID.class)), Optional.empty());
    }

    public ExportsolutionuploadCollectionRequest owner_exportsolutionupload() {
        return new ExportsolutionuploadCollectionRequest(
                        contextPath.addSegment("owner_exportsolutionupload"), Optional.empty());
    }

    public ConnectorRequest owner_connector(UUID connectorid) {
        return new ConnectorRequest(contextPath.addSegment("owner_connector").addKeys(new NameValue(connectorid, UUID.class)), Optional.empty());
    }

    public ConnectorCollectionRequest owner_connector() {
        return new ConnectorCollectionRequest(
                        contextPath.addSegment("owner_connector"), Optional.empty());
    }

    public EnvironmentvariabledefinitionRequest owner_environmentvariabledefinition(UUID environmentvariabledefinitionid) {
        return new EnvironmentvariabledefinitionRequest(contextPath.addSegment("owner_environmentvariabledefinition").addKeys(new NameValue(environmentvariabledefinitionid, UUID.class)), Optional.empty());
    }

    public EnvironmentvariabledefinitionCollectionRequest owner_environmentvariabledefinition() {
        return new EnvironmentvariabledefinitionCollectionRequest(
                        contextPath.addSegment("owner_environmentvariabledefinition"), Optional.empty());
    }

    public EnvironmentvariablevalueRequest owner_environmentvariablevalue(UUID environmentvariablevalueid) {
        return new EnvironmentvariablevalueRequest(contextPath.addSegment("owner_environmentvariablevalue").addKeys(new NameValue(environmentvariablevalueid, UUID.class)), Optional.empty());
    }

    public EnvironmentvariablevalueCollectionRequest owner_environmentvariablevalue() {
        return new EnvironmentvariablevalueCollectionRequest(
                        contextPath.addSegment("owner_environmentvariablevalue"), Optional.empty());
    }

    public ProcessstageparameterRequest owner_processstageparameter(UUID processstageparameterid) {
        return new ProcessstageparameterRequest(contextPath.addSegment("owner_processstageparameter").addKeys(new NameValue(processstageparameterid, UUID.class)), Optional.empty());
    }

    public ProcessstageparameterCollectionRequest owner_processstageparameter() {
        return new ProcessstageparameterCollectionRequest(
                        contextPath.addSegment("owner_processstageparameter"), Optional.empty());
    }

    public FlowsessionRequest owner_flowsession(UUID flowsessionid) {
        return new FlowsessionRequest(contextPath.addSegment("owner_flowsession").addKeys(new NameValue(flowsessionid, UUID.class)), Optional.empty());
    }

    public FlowsessionCollectionRequest owner_flowsession() {
        return new FlowsessionCollectionRequest(
                        contextPath.addSegment("owner_flowsession"), Optional.empty());
    }

    public WorkflowbinaryRequest owner_workflowbinary(UUID workflowbinaryid) {
        return new WorkflowbinaryRequest(contextPath.addSegment("owner_workflowbinary").addKeys(new NameValue(workflowbinaryid, UUID.class)), Optional.empty());
    }

    public WorkflowbinaryCollectionRequest owner_workflowbinary() {
        return new WorkflowbinaryCollectionRequest(
                        contextPath.addSegment("owner_workflowbinary"), Optional.empty());
    }

    public ConnectionreferenceRequest owner_connectionreference(UUID connectionreferenceid) {
        return new ConnectionreferenceRequest(contextPath.addSegment("owner_connectionreference").addKeys(new NameValue(connectionreferenceid, UUID.class)), Optional.empty());
    }

    public ConnectionreferenceCollectionRequest owner_connectionreference() {
        return new ConnectionreferenceCollectionRequest(
                        contextPath.addSegment("owner_connectionreference"), Optional.empty());
    }

    public Msdyn_serviceconfigurationRequest owner_msdyn_serviceconfiguration(UUID msdyn_serviceconfigurationid) {
        return new Msdyn_serviceconfigurationRequest(contextPath.addSegment("owner_msdyn_serviceconfiguration").addKeys(new NameValue(msdyn_serviceconfigurationid, UUID.class)), Optional.empty());
    }

    public Msdyn_serviceconfigurationCollectionRequest owner_msdyn_serviceconfiguration() {
        return new Msdyn_serviceconfigurationCollectionRequest(
                        contextPath.addSegment("owner_msdyn_serviceconfiguration"), Optional.empty());
    }

    public Msdyn_slakpiRequest owner_msdyn_slakpi(UUID msdyn_slakpiid) {
        return new Msdyn_slakpiRequest(contextPath.addSegment("owner_msdyn_slakpi").addKeys(new NameValue(msdyn_slakpiid, UUID.class)), Optional.empty());
    }

    public Msdyn_slakpiCollectionRequest owner_msdyn_slakpi() {
        return new Msdyn_slakpiCollectionRequest(
                        contextPath.addSegment("owner_msdyn_slakpi"), Optional.empty());
    }

    public Msdyn_knowledgearticleimageRequest owner_msdyn_knowledgearticleimage(UUID msdyn_knowledgearticleimageid) {
        return new Msdyn_knowledgearticleimageRequest(contextPath.addSegment("owner_msdyn_knowledgearticleimage").addKeys(new NameValue(msdyn_knowledgearticleimageid, UUID.class)), Optional.empty());
    }

    public Msdyn_knowledgearticleimageCollectionRequest owner_msdyn_knowledgearticleimage() {
        return new Msdyn_knowledgearticleimageCollectionRequest(
                        contextPath.addSegment("owner_msdyn_knowledgearticleimage"), Optional.empty());
    }

    public Msdyn_knowledgearticletemplateRequest owner_msdyn_knowledgearticletemplate(UUID msdyn_knowledgearticletemplateid) {
        return new Msdyn_knowledgearticletemplateRequest(contextPath.addSegment("owner_msdyn_knowledgearticletemplate").addKeys(new NameValue(msdyn_knowledgearticletemplateid, UUID.class)), Optional.empty());
    }

    public Msdyn_knowledgearticletemplateCollectionRequest owner_msdyn_knowledgearticletemplate() {
        return new Msdyn_knowledgearticletemplateCollectionRequest(
                        contextPath.addSegment("owner_msdyn_knowledgearticletemplate"), Optional.empty());
    }

    public Msdyn_dataflowRequest owner_msdyn_dataflow(UUID msdyn_dataflowid) {
        return new Msdyn_dataflowRequest(contextPath.addSegment("owner_msdyn_dataflow").addKeys(new NameValue(msdyn_dataflowid, UUID.class)), Optional.empty());
    }

    public Msdyn_dataflowCollectionRequest owner_msdyn_dataflow() {
        return new Msdyn_dataflowCollectionRequest(
                        contextPath.addSegment("owner_msdyn_dataflow"), Optional.empty());
    }

    public Msdyn_richtextfileRequest owner_msdyn_richtextfile(UUID msdyn_richtextfileid) {
        return new Msdyn_richtextfileRequest(contextPath.addSegment("owner_msdyn_richtextfile").addKeys(new NameValue(msdyn_richtextfileid, UUID.class)), Optional.empty());
    }

    public Msdyn_richtextfileCollectionRequest owner_msdyn_richtextfile() {
        return new Msdyn_richtextfileCollectionRequest(
                        contextPath.addSegment("owner_msdyn_richtextfile"), Optional.empty());
    }

    public Msdyn_aiconfigurationRequest owner_msdyn_aiconfiguration(UUID msdyn_aiconfigurationid) {
        return new Msdyn_aiconfigurationRequest(contextPath.addSegment("owner_msdyn_aiconfiguration").addKeys(new NameValue(msdyn_aiconfigurationid, UUID.class)), Optional.empty());
    }

    public Msdyn_aiconfigurationCollectionRequest owner_msdyn_aiconfiguration() {
        return new Msdyn_aiconfigurationCollectionRequest(
                        contextPath.addSegment("owner_msdyn_aiconfiguration"), Optional.empty());
    }

    public Msdyn_aimodelRequest owner_msdyn_aimodel(UUID msdyn_aimodelid) {
        return new Msdyn_aimodelRequest(contextPath.addSegment("owner_msdyn_aimodel").addKeys(new NameValue(msdyn_aimodelid, UUID.class)), Optional.empty());
    }

    public Msdyn_aimodelCollectionRequest owner_msdyn_aimodel() {
        return new Msdyn_aimodelCollectionRequest(
                        contextPath.addSegment("owner_msdyn_aimodel"), Optional.empty());
    }

    public Msdyn_aitemplateRequest owner_msdyn_aitemplate(UUID msdyn_aitemplateid) {
        return new Msdyn_aitemplateRequest(contextPath.addSegment("owner_msdyn_aitemplate").addKeys(new NameValue(msdyn_aitemplateid, UUID.class)), Optional.empty());
    }

    public Msdyn_aitemplateCollectionRequest owner_msdyn_aitemplate() {
        return new Msdyn_aitemplateCollectionRequest(
                        contextPath.addSegment("owner_msdyn_aitemplate"), Optional.empty());
    }

    public Msdyn_aibdatasetRequest owner_msdyn_aibdataset(UUID msdyn_aibdatasetid) {
        return new Msdyn_aibdatasetRequest(contextPath.addSegment("owner_msdyn_aibdataset").addKeys(new NameValue(msdyn_aibdatasetid, UUID.class)), Optional.empty());
    }

    public Msdyn_aibdatasetCollectionRequest owner_msdyn_aibdataset() {
        return new Msdyn_aibdatasetCollectionRequest(
                        contextPath.addSegment("owner_msdyn_aibdataset"), Optional.empty());
    }

    public Msdyn_aibdatasetfileRequest owner_msdyn_aibdatasetfile(UUID msdyn_aibdatasetfileid) {
        return new Msdyn_aibdatasetfileRequest(contextPath.addSegment("owner_msdyn_aibdatasetfile").addKeys(new NameValue(msdyn_aibdatasetfileid, UUID.class)), Optional.empty());
    }

    public Msdyn_aibdatasetfileCollectionRequest owner_msdyn_aibdatasetfile() {
        return new Msdyn_aibdatasetfileCollectionRequest(
                        contextPath.addSegment("owner_msdyn_aibdatasetfile"), Optional.empty());
    }

    public Msdyn_aibdatasetrecordRequest owner_msdyn_aibdatasetrecord(UUID msdyn_aibdatasetrecordid) {
        return new Msdyn_aibdatasetrecordRequest(contextPath.addSegment("owner_msdyn_aibdatasetrecord").addKeys(new NameValue(msdyn_aibdatasetrecordid, UUID.class)), Optional.empty());
    }

    public Msdyn_aibdatasetrecordCollectionRequest owner_msdyn_aibdatasetrecord() {
        return new Msdyn_aibdatasetrecordCollectionRequest(
                        contextPath.addSegment("owner_msdyn_aibdatasetrecord"), Optional.empty());
    }

    public Msdyn_aibdatasetscontainerRequest owner_msdyn_aibdatasetscontainer(UUID msdyn_aibdatasetscontainerid) {
        return new Msdyn_aibdatasetscontainerRequest(contextPath.addSegment("owner_msdyn_aibdatasetscontainer").addKeys(new NameValue(msdyn_aibdatasetscontainerid, UUID.class)), Optional.empty());
    }

    public Msdyn_aibdatasetscontainerCollectionRequest owner_msdyn_aibdatasetscontainer() {
        return new Msdyn_aibdatasetscontainerCollectionRequest(
                        contextPath.addSegment("owner_msdyn_aibdatasetscontainer"), Optional.empty());
    }

    public Msdyn_aibfileRequest owner_msdyn_aibfile(UUID msdyn_aibfileid) {
        return new Msdyn_aibfileRequest(contextPath.addSegment("owner_msdyn_aibfile").addKeys(new NameValue(msdyn_aibfileid, UUID.class)), Optional.empty());
    }

    public Msdyn_aibfileCollectionRequest owner_msdyn_aibfile() {
        return new Msdyn_aibfileCollectionRequest(
                        contextPath.addSegment("owner_msdyn_aibfile"), Optional.empty());
    }

    public Msdyn_aibfileattacheddataRequest owner_msdyn_aibfileattacheddata(UUID msdyn_aibfileattacheddataid) {
        return new Msdyn_aibfileattacheddataRequest(contextPath.addSegment("owner_msdyn_aibfileattacheddata").addKeys(new NameValue(msdyn_aibfileattacheddataid, UUID.class)), Optional.empty());
    }

    public Msdyn_aibfileattacheddataCollectionRequest owner_msdyn_aibfileattacheddata() {
        return new Msdyn_aibfileattacheddataCollectionRequest(
                        contextPath.addSegment("owner_msdyn_aibfileattacheddata"), Optional.empty());
    }

    public Msdyn_aifptrainingdocumentRequest owner_msdyn_aifptrainingdocument(UUID msdyn_aifptrainingdocumentid) {
        return new Msdyn_aifptrainingdocumentRequest(contextPath.addSegment("owner_msdyn_aifptrainingdocument").addKeys(new NameValue(msdyn_aifptrainingdocumentid, UUID.class)), Optional.empty());
    }

    public Msdyn_aifptrainingdocumentCollectionRequest owner_msdyn_aifptrainingdocument() {
        return new Msdyn_aifptrainingdocumentCollectionRequest(
                        contextPath.addSegment("owner_msdyn_aifptrainingdocument"), Optional.empty());
    }

    public Msdyn_aiodimageRequest owner_msdyn_aiodimage(UUID msdyn_aiodimageid) {
        return new Msdyn_aiodimageRequest(contextPath.addSegment("owner_msdyn_aiodimage").addKeys(new NameValue(msdyn_aiodimageid, UUID.class)), Optional.empty());
    }

    public Msdyn_aiodimageCollectionRequest owner_msdyn_aiodimage() {
        return new Msdyn_aiodimageCollectionRequest(
                        contextPath.addSegment("owner_msdyn_aiodimage"), Optional.empty());
    }

    public Msdyn_aiodlabelRequest owner_msdyn_aiodlabel(UUID msdyn_aiodlabelid) {
        return new Msdyn_aiodlabelRequest(contextPath.addSegment("owner_msdyn_aiodlabel").addKeys(new NameValue(msdyn_aiodlabelid, UUID.class)), Optional.empty());
    }

    public Msdyn_aiodlabelCollectionRequest owner_msdyn_aiodlabel() {
        return new Msdyn_aiodlabelCollectionRequest(
                        contextPath.addSegment("owner_msdyn_aiodlabel"), Optional.empty());
    }

    public Msdyn_aiodtrainingboundingboxRequest owner_msdyn_aiodtrainingboundingbox(UUID msdyn_aiodtrainingboundingboxid) {
        return new Msdyn_aiodtrainingboundingboxRequest(contextPath.addSegment("owner_msdyn_aiodtrainingboundingbox").addKeys(new NameValue(msdyn_aiodtrainingboundingboxid, UUID.class)), Optional.empty());
    }

    public Msdyn_aiodtrainingboundingboxCollectionRequest owner_msdyn_aiodtrainingboundingbox() {
        return new Msdyn_aiodtrainingboundingboxCollectionRequest(
                        contextPath.addSegment("owner_msdyn_aiodtrainingboundingbox"), Optional.empty());
    }

    public Msdyn_aiodtrainingimageRequest owner_msdyn_aiodtrainingimage(UUID msdyn_aiodtrainingimageid) {
        return new Msdyn_aiodtrainingimageRequest(contextPath.addSegment("owner_msdyn_aiodtrainingimage").addKeys(new NameValue(msdyn_aiodtrainingimageid, UUID.class)), Optional.empty());
    }

    public Msdyn_aiodtrainingimageCollectionRequest owner_msdyn_aiodtrainingimage() {
        return new Msdyn_aiodtrainingimageCollectionRequest(
                        contextPath.addSegment("owner_msdyn_aiodtrainingimage"), Optional.empty());
    }

    public Msdyn_analysiscomponentRequest owner_msdyn_analysiscomponent(UUID msdyn_analysiscomponentid) {
        return new Msdyn_analysiscomponentRequest(contextPath.addSegment("owner_msdyn_analysiscomponent").addKeys(new NameValue(msdyn_analysiscomponentid, UUID.class)), Optional.empty());
    }

    public Msdyn_analysiscomponentCollectionRequest owner_msdyn_analysiscomponent() {
        return new Msdyn_analysiscomponentCollectionRequest(
                        contextPath.addSegment("owner_msdyn_analysiscomponent"), Optional.empty());
    }

    public Msdyn_analysisjobRequest owner_msdyn_analysisjob(UUID msdyn_analysisjobid) {
        return new Msdyn_analysisjobRequest(contextPath.addSegment("owner_msdyn_analysisjob").addKeys(new NameValue(msdyn_analysisjobid, UUID.class)), Optional.empty());
    }

    public Msdyn_analysisjobCollectionRequest owner_msdyn_analysisjob() {
        return new Msdyn_analysisjobCollectionRequest(
                        contextPath.addSegment("owner_msdyn_analysisjob"), Optional.empty());
    }

    public Msdyn_analysisresultRequest owner_msdyn_analysisresult(UUID msdyn_analysisresultid) {
        return new Msdyn_analysisresultRequest(contextPath.addSegment("owner_msdyn_analysisresult").addKeys(new NameValue(msdyn_analysisresultid, UUID.class)), Optional.empty());
    }

    public Msdyn_analysisresultCollectionRequest owner_msdyn_analysisresult() {
        return new Msdyn_analysisresultCollectionRequest(
                        contextPath.addSegment("owner_msdyn_analysisresult"), Optional.empty());
    }

    public Msdyn_analysisresultdetailRequest owner_msdyn_analysisresultdetail(UUID msdyn_analysisresultdetailid) {
        return new Msdyn_analysisresultdetailRequest(contextPath.addSegment("owner_msdyn_analysisresultdetail").addKeys(new NameValue(msdyn_analysisresultdetailid, UUID.class)), Optional.empty());
    }

    public Msdyn_analysisresultdetailCollectionRequest owner_msdyn_analysisresultdetail() {
        return new Msdyn_analysisresultdetailCollectionRequest(
                        contextPath.addSegment("owner_msdyn_analysisresultdetail"), Optional.empty());
    }

    public Msdyn_solutionhealthruleRequest owner_msdyn_solutionhealthrule(UUID msdyn_solutionhealthruleid) {
        return new Msdyn_solutionhealthruleRequest(contextPath.addSegment("owner_msdyn_solutionhealthrule").addKeys(new NameValue(msdyn_solutionhealthruleid, UUID.class)), Optional.empty());
    }

    public Msdyn_solutionhealthruleCollectionRequest owner_msdyn_solutionhealthrule() {
        return new Msdyn_solutionhealthruleCollectionRequest(
                        contextPath.addSegment("owner_msdyn_solutionhealthrule"), Optional.empty());
    }

    public Msdyn_solutionhealthruleargumentRequest owner_msdyn_solutionhealthruleargument(UUID msdyn_solutionhealthruleargumentid) {
        return new Msdyn_solutionhealthruleargumentRequest(contextPath.addSegment("owner_msdyn_solutionhealthruleargument").addKeys(new NameValue(msdyn_solutionhealthruleargumentid, UUID.class)), Optional.empty());
    }

    public Msdyn_solutionhealthruleargumentCollectionRequest owner_msdyn_solutionhealthruleargument() {
        return new Msdyn_solutionhealthruleargumentCollectionRequest(
                        contextPath.addSegment("owner_msdyn_solutionhealthruleargument"), Optional.empty());
    }

    public Ggw_eventRequest owner_ggw_event(UUID ggw_eventid) {
        return new Ggw_eventRequest(contextPath.addSegment("owner_ggw_event").addKeys(new NameValue(ggw_eventid, UUID.class)), Optional.empty());
    }

    public Ggw_eventCollectionRequest owner_ggw_event() {
        return new Ggw_eventCollectionRequest(
                        contextPath.addSegment("owner_ggw_event"), Optional.empty());
    }

    public Ggw_teamRequest owner_ggw_team(UUID ggw_teamid) {
        return new Ggw_teamRequest(contextPath.addSegment("owner_ggw_team").addKeys(new NameValue(ggw_teamid, UUID.class)), Optional.empty());
    }

    public Ggw_teamCollectionRequest owner_ggw_team() {
        return new Ggw_teamCollectionRequest(
                        contextPath.addSegment("owner_ggw_team"), Optional.empty());
    }

    public Ggw_crewRequest owner_ggw_crew(UUID ggw_crewid) {
        return new Ggw_crewRequest(contextPath.addSegment("owner_ggw_crew").addKeys(new NameValue(ggw_crewid, UUID.class)), Optional.empty());
    }

    public Ggw_crewCollectionRequest owner_ggw_crew() {
        return new Ggw_crewCollectionRequest(
                        contextPath.addSegment("owner_ggw_crew"), Optional.empty());
    }

    public Ggw_team_applicationRequest owner_ggw_team_application(UUID ggw_team_applicationid) {
        return new Ggw_team_applicationRequest(contextPath.addSegment("owner_ggw_team_application").addKeys(new NameValue(ggw_team_applicationid, UUID.class)), Optional.empty());
    }

    public Ggw_team_applicationCollectionRequest owner_ggw_team_application() {
        return new Ggw_team_applicationCollectionRequest(
                        contextPath.addSegment("owner_ggw_team_application"), Optional.empty());
    }

}
