package microsoft.dynamics.crm.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.Msdyn_solutionhealthruleset;
import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.BulkdeletefailureCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.DuplicaterecordCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.MailboxtrackingfolderCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Msdyn_analysiscomponentCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Msdyn_solutionhealthruleCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PrincipalobjectattributeaccessCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ProcesssessionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;

@JsonIgnoreType
public class Msdyn_solutionhealthrulesetRequest extends EntityRequest<Msdyn_solutionhealthruleset> {

    public Msdyn_solutionhealthrulesetRequest(ContextPath contextPath, Optional<Object> value) {
        super(Msdyn_solutionhealthruleset.class, contextPath, value, false);
    }

    public SystemuserRequest createdby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), Optional.empty());
    }

    public SystemuserRequest createdonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), Optional.empty());
    }

    public SystemuserRequest modifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), Optional.empty());
    }

    public SystemuserRequest modifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), Optional.empty());
    }

    public OrganizationRequest organizationid() {
        return new OrganizationRequest(contextPath.addSegment("organizationid"), Optional.empty());
    }

    public SyncerrorRequest msdyn_solutionhealthruleset_SyncErrors(UUID syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("msdyn_solutionhealthruleset_SyncErrors").addKeys(new NameValue(syncerrorid, UUID.class)), Optional.empty());
    }

    public SyncerrorCollectionRequest msdyn_solutionhealthruleset_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("msdyn_solutionhealthruleset_SyncErrors"), Optional.empty());
    }

    public DuplicaterecordRequest msdyn_solutionhealthruleset_DuplicateMatchingRecord(UUID duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("msdyn_solutionhealthruleset_DuplicateMatchingRecord").addKeys(new NameValue(duplicateid, UUID.class)), Optional.empty());
    }

    public DuplicaterecordCollectionRequest msdyn_solutionhealthruleset_DuplicateMatchingRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("msdyn_solutionhealthruleset_DuplicateMatchingRecord"), Optional.empty());
    }

    public DuplicaterecordRequest msdyn_solutionhealthruleset_DuplicateBaseRecord(UUID duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("msdyn_solutionhealthruleset_DuplicateBaseRecord").addKeys(new NameValue(duplicateid, UUID.class)), Optional.empty());
    }

    public DuplicaterecordCollectionRequest msdyn_solutionhealthruleset_DuplicateBaseRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("msdyn_solutionhealthruleset_DuplicateBaseRecord"), Optional.empty());
    }

    public AsyncoperationRequest msdyn_solutionhealthruleset_AsyncOperations(UUID asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("msdyn_solutionhealthruleset_AsyncOperations").addKeys(new NameValue(asyncoperationid, UUID.class)), Optional.empty());
    }

    public AsyncoperationCollectionRequest msdyn_solutionhealthruleset_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("msdyn_solutionhealthruleset_AsyncOperations"), Optional.empty());
    }

    public MailboxtrackingfolderRequest msdyn_solutionhealthruleset_MailboxTrackingFolders(UUID mailboxtrackingfolderid) {
        return new MailboxtrackingfolderRequest(contextPath.addSegment("msdyn_solutionhealthruleset_MailboxTrackingFolders").addKeys(new NameValue(mailboxtrackingfolderid, UUID.class)), Optional.empty());
    }

    public MailboxtrackingfolderCollectionRequest msdyn_solutionhealthruleset_MailboxTrackingFolders() {
        return new MailboxtrackingfolderCollectionRequest(
                        contextPath.addSegment("msdyn_solutionhealthruleset_MailboxTrackingFolders"), Optional.empty());
    }

    public ProcesssessionRequest msdyn_solutionhealthruleset_ProcessSession(UUID processsessionid) {
        return new ProcesssessionRequest(contextPath.addSegment("msdyn_solutionhealthruleset_ProcessSession").addKeys(new NameValue(processsessionid, UUID.class)), Optional.empty());
    }

    public ProcesssessionCollectionRequest msdyn_solutionhealthruleset_ProcessSession() {
        return new ProcesssessionCollectionRequest(
                        contextPath.addSegment("msdyn_solutionhealthruleset_ProcessSession"), Optional.empty());
    }

    public BulkdeletefailureRequest msdyn_solutionhealthruleset_BulkDeleteFailures(UUID bulkdeletefailureid) {
        return new BulkdeletefailureRequest(contextPath.addSegment("msdyn_solutionhealthruleset_BulkDeleteFailures").addKeys(new NameValue(bulkdeletefailureid, UUID.class)), Optional.empty());
    }

    public BulkdeletefailureCollectionRequest msdyn_solutionhealthruleset_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(
                        contextPath.addSegment("msdyn_solutionhealthruleset_BulkDeleteFailures"), Optional.empty());
    }

    public PrincipalobjectattributeaccessRequest msdyn_solutionhealthruleset_PrincipalObjectAttributeAccesses(UUID principalobjectattributeaccessid) {
        return new PrincipalobjectattributeaccessRequest(contextPath.addSegment("msdyn_solutionhealthruleset_PrincipalObjectAttributeAccesses").addKeys(new NameValue(principalobjectattributeaccessid, UUID.class)), Optional.empty());
    }

    public PrincipalobjectattributeaccessCollectionRequest msdyn_solutionhealthruleset_PrincipalObjectAttributeAccesses() {
        return new PrincipalobjectattributeaccessCollectionRequest(
                        contextPath.addSegment("msdyn_solutionhealthruleset_PrincipalObjectAttributeAccesses"), Optional.empty());
    }

    public Msdyn_analysiscomponentRequest msdyn_msdyn_solutionhealthruleset_msdyn_analysi(UUID msdyn_analysiscomponentid) {
        return new Msdyn_analysiscomponentRequest(contextPath.addSegment("msdyn_msdyn_solutionhealthruleset_msdyn_analysi").addKeys(new NameValue(msdyn_analysiscomponentid, UUID.class)), Optional.empty());
    }

    public Msdyn_analysiscomponentCollectionRequest msdyn_msdyn_solutionhealthruleset_msdyn_analysi() {
        return new Msdyn_analysiscomponentCollectionRequest(
                        contextPath.addSegment("msdyn_msdyn_solutionhealthruleset_msdyn_analysi"), Optional.empty());
    }

    public Msdyn_solutionhealthruleRequest msdyn_msdyn_solutionhealthruleset_msdyn_solutio(UUID msdyn_solutionhealthruleid) {
        return new Msdyn_solutionhealthruleRequest(contextPath.addSegment("msdyn_msdyn_solutionhealthruleset_msdyn_solutio").addKeys(new NameValue(msdyn_solutionhealthruleid, UUID.class)), Optional.empty());
    }

    public Msdyn_solutionhealthruleCollectionRequest msdyn_msdyn_solutionhealthruleset_msdyn_solutio() {
        return new Msdyn_solutionhealthruleCollectionRequest(
                        contextPath.addSegment("msdyn_msdyn_solutionhealthruleset_msdyn_solutio"), Optional.empty());
    }

}
