package microsoft.dynamics.crm.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.Metric;
import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.GoalCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ProcesssessionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.RollupfieldCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;

@JsonIgnoreType
public class MetricRequest extends EntityRequest<Metric> {

    public MetricRequest(ContextPath contextPath, Optional<Object> value) {
        super(Metric.class, contextPath, value, false);
    }

    public SystemuserRequest createdby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), Optional.empty());
    }

    public SystemuserRequest createdonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), Optional.empty());
    }

    public SystemuserRequest modifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), Optional.empty());
    }

    public SystemuserRequest modifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), Optional.empty());
    }

    public OrganizationRequest organizationid() {
        return new OrganizationRequest(contextPath.addSegment("organizationid"), Optional.empty());
    }

    public GoalRequest metric_goal(UUID goalid) {
        return new GoalRequest(contextPath.addSegment("metric_goal").addKeys(new NameValue(goalid, UUID.class)), Optional.empty());
    }

    public GoalCollectionRequest metric_goal() {
        return new GoalCollectionRequest(
                        contextPath.addSegment("metric_goal"), Optional.empty());
    }

    public RollupfieldRequest metric_rollupfield(UUID rollupfieldid) {
        return new RollupfieldRequest(contextPath.addSegment("metric_rollupfield").addKeys(new NameValue(rollupfieldid, UUID.class)), Optional.empty());
    }

    public RollupfieldCollectionRequest metric_rollupfield() {
        return new RollupfieldCollectionRequest(
                        contextPath.addSegment("metric_rollupfield"), Optional.empty());
    }

    public ProcesssessionRequest metric_ProcessSessions(UUID processsessionid) {
        return new ProcesssessionRequest(contextPath.addSegment("metric_ProcessSessions").addKeys(new NameValue(processsessionid, UUID.class)), Optional.empty());
    }

    public ProcesssessionCollectionRequest metric_ProcessSessions() {
        return new ProcesssessionCollectionRequest(
                        contextPath.addSegment("metric_ProcessSessions"), Optional.empty());
    }

    public AsyncoperationRequest metric_AsyncOperations(UUID asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("metric_AsyncOperations").addKeys(new NameValue(asyncoperationid, UUID.class)), Optional.empty());
    }

    public AsyncoperationCollectionRequest metric_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("metric_AsyncOperations"), Optional.empty());
    }

    public SyncerrorRequest metric_SyncErrors(UUID syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("Metric_SyncErrors").addKeys(new NameValue(syncerrorid, UUID.class)), Optional.empty());
    }

    public SyncerrorCollectionRequest metric_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("Metric_SyncErrors"), Optional.empty());
    }

}
