package microsoft.dynamics.crm.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.Mailmergetemplate;
import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PrincipalobjectattributeaccessCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ProcesssessionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;

@JsonIgnoreType
public class MailmergetemplateRequest extends EntityRequest<Mailmergetemplate> {

    public MailmergetemplateRequest(ContextPath contextPath, Optional<Object> value) {
        super(Mailmergetemplate.class, contextPath, value, false);
    }

    public TransactioncurrencyRequest transactioncurrencyid() {
        return new TransactioncurrencyRequest(contextPath.addSegment("transactioncurrencyid"), Optional.empty());
    }

    public PrincipalRequest ownerid() {
        return new PrincipalRequest(contextPath.addSegment("ownerid"), Optional.empty());
    }

    public PrincipalobjectattributeaccessRequest mailmergetemplate_principalobjectattributeaccess(UUID principalobjectattributeaccessid) {
        return new PrincipalobjectattributeaccessRequest(contextPath.addSegment("mailmergetemplate_principalobjectattributeaccess").addKeys(new NameValue(principalobjectattributeaccessid, UUID.class)), Optional.empty());
    }

    public PrincipalobjectattributeaccessCollectionRequest mailmergetemplate_principalobjectattributeaccess() {
        return new PrincipalobjectattributeaccessCollectionRequest(
                        contextPath.addSegment("mailmergetemplate_principalobjectattributeaccess"), Optional.empty());
    }

    public AsyncoperationRequest mailMergeTemplate_AsyncOperations(UUID asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("MailMergeTemplate_AsyncOperations").addKeys(new NameValue(asyncoperationid, UUID.class)), Optional.empty());
    }

    public AsyncoperationCollectionRequest mailMergeTemplate_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("MailMergeTemplate_AsyncOperations"), Optional.empty());
    }

    public ProcesssessionRequest mailMergeTemplate_ProcessSessions(UUID processsessionid) {
        return new ProcesssessionRequest(contextPath.addSegment("MailMergeTemplate_ProcessSessions").addKeys(new NameValue(processsessionid, UUID.class)), Optional.empty());
    }

    public ProcesssessionCollectionRequest mailMergeTemplate_ProcessSessions() {
        return new ProcesssessionCollectionRequest(
                        contextPath.addSegment("MailMergeTemplate_ProcessSessions"), Optional.empty());
    }

    public SystemuserRequest createdonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), Optional.empty());
    }

    public BusinessunitRequest owningbusinessunit() {
        return new BusinessunitRequest(contextPath.addSegment("owningbusinessunit"), Optional.empty());
    }

    public SystemuserRequest modifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), Optional.empty());
    }

    public SyncerrorRequest mailMergeTemplate_SyncErrors(UUID syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("MailMergeTemplate_SyncErrors").addKeys(new NameValue(syncerrorid, UUID.class)), Optional.empty());
    }

    public SyncerrorCollectionRequest mailMergeTemplate_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("MailMergeTemplate_SyncErrors"), Optional.empty());
    }

    public SystemuserRequest modifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), Optional.empty());
    }

    public SystemuserRequest createdby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), Optional.empty());
    }

}
