package microsoft.dynamics.crm.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.Fieldsecurityprofile;
import microsoft.dynamics.crm.entity.collection.request.FieldpermissionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SystemuserCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.TeamCollectionRequest;

@JsonIgnoreType
public class FieldsecurityprofileRequest extends EntityRequest<Fieldsecurityprofile> {

    public FieldsecurityprofileRequest(ContextPath contextPath, Optional<Object> value) {
        super(Fieldsecurityprofile.class, contextPath, value, false);
    }

    public SystemuserRequest createdonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), Optional.empty());
    }

    public SyncerrorRequest fieldSecurityProfile_SyncErrors(UUID syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("FieldSecurityProfile_SyncErrors").addKeys(new NameValue(syncerrorid, UUID.class)), Optional.empty());
    }

    public SyncerrorCollectionRequest fieldSecurityProfile_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("FieldSecurityProfile_SyncErrors"), Optional.empty());
    }

    public OrganizationRequest organizationid() {
        return new OrganizationRequest(contextPath.addSegment("organizationid"), Optional.empty());
    }

    public SystemuserRequest systemuserprofiles_association(UUID ownerid) {
        return new SystemuserRequest(contextPath.addSegment("systemuserprofiles_association").addKeys(new NameValue(ownerid, UUID.class)), Optional.empty());
    }

    public SystemuserCollectionRequest systemuserprofiles_association() {
        return new SystemuserCollectionRequest(
                        contextPath.addSegment("systemuserprofiles_association"), Optional.empty());
    }

    public FieldpermissionRequest lk_fieldpermission_fieldsecurityprofileid(UUID fieldpermissionid) {
        return new FieldpermissionRequest(contextPath.addSegment("lk_fieldpermission_fieldsecurityprofileid").addKeys(new NameValue(fieldpermissionid, UUID.class)), Optional.empty());
    }

    public FieldpermissionCollectionRequest lk_fieldpermission_fieldsecurityprofileid() {
        return new FieldpermissionCollectionRequest(
                        contextPath.addSegment("lk_fieldpermission_fieldsecurityprofileid"), Optional.empty());
    }

    public SystemuserRequest modifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), Optional.empty());
    }

    public TeamRequest teamprofiles_association(UUID ownerid) {
        return new TeamRequest(contextPath.addSegment("teamprofiles_association").addKeys(new NameValue(ownerid, UUID.class)), Optional.empty());
    }

    public TeamCollectionRequest teamprofiles_association() {
        return new TeamCollectionRequest(
                        contextPath.addSegment("teamprofiles_association"), Optional.empty());
    }

    public SystemuserRequest modifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), Optional.empty());
    }

    public SystemuserRequest createdby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), Optional.empty());
    }

    public SolutionRequest solution_fieldsecurityprofile() {
        return new SolutionRequest(contextPath.addSegment("solution_fieldsecurityprofile"), Optional.empty());
    }

}
