package microsoft.dynamics.crm.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Sitemap;
import microsoft.dynamics.crm.entity.request.SitemapRequest;

public class SitemapCollectionRequest extends CollectionPageEntityRequest<Sitemap, SitemapRequest>{

    protected ContextPath contextPath;

    public SitemapCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Sitemap.class, cp -> new SitemapRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    @Function(name = "RetrieveUnpublishedMultiple")
    @JsonIgnore
    public CollectionPageNonEntityRequest<Sitemap> retrieveUnpublishedMultiple() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrieveUnpublishedMultiple"), Sitemap.class, _parameters);
    }

}
