package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.Postregarding;
import microsoft.dynamics.crm.entity.request.PostRequest;
import microsoft.dynamics.crm.entity.request.PostregardingRequest;

public class PostregardingCollectionRequest extends CollectionPageEntityRequest<Postregarding, PostregardingRequest>{

    protected ContextPath contextPath;

    public PostregardingCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Postregarding.class, cp -> new PostregardingRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public PostRequest post_PostRegardings(UUID postid) {
        return new PostRequest(contextPath.addSegment("post_PostRegardings").addKeys(new NameValue(postid, UUID.class)), Optional.empty());
    }

    public PostCollectionRequest post_PostRegardings() {
        return new PostCollectionRequest(contextPath.addSegment("post_PostRegardings"), Optional.empty());
    }

}
