package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.Importmap;
import microsoft.dynamics.crm.entity.request.AsyncoperationRequest;
import microsoft.dynamics.crm.entity.request.BulkdeletefailureRequest;
import microsoft.dynamics.crm.entity.request.ColumnmappingRequest;
import microsoft.dynamics.crm.entity.request.ImportentitymappingRequest;
import microsoft.dynamics.crm.entity.request.ImportfileRequest;
import microsoft.dynamics.crm.entity.request.ImportmapRequest;
import microsoft.dynamics.crm.entity.request.OwnermappingRequest;
import microsoft.dynamics.crm.entity.request.SyncerrorRequest;
import microsoft.dynamics.crm.entity.request.TransformationmappingRequest;

public class ImportmapCollectionRequest extends CollectionPageEntityRequest<Importmap, ImportmapRequest>{

    protected ContextPath contextPath;

    public ImportmapCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Importmap.class, cp -> new ImportmapRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public SyncerrorRequest importMap_SyncErrors(UUID syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("ImportMap_SyncErrors").addKeys(new NameValue(syncerrorid, UUID.class)), Optional.empty());
    }

    public SyncerrorCollectionRequest importMap_SyncErrors() {
        return new SyncerrorCollectionRequest(contextPath.addSegment("ImportMap_SyncErrors"), Optional.empty());
    }

    public ColumnmappingRequest columnMapping_ImportMap(UUID columnmappingid) {
        return new ColumnmappingRequest(contextPath.addSegment("ColumnMapping_ImportMap").addKeys(new NameValue(columnmappingid, UUID.class)), Optional.empty());
    }

    public ColumnmappingCollectionRequest columnMapping_ImportMap() {
        return new ColumnmappingCollectionRequest(contextPath.addSegment("ColumnMapping_ImportMap"), Optional.empty());
    }

    public AsyncoperationRequest importMap_AsyncOperations(UUID asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("ImportMap_AsyncOperations").addKeys(new NameValue(asyncoperationid, UUID.class)), Optional.empty());
    }

    public AsyncoperationCollectionRequest importMap_AsyncOperations() {
        return new AsyncoperationCollectionRequest(contextPath.addSegment("ImportMap_AsyncOperations"), Optional.empty());
    }

    public ImportentitymappingRequest importEntityMapping_ImportMap(UUID importentitymappingid) {
        return new ImportentitymappingRequest(contextPath.addSegment("ImportEntityMapping_ImportMap").addKeys(new NameValue(importentitymappingid, UUID.class)), Optional.empty());
    }

    public ImportentitymappingCollectionRequest importEntityMapping_ImportMap() {
        return new ImportentitymappingCollectionRequest(contextPath.addSegment("ImportEntityMapping_ImportMap"), Optional.empty());
    }

    public BulkdeletefailureRequest importMap_BulkDeleteFailures(UUID bulkdeletefailureid) {
        return new BulkdeletefailureRequest(contextPath.addSegment("ImportMap_BulkDeleteFailures").addKeys(new NameValue(bulkdeletefailureid, UUID.class)), Optional.empty());
    }

    public BulkdeletefailureCollectionRequest importMap_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(contextPath.addSegment("ImportMap_BulkDeleteFailures"), Optional.empty());
    }

    public OwnermappingRequest ownerMapping_ImportMap(UUID ownermappingid) {
        return new OwnermappingRequest(contextPath.addSegment("OwnerMapping_ImportMap").addKeys(new NameValue(ownermappingid, UUID.class)), Optional.empty());
    }

    public OwnermappingCollectionRequest ownerMapping_ImportMap() {
        return new OwnermappingCollectionRequest(contextPath.addSegment("OwnerMapping_ImportMap"), Optional.empty());
    }

    public ImportfileRequest importMap_ImportFile(UUID importfileid) {
        return new ImportfileRequest(contextPath.addSegment("ImportMap_ImportFile").addKeys(new NameValue(importfileid, UUID.class)), Optional.empty());
    }

    public ImportfileCollectionRequest importMap_ImportFile() {
        return new ImportfileCollectionRequest(contextPath.addSegment("ImportMap_ImportFile"), Optional.empty());
    }

    public TransformationmappingRequest transformationMapping_ImportMap(UUID transformationmappingid) {
        return new TransformationmappingRequest(contextPath.addSegment("TransformationMapping_ImportMap").addKeys(new NameValue(transformationmappingid, UUID.class)), Optional.empty());
    }

    public TransformationmappingCollectionRequest transformationMapping_ImportMap() {
        return new TransformationmappingCollectionRequest(contextPath.addSegment("TransformationMapping_ImportMap"), Optional.empty());
    }

}
