package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.Entityanalyticsconfig;
import microsoft.dynamics.crm.entity.request.AsyncoperationRequest;
import microsoft.dynamics.crm.entity.request.BulkdeletefailureRequest;
import microsoft.dynamics.crm.entity.request.EntityanalyticsconfigRequest;
import microsoft.dynamics.crm.entity.request.MailboxtrackingfolderRequest;
import microsoft.dynamics.crm.entity.request.PrincipalobjectattributeaccessRequest;
import microsoft.dynamics.crm.entity.request.SyncerrorRequest;

public class EntityanalyticsconfigCollectionRequest extends CollectionPageEntityRequest<Entityanalyticsconfig, EntityanalyticsconfigRequest>{

    protected ContextPath contextPath;

    public EntityanalyticsconfigCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Entityanalyticsconfig.class, cp -> new EntityanalyticsconfigRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public SyncerrorRequest entityanalyticsconfig_SyncErrors(UUID syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("entityanalyticsconfig_SyncErrors").addKeys(new NameValue(syncerrorid, UUID.class)), Optional.empty());
    }

    public SyncerrorCollectionRequest entityanalyticsconfig_SyncErrors() {
        return new SyncerrorCollectionRequest(contextPath.addSegment("entityanalyticsconfig_SyncErrors"), Optional.empty());
    }

    public AsyncoperationRequest entityanalyticsconfig_AsyncOperations(UUID asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("entityanalyticsconfig_AsyncOperations").addKeys(new NameValue(asyncoperationid, UUID.class)), Optional.empty());
    }

    public AsyncoperationCollectionRequest entityanalyticsconfig_AsyncOperations() {
        return new AsyncoperationCollectionRequest(contextPath.addSegment("entityanalyticsconfig_AsyncOperations"), Optional.empty());
    }

    public MailboxtrackingfolderRequest entityanalyticsconfig_MailboxTrackingFolders(UUID mailboxtrackingfolderid) {
        return new MailboxtrackingfolderRequest(contextPath.addSegment("entityanalyticsconfig_MailboxTrackingFolders").addKeys(new NameValue(mailboxtrackingfolderid, UUID.class)), Optional.empty());
    }

    public MailboxtrackingfolderCollectionRequest entityanalyticsconfig_MailboxTrackingFolders() {
        return new MailboxtrackingfolderCollectionRequest(contextPath.addSegment("entityanalyticsconfig_MailboxTrackingFolders"), Optional.empty());
    }

    public BulkdeletefailureRequest entityanalyticsconfig_BulkDeleteFailures(UUID bulkdeletefailureid) {
        return new BulkdeletefailureRequest(contextPath.addSegment("entityanalyticsconfig_BulkDeleteFailures").addKeys(new NameValue(bulkdeletefailureid, UUID.class)), Optional.empty());
    }

    public BulkdeletefailureCollectionRequest entityanalyticsconfig_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(contextPath.addSegment("entityanalyticsconfig_BulkDeleteFailures"), Optional.empty());
    }

    public PrincipalobjectattributeaccessRequest entityanalyticsconfig_PrincipalObjectAttributeAccesses(UUID principalobjectattributeaccessid) {
        return new PrincipalobjectattributeaccessRequest(contextPath.addSegment("entityanalyticsconfig_PrincipalObjectAttributeAccesses").addKeys(new NameValue(principalobjectattributeaccessid, UUID.class)), Optional.empty());
    }

    public PrincipalobjectattributeaccessCollectionRequest entityanalyticsconfig_PrincipalObjectAttributeAccesses() {
        return new PrincipalobjectattributeaccessCollectionRequest(contextPath.addSegment("entityanalyticsconfig_PrincipalObjectAttributeAccesses"), Optional.empty());
    }

}
