package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;
import java.util.UUID;

@JsonPropertyOrder({
    "@odata.type", 
    "teamprofileid", 
    "versionnumber", 
    "teamid", 
    "fieldsecurityprofileid"})
@JsonInclude(Include.NON_NULL)
public class Teamprofiles extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.teamprofiles";
    }

    @JsonProperty("teamprofileid")
    protected UUID teamprofileid;

    @JsonProperty("versionnumber")
    protected Long versionnumber;

    @JsonProperty("teamid")
    protected UUID teamid;

    @JsonProperty("fieldsecurityprofileid")
    protected UUID fieldsecurityprofileid;

    protected Teamprofiles() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderTeamprofiles() {
        return new Builder();
    }

    public static final class Builder {
        private UUID teamprofileid;
        private Long versionnumber;
        private UUID teamid;
        private UUID fieldsecurityprofileid;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder teamprofileid(UUID teamprofileid) {
            this.teamprofileid = teamprofileid;
            this.changedFields = changedFields.add("teamprofileid");
            return this;
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Builder teamid(UUID teamid) {
            this.teamid = teamid;
            this.changedFields = changedFields.add("teamid");
            return this;
        }

        public Builder fieldsecurityprofileid(UUID fieldsecurityprofileid) {
            this.fieldsecurityprofileid = fieldsecurityprofileid;
            this.changedFields = changedFields.add("fieldsecurityprofileid");
            return this;
        }

        public Teamprofiles build() {
            Teamprofiles _x = new Teamprofiles();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.teamprofiles";
            _x.teamprofileid = teamprofileid;
            _x.versionnumber = versionnumber;
            _x.teamid = teamid;
            _x.fieldsecurityprofileid = fieldsecurityprofileid;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && teamprofileid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(teamprofileid, UUID.class));
        }
    }

    @Property(name="teamprofileid")
    @JsonIgnore
    public Optional<UUID> getTeamprofileid() {
        return Optional.ofNullable(teamprofileid);
    }

    public Teamprofiles withTeamprofileid(UUID teamprofileid) {
        Teamprofiles _x = _copy();
        _x.changedFields = changedFields.add("teamprofileid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.teamprofiles");
        _x.teamprofileid = teamprofileid;
        return _x;
    }

    @Property(name="versionnumber")
    @JsonIgnore
    public Optional<Long> getVersionnumber() {
        return Optional.ofNullable(versionnumber);
    }

    public Teamprofiles withVersionnumber(Long versionnumber) {
        Teamprofiles _x = _copy();
        _x.changedFields = changedFields.add("versionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.teamprofiles");
        _x.versionnumber = versionnumber;
        return _x;
    }

    @Property(name="teamid")
    @JsonIgnore
    public Optional<UUID> getTeamid() {
        return Optional.ofNullable(teamid);
    }

    public Teamprofiles withTeamid(UUID teamid) {
        Teamprofiles _x = _copy();
        _x.changedFields = changedFields.add("teamid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.teamprofiles");
        _x.teamid = teamid;
        return _x;
    }

    @Property(name="fieldsecurityprofileid")
    @JsonIgnore
    public Optional<UUID> getFieldsecurityprofileid() {
        return Optional.ofNullable(fieldsecurityprofileid);
    }

    public Teamprofiles withFieldsecurityprofileid(UUID fieldsecurityprofileid) {
        Teamprofiles _x = _copy();
        _x.changedFields = changedFields.add("fieldsecurityprofileid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.teamprofiles");
        _x.fieldsecurityprofileid = fieldsecurityprofileid;
        return _x;
    }

    public Teamprofiles withUnmappedField(String name, String value) {
        Teamprofiles _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Teamprofiles patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Teamprofiles _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Teamprofiles put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Teamprofiles _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Teamprofiles _copy() {
        Teamprofiles _x = new Teamprofiles();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.teamprofileid = teamprofileid;
        _x.versionnumber = versionnumber;
        _x.teamid = teamid;
        _x.fieldsecurityprofileid = fieldsecurityprofileid;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Teamprofiles[");
        b.append("teamprofileid=");
        b.append(this.teamprofileid);
        b.append(", ");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append(", ");
        b.append("teamid=");
        b.append(this.teamid);
        b.append(", ");
        b.append("fieldsecurityprofileid=");
        b.append(this.fieldsecurityprofileid);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
