package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.BulkdeletefailureCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.DuplicaterecordCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.FileattachmentCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.MailboxtrackingfolderCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PrincipalobjectattributeaccessCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ProcesssessionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;
import microsoft.dynamics.crm.entity.request.BusinessunitRequest;
import microsoft.dynamics.crm.entity.request.PrincipalRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;
import microsoft.dynamics.crm.entity.request.TeamRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "modifiedon", 
    "solutionfilename", 
    "solutionuniquename", 
    "statuscode", 
    "name", 
    "statecode", 
    "stagesolutionuploadid", 
    "_owningbusinessunit_value", 
    "solutionfile", 
    "importsequencenumber", 
    "createdon", 
    "_createdonbehalfby_value", 
    "_owninguser_value", 
    "overriddencreatedon", 
    "_owningteam_value", 
    "_modifiedby_value", 
    "_modifiedonbehalfby_value", 
    "_ownerid_value", 
    "_createdby_value", 
    "timezoneruleversionnumber", 
    "utcconversiontimezonecode", 
    "versionnumber", 
    "solutionfile_name"})
@JsonInclude(Include.NON_NULL)
public class Stagesolutionupload extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.stagesolutionupload";
    }

    @JsonProperty("modifiedon")
    protected OffsetDateTime modifiedon;

    @JsonProperty("solutionfilename")
    protected String solutionfilename;

    @JsonProperty("solutionuniquename")
    protected String solutionuniquename;

    @JsonProperty("statuscode")
    protected Integer statuscode;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("statecode")
    protected Integer statecode;

    @JsonProperty("stagesolutionuploadid")
    protected UUID stagesolutionuploadid;

    @JsonProperty("_owningbusinessunit_value")
    protected UUID _owningbusinessunit_value;

    @JsonProperty("solutionfile")
    protected byte[] solutionfile;

    @JsonProperty("importsequencenumber")
    protected Integer importsequencenumber;

    @JsonProperty("createdon")
    protected OffsetDateTime createdon;

    @JsonProperty("_createdonbehalfby_value")
    protected UUID _createdonbehalfby_value;

    @JsonProperty("_owninguser_value")
    protected UUID _owninguser_value;

    @JsonProperty("overriddencreatedon")
    protected OffsetDateTime overriddencreatedon;

    @JsonProperty("_owningteam_value")
    protected UUID _owningteam_value;

    @JsonProperty("_modifiedby_value")
    protected UUID _modifiedby_value;

    @JsonProperty("_modifiedonbehalfby_value")
    protected UUID _modifiedonbehalfby_value;

    @JsonProperty("_ownerid_value")
    protected UUID _ownerid_value;

    @JsonProperty("_createdby_value")
    protected UUID _createdby_value;

    @JsonProperty("timezoneruleversionnumber")
    protected Integer timezoneruleversionnumber;

    @JsonProperty("utcconversiontimezonecode")
    protected Integer utcconversiontimezonecode;

    @JsonProperty("versionnumber")
    protected Long versionnumber;

    @JsonProperty("solutionfile_name")
    protected String solutionfile_name;

    protected Stagesolutionupload() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderStagesolutionupload() {
        return new Builder();
    }

    public static final class Builder {
        private OffsetDateTime modifiedon;
        private String solutionfilename;
        private String solutionuniquename;
        private Integer statuscode;
        private String name;
        private Integer statecode;
        private UUID stagesolutionuploadid;
        private UUID _owningbusinessunit_value;
        private byte[] solutionfile;
        private Integer importsequencenumber;
        private OffsetDateTime createdon;
        private UUID _createdonbehalfby_value;
        private UUID _owninguser_value;
        private OffsetDateTime overriddencreatedon;
        private UUID _owningteam_value;
        private UUID _modifiedby_value;
        private UUID _modifiedonbehalfby_value;
        private UUID _ownerid_value;
        private UUID _createdby_value;
        private Integer timezoneruleversionnumber;
        private Integer utcconversiontimezonecode;
        private Long versionnumber;
        private String solutionfile_name;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder modifiedon(OffsetDateTime modifiedon) {
            this.modifiedon = modifiedon;
            this.changedFields = changedFields.add("modifiedon");
            return this;
        }

        public Builder solutionfilename(String solutionfilename) {
            this.solutionfilename = solutionfilename;
            this.changedFields = changedFields.add("solutionfilename");
            return this;
        }

        public Builder solutionuniquename(String solutionuniquename) {
            this.solutionuniquename = solutionuniquename;
            this.changedFields = changedFields.add("solutionuniquename");
            return this;
        }

        public Builder statuscode(Integer statuscode) {
            this.statuscode = statuscode;
            this.changedFields = changedFields.add("statuscode");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder statecode(Integer statecode) {
            this.statecode = statecode;
            this.changedFields = changedFields.add("statecode");
            return this;
        }

        public Builder stagesolutionuploadid(UUID stagesolutionuploadid) {
            this.stagesolutionuploadid = stagesolutionuploadid;
            this.changedFields = changedFields.add("stagesolutionuploadid");
            return this;
        }

        public Builder _owningbusinessunit_value(UUID _owningbusinessunit_value) {
            this._owningbusinessunit_value = _owningbusinessunit_value;
            this.changedFields = changedFields.add("_owningbusinessunit_value");
            return this;
        }

        public Builder solutionfile(byte[] solutionfile) {
            this.solutionfile = solutionfile;
            this.changedFields = changedFields.add("solutionfile");
            return this;
        }

        public Builder importsequencenumber(Integer importsequencenumber) {
            this.importsequencenumber = importsequencenumber;
            this.changedFields = changedFields.add("importsequencenumber");
            return this;
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Builder _createdonbehalfby_value(UUID _createdonbehalfby_value) {
            this._createdonbehalfby_value = _createdonbehalfby_value;
            this.changedFields = changedFields.add("_createdonbehalfby_value");
            return this;
        }

        public Builder _owninguser_value(UUID _owninguser_value) {
            this._owninguser_value = _owninguser_value;
            this.changedFields = changedFields.add("_owninguser_value");
            return this;
        }

        public Builder overriddencreatedon(OffsetDateTime overriddencreatedon) {
            this.overriddencreatedon = overriddencreatedon;
            this.changedFields = changedFields.add("overriddencreatedon");
            return this;
        }

        public Builder _owningteam_value(UUID _owningteam_value) {
            this._owningteam_value = _owningteam_value;
            this.changedFields = changedFields.add("_owningteam_value");
            return this;
        }

        public Builder _modifiedby_value(UUID _modifiedby_value) {
            this._modifiedby_value = _modifiedby_value;
            this.changedFields = changedFields.add("_modifiedby_value");
            return this;
        }

        public Builder _modifiedonbehalfby_value(UUID _modifiedonbehalfby_value) {
            this._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            this.changedFields = changedFields.add("_modifiedonbehalfby_value");
            return this;
        }

        public Builder _ownerid_value(UUID _ownerid_value) {
            this._ownerid_value = _ownerid_value;
            this.changedFields = changedFields.add("_ownerid_value");
            return this;
        }

        public Builder _createdby_value(UUID _createdby_value) {
            this._createdby_value = _createdby_value;
            this.changedFields = changedFields.add("_createdby_value");
            return this;
        }

        public Builder timezoneruleversionnumber(Integer timezoneruleversionnumber) {
            this.timezoneruleversionnumber = timezoneruleversionnumber;
            this.changedFields = changedFields.add("timezoneruleversionnumber");
            return this;
        }

        public Builder utcconversiontimezonecode(Integer utcconversiontimezonecode) {
            this.utcconversiontimezonecode = utcconversiontimezonecode;
            this.changedFields = changedFields.add("utcconversiontimezonecode");
            return this;
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Builder solutionfile_name(String solutionfile_name) {
            this.solutionfile_name = solutionfile_name;
            this.changedFields = changedFields.add("solutionfile_name");
            return this;
        }

        public Stagesolutionupload build() {
            Stagesolutionupload _x = new Stagesolutionupload();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.stagesolutionupload";
            _x.modifiedon = modifiedon;
            _x.solutionfilename = solutionfilename;
            _x.solutionuniquename = solutionuniquename;
            _x.statuscode = statuscode;
            _x.name = name;
            _x.statecode = statecode;
            _x.stagesolutionuploadid = stagesolutionuploadid;
            _x._owningbusinessunit_value = _owningbusinessunit_value;
            _x.solutionfile = solutionfile;
            _x.importsequencenumber = importsequencenumber;
            _x.createdon = createdon;
            _x._createdonbehalfby_value = _createdonbehalfby_value;
            _x._owninguser_value = _owninguser_value;
            _x.overriddencreatedon = overriddencreatedon;
            _x._owningteam_value = _owningteam_value;
            _x._modifiedby_value = _modifiedby_value;
            _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            _x._ownerid_value = _ownerid_value;
            _x._createdby_value = _createdby_value;
            _x.timezoneruleversionnumber = timezoneruleversionnumber;
            _x.utcconversiontimezonecode = utcconversiontimezonecode;
            _x.versionnumber = versionnumber;
            _x.solutionfile_name = solutionfile_name;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && stagesolutionuploadid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(stagesolutionuploadid, UUID.class));
        }
    }

    @Property(name="modifiedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedon() {
        return Optional.ofNullable(modifiedon);
    }

    public Stagesolutionupload withModifiedon(OffsetDateTime modifiedon) {
        Stagesolutionupload _x = _copy();
        _x.changedFields = changedFields.add("modifiedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.stagesolutionupload");
        _x.modifiedon = modifiedon;
        return _x;
    }

    @Property(name="solutionfilename")
    @JsonIgnore
    public Optional<String> getSolutionfilename() {
        return Optional.ofNullable(solutionfilename);
    }

    public Stagesolutionupload withSolutionfilename(String solutionfilename) {
        Checks.checkIsAscii(solutionfilename);
        Stagesolutionupload _x = _copy();
        _x.changedFields = changedFields.add("solutionfilename");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.stagesolutionupload");
        _x.solutionfilename = solutionfilename;
        return _x;
    }

    @Property(name="solutionuniquename")
    @JsonIgnore
    public Optional<String> getSolutionuniquename() {
        return Optional.ofNullable(solutionuniquename);
    }

    public Stagesolutionupload withSolutionuniquename(String solutionuniquename) {
        Checks.checkIsAscii(solutionuniquename);
        Stagesolutionupload _x = _copy();
        _x.changedFields = changedFields.add("solutionuniquename");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.stagesolutionupload");
        _x.solutionuniquename = solutionuniquename;
        return _x;
    }

    @Property(name="statuscode")
    @JsonIgnore
    public Optional<Integer> getStatuscode() {
        return Optional.ofNullable(statuscode);
    }

    public Stagesolutionupload withStatuscode(Integer statuscode) {
        Stagesolutionupload _x = _copy();
        _x.changedFields = changedFields.add("statuscode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.stagesolutionupload");
        _x.statuscode = statuscode;
        return _x;
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public Stagesolutionupload withName(String name) {
        Checks.checkIsAscii(name);
        Stagesolutionupload _x = _copy();
        _x.changedFields = changedFields.add("name");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.stagesolutionupload");
        _x.name = name;
        return _x;
    }

    @Property(name="statecode")
    @JsonIgnore
    public Optional<Integer> getStatecode() {
        return Optional.ofNullable(statecode);
    }

    public Stagesolutionupload withStatecode(Integer statecode) {
        Stagesolutionupload _x = _copy();
        _x.changedFields = changedFields.add("statecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.stagesolutionupload");
        _x.statecode = statecode;
        return _x;
    }

    @Property(name="stagesolutionuploadid")
    @JsonIgnore
    public Optional<UUID> getStagesolutionuploadid() {
        return Optional.ofNullable(stagesolutionuploadid);
    }

    public Stagesolutionupload withStagesolutionuploadid(UUID stagesolutionuploadid) {
        Stagesolutionupload _x = _copy();
        _x.changedFields = changedFields.add("stagesolutionuploadid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.stagesolutionupload");
        _x.stagesolutionuploadid = stagesolutionuploadid;
        return _x;
    }

    @Property(name="_owningbusinessunit_value")
    @JsonIgnore
    public Optional<UUID> get_owningbusinessunit_value() {
        return Optional.ofNullable(_owningbusinessunit_value);
    }

    public Stagesolutionupload with_owningbusinessunit_value(UUID _owningbusinessunit_value) {
        Stagesolutionupload _x = _copy();
        _x.changedFields = changedFields.add("_owningbusinessunit_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.stagesolutionupload");
        _x._owningbusinessunit_value = _owningbusinessunit_value;
        return _x;
    }

    @Property(name="solutionfile")
    @JsonIgnore
    public Optional<byte[]> getSolutionfile() {
        return Optional.ofNullable(solutionfile);
    }

    public Stagesolutionupload withSolutionfile(byte[] solutionfile) {
        Stagesolutionupload _x = _copy();
        _x.changedFields = changedFields.add("solutionfile");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.stagesolutionupload");
        _x.solutionfile = solutionfile;
        return _x;
    }

    @Property(name="importsequencenumber")
    @JsonIgnore
    public Optional<Integer> getImportsequencenumber() {
        return Optional.ofNullable(importsequencenumber);
    }

    public Stagesolutionupload withImportsequencenumber(Integer importsequencenumber) {
        Stagesolutionupload _x = _copy();
        _x.changedFields = changedFields.add("importsequencenumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.stagesolutionupload");
        _x.importsequencenumber = importsequencenumber;
        return _x;
    }

    @Property(name="createdon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedon() {
        return Optional.ofNullable(createdon);
    }

    public Stagesolutionupload withCreatedon(OffsetDateTime createdon) {
        Stagesolutionupload _x = _copy();
        _x.changedFields = changedFields.add("createdon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.stagesolutionupload");
        _x.createdon = createdon;
        return _x;
    }

    @Property(name="_createdonbehalfby_value")
    @JsonIgnore
    public Optional<UUID> get_createdonbehalfby_value() {
        return Optional.ofNullable(_createdonbehalfby_value);
    }

    public Stagesolutionupload with_createdonbehalfby_value(UUID _createdonbehalfby_value) {
        Stagesolutionupload _x = _copy();
        _x.changedFields = changedFields.add("_createdonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.stagesolutionupload");
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        return _x;
    }

    @Property(name="_owninguser_value")
    @JsonIgnore
    public Optional<UUID> get_owninguser_value() {
        return Optional.ofNullable(_owninguser_value);
    }

    public Stagesolutionupload with_owninguser_value(UUID _owninguser_value) {
        Stagesolutionupload _x = _copy();
        _x.changedFields = changedFields.add("_owninguser_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.stagesolutionupload");
        _x._owninguser_value = _owninguser_value;
        return _x;
    }

    @Property(name="overriddencreatedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverriddencreatedon() {
        return Optional.ofNullable(overriddencreatedon);
    }

    public Stagesolutionupload withOverriddencreatedon(OffsetDateTime overriddencreatedon) {
        Stagesolutionupload _x = _copy();
        _x.changedFields = changedFields.add("overriddencreatedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.stagesolutionupload");
        _x.overriddencreatedon = overriddencreatedon;
        return _x;
    }

    @Property(name="_owningteam_value")
    @JsonIgnore
    public Optional<UUID> get_owningteam_value() {
        return Optional.ofNullable(_owningteam_value);
    }

    public Stagesolutionupload with_owningteam_value(UUID _owningteam_value) {
        Stagesolutionupload _x = _copy();
        _x.changedFields = changedFields.add("_owningteam_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.stagesolutionupload");
        _x._owningteam_value = _owningteam_value;
        return _x;
    }

    @Property(name="_modifiedby_value")
    @JsonIgnore
    public Optional<UUID> get_modifiedby_value() {
        return Optional.ofNullable(_modifiedby_value);
    }

    public Stagesolutionupload with_modifiedby_value(UUID _modifiedby_value) {
        Stagesolutionupload _x = _copy();
        _x.changedFields = changedFields.add("_modifiedby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.stagesolutionupload");
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    @Property(name="_modifiedonbehalfby_value")
    @JsonIgnore
    public Optional<UUID> get_modifiedonbehalfby_value() {
        return Optional.ofNullable(_modifiedonbehalfby_value);
    }

    public Stagesolutionupload with_modifiedonbehalfby_value(UUID _modifiedonbehalfby_value) {
        Stagesolutionupload _x = _copy();
        _x.changedFields = changedFields.add("_modifiedonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.stagesolutionupload");
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        return _x;
    }

    @Property(name="_ownerid_value")
    @JsonIgnore
    public Optional<UUID> get_ownerid_value() {
        return Optional.ofNullable(_ownerid_value);
    }

    public Stagesolutionupload with_ownerid_value(UUID _ownerid_value) {
        Stagesolutionupload _x = _copy();
        _x.changedFields = changedFields.add("_ownerid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.stagesolutionupload");
        _x._ownerid_value = _ownerid_value;
        return _x;
    }

    @Property(name="_createdby_value")
    @JsonIgnore
    public Optional<UUID> get_createdby_value() {
        return Optional.ofNullable(_createdby_value);
    }

    public Stagesolutionupload with_createdby_value(UUID _createdby_value) {
        Stagesolutionupload _x = _copy();
        _x.changedFields = changedFields.add("_createdby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.stagesolutionupload");
        _x._createdby_value = _createdby_value;
        return _x;
    }

    @Property(name="timezoneruleversionnumber")
    @JsonIgnore
    public Optional<Integer> getTimezoneruleversionnumber() {
        return Optional.ofNullable(timezoneruleversionnumber);
    }

    public Stagesolutionupload withTimezoneruleversionnumber(Integer timezoneruleversionnumber) {
        Stagesolutionupload _x = _copy();
        _x.changedFields = changedFields.add("timezoneruleversionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.stagesolutionupload");
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        return _x;
    }

    @Property(name="utcconversiontimezonecode")
    @JsonIgnore
    public Optional<Integer> getUtcconversiontimezonecode() {
        return Optional.ofNullable(utcconversiontimezonecode);
    }

    public Stagesolutionupload withUtcconversiontimezonecode(Integer utcconversiontimezonecode) {
        Stagesolutionupload _x = _copy();
        _x.changedFields = changedFields.add("utcconversiontimezonecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.stagesolutionupload");
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        return _x;
    }

    @Property(name="versionnumber")
    @JsonIgnore
    public Optional<Long> getVersionnumber() {
        return Optional.ofNullable(versionnumber);
    }

    public Stagesolutionupload withVersionnumber(Long versionnumber) {
        Stagesolutionupload _x = _copy();
        _x.changedFields = changedFields.add("versionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.stagesolutionupload");
        _x.versionnumber = versionnumber;
        return _x;
    }

    @Property(name="solutionfile_name")
    @JsonIgnore
    public Optional<String> getSolutionfile_name() {
        return Optional.ofNullable(solutionfile_name);
    }

    public Stagesolutionupload withSolutionfile_name(String solutionfile_name) {
        Checks.checkIsAscii(solutionfile_name);
        Stagesolutionupload _x = _copy();
        _x.changedFields = changedFields.add("solutionfile_name");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.stagesolutionupload");
        _x.solutionfile_name = solutionfile_name;
        return _x;
    }

    public Stagesolutionupload withUnmappedField(String name, String value) {
        Stagesolutionupload _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="createdby")
    @JsonIgnore
    public SystemuserRequest getCreatedby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), RequestHelper.getValue(unmappedFields, "createdby"));
    }

    @NavigationProperty(name="createdonbehalfby")
    @JsonIgnore
    public SystemuserRequest getCreatedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), RequestHelper.getValue(unmappedFields, "createdonbehalfby"));
    }

    @NavigationProperty(name="modifiedby")
    @JsonIgnore
    public SystemuserRequest getModifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), RequestHelper.getValue(unmappedFields, "modifiedby"));
    }

    @NavigationProperty(name="modifiedonbehalfby")
    @JsonIgnore
    public SystemuserRequest getModifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), RequestHelper.getValue(unmappedFields, "modifiedonbehalfby"));
    }

    @NavigationProperty(name="owninguser")
    @JsonIgnore
    public SystemuserRequest getOwninguser() {
        return new SystemuserRequest(contextPath.addSegment("owninguser"), RequestHelper.getValue(unmappedFields, "owninguser"));
    }

    @NavigationProperty(name="owningteam")
    @JsonIgnore
    public TeamRequest getOwningteam() {
        return new TeamRequest(contextPath.addSegment("owningteam"), RequestHelper.getValue(unmappedFields, "owningteam"));
    }

    @NavigationProperty(name="ownerid")
    @JsonIgnore
    public PrincipalRequest getOwnerid() {
        return new PrincipalRequest(contextPath.addSegment("ownerid"), RequestHelper.getValue(unmappedFields, "ownerid"));
    }

    @NavigationProperty(name="owningbusinessunit")
    @JsonIgnore
    public BusinessunitRequest getOwningbusinessunit() {
        return new BusinessunitRequest(contextPath.addSegment("owningbusinessunit"), RequestHelper.getValue(unmappedFields, "owningbusinessunit"));
    }

    @NavigationProperty(name="stagesolutionupload_SyncErrors")
    @JsonIgnore
    public SyncerrorCollectionRequest getStagesolutionupload_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("stagesolutionupload_SyncErrors"), RequestHelper.getValue(unmappedFields, "stagesolutionupload_SyncErrors"));
    }

    @NavigationProperty(name="stagesolutionupload_DuplicateMatchingRecord")
    @JsonIgnore
    public DuplicaterecordCollectionRequest getStagesolutionupload_DuplicateMatchingRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("stagesolutionupload_DuplicateMatchingRecord"), RequestHelper.getValue(unmappedFields, "stagesolutionupload_DuplicateMatchingRecord"));
    }

    @NavigationProperty(name="stagesolutionupload_DuplicateBaseRecord")
    @JsonIgnore
    public DuplicaterecordCollectionRequest getStagesolutionupload_DuplicateBaseRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("stagesolutionupload_DuplicateBaseRecord"), RequestHelper.getValue(unmappedFields, "stagesolutionupload_DuplicateBaseRecord"));
    }

    @NavigationProperty(name="stagesolutionupload_AsyncOperations")
    @JsonIgnore
    public AsyncoperationCollectionRequest getStagesolutionupload_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("stagesolutionupload_AsyncOperations"), RequestHelper.getValue(unmappedFields, "stagesolutionupload_AsyncOperations"));
    }

    @NavigationProperty(name="stagesolutionupload_MailboxTrackingFolders")
    @JsonIgnore
    public MailboxtrackingfolderCollectionRequest getStagesolutionupload_MailboxTrackingFolders() {
        return new MailboxtrackingfolderCollectionRequest(
                        contextPath.addSegment("stagesolutionupload_MailboxTrackingFolders"), RequestHelper.getValue(unmappedFields, "stagesolutionupload_MailboxTrackingFolders"));
    }

    @NavigationProperty(name="stagesolutionupload_ProcessSession")
    @JsonIgnore
    public ProcesssessionCollectionRequest getStagesolutionupload_ProcessSession() {
        return new ProcesssessionCollectionRequest(
                        contextPath.addSegment("stagesolutionupload_ProcessSession"), RequestHelper.getValue(unmappedFields, "stagesolutionupload_ProcessSession"));
    }

    @NavigationProperty(name="stagesolutionupload_BulkDeleteFailures")
    @JsonIgnore
    public BulkdeletefailureCollectionRequest getStagesolutionupload_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(
                        contextPath.addSegment("stagesolutionupload_BulkDeleteFailures"), RequestHelper.getValue(unmappedFields, "stagesolutionupload_BulkDeleteFailures"));
    }

    @NavigationProperty(name="stagesolutionupload_PrincipalObjectAttributeAccesses")
    @JsonIgnore
    public PrincipalobjectattributeaccessCollectionRequest getStagesolutionupload_PrincipalObjectAttributeAccesses() {
        return new PrincipalobjectattributeaccessCollectionRequest(
                        contextPath.addSegment("stagesolutionupload_PrincipalObjectAttributeAccesses"), RequestHelper.getValue(unmappedFields, "stagesolutionupload_PrincipalObjectAttributeAccesses"));
    }

    @NavigationProperty(name="stagesolutionupload_FileAttachments")
    @JsonIgnore
    public FileattachmentCollectionRequest getStagesolutionupload_FileAttachments() {
        return new FileattachmentCollectionRequest(
                        contextPath.addSegment("stagesolutionupload_FileAttachments"), RequestHelper.getValue(unmappedFields, "stagesolutionupload_FileAttachments"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Stagesolutionupload patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Stagesolutionupload _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Stagesolutionupload put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Stagesolutionupload _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Stagesolutionupload _copy() {
        Stagesolutionupload _x = new Stagesolutionupload();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.modifiedon = modifiedon;
        _x.solutionfilename = solutionfilename;
        _x.solutionuniquename = solutionuniquename;
        _x.statuscode = statuscode;
        _x.name = name;
        _x.statecode = statecode;
        _x.stagesolutionuploadid = stagesolutionuploadid;
        _x._owningbusinessunit_value = _owningbusinessunit_value;
        _x.solutionfile = solutionfile;
        _x.importsequencenumber = importsequencenumber;
        _x.createdon = createdon;
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        _x._owninguser_value = _owninguser_value;
        _x.overriddencreatedon = overriddencreatedon;
        _x._owningteam_value = _owningteam_value;
        _x._modifiedby_value = _modifiedby_value;
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        _x._ownerid_value = _ownerid_value;
        _x._createdby_value = _createdby_value;
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        _x.versionnumber = versionnumber;
        _x.solutionfile_name = solutionfile_name;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Stagesolutionupload[");
        b.append("modifiedon=");
        b.append(this.modifiedon);
        b.append(", ");
        b.append("solutionfilename=");
        b.append(this.solutionfilename);
        b.append(", ");
        b.append("solutionuniquename=");
        b.append(this.solutionuniquename);
        b.append(", ");
        b.append("statuscode=");
        b.append(this.statuscode);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("statecode=");
        b.append(this.statecode);
        b.append(", ");
        b.append("stagesolutionuploadid=");
        b.append(this.stagesolutionuploadid);
        b.append(", ");
        b.append("_owningbusinessunit_value=");
        b.append(this._owningbusinessunit_value);
        b.append(", ");
        b.append("solutionfile=");
        b.append(this.solutionfile);
        b.append(", ");
        b.append("importsequencenumber=");
        b.append(this.importsequencenumber);
        b.append(", ");
        b.append("createdon=");
        b.append(this.createdon);
        b.append(", ");
        b.append("_createdonbehalfby_value=");
        b.append(this._createdonbehalfby_value);
        b.append(", ");
        b.append("_owninguser_value=");
        b.append(this._owninguser_value);
        b.append(", ");
        b.append("overriddencreatedon=");
        b.append(this.overriddencreatedon);
        b.append(", ");
        b.append("_owningteam_value=");
        b.append(this._owningteam_value);
        b.append(", ");
        b.append("_modifiedby_value=");
        b.append(this._modifiedby_value);
        b.append(", ");
        b.append("_modifiedonbehalfby_value=");
        b.append(this._modifiedonbehalfby_value);
        b.append(", ");
        b.append("_ownerid_value=");
        b.append(this._ownerid_value);
        b.append(", ");
        b.append("_createdby_value=");
        b.append(this._createdby_value);
        b.append(", ");
        b.append("timezoneruleversionnumber=");
        b.append(this.timezoneruleversionnumber);
        b.append(", ");
        b.append("utcconversiontimezonecode=");
        b.append(this.utcconversiontimezonecode);
        b.append(", ");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append(", ");
        b.append("solutionfile_name=");
        b.append(this.solutionfile_name);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
