package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.BulkdeletefailureCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.RoleCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.RoletemplateCollectionRequest;
import microsoft.dynamics.crm.entity.request.SolutionRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "privilegerowid", 
    "canbebasic", 
    "accessright", 
    "privilegeid", 
    "overwritetime", 
    "componentstate", 
    "solutionid", 
    "canbeentityreference", 
    "canbeglobal", 
    "canbedeep", 
    "name", 
    "canbeparententityreference", 
    "ismanaged", 
    "versionnumber", 
    "introducedversion", 
    "canbelocal"})
@JsonInclude(Include.NON_NULL)
public class Privilege extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.privilege";
    }

    @JsonProperty("privilegerowid")
    protected UUID privilegerowid;

    @JsonProperty("canbebasic")
    protected Boolean canbebasic;

    @JsonProperty("accessright")
    protected Integer accessright;

    @JsonProperty("privilegeid")
    protected UUID privilegeid;

    @JsonProperty("overwritetime")
    protected OffsetDateTime overwritetime;

    @JsonProperty("componentstate")
    protected Integer componentstate;

    @JsonProperty("solutionid")
    protected UUID solutionid;

    @JsonProperty("canbeentityreference")
    protected Boolean canbeentityreference;

    @JsonProperty("canbeglobal")
    protected Boolean canbeglobal;

    @JsonProperty("canbedeep")
    protected Boolean canbedeep;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("canbeparententityreference")
    protected Boolean canbeparententityreference;

    @JsonProperty("ismanaged")
    protected Boolean ismanaged;

    @JsonProperty("versionnumber")
    protected Long versionnumber;

    @JsonProperty("introducedversion")
    protected String introducedversion;

    @JsonProperty("canbelocal")
    protected Boolean canbelocal;

    protected Privilege() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderPrivilege() {
        return new Builder();
    }

    public static final class Builder {
        private UUID privilegerowid;
        private Boolean canbebasic;
        private Integer accessright;
        private UUID privilegeid;
        private OffsetDateTime overwritetime;
        private Integer componentstate;
        private UUID solutionid;
        private Boolean canbeentityreference;
        private Boolean canbeglobal;
        private Boolean canbedeep;
        private String name;
        private Boolean canbeparententityreference;
        private Boolean ismanaged;
        private Long versionnumber;
        private String introducedversion;
        private Boolean canbelocal;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder privilegerowid(UUID privilegerowid) {
            this.privilegerowid = privilegerowid;
            this.changedFields = changedFields.add("privilegerowid");
            return this;
        }

        public Builder canbebasic(Boolean canbebasic) {
            this.canbebasic = canbebasic;
            this.changedFields = changedFields.add("canbebasic");
            return this;
        }

        public Builder accessright(Integer accessright) {
            this.accessright = accessright;
            this.changedFields = changedFields.add("accessright");
            return this;
        }

        public Builder privilegeid(UUID privilegeid) {
            this.privilegeid = privilegeid;
            this.changedFields = changedFields.add("privilegeid");
            return this;
        }

        public Builder overwritetime(OffsetDateTime overwritetime) {
            this.overwritetime = overwritetime;
            this.changedFields = changedFields.add("overwritetime");
            return this;
        }

        public Builder componentstate(Integer componentstate) {
            this.componentstate = componentstate;
            this.changedFields = changedFields.add("componentstate");
            return this;
        }

        public Builder solutionid(UUID solutionid) {
            this.solutionid = solutionid;
            this.changedFields = changedFields.add("solutionid");
            return this;
        }

        public Builder canbeentityreference(Boolean canbeentityreference) {
            this.canbeentityreference = canbeentityreference;
            this.changedFields = changedFields.add("canbeentityreference");
            return this;
        }

        public Builder canbeglobal(Boolean canbeglobal) {
            this.canbeglobal = canbeglobal;
            this.changedFields = changedFields.add("canbeglobal");
            return this;
        }

        public Builder canbedeep(Boolean canbedeep) {
            this.canbedeep = canbedeep;
            this.changedFields = changedFields.add("canbedeep");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder canbeparententityreference(Boolean canbeparententityreference) {
            this.canbeparententityreference = canbeparententityreference;
            this.changedFields = changedFields.add("canbeparententityreference");
            return this;
        }

        public Builder ismanaged(Boolean ismanaged) {
            this.ismanaged = ismanaged;
            this.changedFields = changedFields.add("ismanaged");
            return this;
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Builder introducedversion(String introducedversion) {
            this.introducedversion = introducedversion;
            this.changedFields = changedFields.add("introducedversion");
            return this;
        }

        public Builder canbelocal(Boolean canbelocal) {
            this.canbelocal = canbelocal;
            this.changedFields = changedFields.add("canbelocal");
            return this;
        }

        public Privilege build() {
            Privilege _x = new Privilege();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.privilege";
            _x.privilegerowid = privilegerowid;
            _x.canbebasic = canbebasic;
            _x.accessright = accessright;
            _x.privilegeid = privilegeid;
            _x.overwritetime = overwritetime;
            _x.componentstate = componentstate;
            _x.solutionid = solutionid;
            _x.canbeentityreference = canbeentityreference;
            _x.canbeglobal = canbeglobal;
            _x.canbedeep = canbedeep;
            _x.name = name;
            _x.canbeparententityreference = canbeparententityreference;
            _x.ismanaged = ismanaged;
            _x.versionnumber = versionnumber;
            _x.introducedversion = introducedversion;
            _x.canbelocal = canbelocal;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && privilegeid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(privilegeid, UUID.class));
        }
    }

    @Property(name="privilegerowid")
    @JsonIgnore
    public Optional<UUID> getPrivilegerowid() {
        return Optional.ofNullable(privilegerowid);
    }

    public Privilege withPrivilegerowid(UUID privilegerowid) {
        Privilege _x = _copy();
        _x.changedFields = changedFields.add("privilegerowid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.privilege");
        _x.privilegerowid = privilegerowid;
        return _x;
    }

    @Property(name="canbebasic")
    @JsonIgnore
    public Optional<Boolean> getCanbebasic() {
        return Optional.ofNullable(canbebasic);
    }

    public Privilege withCanbebasic(Boolean canbebasic) {
        Privilege _x = _copy();
        _x.changedFields = changedFields.add("canbebasic");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.privilege");
        _x.canbebasic = canbebasic;
        return _x;
    }

    @Property(name="accessright")
    @JsonIgnore
    public Optional<Integer> getAccessright() {
        return Optional.ofNullable(accessright);
    }

    public Privilege withAccessright(Integer accessright) {
        Privilege _x = _copy();
        _x.changedFields = changedFields.add("accessright");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.privilege");
        _x.accessright = accessright;
        return _x;
    }

    @Property(name="privilegeid")
    @JsonIgnore
    public Optional<UUID> getPrivilegeid() {
        return Optional.ofNullable(privilegeid);
    }

    public Privilege withPrivilegeid(UUID privilegeid) {
        Privilege _x = _copy();
        _x.changedFields = changedFields.add("privilegeid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.privilege");
        _x.privilegeid = privilegeid;
        return _x;
    }

    @Property(name="overwritetime")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverwritetime() {
        return Optional.ofNullable(overwritetime);
    }

    public Privilege withOverwritetime(OffsetDateTime overwritetime) {
        Privilege _x = _copy();
        _x.changedFields = changedFields.add("overwritetime");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.privilege");
        _x.overwritetime = overwritetime;
        return _x;
    }

    @Property(name="componentstate")
    @JsonIgnore
    public Optional<Integer> getComponentstate() {
        return Optional.ofNullable(componentstate);
    }

    public Privilege withComponentstate(Integer componentstate) {
        Privilege _x = _copy();
        _x.changedFields = changedFields.add("componentstate");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.privilege");
        _x.componentstate = componentstate;
        return _x;
    }

    @Property(name="solutionid")
    @JsonIgnore
    public Optional<UUID> getSolutionid() {
        return Optional.ofNullable(solutionid);
    }

    public Privilege withSolutionid(UUID solutionid) {
        Privilege _x = _copy();
        _x.changedFields = changedFields.add("solutionid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.privilege");
        _x.solutionid = solutionid;
        return _x;
    }

    @Property(name="canbeentityreference")
    @JsonIgnore
    public Optional<Boolean> getCanbeentityreference() {
        return Optional.ofNullable(canbeentityreference);
    }

    public Privilege withCanbeentityreference(Boolean canbeentityreference) {
        Privilege _x = _copy();
        _x.changedFields = changedFields.add("canbeentityreference");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.privilege");
        _x.canbeentityreference = canbeentityreference;
        return _x;
    }

    @Property(name="canbeglobal")
    @JsonIgnore
    public Optional<Boolean> getCanbeglobal() {
        return Optional.ofNullable(canbeglobal);
    }

    public Privilege withCanbeglobal(Boolean canbeglobal) {
        Privilege _x = _copy();
        _x.changedFields = changedFields.add("canbeglobal");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.privilege");
        _x.canbeglobal = canbeglobal;
        return _x;
    }

    @Property(name="canbedeep")
    @JsonIgnore
    public Optional<Boolean> getCanbedeep() {
        return Optional.ofNullable(canbedeep);
    }

    public Privilege withCanbedeep(Boolean canbedeep) {
        Privilege _x = _copy();
        _x.changedFields = changedFields.add("canbedeep");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.privilege");
        _x.canbedeep = canbedeep;
        return _x;
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public Privilege withName(String name) {
        Checks.checkIsAscii(name);
        Privilege _x = _copy();
        _x.changedFields = changedFields.add("name");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.privilege");
        _x.name = name;
        return _x;
    }

    @Property(name="canbeparententityreference")
    @JsonIgnore
    public Optional<Boolean> getCanbeparententityreference() {
        return Optional.ofNullable(canbeparententityreference);
    }

    public Privilege withCanbeparententityreference(Boolean canbeparententityreference) {
        Privilege _x = _copy();
        _x.changedFields = changedFields.add("canbeparententityreference");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.privilege");
        _x.canbeparententityreference = canbeparententityreference;
        return _x;
    }

    @Property(name="ismanaged")
    @JsonIgnore
    public Optional<Boolean> getIsmanaged() {
        return Optional.ofNullable(ismanaged);
    }

    public Privilege withIsmanaged(Boolean ismanaged) {
        Privilege _x = _copy();
        _x.changedFields = changedFields.add("ismanaged");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.privilege");
        _x.ismanaged = ismanaged;
        return _x;
    }

    @Property(name="versionnumber")
    @JsonIgnore
    public Optional<Long> getVersionnumber() {
        return Optional.ofNullable(versionnumber);
    }

    public Privilege withVersionnumber(Long versionnumber) {
        Privilege _x = _copy();
        _x.changedFields = changedFields.add("versionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.privilege");
        _x.versionnumber = versionnumber;
        return _x;
    }

    @Property(name="introducedversion")
    @JsonIgnore
    public Optional<String> getIntroducedversion() {
        return Optional.ofNullable(introducedversion);
    }

    public Privilege withIntroducedversion(String introducedversion) {
        Checks.checkIsAscii(introducedversion);
        Privilege _x = _copy();
        _x.changedFields = changedFields.add("introducedversion");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.privilege");
        _x.introducedversion = introducedversion;
        return _x;
    }

    @Property(name="canbelocal")
    @JsonIgnore
    public Optional<Boolean> getCanbelocal() {
        return Optional.ofNullable(canbelocal);
    }

    public Privilege withCanbelocal(Boolean canbelocal) {
        Privilege _x = _copy();
        _x.changedFields = changedFields.add("canbelocal");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.privilege");
        _x.canbelocal = canbelocal;
        return _x;
    }

    public Privilege withUnmappedField(String name, String value) {
        Privilege _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="roletemplateprivileges_association")
    @JsonIgnore
    public RoletemplateCollectionRequest getRoletemplateprivileges_association() {
        return new RoletemplateCollectionRequest(
                        contextPath.addSegment("roletemplateprivileges_association"), RequestHelper.getValue(unmappedFields, "roletemplateprivileges_association"));
    }

    @NavigationProperty(name="roleprivileges_association")
    @JsonIgnore
    public RoleCollectionRequest getRoleprivileges_association() {
        return new RoleCollectionRequest(
                        contextPath.addSegment("roleprivileges_association"), RequestHelper.getValue(unmappedFields, "roleprivileges_association"));
    }

    @NavigationProperty(name="Privilege_AsyncOperations")
    @JsonIgnore
    public AsyncoperationCollectionRequest getPrivilege_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("Privilege_AsyncOperations"), RequestHelper.getValue(unmappedFields, "Privilege_AsyncOperations"));
    }

    @NavigationProperty(name="Privilege_BulkDeleteFailures")
    @JsonIgnore
    public BulkdeletefailureCollectionRequest getPrivilege_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(
                        contextPath.addSegment("Privilege_BulkDeleteFailures"), RequestHelper.getValue(unmappedFields, "Privilege_BulkDeleteFailures"));
    }

    @NavigationProperty(name="solution_privilege")
    @JsonIgnore
    public SolutionRequest getSolution_privilege() {
        return new SolutionRequest(contextPath.addSegment("solution_privilege"), RequestHelper.getValue(unmappedFields, "solution_privilege"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Privilege patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Privilege _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Privilege put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Privilege _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Privilege _copy() {
        Privilege _x = new Privilege();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.privilegerowid = privilegerowid;
        _x.canbebasic = canbebasic;
        _x.accessright = accessright;
        _x.privilegeid = privilegeid;
        _x.overwritetime = overwritetime;
        _x.componentstate = componentstate;
        _x.solutionid = solutionid;
        _x.canbeentityreference = canbeentityreference;
        _x.canbeglobal = canbeglobal;
        _x.canbedeep = canbedeep;
        _x.name = name;
        _x.canbeparententityreference = canbeparententityreference;
        _x.ismanaged = ismanaged;
        _x.versionnumber = versionnumber;
        _x.introducedversion = introducedversion;
        _x.canbelocal = canbelocal;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Privilege[");
        b.append("privilegerowid=");
        b.append(this.privilegerowid);
        b.append(", ");
        b.append("canbebasic=");
        b.append(this.canbebasic);
        b.append(", ");
        b.append("accessright=");
        b.append(this.accessright);
        b.append(", ");
        b.append("privilegeid=");
        b.append(this.privilegeid);
        b.append(", ");
        b.append("overwritetime=");
        b.append(this.overwritetime);
        b.append(", ");
        b.append("componentstate=");
        b.append(this.componentstate);
        b.append(", ");
        b.append("solutionid=");
        b.append(this.solutionid);
        b.append(", ");
        b.append("canbeentityreference=");
        b.append(this.canbeentityreference);
        b.append(", ");
        b.append("canbeglobal=");
        b.append(this.canbeglobal);
        b.append(", ");
        b.append("canbedeep=");
        b.append(this.canbedeep);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("canbeparententityreference=");
        b.append(this.canbeparententityreference);
        b.append(", ");
        b.append("ismanaged=");
        b.append(this.ismanaged);
        b.append(", ");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append(", ");
        b.append("introducedversion=");
        b.append(this.introducedversion);
        b.append(", ");
        b.append("canbelocal=");
        b.append(this.canbelocal);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
