package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.complex.BooleanManagedProperty;
import microsoft.dynamics.crm.entity.collection.request.PlugintypeCollectionRequest;
import microsoft.dynamics.crm.entity.request.OrganizationRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "culture", 
    "_modifiedby_value", 
    "version", 
    "description", 
    "sourcehash", 
    "username", 
    "ismanaged", 
    "modifiedon", 
    "introducedversion", 
    "createdon", 
    "customizationlevel", 
    "publickeytoken", 
    "content", 
    "content_binary", 
    "path", 
    "name", 
    "_createdonbehalfby_value", 
    "ispasswordset", 
    "password", 
    "_organizationid_value", 
    "isolationmode", 
    "url", 
    "iscustomizable", 
    "_createdby_value", 
    "major", 
    "minor", 
    "componentstate", 
    "_modifiedonbehalfby_value", 
    "solutionid", 
    "authtype", 
    "sourcetype", 
    "pluginassemblyid", 
    "ishidden", 
    "pluginassemblyidunique", 
    "overwritetime", 
    "versionnumber"})
@JsonInclude(Include.NON_NULL)
public class Pluginassembly extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.pluginassembly";
    }

    @JsonProperty("culture")
    protected String culture;

    @JsonProperty("_modifiedby_value")
    protected UUID _modifiedby_value;

    @JsonProperty("version")
    protected String version;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("sourcehash")
    protected String sourcehash;

    @JsonProperty("username")
    protected String username;

    @JsonProperty("ismanaged")
    protected Boolean ismanaged;

    @JsonProperty("modifiedon")
    protected OffsetDateTime modifiedon;

    @JsonProperty("introducedversion")
    protected String introducedversion;

    @JsonProperty("createdon")
    protected OffsetDateTime createdon;

    @JsonProperty("customizationlevel")
    protected Integer customizationlevel;

    @JsonProperty("publickeytoken")
    protected String publickeytoken;

    @JsonProperty("content")
    protected String content;

    @JsonProperty("content_binary")
    protected byte[] content_binary;

    @JsonProperty("path")
    protected String path;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("_createdonbehalfby_value")
    protected UUID _createdonbehalfby_value;

    @JsonProperty("ispasswordset")
    protected Boolean ispasswordset;

    @JsonProperty("password")
    protected String password;

    @JsonProperty("_organizationid_value")
    protected UUID _organizationid_value;

    @JsonProperty("isolationmode")
    protected Integer isolationmode;

    @JsonProperty("url")
    protected String url;

    @JsonProperty("iscustomizable")
    protected BooleanManagedProperty iscustomizable;

    @JsonProperty("_createdby_value")
    protected UUID _createdby_value;

    @JsonProperty("major")
    protected Integer major;

    @JsonProperty("minor")
    protected Integer minor;

    @JsonProperty("componentstate")
    protected Integer componentstate;

    @JsonProperty("_modifiedonbehalfby_value")
    protected UUID _modifiedonbehalfby_value;

    @JsonProperty("solutionid")
    protected UUID solutionid;

    @JsonProperty("authtype")
    protected Integer authtype;

    @JsonProperty("sourcetype")
    protected Integer sourcetype;

    @JsonProperty("pluginassemblyid")
    protected UUID pluginassemblyid;

    @JsonProperty("ishidden")
    protected BooleanManagedProperty ishidden;

    @JsonProperty("pluginassemblyidunique")
    protected UUID pluginassemblyidunique;

    @JsonProperty("overwritetime")
    protected OffsetDateTime overwritetime;

    @JsonProperty("versionnumber")
    protected Long versionnumber;

    protected Pluginassembly() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderPluginassembly() {
        return new Builder();
    }

    public static final class Builder {
        private String culture;
        private UUID _modifiedby_value;
        private String version;
        private String description;
        private String sourcehash;
        private String username;
        private Boolean ismanaged;
        private OffsetDateTime modifiedon;
        private String introducedversion;
        private OffsetDateTime createdon;
        private Integer customizationlevel;
        private String publickeytoken;
        private String content;
        private byte[] content_binary;
        private String path;
        private String name;
        private UUID _createdonbehalfby_value;
        private Boolean ispasswordset;
        private String password;
        private UUID _organizationid_value;
        private Integer isolationmode;
        private String url;
        private BooleanManagedProperty iscustomizable;
        private UUID _createdby_value;
        private Integer major;
        private Integer minor;
        private Integer componentstate;
        private UUID _modifiedonbehalfby_value;
        private UUID solutionid;
        private Integer authtype;
        private Integer sourcetype;
        private UUID pluginassemblyid;
        private BooleanManagedProperty ishidden;
        private UUID pluginassemblyidunique;
        private OffsetDateTime overwritetime;
        private Long versionnumber;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder culture(String culture) {
            this.culture = culture;
            this.changedFields = changedFields.add("culture");
            return this;
        }

        public Builder _modifiedby_value(UUID _modifiedby_value) {
            this._modifiedby_value = _modifiedby_value;
            this.changedFields = changedFields.add("_modifiedby_value");
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            this.changedFields = changedFields.add("version");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder sourcehash(String sourcehash) {
            this.sourcehash = sourcehash;
            this.changedFields = changedFields.add("sourcehash");
            return this;
        }

        public Builder username(String username) {
            this.username = username;
            this.changedFields = changedFields.add("username");
            return this;
        }

        public Builder ismanaged(Boolean ismanaged) {
            this.ismanaged = ismanaged;
            this.changedFields = changedFields.add("ismanaged");
            return this;
        }

        public Builder modifiedon(OffsetDateTime modifiedon) {
            this.modifiedon = modifiedon;
            this.changedFields = changedFields.add("modifiedon");
            return this;
        }

        public Builder introducedversion(String introducedversion) {
            this.introducedversion = introducedversion;
            this.changedFields = changedFields.add("introducedversion");
            return this;
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Builder customizationlevel(Integer customizationlevel) {
            this.customizationlevel = customizationlevel;
            this.changedFields = changedFields.add("customizationlevel");
            return this;
        }

        public Builder publickeytoken(String publickeytoken) {
            this.publickeytoken = publickeytoken;
            this.changedFields = changedFields.add("publickeytoken");
            return this;
        }

        public Builder content(String content) {
            this.content = content;
            this.changedFields = changedFields.add("content");
            return this;
        }

        public Builder content_binary(byte[] content_binary) {
            this.content_binary = content_binary;
            this.changedFields = changedFields.add("content_binary");
            return this;
        }

        public Builder path(String path) {
            this.path = path;
            this.changedFields = changedFields.add("path");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder _createdonbehalfby_value(UUID _createdonbehalfby_value) {
            this._createdonbehalfby_value = _createdonbehalfby_value;
            this.changedFields = changedFields.add("_createdonbehalfby_value");
            return this;
        }

        public Builder ispasswordset(Boolean ispasswordset) {
            this.ispasswordset = ispasswordset;
            this.changedFields = changedFields.add("ispasswordset");
            return this;
        }

        public Builder password(String password) {
            this.password = password;
            this.changedFields = changedFields.add("password");
            return this;
        }

        public Builder _organizationid_value(UUID _organizationid_value) {
            this._organizationid_value = _organizationid_value;
            this.changedFields = changedFields.add("_organizationid_value");
            return this;
        }

        public Builder isolationmode(Integer isolationmode) {
            this.isolationmode = isolationmode;
            this.changedFields = changedFields.add("isolationmode");
            return this;
        }

        public Builder url(String url) {
            this.url = url;
            this.changedFields = changedFields.add("url");
            return this;
        }

        public Builder iscustomizable(BooleanManagedProperty iscustomizable) {
            this.iscustomizable = iscustomizable;
            this.changedFields = changedFields.add("iscustomizable");
            return this;
        }

        public Builder _createdby_value(UUID _createdby_value) {
            this._createdby_value = _createdby_value;
            this.changedFields = changedFields.add("_createdby_value");
            return this;
        }

        public Builder major(Integer major) {
            this.major = major;
            this.changedFields = changedFields.add("major");
            return this;
        }

        public Builder minor(Integer minor) {
            this.minor = minor;
            this.changedFields = changedFields.add("minor");
            return this;
        }

        public Builder componentstate(Integer componentstate) {
            this.componentstate = componentstate;
            this.changedFields = changedFields.add("componentstate");
            return this;
        }

        public Builder _modifiedonbehalfby_value(UUID _modifiedonbehalfby_value) {
            this._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            this.changedFields = changedFields.add("_modifiedonbehalfby_value");
            return this;
        }

        public Builder solutionid(UUID solutionid) {
            this.solutionid = solutionid;
            this.changedFields = changedFields.add("solutionid");
            return this;
        }

        public Builder authtype(Integer authtype) {
            this.authtype = authtype;
            this.changedFields = changedFields.add("authtype");
            return this;
        }

        public Builder sourcetype(Integer sourcetype) {
            this.sourcetype = sourcetype;
            this.changedFields = changedFields.add("sourcetype");
            return this;
        }

        public Builder pluginassemblyid(UUID pluginassemblyid) {
            this.pluginassemblyid = pluginassemblyid;
            this.changedFields = changedFields.add("pluginassemblyid");
            return this;
        }

        public Builder ishidden(BooleanManagedProperty ishidden) {
            this.ishidden = ishidden;
            this.changedFields = changedFields.add("ishidden");
            return this;
        }

        public Builder pluginassemblyidunique(UUID pluginassemblyidunique) {
            this.pluginassemblyidunique = pluginassemblyidunique;
            this.changedFields = changedFields.add("pluginassemblyidunique");
            return this;
        }

        public Builder overwritetime(OffsetDateTime overwritetime) {
            this.overwritetime = overwritetime;
            this.changedFields = changedFields.add("overwritetime");
            return this;
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Pluginassembly build() {
            Pluginassembly _x = new Pluginassembly();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.pluginassembly";
            _x.culture = culture;
            _x._modifiedby_value = _modifiedby_value;
            _x.version = version;
            _x.description = description;
            _x.sourcehash = sourcehash;
            _x.username = username;
            _x.ismanaged = ismanaged;
            _x.modifiedon = modifiedon;
            _x.introducedversion = introducedversion;
            _x.createdon = createdon;
            _x.customizationlevel = customizationlevel;
            _x.publickeytoken = publickeytoken;
            _x.content = content;
            _x.content_binary = content_binary;
            _x.path = path;
            _x.name = name;
            _x._createdonbehalfby_value = _createdonbehalfby_value;
            _x.ispasswordset = ispasswordset;
            _x.password = password;
            _x._organizationid_value = _organizationid_value;
            _x.isolationmode = isolationmode;
            _x.url = url;
            _x.iscustomizable = iscustomizable;
            _x._createdby_value = _createdby_value;
            _x.major = major;
            _x.minor = minor;
            _x.componentstate = componentstate;
            _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            _x.solutionid = solutionid;
            _x.authtype = authtype;
            _x.sourcetype = sourcetype;
            _x.pluginassemblyid = pluginassemblyid;
            _x.ishidden = ishidden;
            _x.pluginassemblyidunique = pluginassemblyidunique;
            _x.overwritetime = overwritetime;
            _x.versionnumber = versionnumber;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && pluginassemblyid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(pluginassemblyid, UUID.class));
        }
    }

    @Property(name="culture")
    @JsonIgnore
    public Optional<String> getCulture() {
        return Optional.ofNullable(culture);
    }

    public Pluginassembly withCulture(String culture) {
        Checks.checkIsAscii(culture);
        Pluginassembly _x = _copy();
        _x.changedFields = changedFields.add("culture");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.pluginassembly");
        _x.culture = culture;
        return _x;
    }

    @Property(name="_modifiedby_value")
    @JsonIgnore
    public Optional<UUID> get_modifiedby_value() {
        return Optional.ofNullable(_modifiedby_value);
    }

    public Pluginassembly with_modifiedby_value(UUID _modifiedby_value) {
        Pluginassembly _x = _copy();
        _x.changedFields = changedFields.add("_modifiedby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.pluginassembly");
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    @Property(name="version")
    @JsonIgnore
    public Optional<String> getVersion() {
        return Optional.ofNullable(version);
    }

    public Pluginassembly withVersion(String version) {
        Checks.checkIsAscii(version);
        Pluginassembly _x = _copy();
        _x.changedFields = changedFields.add("version");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.pluginassembly");
        _x.version = version;
        return _x;
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public Pluginassembly withDescription(String description) {
        Checks.checkIsAscii(description);
        Pluginassembly _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.pluginassembly");
        _x.description = description;
        return _x;
    }

    @Property(name="sourcehash")
    @JsonIgnore
    public Optional<String> getSourcehash() {
        return Optional.ofNullable(sourcehash);
    }

    public Pluginassembly withSourcehash(String sourcehash) {
        Checks.checkIsAscii(sourcehash);
        Pluginassembly _x = _copy();
        _x.changedFields = changedFields.add("sourcehash");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.pluginassembly");
        _x.sourcehash = sourcehash;
        return _x;
    }

    @Property(name="username")
    @JsonIgnore
    public Optional<String> getUsername() {
        return Optional.ofNullable(username);
    }

    public Pluginassembly withUsername(String username) {
        Checks.checkIsAscii(username);
        Pluginassembly _x = _copy();
        _x.changedFields = changedFields.add("username");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.pluginassembly");
        _x.username = username;
        return _x;
    }

    @Property(name="ismanaged")
    @JsonIgnore
    public Optional<Boolean> getIsmanaged() {
        return Optional.ofNullable(ismanaged);
    }

    public Pluginassembly withIsmanaged(Boolean ismanaged) {
        Pluginassembly _x = _copy();
        _x.changedFields = changedFields.add("ismanaged");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.pluginassembly");
        _x.ismanaged = ismanaged;
        return _x;
    }

    @Property(name="modifiedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedon() {
        return Optional.ofNullable(modifiedon);
    }

    public Pluginassembly withModifiedon(OffsetDateTime modifiedon) {
        Pluginassembly _x = _copy();
        _x.changedFields = changedFields.add("modifiedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.pluginassembly");
        _x.modifiedon = modifiedon;
        return _x;
    }

    @Property(name="introducedversion")
    @JsonIgnore
    public Optional<String> getIntroducedversion() {
        return Optional.ofNullable(introducedversion);
    }

    public Pluginassembly withIntroducedversion(String introducedversion) {
        Checks.checkIsAscii(introducedversion);
        Pluginassembly _x = _copy();
        _x.changedFields = changedFields.add("introducedversion");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.pluginassembly");
        _x.introducedversion = introducedversion;
        return _x;
    }

    @Property(name="createdon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedon() {
        return Optional.ofNullable(createdon);
    }

    public Pluginassembly withCreatedon(OffsetDateTime createdon) {
        Pluginassembly _x = _copy();
        _x.changedFields = changedFields.add("createdon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.pluginassembly");
        _x.createdon = createdon;
        return _x;
    }

    @Property(name="customizationlevel")
    @JsonIgnore
    public Optional<Integer> getCustomizationlevel() {
        return Optional.ofNullable(customizationlevel);
    }

    public Pluginassembly withCustomizationlevel(Integer customizationlevel) {
        Pluginassembly _x = _copy();
        _x.changedFields = changedFields.add("customizationlevel");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.pluginassembly");
        _x.customizationlevel = customizationlevel;
        return _x;
    }

    @Property(name="publickeytoken")
    @JsonIgnore
    public Optional<String> getPublickeytoken() {
        return Optional.ofNullable(publickeytoken);
    }

    public Pluginassembly withPublickeytoken(String publickeytoken) {
        Checks.checkIsAscii(publickeytoken);
        Pluginassembly _x = _copy();
        _x.changedFields = changedFields.add("publickeytoken");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.pluginassembly");
        _x.publickeytoken = publickeytoken;
        return _x;
    }

    @Property(name="content")
    @JsonIgnore
    public Optional<String> getContent() {
        return Optional.ofNullable(content);
    }

    public Pluginassembly withContent(String content) {
        Checks.checkIsAscii(content);
        Pluginassembly _x = _copy();
        _x.changedFields = changedFields.add("content");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.pluginassembly");
        _x.content = content;
        return _x;
    }

    @Property(name="content_binary")
    @JsonIgnore
    public Optional<byte[]> getContent_binary() {
        return Optional.ofNullable(content_binary);
    }

    public Pluginassembly withContent_binary(byte[] content_binary) {
        Pluginassembly _x = _copy();
        _x.changedFields = changedFields.add("content_binary");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.pluginassembly");
        _x.content_binary = content_binary;
        return _x;
    }

    @Property(name="path")
    @JsonIgnore
    public Optional<String> getPath() {
        return Optional.ofNullable(path);
    }

    public Pluginassembly withPath(String path) {
        Checks.checkIsAscii(path);
        Pluginassembly _x = _copy();
        _x.changedFields = changedFields.add("path");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.pluginassembly");
        _x.path = path;
        return _x;
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public Pluginassembly withName(String name) {
        Checks.checkIsAscii(name);
        Pluginassembly _x = _copy();
        _x.changedFields = changedFields.add("name");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.pluginassembly");
        _x.name = name;
        return _x;
    }

    @Property(name="_createdonbehalfby_value")
    @JsonIgnore
    public Optional<UUID> get_createdonbehalfby_value() {
        return Optional.ofNullable(_createdonbehalfby_value);
    }

    public Pluginassembly with_createdonbehalfby_value(UUID _createdonbehalfby_value) {
        Pluginassembly _x = _copy();
        _x.changedFields = changedFields.add("_createdonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.pluginassembly");
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        return _x;
    }

    @Property(name="ispasswordset")
    @JsonIgnore
    public Optional<Boolean> getIspasswordset() {
        return Optional.ofNullable(ispasswordset);
    }

    public Pluginassembly withIspasswordset(Boolean ispasswordset) {
        Pluginassembly _x = _copy();
        _x.changedFields = changedFields.add("ispasswordset");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.pluginassembly");
        _x.ispasswordset = ispasswordset;
        return _x;
    }

    @Property(name="password")
    @JsonIgnore
    public Optional<String> getPassword() {
        return Optional.ofNullable(password);
    }

    public Pluginassembly withPassword(String password) {
        Checks.checkIsAscii(password);
        Pluginassembly _x = _copy();
        _x.changedFields = changedFields.add("password");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.pluginassembly");
        _x.password = password;
        return _x;
    }

    @Property(name="_organizationid_value")
    @JsonIgnore
    public Optional<UUID> get_organizationid_value() {
        return Optional.ofNullable(_organizationid_value);
    }

    public Pluginassembly with_organizationid_value(UUID _organizationid_value) {
        Pluginassembly _x = _copy();
        _x.changedFields = changedFields.add("_organizationid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.pluginassembly");
        _x._organizationid_value = _organizationid_value;
        return _x;
    }

    @Property(name="isolationmode")
    @JsonIgnore
    public Optional<Integer> getIsolationmode() {
        return Optional.ofNullable(isolationmode);
    }

    public Pluginassembly withIsolationmode(Integer isolationmode) {
        Pluginassembly _x = _copy();
        _x.changedFields = changedFields.add("isolationmode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.pluginassembly");
        _x.isolationmode = isolationmode;
        return _x;
    }

    @Property(name="url")
    @JsonIgnore
    public Optional<String> getUrl() {
        return Optional.ofNullable(url);
    }

    public Pluginassembly withUrl(String url) {
        Checks.checkIsAscii(url);
        Pluginassembly _x = _copy();
        _x.changedFields = changedFields.add("url");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.pluginassembly");
        _x.url = url;
        return _x;
    }

    @Property(name="iscustomizable")
    @JsonIgnore
    public Optional<BooleanManagedProperty> getIscustomizable() {
        return Optional.ofNullable(iscustomizable);
    }

    public Pluginassembly withIscustomizable(BooleanManagedProperty iscustomizable) {
        Pluginassembly _x = _copy();
        _x.changedFields = changedFields.add("iscustomizable");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.pluginassembly");
        _x.iscustomizable = iscustomizable;
        return _x;
    }

    @Property(name="_createdby_value")
    @JsonIgnore
    public Optional<UUID> get_createdby_value() {
        return Optional.ofNullable(_createdby_value);
    }

    public Pluginassembly with_createdby_value(UUID _createdby_value) {
        Pluginassembly _x = _copy();
        _x.changedFields = changedFields.add("_createdby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.pluginassembly");
        _x._createdby_value = _createdby_value;
        return _x;
    }

    @Property(name="major")
    @JsonIgnore
    public Optional<Integer> getMajor() {
        return Optional.ofNullable(major);
    }

    public Pluginassembly withMajor(Integer major) {
        Pluginassembly _x = _copy();
        _x.changedFields = changedFields.add("major");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.pluginassembly");
        _x.major = major;
        return _x;
    }

    @Property(name="minor")
    @JsonIgnore
    public Optional<Integer> getMinor() {
        return Optional.ofNullable(minor);
    }

    public Pluginassembly withMinor(Integer minor) {
        Pluginassembly _x = _copy();
        _x.changedFields = changedFields.add("minor");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.pluginassembly");
        _x.minor = minor;
        return _x;
    }

    @Property(name="componentstate")
    @JsonIgnore
    public Optional<Integer> getComponentstate() {
        return Optional.ofNullable(componentstate);
    }

    public Pluginassembly withComponentstate(Integer componentstate) {
        Pluginassembly _x = _copy();
        _x.changedFields = changedFields.add("componentstate");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.pluginassembly");
        _x.componentstate = componentstate;
        return _x;
    }

    @Property(name="_modifiedonbehalfby_value")
    @JsonIgnore
    public Optional<UUID> get_modifiedonbehalfby_value() {
        return Optional.ofNullable(_modifiedonbehalfby_value);
    }

    public Pluginassembly with_modifiedonbehalfby_value(UUID _modifiedonbehalfby_value) {
        Pluginassembly _x = _copy();
        _x.changedFields = changedFields.add("_modifiedonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.pluginassembly");
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        return _x;
    }

    @Property(name="solutionid")
    @JsonIgnore
    public Optional<UUID> getSolutionid() {
        return Optional.ofNullable(solutionid);
    }

    public Pluginassembly withSolutionid(UUID solutionid) {
        Pluginassembly _x = _copy();
        _x.changedFields = changedFields.add("solutionid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.pluginassembly");
        _x.solutionid = solutionid;
        return _x;
    }

    @Property(name="authtype")
    @JsonIgnore
    public Optional<Integer> getAuthtype() {
        return Optional.ofNullable(authtype);
    }

    public Pluginassembly withAuthtype(Integer authtype) {
        Pluginassembly _x = _copy();
        _x.changedFields = changedFields.add("authtype");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.pluginassembly");
        _x.authtype = authtype;
        return _x;
    }

    @Property(name="sourcetype")
    @JsonIgnore
    public Optional<Integer> getSourcetype() {
        return Optional.ofNullable(sourcetype);
    }

    public Pluginassembly withSourcetype(Integer sourcetype) {
        Pluginassembly _x = _copy();
        _x.changedFields = changedFields.add("sourcetype");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.pluginassembly");
        _x.sourcetype = sourcetype;
        return _x;
    }

    @Property(name="pluginassemblyid")
    @JsonIgnore
    public Optional<UUID> getPluginassemblyid() {
        return Optional.ofNullable(pluginassemblyid);
    }

    public Pluginassembly withPluginassemblyid(UUID pluginassemblyid) {
        Pluginassembly _x = _copy();
        _x.changedFields = changedFields.add("pluginassemblyid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.pluginassembly");
        _x.pluginassemblyid = pluginassemblyid;
        return _x;
    }

    @Property(name="ishidden")
    @JsonIgnore
    public Optional<BooleanManagedProperty> getIshidden() {
        return Optional.ofNullable(ishidden);
    }

    public Pluginassembly withIshidden(BooleanManagedProperty ishidden) {
        Pluginassembly _x = _copy();
        _x.changedFields = changedFields.add("ishidden");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.pluginassembly");
        _x.ishidden = ishidden;
        return _x;
    }

    @Property(name="pluginassemblyidunique")
    @JsonIgnore
    public Optional<UUID> getPluginassemblyidunique() {
        return Optional.ofNullable(pluginassemblyidunique);
    }

    public Pluginassembly withPluginassemblyidunique(UUID pluginassemblyidunique) {
        Pluginassembly _x = _copy();
        _x.changedFields = changedFields.add("pluginassemblyidunique");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.pluginassembly");
        _x.pluginassemblyidunique = pluginassemblyidunique;
        return _x;
    }

    @Property(name="overwritetime")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverwritetime() {
        return Optional.ofNullable(overwritetime);
    }

    public Pluginassembly withOverwritetime(OffsetDateTime overwritetime) {
        Pluginassembly _x = _copy();
        _x.changedFields = changedFields.add("overwritetime");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.pluginassembly");
        _x.overwritetime = overwritetime;
        return _x;
    }

    @Property(name="versionnumber")
    @JsonIgnore
    public Optional<Long> getVersionnumber() {
        return Optional.ofNullable(versionnumber);
    }

    public Pluginassembly withVersionnumber(Long versionnumber) {
        Pluginassembly _x = _copy();
        _x.changedFields = changedFields.add("versionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.pluginassembly");
        _x.versionnumber = versionnumber;
        return _x;
    }

    public Pluginassembly withUnmappedField(String name, String value) {
        Pluginassembly _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="createdby")
    @JsonIgnore
    public SystemuserRequest getCreatedby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), RequestHelper.getValue(unmappedFields, "createdby"));
    }

    @NavigationProperty(name="pluginassembly_plugintype")
    @JsonIgnore
    public PlugintypeCollectionRequest getPluginassembly_plugintype() {
        return new PlugintypeCollectionRequest(
                        contextPath.addSegment("pluginassembly_plugintype"), RequestHelper.getValue(unmappedFields, "pluginassembly_plugintype"));
    }

    @NavigationProperty(name="organizationid")
    @JsonIgnore
    public OrganizationRequest getOrganizationid() {
        return new OrganizationRequest(contextPath.addSegment("organizationid"), RequestHelper.getValue(unmappedFields, "organizationid"));
    }

    @NavigationProperty(name="modifiedonbehalfby")
    @JsonIgnore
    public SystemuserRequest getModifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), RequestHelper.getValue(unmappedFields, "modifiedonbehalfby"));
    }

    @NavigationProperty(name="createdonbehalfby")
    @JsonIgnore
    public SystemuserRequest getCreatedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), RequestHelper.getValue(unmappedFields, "createdonbehalfby"));
    }

    @NavigationProperty(name="modifiedby")
    @JsonIgnore
    public SystemuserRequest getModifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), RequestHelper.getValue(unmappedFields, "modifiedby"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Pluginassembly patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Pluginassembly _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Pluginassembly put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Pluginassembly _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Pluginassembly _copy() {
        Pluginassembly _x = new Pluginassembly();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.culture = culture;
        _x._modifiedby_value = _modifiedby_value;
        _x.version = version;
        _x.description = description;
        _x.sourcehash = sourcehash;
        _x.username = username;
        _x.ismanaged = ismanaged;
        _x.modifiedon = modifiedon;
        _x.introducedversion = introducedversion;
        _x.createdon = createdon;
        _x.customizationlevel = customizationlevel;
        _x.publickeytoken = publickeytoken;
        _x.content = content;
        _x.content_binary = content_binary;
        _x.path = path;
        _x.name = name;
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        _x.ispasswordset = ispasswordset;
        _x.password = password;
        _x._organizationid_value = _organizationid_value;
        _x.isolationmode = isolationmode;
        _x.url = url;
        _x.iscustomizable = iscustomizable;
        _x._createdby_value = _createdby_value;
        _x.major = major;
        _x.minor = minor;
        _x.componentstate = componentstate;
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        _x.solutionid = solutionid;
        _x.authtype = authtype;
        _x.sourcetype = sourcetype;
        _x.pluginassemblyid = pluginassemblyid;
        _x.ishidden = ishidden;
        _x.pluginassemblyidunique = pluginassemblyidunique;
        _x.overwritetime = overwritetime;
        _x.versionnumber = versionnumber;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Pluginassembly[");
        b.append("culture=");
        b.append(this.culture);
        b.append(", ");
        b.append("_modifiedby_value=");
        b.append(this._modifiedby_value);
        b.append(", ");
        b.append("version=");
        b.append(this.version);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("sourcehash=");
        b.append(this.sourcehash);
        b.append(", ");
        b.append("username=");
        b.append(this.username);
        b.append(", ");
        b.append("ismanaged=");
        b.append(this.ismanaged);
        b.append(", ");
        b.append("modifiedon=");
        b.append(this.modifiedon);
        b.append(", ");
        b.append("introducedversion=");
        b.append(this.introducedversion);
        b.append(", ");
        b.append("createdon=");
        b.append(this.createdon);
        b.append(", ");
        b.append("customizationlevel=");
        b.append(this.customizationlevel);
        b.append(", ");
        b.append("publickeytoken=");
        b.append(this.publickeytoken);
        b.append(", ");
        b.append("content=");
        b.append(this.content);
        b.append(", ");
        b.append("content_binary=");
        b.append(this.content_binary);
        b.append(", ");
        b.append("path=");
        b.append(this.path);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("_createdonbehalfby_value=");
        b.append(this._createdonbehalfby_value);
        b.append(", ");
        b.append("ispasswordset=");
        b.append(this.ispasswordset);
        b.append(", ");
        b.append("password=");
        b.append(this.password);
        b.append(", ");
        b.append("_organizationid_value=");
        b.append(this._organizationid_value);
        b.append(", ");
        b.append("isolationmode=");
        b.append(this.isolationmode);
        b.append(", ");
        b.append("url=");
        b.append(this.url);
        b.append(", ");
        b.append("iscustomizable=");
        b.append(this.iscustomizable);
        b.append(", ");
        b.append("_createdby_value=");
        b.append(this._createdby_value);
        b.append(", ");
        b.append("major=");
        b.append(this.major);
        b.append(", ");
        b.append("minor=");
        b.append(this.minor);
        b.append(", ");
        b.append("componentstate=");
        b.append(this.componentstate);
        b.append(", ");
        b.append("_modifiedonbehalfby_value=");
        b.append(this._modifiedonbehalfby_value);
        b.append(", ");
        b.append("solutionid=");
        b.append(this.solutionid);
        b.append(", ");
        b.append("authtype=");
        b.append(this.authtype);
        b.append(", ");
        b.append("sourcetype=");
        b.append(this.sourcetype);
        b.append(", ");
        b.append("pluginassemblyid=");
        b.append(this.pluginassemblyid);
        b.append(", ");
        b.append("ishidden=");
        b.append(this.ishidden);
        b.append(", ");
        b.append("pluginassemblyidunique=");
        b.append(this.pluginassemblyidunique);
        b.append(", ");
        b.append("overwritetime=");
        b.append(this.overwritetime);
        b.append(", ");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
