package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;
import java.util.UUID;

@JsonPropertyOrder({
    "@odata.type", 
    "msdyn_name", 
    "msdyn_nonrelationaldsid"})
@JsonInclude(Include.NON_NULL)
public class Msdyn_nonrelationalds extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.msdyn_nonrelationalds";
    }

    @JsonProperty("msdyn_name")
    protected String msdyn_name;

    @JsonProperty("msdyn_nonrelationaldsid")
    protected UUID msdyn_nonrelationaldsid;

    protected Msdyn_nonrelationalds() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderMsdyn_nonrelationalds() {
        return new Builder();
    }

    public static final class Builder {
        private String msdyn_name;
        private UUID msdyn_nonrelationaldsid;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder msdyn_name(String msdyn_name) {
            this.msdyn_name = msdyn_name;
            this.changedFields = changedFields.add("msdyn_name");
            return this;
        }

        public Builder msdyn_nonrelationaldsid(UUID msdyn_nonrelationaldsid) {
            this.msdyn_nonrelationaldsid = msdyn_nonrelationaldsid;
            this.changedFields = changedFields.add("msdyn_nonrelationaldsid");
            return this;
        }

        public Msdyn_nonrelationalds build() {
            Msdyn_nonrelationalds _x = new Msdyn_nonrelationalds();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.msdyn_nonrelationalds";
            _x.msdyn_name = msdyn_name;
            _x.msdyn_nonrelationaldsid = msdyn_nonrelationaldsid;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && msdyn_nonrelationaldsid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(msdyn_nonrelationaldsid, UUID.class));
        }
    }

    @Property(name="msdyn_name")
    @JsonIgnore
    public Optional<String> getMsdyn_name() {
        return Optional.ofNullable(msdyn_name);
    }

    public Msdyn_nonrelationalds withMsdyn_name(String msdyn_name) {
        Checks.checkIsAscii(msdyn_name);
        Msdyn_nonrelationalds _x = _copy();
        _x.changedFields = changedFields.add("msdyn_name");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_nonrelationalds");
        _x.msdyn_name = msdyn_name;
        return _x;
    }

    @Property(name="msdyn_nonrelationaldsid")
    @JsonIgnore
    public Optional<UUID> getMsdyn_nonrelationaldsid() {
        return Optional.ofNullable(msdyn_nonrelationaldsid);
    }

    public Msdyn_nonrelationalds withMsdyn_nonrelationaldsid(UUID msdyn_nonrelationaldsid) {
        Msdyn_nonrelationalds _x = _copy();
        _x.changedFields = changedFields.add("msdyn_nonrelationaldsid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_nonrelationalds");
        _x.msdyn_nonrelationaldsid = msdyn_nonrelationaldsid;
        return _x;
    }

    public Msdyn_nonrelationalds withUnmappedField(String name, String value) {
        Msdyn_nonrelationalds _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Msdyn_nonrelationalds patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Msdyn_nonrelationalds _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Msdyn_nonrelationalds put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Msdyn_nonrelationalds _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Msdyn_nonrelationalds _copy() {
        Msdyn_nonrelationalds _x = new Msdyn_nonrelationalds();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.msdyn_name = msdyn_name;
        _x.msdyn_nonrelationaldsid = msdyn_nonrelationaldsid;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Msdyn_nonrelationalds[");
        b.append("msdyn_name=");
        b.append(this.msdyn_name);
        b.append(", ");
        b.append("msdyn_nonrelationaldsid=");
        b.append(this.msdyn_nonrelationaldsid);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
