package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.GoalCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ProcesssessionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.RollupfieldCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;
import microsoft.dynamics.crm.entity.request.OrganizationRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "modifiedon", 
    "metricid", 
    "_modifiedby_value", 
    "statecode", 
    "_modifiedonbehalfby_value", 
    "isstretchtracked", 
    "_createdby_value", 
    "isamount", 
    "statuscode", 
    "importsequencenumber", 
    "amountdatatype", 
    "_createdonbehalfby_value", 
    "versionnumber", 
    "timezoneruleversionnumber", 
    "name", 
    "utcconversiontimezonecode", 
    "_organizationid_value", 
    "createdon", 
    "description", 
    "overriddencreatedon"})
@JsonInclude(Include.NON_NULL)
public class Metric extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.metric";
    }

    @JsonProperty("modifiedon")
    protected OffsetDateTime modifiedon;

    @JsonProperty("metricid")
    protected UUID metricid;

    @JsonProperty("_modifiedby_value")
    protected UUID _modifiedby_value;

    @JsonProperty("statecode")
    protected Integer statecode;

    @JsonProperty("_modifiedonbehalfby_value")
    protected UUID _modifiedonbehalfby_value;

    @JsonProperty("isstretchtracked")
    protected Boolean isstretchtracked;

    @JsonProperty("_createdby_value")
    protected UUID _createdby_value;

    @JsonProperty("isamount")
    protected Boolean isamount;

    @JsonProperty("statuscode")
    protected Integer statuscode;

    @JsonProperty("importsequencenumber")
    protected Integer importsequencenumber;

    @JsonProperty("amountdatatype")
    protected Integer amountdatatype;

    @JsonProperty("_createdonbehalfby_value")
    protected UUID _createdonbehalfby_value;

    @JsonProperty("versionnumber")
    protected Long versionnumber;

    @JsonProperty("timezoneruleversionnumber")
    protected Integer timezoneruleversionnumber;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("utcconversiontimezonecode")
    protected Integer utcconversiontimezonecode;

    @JsonProperty("_organizationid_value")
    protected UUID _organizationid_value;

    @JsonProperty("createdon")
    protected OffsetDateTime createdon;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("overriddencreatedon")
    protected OffsetDateTime overriddencreatedon;

    protected Metric() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderMetric() {
        return new Builder();
    }

    public static final class Builder {
        private OffsetDateTime modifiedon;
        private UUID metricid;
        private UUID _modifiedby_value;
        private Integer statecode;
        private UUID _modifiedonbehalfby_value;
        private Boolean isstretchtracked;
        private UUID _createdby_value;
        private Boolean isamount;
        private Integer statuscode;
        private Integer importsequencenumber;
        private Integer amountdatatype;
        private UUID _createdonbehalfby_value;
        private Long versionnumber;
        private Integer timezoneruleversionnumber;
        private String name;
        private Integer utcconversiontimezonecode;
        private UUID _organizationid_value;
        private OffsetDateTime createdon;
        private String description;
        private OffsetDateTime overriddencreatedon;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder modifiedon(OffsetDateTime modifiedon) {
            this.modifiedon = modifiedon;
            this.changedFields = changedFields.add("modifiedon");
            return this;
        }

        public Builder metricid(UUID metricid) {
            this.metricid = metricid;
            this.changedFields = changedFields.add("metricid");
            return this;
        }

        public Builder _modifiedby_value(UUID _modifiedby_value) {
            this._modifiedby_value = _modifiedby_value;
            this.changedFields = changedFields.add("_modifiedby_value");
            return this;
        }

        public Builder statecode(Integer statecode) {
            this.statecode = statecode;
            this.changedFields = changedFields.add("statecode");
            return this;
        }

        public Builder _modifiedonbehalfby_value(UUID _modifiedonbehalfby_value) {
            this._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            this.changedFields = changedFields.add("_modifiedonbehalfby_value");
            return this;
        }

        public Builder isstretchtracked(Boolean isstretchtracked) {
            this.isstretchtracked = isstretchtracked;
            this.changedFields = changedFields.add("isstretchtracked");
            return this;
        }

        public Builder _createdby_value(UUID _createdby_value) {
            this._createdby_value = _createdby_value;
            this.changedFields = changedFields.add("_createdby_value");
            return this;
        }

        public Builder isamount(Boolean isamount) {
            this.isamount = isamount;
            this.changedFields = changedFields.add("isamount");
            return this;
        }

        public Builder statuscode(Integer statuscode) {
            this.statuscode = statuscode;
            this.changedFields = changedFields.add("statuscode");
            return this;
        }

        public Builder importsequencenumber(Integer importsequencenumber) {
            this.importsequencenumber = importsequencenumber;
            this.changedFields = changedFields.add("importsequencenumber");
            return this;
        }

        public Builder amountdatatype(Integer amountdatatype) {
            this.amountdatatype = amountdatatype;
            this.changedFields = changedFields.add("amountdatatype");
            return this;
        }

        public Builder _createdonbehalfby_value(UUID _createdonbehalfby_value) {
            this._createdonbehalfby_value = _createdonbehalfby_value;
            this.changedFields = changedFields.add("_createdonbehalfby_value");
            return this;
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Builder timezoneruleversionnumber(Integer timezoneruleversionnumber) {
            this.timezoneruleversionnumber = timezoneruleversionnumber;
            this.changedFields = changedFields.add("timezoneruleversionnumber");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder utcconversiontimezonecode(Integer utcconversiontimezonecode) {
            this.utcconversiontimezonecode = utcconversiontimezonecode;
            this.changedFields = changedFields.add("utcconversiontimezonecode");
            return this;
        }

        public Builder _organizationid_value(UUID _organizationid_value) {
            this._organizationid_value = _organizationid_value;
            this.changedFields = changedFields.add("_organizationid_value");
            return this;
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder overriddencreatedon(OffsetDateTime overriddencreatedon) {
            this.overriddencreatedon = overriddencreatedon;
            this.changedFields = changedFields.add("overriddencreatedon");
            return this;
        }

        public Metric build() {
            Metric _x = new Metric();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.metric";
            _x.modifiedon = modifiedon;
            _x.metricid = metricid;
            _x._modifiedby_value = _modifiedby_value;
            _x.statecode = statecode;
            _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            _x.isstretchtracked = isstretchtracked;
            _x._createdby_value = _createdby_value;
            _x.isamount = isamount;
            _x.statuscode = statuscode;
            _x.importsequencenumber = importsequencenumber;
            _x.amountdatatype = amountdatatype;
            _x._createdonbehalfby_value = _createdonbehalfby_value;
            _x.versionnumber = versionnumber;
            _x.timezoneruleversionnumber = timezoneruleversionnumber;
            _x.name = name;
            _x.utcconversiontimezonecode = utcconversiontimezonecode;
            _x._organizationid_value = _organizationid_value;
            _x.createdon = createdon;
            _x.description = description;
            _x.overriddencreatedon = overriddencreatedon;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && metricid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(metricid, UUID.class));
        }
    }

    @Property(name="modifiedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedon() {
        return Optional.ofNullable(modifiedon);
    }

    public Metric withModifiedon(OffsetDateTime modifiedon) {
        Metric _x = _copy();
        _x.changedFields = changedFields.add("modifiedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.metric");
        _x.modifiedon = modifiedon;
        return _x;
    }

    @Property(name="metricid")
    @JsonIgnore
    public Optional<UUID> getMetricid() {
        return Optional.ofNullable(metricid);
    }

    public Metric withMetricid(UUID metricid) {
        Metric _x = _copy();
        _x.changedFields = changedFields.add("metricid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.metric");
        _x.metricid = metricid;
        return _x;
    }

    @Property(name="_modifiedby_value")
    @JsonIgnore
    public Optional<UUID> get_modifiedby_value() {
        return Optional.ofNullable(_modifiedby_value);
    }

    public Metric with_modifiedby_value(UUID _modifiedby_value) {
        Metric _x = _copy();
        _x.changedFields = changedFields.add("_modifiedby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.metric");
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    @Property(name="statecode")
    @JsonIgnore
    public Optional<Integer> getStatecode() {
        return Optional.ofNullable(statecode);
    }

    public Metric withStatecode(Integer statecode) {
        Metric _x = _copy();
        _x.changedFields = changedFields.add("statecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.metric");
        _x.statecode = statecode;
        return _x;
    }

    @Property(name="_modifiedonbehalfby_value")
    @JsonIgnore
    public Optional<UUID> get_modifiedonbehalfby_value() {
        return Optional.ofNullable(_modifiedonbehalfby_value);
    }

    public Metric with_modifiedonbehalfby_value(UUID _modifiedonbehalfby_value) {
        Metric _x = _copy();
        _x.changedFields = changedFields.add("_modifiedonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.metric");
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        return _x;
    }

    @Property(name="isstretchtracked")
    @JsonIgnore
    public Optional<Boolean> getIsstretchtracked() {
        return Optional.ofNullable(isstretchtracked);
    }

    public Metric withIsstretchtracked(Boolean isstretchtracked) {
        Metric _x = _copy();
        _x.changedFields = changedFields.add("isstretchtracked");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.metric");
        _x.isstretchtracked = isstretchtracked;
        return _x;
    }

    @Property(name="_createdby_value")
    @JsonIgnore
    public Optional<UUID> get_createdby_value() {
        return Optional.ofNullable(_createdby_value);
    }

    public Metric with_createdby_value(UUID _createdby_value) {
        Metric _x = _copy();
        _x.changedFields = changedFields.add("_createdby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.metric");
        _x._createdby_value = _createdby_value;
        return _x;
    }

    @Property(name="isamount")
    @JsonIgnore
    public Optional<Boolean> getIsamount() {
        return Optional.ofNullable(isamount);
    }

    public Metric withIsamount(Boolean isamount) {
        Metric _x = _copy();
        _x.changedFields = changedFields.add("isamount");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.metric");
        _x.isamount = isamount;
        return _x;
    }

    @Property(name="statuscode")
    @JsonIgnore
    public Optional<Integer> getStatuscode() {
        return Optional.ofNullable(statuscode);
    }

    public Metric withStatuscode(Integer statuscode) {
        Metric _x = _copy();
        _x.changedFields = changedFields.add("statuscode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.metric");
        _x.statuscode = statuscode;
        return _x;
    }

    @Property(name="importsequencenumber")
    @JsonIgnore
    public Optional<Integer> getImportsequencenumber() {
        return Optional.ofNullable(importsequencenumber);
    }

    public Metric withImportsequencenumber(Integer importsequencenumber) {
        Metric _x = _copy();
        _x.changedFields = changedFields.add("importsequencenumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.metric");
        _x.importsequencenumber = importsequencenumber;
        return _x;
    }

    @Property(name="amountdatatype")
    @JsonIgnore
    public Optional<Integer> getAmountdatatype() {
        return Optional.ofNullable(amountdatatype);
    }

    public Metric withAmountdatatype(Integer amountdatatype) {
        Metric _x = _copy();
        _x.changedFields = changedFields.add("amountdatatype");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.metric");
        _x.amountdatatype = amountdatatype;
        return _x;
    }

    @Property(name="_createdonbehalfby_value")
    @JsonIgnore
    public Optional<UUID> get_createdonbehalfby_value() {
        return Optional.ofNullable(_createdonbehalfby_value);
    }

    public Metric with_createdonbehalfby_value(UUID _createdonbehalfby_value) {
        Metric _x = _copy();
        _x.changedFields = changedFields.add("_createdonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.metric");
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        return _x;
    }

    @Property(name="versionnumber")
    @JsonIgnore
    public Optional<Long> getVersionnumber() {
        return Optional.ofNullable(versionnumber);
    }

    public Metric withVersionnumber(Long versionnumber) {
        Metric _x = _copy();
        _x.changedFields = changedFields.add("versionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.metric");
        _x.versionnumber = versionnumber;
        return _x;
    }

    @Property(name="timezoneruleversionnumber")
    @JsonIgnore
    public Optional<Integer> getTimezoneruleversionnumber() {
        return Optional.ofNullable(timezoneruleversionnumber);
    }

    public Metric withTimezoneruleversionnumber(Integer timezoneruleversionnumber) {
        Metric _x = _copy();
        _x.changedFields = changedFields.add("timezoneruleversionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.metric");
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        return _x;
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public Metric withName(String name) {
        Checks.checkIsAscii(name);
        Metric _x = _copy();
        _x.changedFields = changedFields.add("name");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.metric");
        _x.name = name;
        return _x;
    }

    @Property(name="utcconversiontimezonecode")
    @JsonIgnore
    public Optional<Integer> getUtcconversiontimezonecode() {
        return Optional.ofNullable(utcconversiontimezonecode);
    }

    public Metric withUtcconversiontimezonecode(Integer utcconversiontimezonecode) {
        Metric _x = _copy();
        _x.changedFields = changedFields.add("utcconversiontimezonecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.metric");
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        return _x;
    }

    @Property(name="_organizationid_value")
    @JsonIgnore
    public Optional<UUID> get_organizationid_value() {
        return Optional.ofNullable(_organizationid_value);
    }

    public Metric with_organizationid_value(UUID _organizationid_value) {
        Metric _x = _copy();
        _x.changedFields = changedFields.add("_organizationid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.metric");
        _x._organizationid_value = _organizationid_value;
        return _x;
    }

    @Property(name="createdon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedon() {
        return Optional.ofNullable(createdon);
    }

    public Metric withCreatedon(OffsetDateTime createdon) {
        Metric _x = _copy();
        _x.changedFields = changedFields.add("createdon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.metric");
        _x.createdon = createdon;
        return _x;
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public Metric withDescription(String description) {
        Checks.checkIsAscii(description);
        Metric _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.metric");
        _x.description = description;
        return _x;
    }

    @Property(name="overriddencreatedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverriddencreatedon() {
        return Optional.ofNullable(overriddencreatedon);
    }

    public Metric withOverriddencreatedon(OffsetDateTime overriddencreatedon) {
        Metric _x = _copy();
        _x.changedFields = changedFields.add("overriddencreatedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.metric");
        _x.overriddencreatedon = overriddencreatedon;
        return _x;
    }

    public Metric withUnmappedField(String name, String value) {
        Metric _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="createdby")
    @JsonIgnore
    public SystemuserRequest getCreatedby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), RequestHelper.getValue(unmappedFields, "createdby"));
    }

    @NavigationProperty(name="createdonbehalfby")
    @JsonIgnore
    public SystemuserRequest getCreatedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), RequestHelper.getValue(unmappedFields, "createdonbehalfby"));
    }

    @NavigationProperty(name="modifiedby")
    @JsonIgnore
    public SystemuserRequest getModifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), RequestHelper.getValue(unmappedFields, "modifiedby"));
    }

    @NavigationProperty(name="modifiedonbehalfby")
    @JsonIgnore
    public SystemuserRequest getModifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), RequestHelper.getValue(unmappedFields, "modifiedonbehalfby"));
    }

    @NavigationProperty(name="organizationid")
    @JsonIgnore
    public OrganizationRequest getOrganizationid() {
        return new OrganizationRequest(contextPath.addSegment("organizationid"), RequestHelper.getValue(unmappedFields, "organizationid"));
    }

    @NavigationProperty(name="metric_goal")
    @JsonIgnore
    public GoalCollectionRequest getMetric_goal() {
        return new GoalCollectionRequest(
                        contextPath.addSegment("metric_goal"), RequestHelper.getValue(unmappedFields, "metric_goal"));
    }

    @NavigationProperty(name="metric_rollupfield")
    @JsonIgnore
    public RollupfieldCollectionRequest getMetric_rollupfield() {
        return new RollupfieldCollectionRequest(
                        contextPath.addSegment("metric_rollupfield"), RequestHelper.getValue(unmappedFields, "metric_rollupfield"));
    }

    @NavigationProperty(name="metric_ProcessSessions")
    @JsonIgnore
    public ProcesssessionCollectionRequest getMetric_ProcessSessions() {
        return new ProcesssessionCollectionRequest(
                        contextPath.addSegment("metric_ProcessSessions"), RequestHelper.getValue(unmappedFields, "metric_ProcessSessions"));
    }

    @NavigationProperty(name="metric_AsyncOperations")
    @JsonIgnore
    public AsyncoperationCollectionRequest getMetric_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("metric_AsyncOperations"), RequestHelper.getValue(unmappedFields, "metric_AsyncOperations"));
    }

    @NavigationProperty(name="Metric_SyncErrors")
    @JsonIgnore
    public SyncerrorCollectionRequest getMetric_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("Metric_SyncErrors"), RequestHelper.getValue(unmappedFields, "Metric_SyncErrors"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Metric patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Metric _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Metric put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Metric _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Metric _copy() {
        Metric _x = new Metric();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.modifiedon = modifiedon;
        _x.metricid = metricid;
        _x._modifiedby_value = _modifiedby_value;
        _x.statecode = statecode;
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        _x.isstretchtracked = isstretchtracked;
        _x._createdby_value = _createdby_value;
        _x.isamount = isamount;
        _x.statuscode = statuscode;
        _x.importsequencenumber = importsequencenumber;
        _x.amountdatatype = amountdatatype;
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        _x.versionnumber = versionnumber;
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        _x.name = name;
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        _x._organizationid_value = _organizationid_value;
        _x.createdon = createdon;
        _x.description = description;
        _x.overriddencreatedon = overriddencreatedon;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Metric[");
        b.append("modifiedon=");
        b.append(this.modifiedon);
        b.append(", ");
        b.append("metricid=");
        b.append(this.metricid);
        b.append(", ");
        b.append("_modifiedby_value=");
        b.append(this._modifiedby_value);
        b.append(", ");
        b.append("statecode=");
        b.append(this.statecode);
        b.append(", ");
        b.append("_modifiedonbehalfby_value=");
        b.append(this._modifiedonbehalfby_value);
        b.append(", ");
        b.append("isstretchtracked=");
        b.append(this.isstretchtracked);
        b.append(", ");
        b.append("_createdby_value=");
        b.append(this._createdby_value);
        b.append(", ");
        b.append("isamount=");
        b.append(this.isamount);
        b.append(", ");
        b.append("statuscode=");
        b.append(this.statuscode);
        b.append(", ");
        b.append("importsequencenumber=");
        b.append(this.importsequencenumber);
        b.append(", ");
        b.append("amountdatatype=");
        b.append(this.amountdatatype);
        b.append(", ");
        b.append("_createdonbehalfby_value=");
        b.append(this._createdonbehalfby_value);
        b.append(", ");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append(", ");
        b.append("timezoneruleversionnumber=");
        b.append(this.timezoneruleversionnumber);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("utcconversiontimezonecode=");
        b.append(this.utcconversiontimezonecode);
        b.append(", ");
        b.append("_organizationid_value=");
        b.append(this._organizationid_value);
        b.append(", ");
        b.append("createdon=");
        b.append(this.createdon);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("overriddencreatedon=");
        b.append(this.overriddencreatedon);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
