package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.complex.Label;
import microsoft.dynamics.crm.enums.ManagedPropertyEvaluationPriority;
import microsoft.dynamics.crm.enums.ManagedPropertyOperation;
import microsoft.dynamics.crm.enums.ManagedPropertyType;

@JsonPropertyOrder({
    "@odata.type", 
    "LogicalName", 
    "DisplayName", 
    "ManagedPropertyType", 
    "Operation", 
    "IsGlobalForOperation", 
    "EvaluationPriority", 
    "IsPrivate", 
    "ErrorCode", 
    "EnablesEntityName", 
    "EnablesAttributeName", 
    "Description", 
    "IntroducedVersion"})
@JsonInclude(Include.NON_NULL)
public class ManagedPropertyMetadata extends MetadataBase implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.ManagedPropertyMetadata";
    }

    @JsonProperty("LogicalName")
    protected String logicalName;

    @JsonProperty("DisplayName")
    protected Label displayName;

    @JsonProperty("ManagedPropertyType")
    protected ManagedPropertyType managedPropertyType;

    @JsonProperty("Operation")
    protected ManagedPropertyOperation operation;

    @JsonProperty("IsGlobalForOperation")
    protected Boolean isGlobalForOperation;

    @JsonProperty("EvaluationPriority")
    protected ManagedPropertyEvaluationPriority evaluationPriority;

    @JsonProperty("IsPrivate")
    protected Boolean isPrivate;

    @JsonProperty("ErrorCode")
    protected Integer errorCode;

    @JsonProperty("EnablesEntityName")
    protected String enablesEntityName;

    @JsonProperty("EnablesAttributeName")
    protected String enablesAttributeName;

    @JsonProperty("Description")
    protected Label description;

    @JsonProperty("IntroducedVersion")
    protected String introducedVersion;

    protected ManagedPropertyMetadata() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderManagedPropertyMetadata() {
        return new Builder();
    }

    public static final class Builder {
        private UUID metadataId;
        private Boolean hasChanged;
        private String logicalName;
        private Label displayName;
        private ManagedPropertyType managedPropertyType;
        private ManagedPropertyOperation operation;
        private Boolean isGlobalForOperation;
        private ManagedPropertyEvaluationPriority evaluationPriority;
        private Boolean isPrivate;
        private Integer errorCode;
        private String enablesEntityName;
        private String enablesAttributeName;
        private Label description;
        private String introducedVersion;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder metadataId(UUID metadataId) {
            this.metadataId = metadataId;
            this.changedFields = changedFields.add("MetadataId");
            return this;
        }

        public Builder hasChanged(Boolean hasChanged) {
            this.hasChanged = hasChanged;
            this.changedFields = changedFields.add("HasChanged");
            return this;
        }

        public Builder logicalName(String logicalName) {
            this.logicalName = logicalName;
            this.changedFields = changedFields.add("LogicalName");
            return this;
        }

        public Builder displayName(Label displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("DisplayName");
            return this;
        }

        public Builder managedPropertyType(ManagedPropertyType managedPropertyType) {
            this.managedPropertyType = managedPropertyType;
            this.changedFields = changedFields.add("ManagedPropertyType");
            return this;
        }

        public Builder operation(ManagedPropertyOperation operation) {
            this.operation = operation;
            this.changedFields = changedFields.add("Operation");
            return this;
        }

        public Builder isGlobalForOperation(Boolean isGlobalForOperation) {
            this.isGlobalForOperation = isGlobalForOperation;
            this.changedFields = changedFields.add("IsGlobalForOperation");
            return this;
        }

        public Builder evaluationPriority(ManagedPropertyEvaluationPriority evaluationPriority) {
            this.evaluationPriority = evaluationPriority;
            this.changedFields = changedFields.add("EvaluationPriority");
            return this;
        }

        public Builder isPrivate(Boolean isPrivate) {
            this.isPrivate = isPrivate;
            this.changedFields = changedFields.add("IsPrivate");
            return this;
        }

        public Builder errorCode(Integer errorCode) {
            this.errorCode = errorCode;
            this.changedFields = changedFields.add("ErrorCode");
            return this;
        }

        public Builder enablesEntityName(String enablesEntityName) {
            this.enablesEntityName = enablesEntityName;
            this.changedFields = changedFields.add("EnablesEntityName");
            return this;
        }

        public Builder enablesAttributeName(String enablesAttributeName) {
            this.enablesAttributeName = enablesAttributeName;
            this.changedFields = changedFields.add("EnablesAttributeName");
            return this;
        }

        public Builder description(Label description) {
            this.description = description;
            this.changedFields = changedFields.add("Description");
            return this;
        }

        public Builder introducedVersion(String introducedVersion) {
            this.introducedVersion = introducedVersion;
            this.changedFields = changedFields.add("IntroducedVersion");
            return this;
        }

        public ManagedPropertyMetadata build() {
            ManagedPropertyMetadata _x = new ManagedPropertyMetadata();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.ManagedPropertyMetadata";
            _x.metadataId = metadataId;
            _x.hasChanged = hasChanged;
            _x.logicalName = logicalName;
            _x.displayName = displayName;
            _x.managedPropertyType = managedPropertyType;
            _x.operation = operation;
            _x.isGlobalForOperation = isGlobalForOperation;
            _x.evaluationPriority = evaluationPriority;
            _x.isPrivate = isPrivate;
            _x.errorCode = errorCode;
            _x.enablesEntityName = enablesEntityName;
            _x.enablesAttributeName = enablesAttributeName;
            _x.description = description;
            _x.introducedVersion = introducedVersion;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && metadataId != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(metadataId, UUID.class));
        }
    }

    @Property(name="LogicalName")
    @JsonIgnore
    public Optional<String> getLogicalName() {
        return Optional.ofNullable(logicalName);
    }

    public ManagedPropertyMetadata withLogicalName(String logicalName) {
        Checks.checkIsAscii(logicalName);
        ManagedPropertyMetadata _x = _copy();
        _x.changedFields = changedFields.add("LogicalName");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ManagedPropertyMetadata");
        _x.logicalName = logicalName;
        return _x;
    }

    @Property(name="DisplayName")
    @JsonIgnore
    public Optional<Label> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public ManagedPropertyMetadata withDisplayName(Label displayName) {
        ManagedPropertyMetadata _x = _copy();
        _x.changedFields = changedFields.add("DisplayName");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ManagedPropertyMetadata");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="ManagedPropertyType")
    @JsonIgnore
    public Optional<ManagedPropertyType> getManagedPropertyType() {
        return Optional.ofNullable(managedPropertyType);
    }

    public ManagedPropertyMetadata withManagedPropertyType(ManagedPropertyType managedPropertyType) {
        ManagedPropertyMetadata _x = _copy();
        _x.changedFields = changedFields.add("ManagedPropertyType");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ManagedPropertyMetadata");
        _x.managedPropertyType = managedPropertyType;
        return _x;
    }

    @Property(name="Operation")
    @JsonIgnore
    public Optional<ManagedPropertyOperation> getOperation() {
        return Optional.ofNullable(operation);
    }

    public ManagedPropertyMetadata withOperation(ManagedPropertyOperation operation) {
        ManagedPropertyMetadata _x = _copy();
        _x.changedFields = changedFields.add("Operation");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ManagedPropertyMetadata");
        _x.operation = operation;
        return _x;
    }

    @Property(name="IsGlobalForOperation")
    @JsonIgnore
    public Optional<Boolean> getIsGlobalForOperation() {
        return Optional.ofNullable(isGlobalForOperation);
    }

    public ManagedPropertyMetadata withIsGlobalForOperation(Boolean isGlobalForOperation) {
        ManagedPropertyMetadata _x = _copy();
        _x.changedFields = changedFields.add("IsGlobalForOperation");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ManagedPropertyMetadata");
        _x.isGlobalForOperation = isGlobalForOperation;
        return _x;
    }

    @Property(name="EvaluationPriority")
    @JsonIgnore
    public Optional<ManagedPropertyEvaluationPriority> getEvaluationPriority() {
        return Optional.ofNullable(evaluationPriority);
    }

    public ManagedPropertyMetadata withEvaluationPriority(ManagedPropertyEvaluationPriority evaluationPriority) {
        ManagedPropertyMetadata _x = _copy();
        _x.changedFields = changedFields.add("EvaluationPriority");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ManagedPropertyMetadata");
        _x.evaluationPriority = evaluationPriority;
        return _x;
    }

    @Property(name="IsPrivate")
    @JsonIgnore
    public Optional<Boolean> getIsPrivate() {
        return Optional.ofNullable(isPrivate);
    }

    public ManagedPropertyMetadata withIsPrivate(Boolean isPrivate) {
        ManagedPropertyMetadata _x = _copy();
        _x.changedFields = changedFields.add("IsPrivate");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ManagedPropertyMetadata");
        _x.isPrivate = isPrivate;
        return _x;
    }

    @Property(name="ErrorCode")
    @JsonIgnore
    public Optional<Integer> getErrorCode() {
        return Optional.ofNullable(errorCode);
    }

    public ManagedPropertyMetadata withErrorCode(Integer errorCode) {
        ManagedPropertyMetadata _x = _copy();
        _x.changedFields = changedFields.add("ErrorCode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ManagedPropertyMetadata");
        _x.errorCode = errorCode;
        return _x;
    }

    @Property(name="EnablesEntityName")
    @JsonIgnore
    public Optional<String> getEnablesEntityName() {
        return Optional.ofNullable(enablesEntityName);
    }

    public ManagedPropertyMetadata withEnablesEntityName(String enablesEntityName) {
        Checks.checkIsAscii(enablesEntityName);
        ManagedPropertyMetadata _x = _copy();
        _x.changedFields = changedFields.add("EnablesEntityName");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ManagedPropertyMetadata");
        _x.enablesEntityName = enablesEntityName;
        return _x;
    }

    @Property(name="EnablesAttributeName")
    @JsonIgnore
    public Optional<String> getEnablesAttributeName() {
        return Optional.ofNullable(enablesAttributeName);
    }

    public ManagedPropertyMetadata withEnablesAttributeName(String enablesAttributeName) {
        Checks.checkIsAscii(enablesAttributeName);
        ManagedPropertyMetadata _x = _copy();
        _x.changedFields = changedFields.add("EnablesAttributeName");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ManagedPropertyMetadata");
        _x.enablesAttributeName = enablesAttributeName;
        return _x;
    }

    @Property(name="Description")
    @JsonIgnore
    public Optional<Label> getDescription() {
        return Optional.ofNullable(description);
    }

    public ManagedPropertyMetadata withDescription(Label description) {
        ManagedPropertyMetadata _x = _copy();
        _x.changedFields = changedFields.add("Description");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ManagedPropertyMetadata");
        _x.description = description;
        return _x;
    }

    @Property(name="IntroducedVersion")
    @JsonIgnore
    public Optional<String> getIntroducedVersion() {
        return Optional.ofNullable(introducedVersion);
    }

    public ManagedPropertyMetadata withIntroducedVersion(String introducedVersion) {
        Checks.checkIsAscii(introducedVersion);
        ManagedPropertyMetadata _x = _copy();
        _x.changedFields = changedFields.add("IntroducedVersion");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ManagedPropertyMetadata");
        _x.introducedVersion = introducedVersion;
        return _x;
    }

    public ManagedPropertyMetadata withUnmappedField(String name, String value) {
        ManagedPropertyMetadata _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ManagedPropertyMetadata patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        ManagedPropertyMetadata _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ManagedPropertyMetadata put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        ManagedPropertyMetadata _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private ManagedPropertyMetadata _copy() {
        ManagedPropertyMetadata _x = new ManagedPropertyMetadata();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.metadataId = metadataId;
        _x.hasChanged = hasChanged;
        _x.logicalName = logicalName;
        _x.displayName = displayName;
        _x.managedPropertyType = managedPropertyType;
        _x.operation = operation;
        _x.isGlobalForOperation = isGlobalForOperation;
        _x.evaluationPriority = evaluationPriority;
        _x.isPrivate = isPrivate;
        _x.errorCode = errorCode;
        _x.enablesEntityName = enablesEntityName;
        _x.enablesAttributeName = enablesAttributeName;
        _x.description = description;
        _x.introducedVersion = introducedVersion;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ManagedPropertyMetadata[");
        b.append("MetadataId=");
        b.append(this.metadataId);
        b.append(", ");
        b.append("HasChanged=");
        b.append(this.hasChanged);
        b.append(", ");
        b.append("LogicalName=");
        b.append(this.logicalName);
        b.append(", ");
        b.append("DisplayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("ManagedPropertyType=");
        b.append(this.managedPropertyType);
        b.append(", ");
        b.append("Operation=");
        b.append(this.operation);
        b.append(", ");
        b.append("IsGlobalForOperation=");
        b.append(this.isGlobalForOperation);
        b.append(", ");
        b.append("EvaluationPriority=");
        b.append(this.evaluationPriority);
        b.append(", ");
        b.append("IsPrivate=");
        b.append(this.isPrivate);
        b.append(", ");
        b.append("ErrorCode=");
        b.append(this.errorCode);
        b.append(", ");
        b.append("EnablesEntityName=");
        b.append(this.enablesEntityName);
        b.append(", ");
        b.append("EnablesAttributeName=");
        b.append(this.enablesAttributeName);
        b.append(", ");
        b.append("Description=");
        b.append(this.description);
        b.append(", ");
        b.append("IntroducedVersion=");
        b.append(this.introducedVersion);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
