package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.math.BigDecimal;
import java.time.OffsetDateTime;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.complex.BooleanManagedProperty;
import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PrincipalobjectattributeaccessCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ProcesssessionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;
import microsoft.dynamics.crm.entity.request.BusinessunitRequest;
import microsoft.dynamics.crm.entity.request.PrincipalRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;
import microsoft.dynamics.crm.entity.request.TransactioncurrencyRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "timezoneruleversionnumber", 
    "componentstate", 
    "languagecode", 
    "_modifiedonbehalfby_value", 
    "name", 
    "_owningbusinessunit_value", 
    "introducedversion", 
    "_transactioncurrencyid_value", 
    "ismanaged", 
    "filesize", 
    "modifiedon", 
    "mailmergetemplateidunique", 
    "_owningteam_value", 
    "statuscode", 
    "versionnumber", 
    "mimetype", 
    "solutionid", 
    "parameterxml", 
    "mailmergetype", 
    "_owninguser_value", 
    "_modifiedby_value", 
    "_createdonbehalfby_value", 
    "body", 
    "documentformat", 
    "filename", 
    "overwritetime", 
    "statecode", 
    "exchangerate", 
    "mailmergetemplateid", 
    "ispersonal", 
    "description", 
    "utcconversiontimezonecode", 
    "createdon", 
    "defaultfilter", 
    "_ownerid_value", 
    "_createdby_value", 
    "templatetypecode", 
    "iscustomizable"})
@JsonInclude(Include.NON_NULL)
public class Mailmergetemplate extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.mailmergetemplate";
    }

    @JsonProperty("timezoneruleversionnumber")
    protected Integer timezoneruleversionnumber;

    @JsonProperty("componentstate")
    protected Integer componentstate;

    @JsonProperty("languagecode")
    protected Integer languagecode;

    @JsonProperty("_modifiedonbehalfby_value")
    protected UUID _modifiedonbehalfby_value;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("_owningbusinessunit_value")
    protected UUID _owningbusinessunit_value;

    @JsonProperty("introducedversion")
    protected String introducedversion;

    @JsonProperty("_transactioncurrencyid_value")
    protected UUID _transactioncurrencyid_value;

    @JsonProperty("ismanaged")
    protected Boolean ismanaged;

    @JsonProperty("filesize")
    protected Integer filesize;

    @JsonProperty("modifiedon")
    protected OffsetDateTime modifiedon;

    @JsonProperty("mailmergetemplateidunique")
    protected UUID mailmergetemplateidunique;

    @JsonProperty("_owningteam_value")
    protected UUID _owningteam_value;

    @JsonProperty("statuscode")
    protected Integer statuscode;

    @JsonProperty("versionnumber")
    protected Long versionnumber;

    @JsonProperty("mimetype")
    protected String mimetype;

    @JsonProperty("solutionid")
    protected UUID solutionid;

    @JsonProperty("parameterxml")
    protected String parameterxml;

    @JsonProperty("mailmergetype")
    protected Integer mailmergetype;

    @JsonProperty("_owninguser_value")
    protected UUID _owninguser_value;

    @JsonProperty("_modifiedby_value")
    protected UUID _modifiedby_value;

    @JsonProperty("_createdonbehalfby_value")
    protected UUID _createdonbehalfby_value;

    @JsonProperty("body")
    protected String body;

    @JsonProperty("documentformat")
    protected Integer documentformat;

    @JsonProperty("filename")
    protected String filename;

    @JsonProperty("overwritetime")
    protected OffsetDateTime overwritetime;

    @JsonProperty("statecode")
    protected Integer statecode;

    @JsonProperty("exchangerate")
    protected BigDecimal exchangerate;

    @JsonProperty("mailmergetemplateid")
    protected UUID mailmergetemplateid;

    @JsonProperty("ispersonal")
    protected Boolean ispersonal;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("utcconversiontimezonecode")
    protected Integer utcconversiontimezonecode;

    @JsonProperty("createdon")
    protected OffsetDateTime createdon;

    @JsonProperty("defaultfilter")
    protected String defaultfilter;

    @JsonProperty("_ownerid_value")
    protected UUID _ownerid_value;

    @JsonProperty("_createdby_value")
    protected UUID _createdby_value;

    @JsonProperty("templatetypecode")
    protected String templatetypecode;

    @JsonProperty("iscustomizable")
    protected BooleanManagedProperty iscustomizable;

    protected Mailmergetemplate() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderMailmergetemplate() {
        return new Builder();
    }

    public static final class Builder {
        private Integer timezoneruleversionnumber;
        private Integer componentstate;
        private Integer languagecode;
        private UUID _modifiedonbehalfby_value;
        private String name;
        private UUID _owningbusinessunit_value;
        private String introducedversion;
        private UUID _transactioncurrencyid_value;
        private Boolean ismanaged;
        private Integer filesize;
        private OffsetDateTime modifiedon;
        private UUID mailmergetemplateidunique;
        private UUID _owningteam_value;
        private Integer statuscode;
        private Long versionnumber;
        private String mimetype;
        private UUID solutionid;
        private String parameterxml;
        private Integer mailmergetype;
        private UUID _owninguser_value;
        private UUID _modifiedby_value;
        private UUID _createdonbehalfby_value;
        private String body;
        private Integer documentformat;
        private String filename;
        private OffsetDateTime overwritetime;
        private Integer statecode;
        private BigDecimal exchangerate;
        private UUID mailmergetemplateid;
        private Boolean ispersonal;
        private String description;
        private Integer utcconversiontimezonecode;
        private OffsetDateTime createdon;
        private String defaultfilter;
        private UUID _ownerid_value;
        private UUID _createdby_value;
        private String templatetypecode;
        private BooleanManagedProperty iscustomizable;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder timezoneruleversionnumber(Integer timezoneruleversionnumber) {
            this.timezoneruleversionnumber = timezoneruleversionnumber;
            this.changedFields = changedFields.add("timezoneruleversionnumber");
            return this;
        }

        public Builder componentstate(Integer componentstate) {
            this.componentstate = componentstate;
            this.changedFields = changedFields.add("componentstate");
            return this;
        }

        public Builder languagecode(Integer languagecode) {
            this.languagecode = languagecode;
            this.changedFields = changedFields.add("languagecode");
            return this;
        }

        public Builder _modifiedonbehalfby_value(UUID _modifiedonbehalfby_value) {
            this._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            this.changedFields = changedFields.add("_modifiedonbehalfby_value");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder _owningbusinessunit_value(UUID _owningbusinessunit_value) {
            this._owningbusinessunit_value = _owningbusinessunit_value;
            this.changedFields = changedFields.add("_owningbusinessunit_value");
            return this;
        }

        public Builder introducedversion(String introducedversion) {
            this.introducedversion = introducedversion;
            this.changedFields = changedFields.add("introducedversion");
            return this;
        }

        public Builder _transactioncurrencyid_value(UUID _transactioncurrencyid_value) {
            this._transactioncurrencyid_value = _transactioncurrencyid_value;
            this.changedFields = changedFields.add("_transactioncurrencyid_value");
            return this;
        }

        public Builder ismanaged(Boolean ismanaged) {
            this.ismanaged = ismanaged;
            this.changedFields = changedFields.add("ismanaged");
            return this;
        }

        public Builder filesize(Integer filesize) {
            this.filesize = filesize;
            this.changedFields = changedFields.add("filesize");
            return this;
        }

        public Builder modifiedon(OffsetDateTime modifiedon) {
            this.modifiedon = modifiedon;
            this.changedFields = changedFields.add("modifiedon");
            return this;
        }

        public Builder mailmergetemplateidunique(UUID mailmergetemplateidunique) {
            this.mailmergetemplateidunique = mailmergetemplateidunique;
            this.changedFields = changedFields.add("mailmergetemplateidunique");
            return this;
        }

        public Builder _owningteam_value(UUID _owningteam_value) {
            this._owningteam_value = _owningteam_value;
            this.changedFields = changedFields.add("_owningteam_value");
            return this;
        }

        public Builder statuscode(Integer statuscode) {
            this.statuscode = statuscode;
            this.changedFields = changedFields.add("statuscode");
            return this;
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Builder mimetype(String mimetype) {
            this.mimetype = mimetype;
            this.changedFields = changedFields.add("mimetype");
            return this;
        }

        public Builder solutionid(UUID solutionid) {
            this.solutionid = solutionid;
            this.changedFields = changedFields.add("solutionid");
            return this;
        }

        public Builder parameterxml(String parameterxml) {
            this.parameterxml = parameterxml;
            this.changedFields = changedFields.add("parameterxml");
            return this;
        }

        public Builder mailmergetype(Integer mailmergetype) {
            this.mailmergetype = mailmergetype;
            this.changedFields = changedFields.add("mailmergetype");
            return this;
        }

        public Builder _owninguser_value(UUID _owninguser_value) {
            this._owninguser_value = _owninguser_value;
            this.changedFields = changedFields.add("_owninguser_value");
            return this;
        }

        public Builder _modifiedby_value(UUID _modifiedby_value) {
            this._modifiedby_value = _modifiedby_value;
            this.changedFields = changedFields.add("_modifiedby_value");
            return this;
        }

        public Builder _createdonbehalfby_value(UUID _createdonbehalfby_value) {
            this._createdonbehalfby_value = _createdonbehalfby_value;
            this.changedFields = changedFields.add("_createdonbehalfby_value");
            return this;
        }

        public Builder body(String body) {
            this.body = body;
            this.changedFields = changedFields.add("body");
            return this;
        }

        public Builder documentformat(Integer documentformat) {
            this.documentformat = documentformat;
            this.changedFields = changedFields.add("documentformat");
            return this;
        }

        public Builder filename(String filename) {
            this.filename = filename;
            this.changedFields = changedFields.add("filename");
            return this;
        }

        public Builder overwritetime(OffsetDateTime overwritetime) {
            this.overwritetime = overwritetime;
            this.changedFields = changedFields.add("overwritetime");
            return this;
        }

        public Builder statecode(Integer statecode) {
            this.statecode = statecode;
            this.changedFields = changedFields.add("statecode");
            return this;
        }

        public Builder exchangerate(BigDecimal exchangerate) {
            this.exchangerate = exchangerate;
            this.changedFields = changedFields.add("exchangerate");
            return this;
        }

        public Builder mailmergetemplateid(UUID mailmergetemplateid) {
            this.mailmergetemplateid = mailmergetemplateid;
            this.changedFields = changedFields.add("mailmergetemplateid");
            return this;
        }

        public Builder ispersonal(Boolean ispersonal) {
            this.ispersonal = ispersonal;
            this.changedFields = changedFields.add("ispersonal");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder utcconversiontimezonecode(Integer utcconversiontimezonecode) {
            this.utcconversiontimezonecode = utcconversiontimezonecode;
            this.changedFields = changedFields.add("utcconversiontimezonecode");
            return this;
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Builder defaultfilter(String defaultfilter) {
            this.defaultfilter = defaultfilter;
            this.changedFields = changedFields.add("defaultfilter");
            return this;
        }

        public Builder _ownerid_value(UUID _ownerid_value) {
            this._ownerid_value = _ownerid_value;
            this.changedFields = changedFields.add("_ownerid_value");
            return this;
        }

        public Builder _createdby_value(UUID _createdby_value) {
            this._createdby_value = _createdby_value;
            this.changedFields = changedFields.add("_createdby_value");
            return this;
        }

        public Builder templatetypecode(String templatetypecode) {
            this.templatetypecode = templatetypecode;
            this.changedFields = changedFields.add("templatetypecode");
            return this;
        }

        public Builder iscustomizable(BooleanManagedProperty iscustomizable) {
            this.iscustomizable = iscustomizable;
            this.changedFields = changedFields.add("iscustomizable");
            return this;
        }

        public Mailmergetemplate build() {
            Mailmergetemplate _x = new Mailmergetemplate();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.mailmergetemplate";
            _x.timezoneruleversionnumber = timezoneruleversionnumber;
            _x.componentstate = componentstate;
            _x.languagecode = languagecode;
            _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            _x.name = name;
            _x._owningbusinessunit_value = _owningbusinessunit_value;
            _x.introducedversion = introducedversion;
            _x._transactioncurrencyid_value = _transactioncurrencyid_value;
            _x.ismanaged = ismanaged;
            _x.filesize = filesize;
            _x.modifiedon = modifiedon;
            _x.mailmergetemplateidunique = mailmergetemplateidunique;
            _x._owningteam_value = _owningteam_value;
            _x.statuscode = statuscode;
            _x.versionnumber = versionnumber;
            _x.mimetype = mimetype;
            _x.solutionid = solutionid;
            _x.parameterxml = parameterxml;
            _x.mailmergetype = mailmergetype;
            _x._owninguser_value = _owninguser_value;
            _x._modifiedby_value = _modifiedby_value;
            _x._createdonbehalfby_value = _createdonbehalfby_value;
            _x.body = body;
            _x.documentformat = documentformat;
            _x.filename = filename;
            _x.overwritetime = overwritetime;
            _x.statecode = statecode;
            _x.exchangerate = exchangerate;
            _x.mailmergetemplateid = mailmergetemplateid;
            _x.ispersonal = ispersonal;
            _x.description = description;
            _x.utcconversiontimezonecode = utcconversiontimezonecode;
            _x.createdon = createdon;
            _x.defaultfilter = defaultfilter;
            _x._ownerid_value = _ownerid_value;
            _x._createdby_value = _createdby_value;
            _x.templatetypecode = templatetypecode;
            _x.iscustomizable = iscustomizable;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && mailmergetemplateid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(mailmergetemplateid, UUID.class));
        }
    }

    @Property(name="timezoneruleversionnumber")
    @JsonIgnore
    public Optional<Integer> getTimezoneruleversionnumber() {
        return Optional.ofNullable(timezoneruleversionnumber);
    }

    public Mailmergetemplate withTimezoneruleversionnumber(Integer timezoneruleversionnumber) {
        Mailmergetemplate _x = _copy();
        _x.changedFields = changedFields.add("timezoneruleversionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.mailmergetemplate");
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        return _x;
    }

    @Property(name="componentstate")
    @JsonIgnore
    public Optional<Integer> getComponentstate() {
        return Optional.ofNullable(componentstate);
    }

    public Mailmergetemplate withComponentstate(Integer componentstate) {
        Mailmergetemplate _x = _copy();
        _x.changedFields = changedFields.add("componentstate");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.mailmergetemplate");
        _x.componentstate = componentstate;
        return _x;
    }

    @Property(name="languagecode")
    @JsonIgnore
    public Optional<Integer> getLanguagecode() {
        return Optional.ofNullable(languagecode);
    }

    public Mailmergetemplate withLanguagecode(Integer languagecode) {
        Mailmergetemplate _x = _copy();
        _x.changedFields = changedFields.add("languagecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.mailmergetemplate");
        _x.languagecode = languagecode;
        return _x;
    }

    @Property(name="_modifiedonbehalfby_value")
    @JsonIgnore
    public Optional<UUID> get_modifiedonbehalfby_value() {
        return Optional.ofNullable(_modifiedonbehalfby_value);
    }

    public Mailmergetemplate with_modifiedonbehalfby_value(UUID _modifiedonbehalfby_value) {
        Mailmergetemplate _x = _copy();
        _x.changedFields = changedFields.add("_modifiedonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.mailmergetemplate");
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        return _x;
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public Mailmergetemplate withName(String name) {
        Checks.checkIsAscii(name);
        Mailmergetemplate _x = _copy();
        _x.changedFields = changedFields.add("name");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.mailmergetemplate");
        _x.name = name;
        return _x;
    }

    @Property(name="_owningbusinessunit_value")
    @JsonIgnore
    public Optional<UUID> get_owningbusinessunit_value() {
        return Optional.ofNullable(_owningbusinessunit_value);
    }

    public Mailmergetemplate with_owningbusinessunit_value(UUID _owningbusinessunit_value) {
        Mailmergetemplate _x = _copy();
        _x.changedFields = changedFields.add("_owningbusinessunit_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.mailmergetemplate");
        _x._owningbusinessunit_value = _owningbusinessunit_value;
        return _x;
    }

    @Property(name="introducedversion")
    @JsonIgnore
    public Optional<String> getIntroducedversion() {
        return Optional.ofNullable(introducedversion);
    }

    public Mailmergetemplate withIntroducedversion(String introducedversion) {
        Checks.checkIsAscii(introducedversion);
        Mailmergetemplate _x = _copy();
        _x.changedFields = changedFields.add("introducedversion");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.mailmergetemplate");
        _x.introducedversion = introducedversion;
        return _x;
    }

    @Property(name="_transactioncurrencyid_value")
    @JsonIgnore
    public Optional<UUID> get_transactioncurrencyid_value() {
        return Optional.ofNullable(_transactioncurrencyid_value);
    }

    public Mailmergetemplate with_transactioncurrencyid_value(UUID _transactioncurrencyid_value) {
        Mailmergetemplate _x = _copy();
        _x.changedFields = changedFields.add("_transactioncurrencyid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.mailmergetemplate");
        _x._transactioncurrencyid_value = _transactioncurrencyid_value;
        return _x;
    }

    @Property(name="ismanaged")
    @JsonIgnore
    public Optional<Boolean> getIsmanaged() {
        return Optional.ofNullable(ismanaged);
    }

    public Mailmergetemplate withIsmanaged(Boolean ismanaged) {
        Mailmergetemplate _x = _copy();
        _x.changedFields = changedFields.add("ismanaged");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.mailmergetemplate");
        _x.ismanaged = ismanaged;
        return _x;
    }

    @Property(name="filesize")
    @JsonIgnore
    public Optional<Integer> getFilesize() {
        return Optional.ofNullable(filesize);
    }

    public Mailmergetemplate withFilesize(Integer filesize) {
        Mailmergetemplate _x = _copy();
        _x.changedFields = changedFields.add("filesize");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.mailmergetemplate");
        _x.filesize = filesize;
        return _x;
    }

    @Property(name="modifiedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedon() {
        return Optional.ofNullable(modifiedon);
    }

    public Mailmergetemplate withModifiedon(OffsetDateTime modifiedon) {
        Mailmergetemplate _x = _copy();
        _x.changedFields = changedFields.add("modifiedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.mailmergetemplate");
        _x.modifiedon = modifiedon;
        return _x;
    }

    @Property(name="mailmergetemplateidunique")
    @JsonIgnore
    public Optional<UUID> getMailmergetemplateidunique() {
        return Optional.ofNullable(mailmergetemplateidunique);
    }

    public Mailmergetemplate withMailmergetemplateidunique(UUID mailmergetemplateidunique) {
        Mailmergetemplate _x = _copy();
        _x.changedFields = changedFields.add("mailmergetemplateidunique");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.mailmergetemplate");
        _x.mailmergetemplateidunique = mailmergetemplateidunique;
        return _x;
    }

    @Property(name="_owningteam_value")
    @JsonIgnore
    public Optional<UUID> get_owningteam_value() {
        return Optional.ofNullable(_owningteam_value);
    }

    public Mailmergetemplate with_owningteam_value(UUID _owningteam_value) {
        Mailmergetemplate _x = _copy();
        _x.changedFields = changedFields.add("_owningteam_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.mailmergetemplate");
        _x._owningteam_value = _owningteam_value;
        return _x;
    }

    @Property(name="statuscode")
    @JsonIgnore
    public Optional<Integer> getStatuscode() {
        return Optional.ofNullable(statuscode);
    }

    public Mailmergetemplate withStatuscode(Integer statuscode) {
        Mailmergetemplate _x = _copy();
        _x.changedFields = changedFields.add("statuscode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.mailmergetemplate");
        _x.statuscode = statuscode;
        return _x;
    }

    @Property(name="versionnumber")
    @JsonIgnore
    public Optional<Long> getVersionnumber() {
        return Optional.ofNullable(versionnumber);
    }

    public Mailmergetemplate withVersionnumber(Long versionnumber) {
        Mailmergetemplate _x = _copy();
        _x.changedFields = changedFields.add("versionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.mailmergetemplate");
        _x.versionnumber = versionnumber;
        return _x;
    }

    @Property(name="mimetype")
    @JsonIgnore
    public Optional<String> getMimetype() {
        return Optional.ofNullable(mimetype);
    }

    public Mailmergetemplate withMimetype(String mimetype) {
        Checks.checkIsAscii(mimetype);
        Mailmergetemplate _x = _copy();
        _x.changedFields = changedFields.add("mimetype");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.mailmergetemplate");
        _x.mimetype = mimetype;
        return _x;
    }

    @Property(name="solutionid")
    @JsonIgnore
    public Optional<UUID> getSolutionid() {
        return Optional.ofNullable(solutionid);
    }

    public Mailmergetemplate withSolutionid(UUID solutionid) {
        Mailmergetemplate _x = _copy();
        _x.changedFields = changedFields.add("solutionid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.mailmergetemplate");
        _x.solutionid = solutionid;
        return _x;
    }

    @Property(name="parameterxml")
    @JsonIgnore
    public Optional<String> getParameterxml() {
        return Optional.ofNullable(parameterxml);
    }

    public Mailmergetemplate withParameterxml(String parameterxml) {
        Checks.checkIsAscii(parameterxml);
        Mailmergetemplate _x = _copy();
        _x.changedFields = changedFields.add("parameterxml");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.mailmergetemplate");
        _x.parameterxml = parameterxml;
        return _x;
    }

    @Property(name="mailmergetype")
    @JsonIgnore
    public Optional<Integer> getMailmergetype() {
        return Optional.ofNullable(mailmergetype);
    }

    public Mailmergetemplate withMailmergetype(Integer mailmergetype) {
        Mailmergetemplate _x = _copy();
        _x.changedFields = changedFields.add("mailmergetype");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.mailmergetemplate");
        _x.mailmergetype = mailmergetype;
        return _x;
    }

    @Property(name="_owninguser_value")
    @JsonIgnore
    public Optional<UUID> get_owninguser_value() {
        return Optional.ofNullable(_owninguser_value);
    }

    public Mailmergetemplate with_owninguser_value(UUID _owninguser_value) {
        Mailmergetemplate _x = _copy();
        _x.changedFields = changedFields.add("_owninguser_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.mailmergetemplate");
        _x._owninguser_value = _owninguser_value;
        return _x;
    }

    @Property(name="_modifiedby_value")
    @JsonIgnore
    public Optional<UUID> get_modifiedby_value() {
        return Optional.ofNullable(_modifiedby_value);
    }

    public Mailmergetemplate with_modifiedby_value(UUID _modifiedby_value) {
        Mailmergetemplate _x = _copy();
        _x.changedFields = changedFields.add("_modifiedby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.mailmergetemplate");
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    @Property(name="_createdonbehalfby_value")
    @JsonIgnore
    public Optional<UUID> get_createdonbehalfby_value() {
        return Optional.ofNullable(_createdonbehalfby_value);
    }

    public Mailmergetemplate with_createdonbehalfby_value(UUID _createdonbehalfby_value) {
        Mailmergetemplate _x = _copy();
        _x.changedFields = changedFields.add("_createdonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.mailmergetemplate");
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        return _x;
    }

    @Property(name="body")
    @JsonIgnore
    public Optional<String> getBody() {
        return Optional.ofNullable(body);
    }

    public Mailmergetemplate withBody(String body) {
        Checks.checkIsAscii(body);
        Mailmergetemplate _x = _copy();
        _x.changedFields = changedFields.add("body");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.mailmergetemplate");
        _x.body = body;
        return _x;
    }

    @Property(name="documentformat")
    @JsonIgnore
    public Optional<Integer> getDocumentformat() {
        return Optional.ofNullable(documentformat);
    }

    public Mailmergetemplate withDocumentformat(Integer documentformat) {
        Mailmergetemplate _x = _copy();
        _x.changedFields = changedFields.add("documentformat");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.mailmergetemplate");
        _x.documentformat = documentformat;
        return _x;
    }

    @Property(name="filename")
    @JsonIgnore
    public Optional<String> getFilename() {
        return Optional.ofNullable(filename);
    }

    public Mailmergetemplate withFilename(String filename) {
        Checks.checkIsAscii(filename);
        Mailmergetemplate _x = _copy();
        _x.changedFields = changedFields.add("filename");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.mailmergetemplate");
        _x.filename = filename;
        return _x;
    }

    @Property(name="overwritetime")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverwritetime() {
        return Optional.ofNullable(overwritetime);
    }

    public Mailmergetemplate withOverwritetime(OffsetDateTime overwritetime) {
        Mailmergetemplate _x = _copy();
        _x.changedFields = changedFields.add("overwritetime");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.mailmergetemplate");
        _x.overwritetime = overwritetime;
        return _x;
    }

    @Property(name="statecode")
    @JsonIgnore
    public Optional<Integer> getStatecode() {
        return Optional.ofNullable(statecode);
    }

    public Mailmergetemplate withStatecode(Integer statecode) {
        Mailmergetemplate _x = _copy();
        _x.changedFields = changedFields.add("statecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.mailmergetemplate");
        _x.statecode = statecode;
        return _x;
    }

    @Property(name="exchangerate")
    @JsonIgnore
    public Optional<BigDecimal> getExchangerate() {
        return Optional.ofNullable(exchangerate);
    }

    public Mailmergetemplate withExchangerate(BigDecimal exchangerate) {
        Mailmergetemplate _x = _copy();
        _x.changedFields = changedFields.add("exchangerate");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.mailmergetemplate");
        _x.exchangerate = exchangerate;
        return _x;
    }

    @Property(name="mailmergetemplateid")
    @JsonIgnore
    public Optional<UUID> getMailmergetemplateid() {
        return Optional.ofNullable(mailmergetemplateid);
    }

    public Mailmergetemplate withMailmergetemplateid(UUID mailmergetemplateid) {
        Mailmergetemplate _x = _copy();
        _x.changedFields = changedFields.add("mailmergetemplateid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.mailmergetemplate");
        _x.mailmergetemplateid = mailmergetemplateid;
        return _x;
    }

    @Property(name="ispersonal")
    @JsonIgnore
    public Optional<Boolean> getIspersonal() {
        return Optional.ofNullable(ispersonal);
    }

    public Mailmergetemplate withIspersonal(Boolean ispersonal) {
        Mailmergetemplate _x = _copy();
        _x.changedFields = changedFields.add("ispersonal");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.mailmergetemplate");
        _x.ispersonal = ispersonal;
        return _x;
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public Mailmergetemplate withDescription(String description) {
        Checks.checkIsAscii(description);
        Mailmergetemplate _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.mailmergetemplate");
        _x.description = description;
        return _x;
    }

    @Property(name="utcconversiontimezonecode")
    @JsonIgnore
    public Optional<Integer> getUtcconversiontimezonecode() {
        return Optional.ofNullable(utcconversiontimezonecode);
    }

    public Mailmergetemplate withUtcconversiontimezonecode(Integer utcconversiontimezonecode) {
        Mailmergetemplate _x = _copy();
        _x.changedFields = changedFields.add("utcconversiontimezonecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.mailmergetemplate");
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        return _x;
    }

    @Property(name="createdon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedon() {
        return Optional.ofNullable(createdon);
    }

    public Mailmergetemplate withCreatedon(OffsetDateTime createdon) {
        Mailmergetemplate _x = _copy();
        _x.changedFields = changedFields.add("createdon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.mailmergetemplate");
        _x.createdon = createdon;
        return _x;
    }

    @Property(name="defaultfilter")
    @JsonIgnore
    public Optional<String> getDefaultfilter() {
        return Optional.ofNullable(defaultfilter);
    }

    public Mailmergetemplate withDefaultfilter(String defaultfilter) {
        Checks.checkIsAscii(defaultfilter);
        Mailmergetemplate _x = _copy();
        _x.changedFields = changedFields.add("defaultfilter");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.mailmergetemplate");
        _x.defaultfilter = defaultfilter;
        return _x;
    }

    @Property(name="_ownerid_value")
    @JsonIgnore
    public Optional<UUID> get_ownerid_value() {
        return Optional.ofNullable(_ownerid_value);
    }

    public Mailmergetemplate with_ownerid_value(UUID _ownerid_value) {
        Mailmergetemplate _x = _copy();
        _x.changedFields = changedFields.add("_ownerid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.mailmergetemplate");
        _x._ownerid_value = _ownerid_value;
        return _x;
    }

    @Property(name="_createdby_value")
    @JsonIgnore
    public Optional<UUID> get_createdby_value() {
        return Optional.ofNullable(_createdby_value);
    }

    public Mailmergetemplate with_createdby_value(UUID _createdby_value) {
        Mailmergetemplate _x = _copy();
        _x.changedFields = changedFields.add("_createdby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.mailmergetemplate");
        _x._createdby_value = _createdby_value;
        return _x;
    }

    @Property(name="templatetypecode")
    @JsonIgnore
    public Optional<String> getTemplatetypecode() {
        return Optional.ofNullable(templatetypecode);
    }

    public Mailmergetemplate withTemplatetypecode(String templatetypecode) {
        Checks.checkIsAscii(templatetypecode);
        Mailmergetemplate _x = _copy();
        _x.changedFields = changedFields.add("templatetypecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.mailmergetemplate");
        _x.templatetypecode = templatetypecode;
        return _x;
    }

    @Property(name="iscustomizable")
    @JsonIgnore
    public Optional<BooleanManagedProperty> getIscustomizable() {
        return Optional.ofNullable(iscustomizable);
    }

    public Mailmergetemplate withIscustomizable(BooleanManagedProperty iscustomizable) {
        Mailmergetemplate _x = _copy();
        _x.changedFields = changedFields.add("iscustomizable");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.mailmergetemplate");
        _x.iscustomizable = iscustomizable;
        return _x;
    }

    public Mailmergetemplate withUnmappedField(String name, String value) {
        Mailmergetemplate _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="transactioncurrencyid")
    @JsonIgnore
    public TransactioncurrencyRequest getTransactioncurrencyid() {
        return new TransactioncurrencyRequest(contextPath.addSegment("transactioncurrencyid"), RequestHelper.getValue(unmappedFields, "transactioncurrencyid"));
    }

    @NavigationProperty(name="ownerid")
    @JsonIgnore
    public PrincipalRequest getOwnerid() {
        return new PrincipalRequest(contextPath.addSegment("ownerid"), RequestHelper.getValue(unmappedFields, "ownerid"));
    }

    @NavigationProperty(name="mailmergetemplate_principalobjectattributeaccess")
    @JsonIgnore
    public PrincipalobjectattributeaccessCollectionRequest getMailmergetemplate_principalobjectattributeaccess() {
        return new PrincipalobjectattributeaccessCollectionRequest(
                        contextPath.addSegment("mailmergetemplate_principalobjectattributeaccess"), RequestHelper.getValue(unmappedFields, "mailmergetemplate_principalobjectattributeaccess"));
    }

    @NavigationProperty(name="MailMergeTemplate_AsyncOperations")
    @JsonIgnore
    public AsyncoperationCollectionRequest getMailMergeTemplate_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("MailMergeTemplate_AsyncOperations"), RequestHelper.getValue(unmappedFields, "MailMergeTemplate_AsyncOperations"));
    }

    @NavigationProperty(name="MailMergeTemplate_ProcessSessions")
    @JsonIgnore
    public ProcesssessionCollectionRequest getMailMergeTemplate_ProcessSessions() {
        return new ProcesssessionCollectionRequest(
                        contextPath.addSegment("MailMergeTemplate_ProcessSessions"), RequestHelper.getValue(unmappedFields, "MailMergeTemplate_ProcessSessions"));
    }

    @NavigationProperty(name="createdonbehalfby")
    @JsonIgnore
    public SystemuserRequest getCreatedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), RequestHelper.getValue(unmappedFields, "createdonbehalfby"));
    }

    @NavigationProperty(name="owningbusinessunit")
    @JsonIgnore
    public BusinessunitRequest getOwningbusinessunit() {
        return new BusinessunitRequest(contextPath.addSegment("owningbusinessunit"), RequestHelper.getValue(unmappedFields, "owningbusinessunit"));
    }

    @NavigationProperty(name="modifiedonbehalfby")
    @JsonIgnore
    public SystemuserRequest getModifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), RequestHelper.getValue(unmappedFields, "modifiedonbehalfby"));
    }

    @NavigationProperty(name="MailMergeTemplate_SyncErrors")
    @JsonIgnore
    public SyncerrorCollectionRequest getMailMergeTemplate_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("MailMergeTemplate_SyncErrors"), RequestHelper.getValue(unmappedFields, "MailMergeTemplate_SyncErrors"));
    }

    @NavigationProperty(name="modifiedby")
    @JsonIgnore
    public SystemuserRequest getModifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), RequestHelper.getValue(unmappedFields, "modifiedby"));
    }

    @NavigationProperty(name="createdby")
    @JsonIgnore
    public SystemuserRequest getCreatedby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), RequestHelper.getValue(unmappedFields, "createdby"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Mailmergetemplate patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Mailmergetemplate _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Mailmergetemplate put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Mailmergetemplate _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Mailmergetemplate _copy() {
        Mailmergetemplate _x = new Mailmergetemplate();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        _x.componentstate = componentstate;
        _x.languagecode = languagecode;
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        _x.name = name;
        _x._owningbusinessunit_value = _owningbusinessunit_value;
        _x.introducedversion = introducedversion;
        _x._transactioncurrencyid_value = _transactioncurrencyid_value;
        _x.ismanaged = ismanaged;
        _x.filesize = filesize;
        _x.modifiedon = modifiedon;
        _x.mailmergetemplateidunique = mailmergetemplateidunique;
        _x._owningteam_value = _owningteam_value;
        _x.statuscode = statuscode;
        _x.versionnumber = versionnumber;
        _x.mimetype = mimetype;
        _x.solutionid = solutionid;
        _x.parameterxml = parameterxml;
        _x.mailmergetype = mailmergetype;
        _x._owninguser_value = _owninguser_value;
        _x._modifiedby_value = _modifiedby_value;
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        _x.body = body;
        _x.documentformat = documentformat;
        _x.filename = filename;
        _x.overwritetime = overwritetime;
        _x.statecode = statecode;
        _x.exchangerate = exchangerate;
        _x.mailmergetemplateid = mailmergetemplateid;
        _x.ispersonal = ispersonal;
        _x.description = description;
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        _x.createdon = createdon;
        _x.defaultfilter = defaultfilter;
        _x._ownerid_value = _ownerid_value;
        _x._createdby_value = _createdby_value;
        _x.templatetypecode = templatetypecode;
        _x.iscustomizable = iscustomizable;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Mailmergetemplate[");
        b.append("timezoneruleversionnumber=");
        b.append(this.timezoneruleversionnumber);
        b.append(", ");
        b.append("componentstate=");
        b.append(this.componentstate);
        b.append(", ");
        b.append("languagecode=");
        b.append(this.languagecode);
        b.append(", ");
        b.append("_modifiedonbehalfby_value=");
        b.append(this._modifiedonbehalfby_value);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("_owningbusinessunit_value=");
        b.append(this._owningbusinessunit_value);
        b.append(", ");
        b.append("introducedversion=");
        b.append(this.introducedversion);
        b.append(", ");
        b.append("_transactioncurrencyid_value=");
        b.append(this._transactioncurrencyid_value);
        b.append(", ");
        b.append("ismanaged=");
        b.append(this.ismanaged);
        b.append(", ");
        b.append("filesize=");
        b.append(this.filesize);
        b.append(", ");
        b.append("modifiedon=");
        b.append(this.modifiedon);
        b.append(", ");
        b.append("mailmergetemplateidunique=");
        b.append(this.mailmergetemplateidunique);
        b.append(", ");
        b.append("_owningteam_value=");
        b.append(this._owningteam_value);
        b.append(", ");
        b.append("statuscode=");
        b.append(this.statuscode);
        b.append(", ");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append(", ");
        b.append("mimetype=");
        b.append(this.mimetype);
        b.append(", ");
        b.append("solutionid=");
        b.append(this.solutionid);
        b.append(", ");
        b.append("parameterxml=");
        b.append(this.parameterxml);
        b.append(", ");
        b.append("mailmergetype=");
        b.append(this.mailmergetype);
        b.append(", ");
        b.append("_owninguser_value=");
        b.append(this._owninguser_value);
        b.append(", ");
        b.append("_modifiedby_value=");
        b.append(this._modifiedby_value);
        b.append(", ");
        b.append("_createdonbehalfby_value=");
        b.append(this._createdonbehalfby_value);
        b.append(", ");
        b.append("body=");
        b.append(this.body);
        b.append(", ");
        b.append("documentformat=");
        b.append(this.documentformat);
        b.append(", ");
        b.append("filename=");
        b.append(this.filename);
        b.append(", ");
        b.append("overwritetime=");
        b.append(this.overwritetime);
        b.append(", ");
        b.append("statecode=");
        b.append(this.statecode);
        b.append(", ");
        b.append("exchangerate=");
        b.append(this.exchangerate);
        b.append(", ");
        b.append("mailmergetemplateid=");
        b.append(this.mailmergetemplateid);
        b.append(", ");
        b.append("ispersonal=");
        b.append(this.ispersonal);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("utcconversiontimezonecode=");
        b.append(this.utcconversiontimezonecode);
        b.append(", ");
        b.append("createdon=");
        b.append(this.createdon);
        b.append(", ");
        b.append("defaultfilter=");
        b.append(this.defaultfilter);
        b.append(", ");
        b.append("_ownerid_value=");
        b.append(this._ownerid_value);
        b.append(", ");
        b.append("_createdby_value=");
        b.append(this._createdby_value);
        b.append(", ");
        b.append("templatetypecode=");
        b.append(this.templatetypecode);
        b.append(", ");
        b.append("iscustomizable=");
        b.append(this.iscustomizable);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
