package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.math.BigDecimal;
import java.time.OffsetDateTime;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.collection.request.ActioncardCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ActivitypartyCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.AnnotationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.BulkdeletefailureCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ConnectionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.DuplicaterecordCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PrincipalobjectattributeaccessCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ProcesssessionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.QueueitemCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SlakpiinstanceCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;
import microsoft.dynamics.crm.entity.request.AccountRequest;
import microsoft.dynamics.crm.entity.request.ActivitypointerRequest;
import microsoft.dynamics.crm.entity.request.BusinessunitRequest;
import microsoft.dynamics.crm.entity.request.ContactRequest;
import microsoft.dynamics.crm.entity.request.KnowledgearticleRequest;
import microsoft.dynamics.crm.entity.request.KnowledgebaserecordRequest;
import microsoft.dynamics.crm.entity.request.PrincipalRequest;
import microsoft.dynamics.crm.entity.request.ProcessstageRequest;
import microsoft.dynamics.crm.entity.request.SlaRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;
import microsoft.dynamics.crm.entity.request.TeamRequest;
import microsoft.dynamics.crm.entity.request.TransactioncurrencyRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "category", 
    "subcategory", 
    "directioncode", 
    "subscriptionid", 
    "importsequencenumber", 
    "overriddencreatedon", 
    "address"})
@JsonInclude(Include.NON_NULL)
public class Letter extends Activitypointer implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.letter";
    }

    @JsonProperty("category")
    protected String category;

    @JsonProperty("subcategory")
    protected String subcategory;

    @JsonProperty("directioncode")
    protected Boolean directioncode;

    @JsonProperty("subscriptionid")
    protected UUID subscriptionid;

    @JsonProperty("importsequencenumber")
    protected Integer importsequencenumber;

    @JsonProperty("overriddencreatedon")
    protected OffsetDateTime overriddencreatedon;

    @JsonProperty("address")
    protected String address;

    protected Letter() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderLetter() {
        return new Builder();
    }

    public static final class Builder {
        private OffsetDateTime lastonholdtime;
        private Integer actualdurationminutes;
        private UUID _owningteam_value;
        private String exchangeitemid;
        private Boolean ismapiprivate;
        private OffsetDateTime createdon;
        private UUID seriesid;
        private Boolean leftvoicemail;
        private OffsetDateTime deliverylastattemptedon;
        private Boolean isbilled;
        private Boolean isworkflowcreated;
        private UUID _sendermailboxid_value;
        private String description;
        private UUID _regardingobjectid_value;
        private Integer onholdtime;
        private UUID _modifiedby_value;
        private Integer community;
        private UUID activityid;
        private OffsetDateTime sortdate;
        private Integer instancetypecode;
        private Integer timezoneruleversionnumber;
        private UUID _createdonbehalfby_value;
        private UUID _transactioncurrencyid_value;
        private Long versionnumber;
        private UUID processid;
        private OffsetDateTime scheduledend;
        private Integer prioritycode;
        private UUID _slaid_value;
        private UUID stageid;
        private OffsetDateTime actualstart;
        private UUID _owningbusinessunit_value;
        private UUID _owninguser_value;
        private Integer utcconversiontimezonecode;
        private String exchangeweblink;
        private Integer scheduleddurationminutes;
        private OffsetDateTime senton;
        private OffsetDateTime scheduledstart;
        private Integer statecode;
        private String subject;
        private OffsetDateTime postponeactivityprocessinguntil;
        private UUID _modifiedonbehalfby_value;
        private BigDecimal exchangerate;
        private Boolean isregularactivity;
        private Integer deliveryprioritycode;
        private String activityadditionalparams;
        private String traversedpath;
        private UUID _createdby_value;
        private String activitytypecode;
        private UUID _ownerid_value;
        private OffsetDateTime modifiedon;
        private UUID _slainvokedid_value;
        private Integer statuscode;
        private OffsetDateTime actualend;
        private String category;
        private String subcategory;
        private Boolean directioncode;
        private UUID subscriptionid;
        private Integer importsequencenumber;
        private OffsetDateTime overriddencreatedon;
        private String address;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder lastonholdtime(OffsetDateTime lastonholdtime) {
            this.lastonholdtime = lastonholdtime;
            this.changedFields = changedFields.add("lastonholdtime");
            return this;
        }

        public Builder actualdurationminutes(Integer actualdurationminutes) {
            this.actualdurationminutes = actualdurationminutes;
            this.changedFields = changedFields.add("actualdurationminutes");
            return this;
        }

        public Builder _owningteam_value(UUID _owningteam_value) {
            this._owningteam_value = _owningteam_value;
            this.changedFields = changedFields.add("_owningteam_value");
            return this;
        }

        public Builder exchangeitemid(String exchangeitemid) {
            this.exchangeitemid = exchangeitemid;
            this.changedFields = changedFields.add("exchangeitemid");
            return this;
        }

        public Builder ismapiprivate(Boolean ismapiprivate) {
            this.ismapiprivate = ismapiprivate;
            this.changedFields = changedFields.add("ismapiprivate");
            return this;
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Builder seriesid(UUID seriesid) {
            this.seriesid = seriesid;
            this.changedFields = changedFields.add("seriesid");
            return this;
        }

        public Builder leftvoicemail(Boolean leftvoicemail) {
            this.leftvoicemail = leftvoicemail;
            this.changedFields = changedFields.add("leftvoicemail");
            return this;
        }

        public Builder deliverylastattemptedon(OffsetDateTime deliverylastattemptedon) {
            this.deliverylastattemptedon = deliverylastattemptedon;
            this.changedFields = changedFields.add("deliverylastattemptedon");
            return this;
        }

        public Builder isbilled(Boolean isbilled) {
            this.isbilled = isbilled;
            this.changedFields = changedFields.add("isbilled");
            return this;
        }

        public Builder isworkflowcreated(Boolean isworkflowcreated) {
            this.isworkflowcreated = isworkflowcreated;
            this.changedFields = changedFields.add("isworkflowcreated");
            return this;
        }

        public Builder _sendermailboxid_value(UUID _sendermailboxid_value) {
            this._sendermailboxid_value = _sendermailboxid_value;
            this.changedFields = changedFields.add("_sendermailboxid_value");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder _regardingobjectid_value(UUID _regardingobjectid_value) {
            this._regardingobjectid_value = _regardingobjectid_value;
            this.changedFields = changedFields.add("_regardingobjectid_value");
            return this;
        }

        public Builder onholdtime(Integer onholdtime) {
            this.onholdtime = onholdtime;
            this.changedFields = changedFields.add("onholdtime");
            return this;
        }

        public Builder _modifiedby_value(UUID _modifiedby_value) {
            this._modifiedby_value = _modifiedby_value;
            this.changedFields = changedFields.add("_modifiedby_value");
            return this;
        }

        public Builder community(Integer community) {
            this.community = community;
            this.changedFields = changedFields.add("community");
            return this;
        }

        public Builder activityid(UUID activityid) {
            this.activityid = activityid;
            this.changedFields = changedFields.add("activityid");
            return this;
        }

        public Builder sortdate(OffsetDateTime sortdate) {
            this.sortdate = sortdate;
            this.changedFields = changedFields.add("sortdate");
            return this;
        }

        public Builder instancetypecode(Integer instancetypecode) {
            this.instancetypecode = instancetypecode;
            this.changedFields = changedFields.add("instancetypecode");
            return this;
        }

        public Builder timezoneruleversionnumber(Integer timezoneruleversionnumber) {
            this.timezoneruleversionnumber = timezoneruleversionnumber;
            this.changedFields = changedFields.add("timezoneruleversionnumber");
            return this;
        }

        public Builder _createdonbehalfby_value(UUID _createdonbehalfby_value) {
            this._createdonbehalfby_value = _createdonbehalfby_value;
            this.changedFields = changedFields.add("_createdonbehalfby_value");
            return this;
        }

        public Builder _transactioncurrencyid_value(UUID _transactioncurrencyid_value) {
            this._transactioncurrencyid_value = _transactioncurrencyid_value;
            this.changedFields = changedFields.add("_transactioncurrencyid_value");
            return this;
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Builder processid(UUID processid) {
            this.processid = processid;
            this.changedFields = changedFields.add("processid");
            return this;
        }

        public Builder scheduledend(OffsetDateTime scheduledend) {
            this.scheduledend = scheduledend;
            this.changedFields = changedFields.add("scheduledend");
            return this;
        }

        public Builder prioritycode(Integer prioritycode) {
            this.prioritycode = prioritycode;
            this.changedFields = changedFields.add("prioritycode");
            return this;
        }

        public Builder _slaid_value(UUID _slaid_value) {
            this._slaid_value = _slaid_value;
            this.changedFields = changedFields.add("_slaid_value");
            return this;
        }

        public Builder stageid(UUID stageid) {
            this.stageid = stageid;
            this.changedFields = changedFields.add("stageid");
            return this;
        }

        public Builder actualstart(OffsetDateTime actualstart) {
            this.actualstart = actualstart;
            this.changedFields = changedFields.add("actualstart");
            return this;
        }

        public Builder _owningbusinessunit_value(UUID _owningbusinessunit_value) {
            this._owningbusinessunit_value = _owningbusinessunit_value;
            this.changedFields = changedFields.add("_owningbusinessunit_value");
            return this;
        }

        public Builder _owninguser_value(UUID _owninguser_value) {
            this._owninguser_value = _owninguser_value;
            this.changedFields = changedFields.add("_owninguser_value");
            return this;
        }

        public Builder utcconversiontimezonecode(Integer utcconversiontimezonecode) {
            this.utcconversiontimezonecode = utcconversiontimezonecode;
            this.changedFields = changedFields.add("utcconversiontimezonecode");
            return this;
        }

        public Builder exchangeweblink(String exchangeweblink) {
            this.exchangeweblink = exchangeweblink;
            this.changedFields = changedFields.add("exchangeweblink");
            return this;
        }

        public Builder scheduleddurationminutes(Integer scheduleddurationminutes) {
            this.scheduleddurationminutes = scheduleddurationminutes;
            this.changedFields = changedFields.add("scheduleddurationminutes");
            return this;
        }

        public Builder senton(OffsetDateTime senton) {
            this.senton = senton;
            this.changedFields = changedFields.add("senton");
            return this;
        }

        public Builder scheduledstart(OffsetDateTime scheduledstart) {
            this.scheduledstart = scheduledstart;
            this.changedFields = changedFields.add("scheduledstart");
            return this;
        }

        public Builder statecode(Integer statecode) {
            this.statecode = statecode;
            this.changedFields = changedFields.add("statecode");
            return this;
        }

        public Builder subject(String subject) {
            this.subject = subject;
            this.changedFields = changedFields.add("subject");
            return this;
        }

        public Builder postponeactivityprocessinguntil(OffsetDateTime postponeactivityprocessinguntil) {
            this.postponeactivityprocessinguntil = postponeactivityprocessinguntil;
            this.changedFields = changedFields.add("postponeactivityprocessinguntil");
            return this;
        }

        public Builder _modifiedonbehalfby_value(UUID _modifiedonbehalfby_value) {
            this._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            this.changedFields = changedFields.add("_modifiedonbehalfby_value");
            return this;
        }

        public Builder exchangerate(BigDecimal exchangerate) {
            this.exchangerate = exchangerate;
            this.changedFields = changedFields.add("exchangerate");
            return this;
        }

        public Builder isregularactivity(Boolean isregularactivity) {
            this.isregularactivity = isregularactivity;
            this.changedFields = changedFields.add("isregularactivity");
            return this;
        }

        public Builder deliveryprioritycode(Integer deliveryprioritycode) {
            this.deliveryprioritycode = deliveryprioritycode;
            this.changedFields = changedFields.add("deliveryprioritycode");
            return this;
        }

        public Builder activityadditionalparams(String activityadditionalparams) {
            this.activityadditionalparams = activityadditionalparams;
            this.changedFields = changedFields.add("activityadditionalparams");
            return this;
        }

        public Builder traversedpath(String traversedpath) {
            this.traversedpath = traversedpath;
            this.changedFields = changedFields.add("traversedpath");
            return this;
        }

        public Builder _createdby_value(UUID _createdby_value) {
            this._createdby_value = _createdby_value;
            this.changedFields = changedFields.add("_createdby_value");
            return this;
        }

        public Builder activitytypecode(String activitytypecode) {
            this.activitytypecode = activitytypecode;
            this.changedFields = changedFields.add("activitytypecode");
            return this;
        }

        public Builder _ownerid_value(UUID _ownerid_value) {
            this._ownerid_value = _ownerid_value;
            this.changedFields = changedFields.add("_ownerid_value");
            return this;
        }

        public Builder modifiedon(OffsetDateTime modifiedon) {
            this.modifiedon = modifiedon;
            this.changedFields = changedFields.add("modifiedon");
            return this;
        }

        public Builder _slainvokedid_value(UUID _slainvokedid_value) {
            this._slainvokedid_value = _slainvokedid_value;
            this.changedFields = changedFields.add("_slainvokedid_value");
            return this;
        }

        public Builder statuscode(Integer statuscode) {
            this.statuscode = statuscode;
            this.changedFields = changedFields.add("statuscode");
            return this;
        }

        public Builder actualend(OffsetDateTime actualend) {
            this.actualend = actualend;
            this.changedFields = changedFields.add("actualend");
            return this;
        }

        public Builder category(String category) {
            this.category = category;
            this.changedFields = changedFields.add("category");
            return this;
        }

        public Builder subcategory(String subcategory) {
            this.subcategory = subcategory;
            this.changedFields = changedFields.add("subcategory");
            return this;
        }

        public Builder directioncode(Boolean directioncode) {
            this.directioncode = directioncode;
            this.changedFields = changedFields.add("directioncode");
            return this;
        }

        public Builder subscriptionid(UUID subscriptionid) {
            this.subscriptionid = subscriptionid;
            this.changedFields = changedFields.add("subscriptionid");
            return this;
        }

        public Builder importsequencenumber(Integer importsequencenumber) {
            this.importsequencenumber = importsequencenumber;
            this.changedFields = changedFields.add("importsequencenumber");
            return this;
        }

        public Builder overriddencreatedon(OffsetDateTime overriddencreatedon) {
            this.overriddencreatedon = overriddencreatedon;
            this.changedFields = changedFields.add("overriddencreatedon");
            return this;
        }

        public Builder address(String address) {
            this.address = address;
            this.changedFields = changedFields.add("address");
            return this;
        }

        public Letter build() {
            Letter _x = new Letter();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.letter";
            _x.lastonholdtime = lastonholdtime;
            _x.actualdurationminutes = actualdurationminutes;
            _x._owningteam_value = _owningteam_value;
            _x.exchangeitemid = exchangeitemid;
            _x.ismapiprivate = ismapiprivate;
            _x.createdon = createdon;
            _x.seriesid = seriesid;
            _x.leftvoicemail = leftvoicemail;
            _x.deliverylastattemptedon = deliverylastattemptedon;
            _x.isbilled = isbilled;
            _x.isworkflowcreated = isworkflowcreated;
            _x._sendermailboxid_value = _sendermailboxid_value;
            _x.description = description;
            _x._regardingobjectid_value = _regardingobjectid_value;
            _x.onholdtime = onholdtime;
            _x._modifiedby_value = _modifiedby_value;
            _x.community = community;
            _x.activityid = activityid;
            _x.sortdate = sortdate;
            _x.instancetypecode = instancetypecode;
            _x.timezoneruleversionnumber = timezoneruleversionnumber;
            _x._createdonbehalfby_value = _createdonbehalfby_value;
            _x._transactioncurrencyid_value = _transactioncurrencyid_value;
            _x.versionnumber = versionnumber;
            _x.processid = processid;
            _x.scheduledend = scheduledend;
            _x.prioritycode = prioritycode;
            _x._slaid_value = _slaid_value;
            _x.stageid = stageid;
            _x.actualstart = actualstart;
            _x._owningbusinessunit_value = _owningbusinessunit_value;
            _x._owninguser_value = _owninguser_value;
            _x.utcconversiontimezonecode = utcconversiontimezonecode;
            _x.exchangeweblink = exchangeweblink;
            _x.scheduleddurationminutes = scheduleddurationminutes;
            _x.senton = senton;
            _x.scheduledstart = scheduledstart;
            _x.statecode = statecode;
            _x.subject = subject;
            _x.postponeactivityprocessinguntil = postponeactivityprocessinguntil;
            _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            _x.exchangerate = exchangerate;
            _x.isregularactivity = isregularactivity;
            _x.deliveryprioritycode = deliveryprioritycode;
            _x.activityadditionalparams = activityadditionalparams;
            _x.traversedpath = traversedpath;
            _x._createdby_value = _createdby_value;
            _x.activitytypecode = activitytypecode;
            _x._ownerid_value = _ownerid_value;
            _x.modifiedon = modifiedon;
            _x._slainvokedid_value = _slainvokedid_value;
            _x.statuscode = statuscode;
            _x.actualend = actualend;
            _x.category = category;
            _x.subcategory = subcategory;
            _x.directioncode = directioncode;
            _x.subscriptionid = subscriptionid;
            _x.importsequencenumber = importsequencenumber;
            _x.overriddencreatedon = overriddencreatedon;
            _x.address = address;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && activityid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(activityid, UUID.class));
        }
    }

    @Property(name="category")
    @JsonIgnore
    public Optional<String> getCategory() {
        return Optional.ofNullable(category);
    }

    public Letter withCategory(String category) {
        Checks.checkIsAscii(category);
        Letter _x = _copy();
        _x.changedFields = changedFields.add("category");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.letter");
        _x.category = category;
        return _x;
    }

    @Property(name="subcategory")
    @JsonIgnore
    public Optional<String> getSubcategory() {
        return Optional.ofNullable(subcategory);
    }

    public Letter withSubcategory(String subcategory) {
        Checks.checkIsAscii(subcategory);
        Letter _x = _copy();
        _x.changedFields = changedFields.add("subcategory");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.letter");
        _x.subcategory = subcategory;
        return _x;
    }

    @Property(name="directioncode")
    @JsonIgnore
    public Optional<Boolean> getDirectioncode() {
        return Optional.ofNullable(directioncode);
    }

    public Letter withDirectioncode(Boolean directioncode) {
        Letter _x = _copy();
        _x.changedFields = changedFields.add("directioncode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.letter");
        _x.directioncode = directioncode;
        return _x;
    }

    @Property(name="subscriptionid")
    @JsonIgnore
    public Optional<UUID> getSubscriptionid() {
        return Optional.ofNullable(subscriptionid);
    }

    public Letter withSubscriptionid(UUID subscriptionid) {
        Letter _x = _copy();
        _x.changedFields = changedFields.add("subscriptionid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.letter");
        _x.subscriptionid = subscriptionid;
        return _x;
    }

    @Property(name="importsequencenumber")
    @JsonIgnore
    public Optional<Integer> getImportsequencenumber() {
        return Optional.ofNullable(importsequencenumber);
    }

    public Letter withImportsequencenumber(Integer importsequencenumber) {
        Letter _x = _copy();
        _x.changedFields = changedFields.add("importsequencenumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.letter");
        _x.importsequencenumber = importsequencenumber;
        return _x;
    }

    @Property(name="overriddencreatedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverriddencreatedon() {
        return Optional.ofNullable(overriddencreatedon);
    }

    public Letter withOverriddencreatedon(OffsetDateTime overriddencreatedon) {
        Letter _x = _copy();
        _x.changedFields = changedFields.add("overriddencreatedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.letter");
        _x.overriddencreatedon = overriddencreatedon;
        return _x;
    }

    @Property(name="address")
    @JsonIgnore
    public Optional<String> getAddress() {
        return Optional.ofNullable(address);
    }

    public Letter withAddress(String address) {
        Checks.checkIsAscii(address);
        Letter _x = _copy();
        _x.changedFields = changedFields.add("address");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.letter");
        _x.address = address;
        return _x;
    }

    public Letter withUnmappedField(String name, String value) {
        Letter _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="regardingobjectid_knowledgebaserecord_letter")
    @JsonIgnore
    public KnowledgebaserecordRequest getRegardingobjectid_knowledgebaserecord_letter() {
        return new KnowledgebaserecordRequest(contextPath.addSegment("regardingobjectid_knowledgebaserecord_letter"), RequestHelper.getValue(unmappedFields, "regardingobjectid_knowledgebaserecord_letter"));
    }

    @NavigationProperty(name="letter_actioncard")
    @JsonIgnore
    public ActioncardCollectionRequest getLetter_actioncard() {
        return new ActioncardCollectionRequest(
                        contextPath.addSegment("letter_actioncard"), RequestHelper.getValue(unmappedFields, "letter_actioncard"));
    }

    @NavigationProperty(name="letter_principalobjectattributeaccess")
    @JsonIgnore
    public PrincipalobjectattributeaccessCollectionRequest getLetter_principalobjectattributeaccess() {
        return new PrincipalobjectattributeaccessCollectionRequest(
                        contextPath.addSegment("letter_principalobjectattributeaccess"), RequestHelper.getValue(unmappedFields, "letter_principalobjectattributeaccess"));
    }

    @NavigationProperty(name="slakpiinstance_letter")
    @JsonIgnore
    public SlakpiinstanceCollectionRequest getSlakpiinstance_letter() {
        return new SlakpiinstanceCollectionRequest(
                        contextPath.addSegment("slakpiinstance_letter"), RequestHelper.getValue(unmappedFields, "slakpiinstance_letter"));
    }

    @NavigationProperty(name="Letter_ProcessSessions")
    @JsonIgnore
    public ProcesssessionCollectionRequest getLetter_ProcessSessions() {
        return new ProcesssessionCollectionRequest(
                        contextPath.addSegment("Letter_ProcessSessions"), RequestHelper.getValue(unmappedFields, "Letter_ProcessSessions"));
    }

    @NavigationProperty(name="stageid_processstage")
    @JsonIgnore
    public ProcessstageRequest getStageid_processstage() {
        return new ProcessstageRequest(contextPath.addSegment("stageid_processstage"), RequestHelper.getValue(unmappedFields, "stageid_processstage"));
    }

    @NavigationProperty(name="modifiedonbehalfby_letter")
    @JsonIgnore
    public SystemuserRequest getModifiedonbehalfby_letter() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby_letter"), RequestHelper.getValue(unmappedFields, "modifiedonbehalfby_letter"));
    }

    @NavigationProperty(name="createdonbehalfby_letter")
    @JsonIgnore
    public SystemuserRequest getCreatedonbehalfby_letter() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby_letter"), RequestHelper.getValue(unmappedFields, "createdonbehalfby_letter"));
    }

    @NavigationProperty(name="letter_connections2")
    @JsonIgnore
    public ConnectionCollectionRequest getLetter_connections2() {
        return new ConnectionCollectionRequest(
                        contextPath.addSegment("letter_connections2"), RequestHelper.getValue(unmappedFields, "letter_connections2"));
    }

    @NavigationProperty(name="Letter_BulkDeleteFailures")
    @JsonIgnore
    public BulkdeletefailureCollectionRequest getLetter_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(
                        contextPath.addSegment("Letter_BulkDeleteFailures"), RequestHelper.getValue(unmappedFields, "Letter_BulkDeleteFailures"));
    }

    @NavigationProperty(name="regardingobjectid_knowledgearticle_letter")
    @JsonIgnore
    public KnowledgearticleRequest getRegardingobjectid_knowledgearticle_letter() {
        return new KnowledgearticleRequest(contextPath.addSegment("regardingobjectid_knowledgearticle_letter"), RequestHelper.getValue(unmappedFields, "regardingobjectid_knowledgearticle_letter"));
    }

    @NavigationProperty(name="Letter_SyncErrors")
    @JsonIgnore
    public SyncerrorCollectionRequest getLetter_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("Letter_SyncErrors"), RequestHelper.getValue(unmappedFields, "Letter_SyncErrors"));
    }

    @NavigationProperty(name="owningbusinessunit_letter")
    @JsonIgnore
    public BusinessunitRequest getOwningbusinessunit_letter() {
        return new BusinessunitRequest(contextPath.addSegment("owningbusinessunit_letter"), RequestHelper.getValue(unmappedFields, "owningbusinessunit_letter"));
    }

    @NavigationProperty(name="Letter_Annotation")
    @JsonIgnore
    public AnnotationCollectionRequest getLetter_Annotation() {
        return new AnnotationCollectionRequest(
                        contextPath.addSegment("Letter_Annotation"), RequestHelper.getValue(unmappedFields, "Letter_Annotation"));
    }

    @NavigationProperty(name="slainvokedid_letter_sla")
    @JsonIgnore
    public SlaRequest getSlainvokedid_letter_sla() {
        return new SlaRequest(contextPath.addSegment("slainvokedid_letter_sla"), RequestHelper.getValue(unmappedFields, "slainvokedid_letter_sla"));
    }

    @NavigationProperty(name="owningteam_letter")
    @JsonIgnore
    public TeamRequest getOwningteam_letter() {
        return new TeamRequest(contextPath.addSegment("owningteam_letter"), RequestHelper.getValue(unmappedFields, "owningteam_letter"));
    }

    @NavigationProperty(name="letter_activity_parties")
    @JsonIgnore
    public ActivitypartyCollectionRequest getLetter_activity_parties() {
        return new ActivitypartyCollectionRequest(
                        contextPath.addSegment("letter_activity_parties"), RequestHelper.getValue(unmappedFields, "letter_activity_parties"));
    }

    @NavigationProperty(name="Letter_AsyncOperations")
    @JsonIgnore
    public AsyncoperationCollectionRequest getLetter_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("Letter_AsyncOperations"), RequestHelper.getValue(unmappedFields, "Letter_AsyncOperations"));
    }

    @NavigationProperty(name="transactioncurrencyid_letter")
    @JsonIgnore
    public TransactioncurrencyRequest getTransactioncurrencyid_letter() {
        return new TransactioncurrencyRequest(contextPath.addSegment("transactioncurrencyid_letter"), RequestHelper.getValue(unmappedFields, "transactioncurrencyid_letter"));
    }

    @NavigationProperty(name="letter_connections1")
    @JsonIgnore
    public ConnectionCollectionRequest getLetter_connections1() {
        return new ConnectionCollectionRequest(
                        contextPath.addSegment("letter_connections1"), RequestHelper.getValue(unmappedFields, "letter_connections1"));
    }

    @NavigationProperty(name="owninguser_letter")
    @JsonIgnore
    public SystemuserRequest getOwninguser_letter() {
        return new SystemuserRequest(contextPath.addSegment("owninguser_letter"), RequestHelper.getValue(unmappedFields, "owninguser_letter"));
    }

    @NavigationProperty(name="Letter_DuplicateBaseRecord")
    @JsonIgnore
    public DuplicaterecordCollectionRequest getLetter_DuplicateBaseRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("Letter_DuplicateBaseRecord"), RequestHelper.getValue(unmappedFields, "Letter_DuplicateBaseRecord"));
    }

    @NavigationProperty(name="Letter_QueueItem")
    @JsonIgnore
    public QueueitemCollectionRequest getLetter_QueueItem() {
        return new QueueitemCollectionRequest(
                        contextPath.addSegment("Letter_QueueItem"), RequestHelper.getValue(unmappedFields, "Letter_QueueItem"));
    }

    @NavigationProperty(name="activityid_activitypointer")
    @JsonIgnore
    public ActivitypointerRequest getActivityid_activitypointer() {
        return new ActivitypointerRequest(contextPath.addSegment("activityid_activitypointer"), RequestHelper.getValue(unmappedFields, "activityid_activitypointer"));
    }

    @NavigationProperty(name="modifiedby_letter")
    @JsonIgnore
    public SystemuserRequest getModifiedby_letter() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby_letter"), RequestHelper.getValue(unmappedFields, "modifiedby_letter"));
    }

    @NavigationProperty(name="sla_letter_sla")
    @JsonIgnore
    public SlaRequest getSla_letter_sla() {
        return new SlaRequest(contextPath.addSegment("sla_letter_sla"), RequestHelper.getValue(unmappedFields, "sla_letter_sla"));
    }

    @NavigationProperty(name="createdby_letter")
    @JsonIgnore
    public SystemuserRequest getCreatedby_letter() {
        return new SystemuserRequest(contextPath.addSegment("createdby_letter"), RequestHelper.getValue(unmappedFields, "createdby_letter"));
    }

    @NavigationProperty(name="Letter_DuplicateMatchingRecord")
    @JsonIgnore
    public DuplicaterecordCollectionRequest getLetter_DuplicateMatchingRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("Letter_DuplicateMatchingRecord"), RequestHelper.getValue(unmappedFields, "Letter_DuplicateMatchingRecord"));
    }

    @NavigationProperty(name="regardingobjectid_account_letter")
    @JsonIgnore
    public AccountRequest getRegardingobjectid_account_letter() {
        return new AccountRequest(contextPath.addSegment("regardingobjectid_account_letter"), RequestHelper.getValue(unmappedFields, "regardingobjectid_account_letter"));
    }

    @NavigationProperty(name="regardingobjectid_contact_letter")
    @JsonIgnore
    public ContactRequest getRegardingobjectid_contact_letter() {
        return new ContactRequest(contextPath.addSegment("regardingobjectid_contact_letter"), RequestHelper.getValue(unmappedFields, "regardingobjectid_contact_letter"));
    }

    @NavigationProperty(name="ownerid_letter")
    @JsonIgnore
    public PrincipalRequest getOwnerid_letter() {
        return new PrincipalRequest(contextPath.addSegment("ownerid_letter"), RequestHelper.getValue(unmappedFields, "ownerid_letter"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Letter patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Letter _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Letter put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Letter _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Letter _copy() {
        Letter _x = new Letter();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.lastonholdtime = lastonholdtime;
        _x.actualdurationminutes = actualdurationminutes;
        _x._owningteam_value = _owningteam_value;
        _x.exchangeitemid = exchangeitemid;
        _x.ismapiprivate = ismapiprivate;
        _x.createdon = createdon;
        _x.seriesid = seriesid;
        _x.leftvoicemail = leftvoicemail;
        _x.deliverylastattemptedon = deliverylastattemptedon;
        _x.isbilled = isbilled;
        _x.isworkflowcreated = isworkflowcreated;
        _x._sendermailboxid_value = _sendermailboxid_value;
        _x.description = description;
        _x._regardingobjectid_value = _regardingobjectid_value;
        _x.onholdtime = onholdtime;
        _x._modifiedby_value = _modifiedby_value;
        _x.community = community;
        _x.activityid = activityid;
        _x.sortdate = sortdate;
        _x.instancetypecode = instancetypecode;
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        _x._transactioncurrencyid_value = _transactioncurrencyid_value;
        _x.versionnumber = versionnumber;
        _x.processid = processid;
        _x.scheduledend = scheduledend;
        _x.prioritycode = prioritycode;
        _x._slaid_value = _slaid_value;
        _x.stageid = stageid;
        _x.actualstart = actualstart;
        _x._owningbusinessunit_value = _owningbusinessunit_value;
        _x._owninguser_value = _owninguser_value;
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        _x.exchangeweblink = exchangeweblink;
        _x.scheduleddurationminutes = scheduleddurationminutes;
        _x.senton = senton;
        _x.scheduledstart = scheduledstart;
        _x.statecode = statecode;
        _x.subject = subject;
        _x.postponeactivityprocessinguntil = postponeactivityprocessinguntil;
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        _x.exchangerate = exchangerate;
        _x.isregularactivity = isregularactivity;
        _x.deliveryprioritycode = deliveryprioritycode;
        _x.activityadditionalparams = activityadditionalparams;
        _x.traversedpath = traversedpath;
        _x._createdby_value = _createdby_value;
        _x.activitytypecode = activitytypecode;
        _x._ownerid_value = _ownerid_value;
        _x.modifiedon = modifiedon;
        _x._slainvokedid_value = _slainvokedid_value;
        _x.statuscode = statuscode;
        _x.actualend = actualend;
        _x.category = category;
        _x.subcategory = subcategory;
        _x.directioncode = directioncode;
        _x.subscriptionid = subscriptionid;
        _x.importsequencenumber = importsequencenumber;
        _x.overriddencreatedon = overriddencreatedon;
        _x.address = address;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Letter[");
        b.append("lastonholdtime=");
        b.append(this.lastonholdtime);
        b.append(", ");
        b.append("actualdurationminutes=");
        b.append(this.actualdurationminutes);
        b.append(", ");
        b.append("_owningteam_value=");
        b.append(this._owningteam_value);
        b.append(", ");
        b.append("exchangeitemid=");
        b.append(this.exchangeitemid);
        b.append(", ");
        b.append("ismapiprivate=");
        b.append(this.ismapiprivate);
        b.append(", ");
        b.append("createdon=");
        b.append(this.createdon);
        b.append(", ");
        b.append("seriesid=");
        b.append(this.seriesid);
        b.append(", ");
        b.append("leftvoicemail=");
        b.append(this.leftvoicemail);
        b.append(", ");
        b.append("deliverylastattemptedon=");
        b.append(this.deliverylastattemptedon);
        b.append(", ");
        b.append("isbilled=");
        b.append(this.isbilled);
        b.append(", ");
        b.append("isworkflowcreated=");
        b.append(this.isworkflowcreated);
        b.append(", ");
        b.append("_sendermailboxid_value=");
        b.append(this._sendermailboxid_value);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("_regardingobjectid_value=");
        b.append(this._regardingobjectid_value);
        b.append(", ");
        b.append("onholdtime=");
        b.append(this.onholdtime);
        b.append(", ");
        b.append("_modifiedby_value=");
        b.append(this._modifiedby_value);
        b.append(", ");
        b.append("community=");
        b.append(this.community);
        b.append(", ");
        b.append("activityid=");
        b.append(this.activityid);
        b.append(", ");
        b.append("sortdate=");
        b.append(this.sortdate);
        b.append(", ");
        b.append("instancetypecode=");
        b.append(this.instancetypecode);
        b.append(", ");
        b.append("timezoneruleversionnumber=");
        b.append(this.timezoneruleversionnumber);
        b.append(", ");
        b.append("_createdonbehalfby_value=");
        b.append(this._createdonbehalfby_value);
        b.append(", ");
        b.append("_transactioncurrencyid_value=");
        b.append(this._transactioncurrencyid_value);
        b.append(", ");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append(", ");
        b.append("processid=");
        b.append(this.processid);
        b.append(", ");
        b.append("scheduledend=");
        b.append(this.scheduledend);
        b.append(", ");
        b.append("prioritycode=");
        b.append(this.prioritycode);
        b.append(", ");
        b.append("_slaid_value=");
        b.append(this._slaid_value);
        b.append(", ");
        b.append("stageid=");
        b.append(this.stageid);
        b.append(", ");
        b.append("actualstart=");
        b.append(this.actualstart);
        b.append(", ");
        b.append("_owningbusinessunit_value=");
        b.append(this._owningbusinessunit_value);
        b.append(", ");
        b.append("_owninguser_value=");
        b.append(this._owninguser_value);
        b.append(", ");
        b.append("utcconversiontimezonecode=");
        b.append(this.utcconversiontimezonecode);
        b.append(", ");
        b.append("exchangeweblink=");
        b.append(this.exchangeweblink);
        b.append(", ");
        b.append("scheduleddurationminutes=");
        b.append(this.scheduleddurationminutes);
        b.append(", ");
        b.append("senton=");
        b.append(this.senton);
        b.append(", ");
        b.append("scheduledstart=");
        b.append(this.scheduledstart);
        b.append(", ");
        b.append("statecode=");
        b.append(this.statecode);
        b.append(", ");
        b.append("subject=");
        b.append(this.subject);
        b.append(", ");
        b.append("postponeactivityprocessinguntil=");
        b.append(this.postponeactivityprocessinguntil);
        b.append(", ");
        b.append("_modifiedonbehalfby_value=");
        b.append(this._modifiedonbehalfby_value);
        b.append(", ");
        b.append("exchangerate=");
        b.append(this.exchangerate);
        b.append(", ");
        b.append("isregularactivity=");
        b.append(this.isregularactivity);
        b.append(", ");
        b.append("deliveryprioritycode=");
        b.append(this.deliveryprioritycode);
        b.append(", ");
        b.append("activityadditionalparams=");
        b.append(this.activityadditionalparams);
        b.append(", ");
        b.append("traversedpath=");
        b.append(this.traversedpath);
        b.append(", ");
        b.append("_createdby_value=");
        b.append(this._createdby_value);
        b.append(", ");
        b.append("activitytypecode=");
        b.append(this.activitytypecode);
        b.append(", ");
        b.append("_ownerid_value=");
        b.append(this._ownerid_value);
        b.append(", ");
        b.append("modifiedon=");
        b.append(this.modifiedon);
        b.append(", ");
        b.append("_slainvokedid_value=");
        b.append(this._slainvokedid_value);
        b.append(", ");
        b.append("statuscode=");
        b.append(this.statuscode);
        b.append(", ");
        b.append("actualend=");
        b.append(this.actualend);
        b.append(", ");
        b.append("category=");
        b.append(this.category);
        b.append(", ");
        b.append("subcategory=");
        b.append(this.subcategory);
        b.append(", ");
        b.append("directioncode=");
        b.append(this.directioncode);
        b.append(", ");
        b.append("subscriptionid=");
        b.append(this.subscriptionid);
        b.append(", ");
        b.append("importsequencenumber=");
        b.append(this.importsequencenumber);
        b.append(", ");
        b.append("overriddencreatedon=");
        b.append(this.overriddencreatedon);
        b.append(", ");
        b.append("address=");
        b.append(this.address);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
