package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.math.BigDecimal;
import java.time.OffsetDateTime;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.collection.request.PrincipalobjectattributeaccessCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;
import microsoft.dynamics.crm.entity.request.KnowledgearticleRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;
import microsoft.dynamics.crm.entity.request.TransactioncurrencyRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "location", 
    "utcconversiontimezonecode", 
    "_modifiedby_value", 
    "timezoneruleversionnumber", 
    "versionnumber", 
    "modifiedon", 
    "owningbusinessunit", 
    "statecode", 
    "knowledgearticleviewsid", 
    "_createdonbehalfby_value", 
    "exchangerate", 
    "statuscode", 
    "owninguser", 
    "viewdate", 
    "knowledgearticleview", 
    "_modifiedonbehalfby_value", 
    "_transactioncurrencyid_value", 
    "importsequencenumber", 
    "createdon", 
    "_createdby_value", 
    "overriddencreatedon", 
    "_ownerid_value", 
    "_knowledgearticleid_value"})
@JsonInclude(Include.NON_NULL)
public class Knowledgearticleviews extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.knowledgearticleviews";
    }

    @JsonProperty("location")
    protected Integer location;

    @JsonProperty("utcconversiontimezonecode")
    protected Integer utcconversiontimezonecode;

    @JsonProperty("_modifiedby_value")
    protected UUID _modifiedby_value;

    @JsonProperty("timezoneruleversionnumber")
    protected Integer timezoneruleversionnumber;

    @JsonProperty("versionnumber")
    protected Long versionnumber;

    @JsonProperty("modifiedon")
    protected OffsetDateTime modifiedon;

    @JsonProperty("owningbusinessunit")
    protected UUID owningbusinessunit;

    @JsonProperty("statecode")
    protected Integer statecode;

    @JsonProperty("knowledgearticleviewsid")
    protected UUID knowledgearticleviewsid;

    @JsonProperty("_createdonbehalfby_value")
    protected UUID _createdonbehalfby_value;

    @JsonProperty("exchangerate")
    protected BigDecimal exchangerate;

    @JsonProperty("statuscode")
    protected Integer statuscode;

    @JsonProperty("owninguser")
    protected UUID owninguser;

    @JsonProperty("viewdate")
    protected OffsetDateTime viewdate;

    @JsonProperty("knowledgearticleview")
    protected Integer knowledgearticleview;

    @JsonProperty("_modifiedonbehalfby_value")
    protected UUID _modifiedonbehalfby_value;

    @JsonProperty("_transactioncurrencyid_value")
    protected UUID _transactioncurrencyid_value;

    @JsonProperty("importsequencenumber")
    protected Integer importsequencenumber;

    @JsonProperty("createdon")
    protected OffsetDateTime createdon;

    @JsonProperty("_createdby_value")
    protected UUID _createdby_value;

    @JsonProperty("overriddencreatedon")
    protected OffsetDateTime overriddencreatedon;

    @JsonProperty("_ownerid_value")
    protected UUID _ownerid_value;

    @JsonProperty("_knowledgearticleid_value")
    protected UUID _knowledgearticleid_value;

    protected Knowledgearticleviews() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderKnowledgearticleviews() {
        return new Builder();
    }

    public static final class Builder {
        private Integer location;
        private Integer utcconversiontimezonecode;
        private UUID _modifiedby_value;
        private Integer timezoneruleversionnumber;
        private Long versionnumber;
        private OffsetDateTime modifiedon;
        private UUID owningbusinessunit;
        private Integer statecode;
        private UUID knowledgearticleviewsid;
        private UUID _createdonbehalfby_value;
        private BigDecimal exchangerate;
        private Integer statuscode;
        private UUID owninguser;
        private OffsetDateTime viewdate;
        private Integer knowledgearticleview;
        private UUID _modifiedonbehalfby_value;
        private UUID _transactioncurrencyid_value;
        private Integer importsequencenumber;
        private OffsetDateTime createdon;
        private UUID _createdby_value;
        private OffsetDateTime overriddencreatedon;
        private UUID _ownerid_value;
        private UUID _knowledgearticleid_value;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder location(Integer location) {
            this.location = location;
            this.changedFields = changedFields.add("location");
            return this;
        }

        public Builder utcconversiontimezonecode(Integer utcconversiontimezonecode) {
            this.utcconversiontimezonecode = utcconversiontimezonecode;
            this.changedFields = changedFields.add("utcconversiontimezonecode");
            return this;
        }

        public Builder _modifiedby_value(UUID _modifiedby_value) {
            this._modifiedby_value = _modifiedby_value;
            this.changedFields = changedFields.add("_modifiedby_value");
            return this;
        }

        public Builder timezoneruleversionnumber(Integer timezoneruleversionnumber) {
            this.timezoneruleversionnumber = timezoneruleversionnumber;
            this.changedFields = changedFields.add("timezoneruleversionnumber");
            return this;
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Builder modifiedon(OffsetDateTime modifiedon) {
            this.modifiedon = modifiedon;
            this.changedFields = changedFields.add("modifiedon");
            return this;
        }

        public Builder owningbusinessunit(UUID owningbusinessunit) {
            this.owningbusinessunit = owningbusinessunit;
            this.changedFields = changedFields.add("owningbusinessunit");
            return this;
        }

        public Builder statecode(Integer statecode) {
            this.statecode = statecode;
            this.changedFields = changedFields.add("statecode");
            return this;
        }

        public Builder knowledgearticleviewsid(UUID knowledgearticleviewsid) {
            this.knowledgearticleviewsid = knowledgearticleviewsid;
            this.changedFields = changedFields.add("knowledgearticleviewsid");
            return this;
        }

        public Builder _createdonbehalfby_value(UUID _createdonbehalfby_value) {
            this._createdonbehalfby_value = _createdonbehalfby_value;
            this.changedFields = changedFields.add("_createdonbehalfby_value");
            return this;
        }

        public Builder exchangerate(BigDecimal exchangerate) {
            this.exchangerate = exchangerate;
            this.changedFields = changedFields.add("exchangerate");
            return this;
        }

        public Builder statuscode(Integer statuscode) {
            this.statuscode = statuscode;
            this.changedFields = changedFields.add("statuscode");
            return this;
        }

        public Builder owninguser(UUID owninguser) {
            this.owninguser = owninguser;
            this.changedFields = changedFields.add("owninguser");
            return this;
        }

        public Builder viewdate(OffsetDateTime viewdate) {
            this.viewdate = viewdate;
            this.changedFields = changedFields.add("viewdate");
            return this;
        }

        public Builder knowledgearticleview(Integer knowledgearticleview) {
            this.knowledgearticleview = knowledgearticleview;
            this.changedFields = changedFields.add("knowledgearticleview");
            return this;
        }

        public Builder _modifiedonbehalfby_value(UUID _modifiedonbehalfby_value) {
            this._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            this.changedFields = changedFields.add("_modifiedonbehalfby_value");
            return this;
        }

        public Builder _transactioncurrencyid_value(UUID _transactioncurrencyid_value) {
            this._transactioncurrencyid_value = _transactioncurrencyid_value;
            this.changedFields = changedFields.add("_transactioncurrencyid_value");
            return this;
        }

        public Builder importsequencenumber(Integer importsequencenumber) {
            this.importsequencenumber = importsequencenumber;
            this.changedFields = changedFields.add("importsequencenumber");
            return this;
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Builder _createdby_value(UUID _createdby_value) {
            this._createdby_value = _createdby_value;
            this.changedFields = changedFields.add("_createdby_value");
            return this;
        }

        public Builder overriddencreatedon(OffsetDateTime overriddencreatedon) {
            this.overriddencreatedon = overriddencreatedon;
            this.changedFields = changedFields.add("overriddencreatedon");
            return this;
        }

        public Builder _ownerid_value(UUID _ownerid_value) {
            this._ownerid_value = _ownerid_value;
            this.changedFields = changedFields.add("_ownerid_value");
            return this;
        }

        public Builder _knowledgearticleid_value(UUID _knowledgearticleid_value) {
            this._knowledgearticleid_value = _knowledgearticleid_value;
            this.changedFields = changedFields.add("_knowledgearticleid_value");
            return this;
        }

        public Knowledgearticleviews build() {
            Knowledgearticleviews _x = new Knowledgearticleviews();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.knowledgearticleviews";
            _x.location = location;
            _x.utcconversiontimezonecode = utcconversiontimezonecode;
            _x._modifiedby_value = _modifiedby_value;
            _x.timezoneruleversionnumber = timezoneruleversionnumber;
            _x.versionnumber = versionnumber;
            _x.modifiedon = modifiedon;
            _x.owningbusinessunit = owningbusinessunit;
            _x.statecode = statecode;
            _x.knowledgearticleviewsid = knowledgearticleviewsid;
            _x._createdonbehalfby_value = _createdonbehalfby_value;
            _x.exchangerate = exchangerate;
            _x.statuscode = statuscode;
            _x.owninguser = owninguser;
            _x.viewdate = viewdate;
            _x.knowledgearticleview = knowledgearticleview;
            _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            _x._transactioncurrencyid_value = _transactioncurrencyid_value;
            _x.importsequencenumber = importsequencenumber;
            _x.createdon = createdon;
            _x._createdby_value = _createdby_value;
            _x.overriddencreatedon = overriddencreatedon;
            _x._ownerid_value = _ownerid_value;
            _x._knowledgearticleid_value = _knowledgearticleid_value;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && knowledgearticleviewsid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(knowledgearticleviewsid, UUID.class));
        }
    }

    @Property(name="location")
    @JsonIgnore
    public Optional<Integer> getLocation() {
        return Optional.ofNullable(location);
    }

    public Knowledgearticleviews withLocation(Integer location) {
        Knowledgearticleviews _x = _copy();
        _x.changedFields = changedFields.add("location");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.knowledgearticleviews");
        _x.location = location;
        return _x;
    }

    @Property(name="utcconversiontimezonecode")
    @JsonIgnore
    public Optional<Integer> getUtcconversiontimezonecode() {
        return Optional.ofNullable(utcconversiontimezonecode);
    }

    public Knowledgearticleviews withUtcconversiontimezonecode(Integer utcconversiontimezonecode) {
        Knowledgearticleviews _x = _copy();
        _x.changedFields = changedFields.add("utcconversiontimezonecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.knowledgearticleviews");
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        return _x;
    }

    @Property(name="_modifiedby_value")
    @JsonIgnore
    public Optional<UUID> get_modifiedby_value() {
        return Optional.ofNullable(_modifiedby_value);
    }

    public Knowledgearticleviews with_modifiedby_value(UUID _modifiedby_value) {
        Knowledgearticleviews _x = _copy();
        _x.changedFields = changedFields.add("_modifiedby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.knowledgearticleviews");
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    @Property(name="timezoneruleversionnumber")
    @JsonIgnore
    public Optional<Integer> getTimezoneruleversionnumber() {
        return Optional.ofNullable(timezoneruleversionnumber);
    }

    public Knowledgearticleviews withTimezoneruleversionnumber(Integer timezoneruleversionnumber) {
        Knowledgearticleviews _x = _copy();
        _x.changedFields = changedFields.add("timezoneruleversionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.knowledgearticleviews");
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        return _x;
    }

    @Property(name="versionnumber")
    @JsonIgnore
    public Optional<Long> getVersionnumber() {
        return Optional.ofNullable(versionnumber);
    }

    public Knowledgearticleviews withVersionnumber(Long versionnumber) {
        Knowledgearticleviews _x = _copy();
        _x.changedFields = changedFields.add("versionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.knowledgearticleviews");
        _x.versionnumber = versionnumber;
        return _x;
    }

    @Property(name="modifiedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedon() {
        return Optional.ofNullable(modifiedon);
    }

    public Knowledgearticleviews withModifiedon(OffsetDateTime modifiedon) {
        Knowledgearticleviews _x = _copy();
        _x.changedFields = changedFields.add("modifiedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.knowledgearticleviews");
        _x.modifiedon = modifiedon;
        return _x;
    }

    @Property(name="owningbusinessunit")
    @JsonIgnore
    public Optional<UUID> getOwningbusinessunit() {
        return Optional.ofNullable(owningbusinessunit);
    }

    public Knowledgearticleviews withOwningbusinessunit(UUID owningbusinessunit) {
        Knowledgearticleviews _x = _copy();
        _x.changedFields = changedFields.add("owningbusinessunit");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.knowledgearticleviews");
        _x.owningbusinessunit = owningbusinessunit;
        return _x;
    }

    @Property(name="statecode")
    @JsonIgnore
    public Optional<Integer> getStatecode() {
        return Optional.ofNullable(statecode);
    }

    public Knowledgearticleviews withStatecode(Integer statecode) {
        Knowledgearticleviews _x = _copy();
        _x.changedFields = changedFields.add("statecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.knowledgearticleviews");
        _x.statecode = statecode;
        return _x;
    }

    @Property(name="knowledgearticleviewsid")
    @JsonIgnore
    public Optional<UUID> getKnowledgearticleviewsid() {
        return Optional.ofNullable(knowledgearticleviewsid);
    }

    public Knowledgearticleviews withKnowledgearticleviewsid(UUID knowledgearticleviewsid) {
        Knowledgearticleviews _x = _copy();
        _x.changedFields = changedFields.add("knowledgearticleviewsid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.knowledgearticleviews");
        _x.knowledgearticleviewsid = knowledgearticleviewsid;
        return _x;
    }

    @Property(name="_createdonbehalfby_value")
    @JsonIgnore
    public Optional<UUID> get_createdonbehalfby_value() {
        return Optional.ofNullable(_createdonbehalfby_value);
    }

    public Knowledgearticleviews with_createdonbehalfby_value(UUID _createdonbehalfby_value) {
        Knowledgearticleviews _x = _copy();
        _x.changedFields = changedFields.add("_createdonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.knowledgearticleviews");
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        return _x;
    }

    @Property(name="exchangerate")
    @JsonIgnore
    public Optional<BigDecimal> getExchangerate() {
        return Optional.ofNullable(exchangerate);
    }

    public Knowledgearticleviews withExchangerate(BigDecimal exchangerate) {
        Knowledgearticleviews _x = _copy();
        _x.changedFields = changedFields.add("exchangerate");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.knowledgearticleviews");
        _x.exchangerate = exchangerate;
        return _x;
    }

    @Property(name="statuscode")
    @JsonIgnore
    public Optional<Integer> getStatuscode() {
        return Optional.ofNullable(statuscode);
    }

    public Knowledgearticleviews withStatuscode(Integer statuscode) {
        Knowledgearticleviews _x = _copy();
        _x.changedFields = changedFields.add("statuscode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.knowledgearticleviews");
        _x.statuscode = statuscode;
        return _x;
    }

    @Property(name="owninguser")
    @JsonIgnore
    public Optional<UUID> getOwninguser() {
        return Optional.ofNullable(owninguser);
    }

    public Knowledgearticleviews withOwninguser(UUID owninguser) {
        Knowledgearticleviews _x = _copy();
        _x.changedFields = changedFields.add("owninguser");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.knowledgearticleviews");
        _x.owninguser = owninguser;
        return _x;
    }

    @Property(name="viewdate")
    @JsonIgnore
    public Optional<OffsetDateTime> getViewdate() {
        return Optional.ofNullable(viewdate);
    }

    public Knowledgearticleviews withViewdate(OffsetDateTime viewdate) {
        Knowledgearticleviews _x = _copy();
        _x.changedFields = changedFields.add("viewdate");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.knowledgearticleviews");
        _x.viewdate = viewdate;
        return _x;
    }

    @Property(name="knowledgearticleview")
    @JsonIgnore
    public Optional<Integer> getKnowledgearticleview() {
        return Optional.ofNullable(knowledgearticleview);
    }

    public Knowledgearticleviews withKnowledgearticleview(Integer knowledgearticleview) {
        Knowledgearticleviews _x = _copy();
        _x.changedFields = changedFields.add("knowledgearticleview");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.knowledgearticleviews");
        _x.knowledgearticleview = knowledgearticleview;
        return _x;
    }

    @Property(name="_modifiedonbehalfby_value")
    @JsonIgnore
    public Optional<UUID> get_modifiedonbehalfby_value() {
        return Optional.ofNullable(_modifiedonbehalfby_value);
    }

    public Knowledgearticleviews with_modifiedonbehalfby_value(UUID _modifiedonbehalfby_value) {
        Knowledgearticleviews _x = _copy();
        _x.changedFields = changedFields.add("_modifiedonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.knowledgearticleviews");
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        return _x;
    }

    @Property(name="_transactioncurrencyid_value")
    @JsonIgnore
    public Optional<UUID> get_transactioncurrencyid_value() {
        return Optional.ofNullable(_transactioncurrencyid_value);
    }

    public Knowledgearticleviews with_transactioncurrencyid_value(UUID _transactioncurrencyid_value) {
        Knowledgearticleviews _x = _copy();
        _x.changedFields = changedFields.add("_transactioncurrencyid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.knowledgearticleviews");
        _x._transactioncurrencyid_value = _transactioncurrencyid_value;
        return _x;
    }

    @Property(name="importsequencenumber")
    @JsonIgnore
    public Optional<Integer> getImportsequencenumber() {
        return Optional.ofNullable(importsequencenumber);
    }

    public Knowledgearticleviews withImportsequencenumber(Integer importsequencenumber) {
        Knowledgearticleviews _x = _copy();
        _x.changedFields = changedFields.add("importsequencenumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.knowledgearticleviews");
        _x.importsequencenumber = importsequencenumber;
        return _x;
    }

    @Property(name="createdon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedon() {
        return Optional.ofNullable(createdon);
    }

    public Knowledgearticleviews withCreatedon(OffsetDateTime createdon) {
        Knowledgearticleviews _x = _copy();
        _x.changedFields = changedFields.add("createdon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.knowledgearticleviews");
        _x.createdon = createdon;
        return _x;
    }

    @Property(name="_createdby_value")
    @JsonIgnore
    public Optional<UUID> get_createdby_value() {
        return Optional.ofNullable(_createdby_value);
    }

    public Knowledgearticleviews with_createdby_value(UUID _createdby_value) {
        Knowledgearticleviews _x = _copy();
        _x.changedFields = changedFields.add("_createdby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.knowledgearticleviews");
        _x._createdby_value = _createdby_value;
        return _x;
    }

    @Property(name="overriddencreatedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverriddencreatedon() {
        return Optional.ofNullable(overriddencreatedon);
    }

    public Knowledgearticleviews withOverriddencreatedon(OffsetDateTime overriddencreatedon) {
        Knowledgearticleviews _x = _copy();
        _x.changedFields = changedFields.add("overriddencreatedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.knowledgearticleviews");
        _x.overriddencreatedon = overriddencreatedon;
        return _x;
    }

    @Property(name="_ownerid_value")
    @JsonIgnore
    public Optional<UUID> get_ownerid_value() {
        return Optional.ofNullable(_ownerid_value);
    }

    public Knowledgearticleviews with_ownerid_value(UUID _ownerid_value) {
        Knowledgearticleviews _x = _copy();
        _x.changedFields = changedFields.add("_ownerid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.knowledgearticleviews");
        _x._ownerid_value = _ownerid_value;
        return _x;
    }

    @Property(name="_knowledgearticleid_value")
    @JsonIgnore
    public Optional<UUID> get_knowledgearticleid_value() {
        return Optional.ofNullable(_knowledgearticleid_value);
    }

    public Knowledgearticleviews with_knowledgearticleid_value(UUID _knowledgearticleid_value) {
        Knowledgearticleviews _x = _copy();
        _x.changedFields = changedFields.add("_knowledgearticleid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.knowledgearticleviews");
        _x._knowledgearticleid_value = _knowledgearticleid_value;
        return _x;
    }

    public Knowledgearticleviews withUnmappedField(String name, String value) {
        Knowledgearticleviews _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="KnowledgeArticleViews_SyncErrors")
    @JsonIgnore
    public SyncerrorCollectionRequest getKnowledgeArticleViews_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("KnowledgeArticleViews_SyncErrors"), RequestHelper.getValue(unmappedFields, "KnowledgeArticleViews_SyncErrors"));
    }

    @NavigationProperty(name="createdonbehalfby")
    @JsonIgnore
    public SystemuserRequest getCreatedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), RequestHelper.getValue(unmappedFields, "createdonbehalfby"));
    }

    @NavigationProperty(name="modifiedonbehalfby")
    @JsonIgnore
    public SystemuserRequest getModifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), RequestHelper.getValue(unmappedFields, "modifiedonbehalfby"));
    }

    @NavigationProperty(name="transactioncurrencyid")
    @JsonIgnore
    public TransactioncurrencyRequest getTransactioncurrencyid() {
        return new TransactioncurrencyRequest(contextPath.addSegment("transactioncurrencyid"), RequestHelper.getValue(unmappedFields, "transactioncurrencyid"));
    }

    @NavigationProperty(name="modifiedby")
    @JsonIgnore
    public SystemuserRequest getModifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), RequestHelper.getValue(unmappedFields, "modifiedby"));
    }

    @NavigationProperty(name="knowledgearticleid")
    @JsonIgnore
    public KnowledgearticleRequest getKnowledgearticleid() {
        return new KnowledgearticleRequest(contextPath.addSegment("knowledgearticleid"), RequestHelper.getValue(unmappedFields, "knowledgearticleid"));
    }

    @NavigationProperty(name="createdby")
    @JsonIgnore
    public SystemuserRequest getCreatedby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), RequestHelper.getValue(unmappedFields, "createdby"));
    }

    @NavigationProperty(name="knowledgearticleviews_principalobjectattributeaccess")
    @JsonIgnore
    public PrincipalobjectattributeaccessCollectionRequest getKnowledgearticleviews_principalobjectattributeaccess() {
        return new PrincipalobjectattributeaccessCollectionRequest(
                        contextPath.addSegment("knowledgearticleviews_principalobjectattributeaccess"), RequestHelper.getValue(unmappedFields, "knowledgearticleviews_principalobjectattributeaccess"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Knowledgearticleviews patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Knowledgearticleviews _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Knowledgearticleviews put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Knowledgearticleviews _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Knowledgearticleviews _copy() {
        Knowledgearticleviews _x = new Knowledgearticleviews();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.location = location;
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        _x._modifiedby_value = _modifiedby_value;
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        _x.versionnumber = versionnumber;
        _x.modifiedon = modifiedon;
        _x.owningbusinessunit = owningbusinessunit;
        _x.statecode = statecode;
        _x.knowledgearticleviewsid = knowledgearticleviewsid;
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        _x.exchangerate = exchangerate;
        _x.statuscode = statuscode;
        _x.owninguser = owninguser;
        _x.viewdate = viewdate;
        _x.knowledgearticleview = knowledgearticleview;
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        _x._transactioncurrencyid_value = _transactioncurrencyid_value;
        _x.importsequencenumber = importsequencenumber;
        _x.createdon = createdon;
        _x._createdby_value = _createdby_value;
        _x.overriddencreatedon = overriddencreatedon;
        _x._ownerid_value = _ownerid_value;
        _x._knowledgearticleid_value = _knowledgearticleid_value;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Knowledgearticleviews[");
        b.append("location=");
        b.append(this.location);
        b.append(", ");
        b.append("utcconversiontimezonecode=");
        b.append(this.utcconversiontimezonecode);
        b.append(", ");
        b.append("_modifiedby_value=");
        b.append(this._modifiedby_value);
        b.append(", ");
        b.append("timezoneruleversionnumber=");
        b.append(this.timezoneruleversionnumber);
        b.append(", ");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append(", ");
        b.append("modifiedon=");
        b.append(this.modifiedon);
        b.append(", ");
        b.append("owningbusinessunit=");
        b.append(this.owningbusinessunit);
        b.append(", ");
        b.append("statecode=");
        b.append(this.statecode);
        b.append(", ");
        b.append("knowledgearticleviewsid=");
        b.append(this.knowledgearticleviewsid);
        b.append(", ");
        b.append("_createdonbehalfby_value=");
        b.append(this._createdonbehalfby_value);
        b.append(", ");
        b.append("exchangerate=");
        b.append(this.exchangerate);
        b.append(", ");
        b.append("statuscode=");
        b.append(this.statuscode);
        b.append(", ");
        b.append("owninguser=");
        b.append(this.owninguser);
        b.append(", ");
        b.append("viewdate=");
        b.append(this.viewdate);
        b.append(", ");
        b.append("knowledgearticleview=");
        b.append(this.knowledgearticleview);
        b.append(", ");
        b.append("_modifiedonbehalfby_value=");
        b.append(this._modifiedonbehalfby_value);
        b.append(", ");
        b.append("_transactioncurrencyid_value=");
        b.append(this._transactioncurrencyid_value);
        b.append(", ");
        b.append("importsequencenumber=");
        b.append(this.importsequencenumber);
        b.append(", ");
        b.append("createdon=");
        b.append(this.createdon);
        b.append(", ");
        b.append("_createdby_value=");
        b.append(this._createdby_value);
        b.append(", ");
        b.append("overriddencreatedon=");
        b.append(this.overriddencreatedon);
        b.append(", ");
        b.append("_ownerid_value=");
        b.append(this._ownerid_value);
        b.append(", ");
        b.append("_knowledgearticleid_value=");
        b.append(this._knowledgearticleid_value);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
