package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.math.BigDecimal;
import java.time.OffsetDateTime;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.collection.request.AnnotationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.BulkdeletefailureCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.DuplicaterecordCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.KbarticlecommentCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PrincipalobjectattributeaccessCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ProcesssessionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SharepointdocumentlocationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;
import microsoft.dynamics.crm.entity.request.KbarticletemplateRequest;
import microsoft.dynamics.crm.entity.request.OrganizationRequest;
import microsoft.dynamics.crm.entity.request.SubjectRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;
import microsoft.dynamics.crm.entity.request.TransactioncurrencyRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "articlexml", 
    "_createdby_value", 
    "languagecode", 
    "versionnumber", 
    "content", 
    "_createdonbehalfby_value", 
    "kbarticleid", 
    "entityimage", 
    "createdon", 
    "title", 
    "_modifiedonbehalfby_value", 
    "exchangerate", 
    "statuscode", 
    "_modifiedby_value", 
    "importsequencenumber", 
    "overriddencreatedon", 
    "keywords", 
    "_organizationid_value", 
    "entityimage_timestamp", 
    "entityimageid", 
    "number", 
    "_subjectid_value", 
    "statecode", 
    "_transactioncurrencyid_value", 
    "description", 
    "_kbarticletemplateid_value", 
    "comments", 
    "modifiedon", 
    "entityimage_url"})
@JsonInclude(Include.NON_NULL)
public class Kbarticle extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.kbarticle";
    }

    @JsonProperty("articlexml")
    protected String articlexml;

    @JsonProperty("_createdby_value")
    protected UUID _createdby_value;

    @JsonProperty("languagecode")
    protected Integer languagecode;

    @JsonProperty("versionnumber")
    protected Long versionnumber;

    @JsonProperty("content")
    protected String content;

    @JsonProperty("_createdonbehalfby_value")
    protected UUID _createdonbehalfby_value;

    @JsonProperty("kbarticleid")
    protected UUID kbarticleid;

    @JsonProperty("entityimage")
    protected byte[] entityimage;

    @JsonProperty("createdon")
    protected OffsetDateTime createdon;

    @JsonProperty("title")
    protected String title;

    @JsonProperty("_modifiedonbehalfby_value")
    protected UUID _modifiedonbehalfby_value;

    @JsonProperty("exchangerate")
    protected BigDecimal exchangerate;

    @JsonProperty("statuscode")
    protected Integer statuscode;

    @JsonProperty("_modifiedby_value")
    protected UUID _modifiedby_value;

    @JsonProperty("importsequencenumber")
    protected Integer importsequencenumber;

    @JsonProperty("overriddencreatedon")
    protected OffsetDateTime overriddencreatedon;

    @JsonProperty("keywords")
    protected String keywords;

    @JsonProperty("_organizationid_value")
    protected UUID _organizationid_value;

    @JsonProperty("entityimage_timestamp")
    protected Long entityimage_timestamp;

    @JsonProperty("entityimageid")
    protected UUID entityimageid;

    @JsonProperty("number")
    protected String number;

    @JsonProperty("_subjectid_value")
    protected UUID _subjectid_value;

    @JsonProperty("statecode")
    protected Integer statecode;

    @JsonProperty("_transactioncurrencyid_value")
    protected UUID _transactioncurrencyid_value;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("_kbarticletemplateid_value")
    protected UUID _kbarticletemplateid_value;

    @JsonProperty("comments")
    protected String comments;

    @JsonProperty("modifiedon")
    protected OffsetDateTime modifiedon;

    @JsonProperty("entityimage_url")
    protected String entityimage_url;

    protected Kbarticle() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderKbarticle() {
        return new Builder();
    }

    public static final class Builder {
        private String articlexml;
        private UUID _createdby_value;
        private Integer languagecode;
        private Long versionnumber;
        private String content;
        private UUID _createdonbehalfby_value;
        private UUID kbarticleid;
        private byte[] entityimage;
        private OffsetDateTime createdon;
        private String title;
        private UUID _modifiedonbehalfby_value;
        private BigDecimal exchangerate;
        private Integer statuscode;
        private UUID _modifiedby_value;
        private Integer importsequencenumber;
        private OffsetDateTime overriddencreatedon;
        private String keywords;
        private UUID _organizationid_value;
        private Long entityimage_timestamp;
        private UUID entityimageid;
        private String number;
        private UUID _subjectid_value;
        private Integer statecode;
        private UUID _transactioncurrencyid_value;
        private String description;
        private UUID _kbarticletemplateid_value;
        private String comments;
        private OffsetDateTime modifiedon;
        private String entityimage_url;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder articlexml(String articlexml) {
            this.articlexml = articlexml;
            this.changedFields = changedFields.add("articlexml");
            return this;
        }

        public Builder _createdby_value(UUID _createdby_value) {
            this._createdby_value = _createdby_value;
            this.changedFields = changedFields.add("_createdby_value");
            return this;
        }

        public Builder languagecode(Integer languagecode) {
            this.languagecode = languagecode;
            this.changedFields = changedFields.add("languagecode");
            return this;
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Builder content(String content) {
            this.content = content;
            this.changedFields = changedFields.add("content");
            return this;
        }

        public Builder _createdonbehalfby_value(UUID _createdonbehalfby_value) {
            this._createdonbehalfby_value = _createdonbehalfby_value;
            this.changedFields = changedFields.add("_createdonbehalfby_value");
            return this;
        }

        public Builder kbarticleid(UUID kbarticleid) {
            this.kbarticleid = kbarticleid;
            this.changedFields = changedFields.add("kbarticleid");
            return this;
        }

        public Builder entityimage(byte[] entityimage) {
            this.entityimage = entityimage;
            this.changedFields = changedFields.add("entityimage");
            return this;
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Builder title(String title) {
            this.title = title;
            this.changedFields = changedFields.add("title");
            return this;
        }

        public Builder _modifiedonbehalfby_value(UUID _modifiedonbehalfby_value) {
            this._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            this.changedFields = changedFields.add("_modifiedonbehalfby_value");
            return this;
        }

        public Builder exchangerate(BigDecimal exchangerate) {
            this.exchangerate = exchangerate;
            this.changedFields = changedFields.add("exchangerate");
            return this;
        }

        public Builder statuscode(Integer statuscode) {
            this.statuscode = statuscode;
            this.changedFields = changedFields.add("statuscode");
            return this;
        }

        public Builder _modifiedby_value(UUID _modifiedby_value) {
            this._modifiedby_value = _modifiedby_value;
            this.changedFields = changedFields.add("_modifiedby_value");
            return this;
        }

        public Builder importsequencenumber(Integer importsequencenumber) {
            this.importsequencenumber = importsequencenumber;
            this.changedFields = changedFields.add("importsequencenumber");
            return this;
        }

        public Builder overriddencreatedon(OffsetDateTime overriddencreatedon) {
            this.overriddencreatedon = overriddencreatedon;
            this.changedFields = changedFields.add("overriddencreatedon");
            return this;
        }

        public Builder keywords(String keywords) {
            this.keywords = keywords;
            this.changedFields = changedFields.add("keywords");
            return this;
        }

        public Builder _organizationid_value(UUID _organizationid_value) {
            this._organizationid_value = _organizationid_value;
            this.changedFields = changedFields.add("_organizationid_value");
            return this;
        }

        public Builder entityimage_timestamp(Long entityimage_timestamp) {
            this.entityimage_timestamp = entityimage_timestamp;
            this.changedFields = changedFields.add("entityimage_timestamp");
            return this;
        }

        public Builder entityimageid(UUID entityimageid) {
            this.entityimageid = entityimageid;
            this.changedFields = changedFields.add("entityimageid");
            return this;
        }

        public Builder number(String number) {
            this.number = number;
            this.changedFields = changedFields.add("number");
            return this;
        }

        public Builder _subjectid_value(UUID _subjectid_value) {
            this._subjectid_value = _subjectid_value;
            this.changedFields = changedFields.add("_subjectid_value");
            return this;
        }

        public Builder statecode(Integer statecode) {
            this.statecode = statecode;
            this.changedFields = changedFields.add("statecode");
            return this;
        }

        public Builder _transactioncurrencyid_value(UUID _transactioncurrencyid_value) {
            this._transactioncurrencyid_value = _transactioncurrencyid_value;
            this.changedFields = changedFields.add("_transactioncurrencyid_value");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder _kbarticletemplateid_value(UUID _kbarticletemplateid_value) {
            this._kbarticletemplateid_value = _kbarticletemplateid_value;
            this.changedFields = changedFields.add("_kbarticletemplateid_value");
            return this;
        }

        public Builder comments(String comments) {
            this.comments = comments;
            this.changedFields = changedFields.add("comments");
            return this;
        }

        public Builder modifiedon(OffsetDateTime modifiedon) {
            this.modifiedon = modifiedon;
            this.changedFields = changedFields.add("modifiedon");
            return this;
        }

        public Builder entityimage_url(String entityimage_url) {
            this.entityimage_url = entityimage_url;
            this.changedFields = changedFields.add("entityimage_url");
            return this;
        }

        public Kbarticle build() {
            Kbarticle _x = new Kbarticle();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.kbarticle";
            _x.articlexml = articlexml;
            _x._createdby_value = _createdby_value;
            _x.languagecode = languagecode;
            _x.versionnumber = versionnumber;
            _x.content = content;
            _x._createdonbehalfby_value = _createdonbehalfby_value;
            _x.kbarticleid = kbarticleid;
            _x.entityimage = entityimage;
            _x.createdon = createdon;
            _x.title = title;
            _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            _x.exchangerate = exchangerate;
            _x.statuscode = statuscode;
            _x._modifiedby_value = _modifiedby_value;
            _x.importsequencenumber = importsequencenumber;
            _x.overriddencreatedon = overriddencreatedon;
            _x.keywords = keywords;
            _x._organizationid_value = _organizationid_value;
            _x.entityimage_timestamp = entityimage_timestamp;
            _x.entityimageid = entityimageid;
            _x.number = number;
            _x._subjectid_value = _subjectid_value;
            _x.statecode = statecode;
            _x._transactioncurrencyid_value = _transactioncurrencyid_value;
            _x.description = description;
            _x._kbarticletemplateid_value = _kbarticletemplateid_value;
            _x.comments = comments;
            _x.modifiedon = modifiedon;
            _x.entityimage_url = entityimage_url;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && kbarticleid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(kbarticleid, UUID.class));
        }
    }

    @Property(name="articlexml")
    @JsonIgnore
    public Optional<String> getArticlexml() {
        return Optional.ofNullable(articlexml);
    }

    public Kbarticle withArticlexml(String articlexml) {
        Checks.checkIsAscii(articlexml);
        Kbarticle _x = _copy();
        _x.changedFields = changedFields.add("articlexml");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.kbarticle");
        _x.articlexml = articlexml;
        return _x;
    }

    @Property(name="_createdby_value")
    @JsonIgnore
    public Optional<UUID> get_createdby_value() {
        return Optional.ofNullable(_createdby_value);
    }

    public Kbarticle with_createdby_value(UUID _createdby_value) {
        Kbarticle _x = _copy();
        _x.changedFields = changedFields.add("_createdby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.kbarticle");
        _x._createdby_value = _createdby_value;
        return _x;
    }

    @Property(name="languagecode")
    @JsonIgnore
    public Optional<Integer> getLanguagecode() {
        return Optional.ofNullable(languagecode);
    }

    public Kbarticle withLanguagecode(Integer languagecode) {
        Kbarticle _x = _copy();
        _x.changedFields = changedFields.add("languagecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.kbarticle");
        _x.languagecode = languagecode;
        return _x;
    }

    @Property(name="versionnumber")
    @JsonIgnore
    public Optional<Long> getVersionnumber() {
        return Optional.ofNullable(versionnumber);
    }

    public Kbarticle withVersionnumber(Long versionnumber) {
        Kbarticle _x = _copy();
        _x.changedFields = changedFields.add("versionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.kbarticle");
        _x.versionnumber = versionnumber;
        return _x;
    }

    @Property(name="content")
    @JsonIgnore
    public Optional<String> getContent() {
        return Optional.ofNullable(content);
    }

    public Kbarticle withContent(String content) {
        Checks.checkIsAscii(content);
        Kbarticle _x = _copy();
        _x.changedFields = changedFields.add("content");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.kbarticle");
        _x.content = content;
        return _x;
    }

    @Property(name="_createdonbehalfby_value")
    @JsonIgnore
    public Optional<UUID> get_createdonbehalfby_value() {
        return Optional.ofNullable(_createdonbehalfby_value);
    }

    public Kbarticle with_createdonbehalfby_value(UUID _createdonbehalfby_value) {
        Kbarticle _x = _copy();
        _x.changedFields = changedFields.add("_createdonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.kbarticle");
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        return _x;
    }

    @Property(name="kbarticleid")
    @JsonIgnore
    public Optional<UUID> getKbarticleid() {
        return Optional.ofNullable(kbarticleid);
    }

    public Kbarticle withKbarticleid(UUID kbarticleid) {
        Kbarticle _x = _copy();
        _x.changedFields = changedFields.add("kbarticleid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.kbarticle");
        _x.kbarticleid = kbarticleid;
        return _x;
    }

    @Property(name="entityimage")
    @JsonIgnore
    public Optional<byte[]> getEntityimage() {
        return Optional.ofNullable(entityimage);
    }

    public Kbarticle withEntityimage(byte[] entityimage) {
        Kbarticle _x = _copy();
        _x.changedFields = changedFields.add("entityimage");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.kbarticle");
        _x.entityimage = entityimage;
        return _x;
    }

    @Property(name="createdon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedon() {
        return Optional.ofNullable(createdon);
    }

    public Kbarticle withCreatedon(OffsetDateTime createdon) {
        Kbarticle _x = _copy();
        _x.changedFields = changedFields.add("createdon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.kbarticle");
        _x.createdon = createdon;
        return _x;
    }

    @Property(name="title")
    @JsonIgnore
    public Optional<String> getTitle() {
        return Optional.ofNullable(title);
    }

    public Kbarticle withTitle(String title) {
        Checks.checkIsAscii(title);
        Kbarticle _x = _copy();
        _x.changedFields = changedFields.add("title");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.kbarticle");
        _x.title = title;
        return _x;
    }

    @Property(name="_modifiedonbehalfby_value")
    @JsonIgnore
    public Optional<UUID> get_modifiedonbehalfby_value() {
        return Optional.ofNullable(_modifiedonbehalfby_value);
    }

    public Kbarticle with_modifiedonbehalfby_value(UUID _modifiedonbehalfby_value) {
        Kbarticle _x = _copy();
        _x.changedFields = changedFields.add("_modifiedonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.kbarticle");
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        return _x;
    }

    @Property(name="exchangerate")
    @JsonIgnore
    public Optional<BigDecimal> getExchangerate() {
        return Optional.ofNullable(exchangerate);
    }

    public Kbarticle withExchangerate(BigDecimal exchangerate) {
        Kbarticle _x = _copy();
        _x.changedFields = changedFields.add("exchangerate");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.kbarticle");
        _x.exchangerate = exchangerate;
        return _x;
    }

    @Property(name="statuscode")
    @JsonIgnore
    public Optional<Integer> getStatuscode() {
        return Optional.ofNullable(statuscode);
    }

    public Kbarticle withStatuscode(Integer statuscode) {
        Kbarticle _x = _copy();
        _x.changedFields = changedFields.add("statuscode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.kbarticle");
        _x.statuscode = statuscode;
        return _x;
    }

    @Property(name="_modifiedby_value")
    @JsonIgnore
    public Optional<UUID> get_modifiedby_value() {
        return Optional.ofNullable(_modifiedby_value);
    }

    public Kbarticle with_modifiedby_value(UUID _modifiedby_value) {
        Kbarticle _x = _copy();
        _x.changedFields = changedFields.add("_modifiedby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.kbarticle");
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    @Property(name="importsequencenumber")
    @JsonIgnore
    public Optional<Integer> getImportsequencenumber() {
        return Optional.ofNullable(importsequencenumber);
    }

    public Kbarticle withImportsequencenumber(Integer importsequencenumber) {
        Kbarticle _x = _copy();
        _x.changedFields = changedFields.add("importsequencenumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.kbarticle");
        _x.importsequencenumber = importsequencenumber;
        return _x;
    }

    @Property(name="overriddencreatedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverriddencreatedon() {
        return Optional.ofNullable(overriddencreatedon);
    }

    public Kbarticle withOverriddencreatedon(OffsetDateTime overriddencreatedon) {
        Kbarticle _x = _copy();
        _x.changedFields = changedFields.add("overriddencreatedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.kbarticle");
        _x.overriddencreatedon = overriddencreatedon;
        return _x;
    }

    @Property(name="keywords")
    @JsonIgnore
    public Optional<String> getKeywords() {
        return Optional.ofNullable(keywords);
    }

    public Kbarticle withKeywords(String keywords) {
        Checks.checkIsAscii(keywords);
        Kbarticle _x = _copy();
        _x.changedFields = changedFields.add("keywords");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.kbarticle");
        _x.keywords = keywords;
        return _x;
    }

    @Property(name="_organizationid_value")
    @JsonIgnore
    public Optional<UUID> get_organizationid_value() {
        return Optional.ofNullable(_organizationid_value);
    }

    public Kbarticle with_organizationid_value(UUID _organizationid_value) {
        Kbarticle _x = _copy();
        _x.changedFields = changedFields.add("_organizationid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.kbarticle");
        _x._organizationid_value = _organizationid_value;
        return _x;
    }

    @Property(name="entityimage_timestamp")
    @JsonIgnore
    public Optional<Long> getEntityimage_timestamp() {
        return Optional.ofNullable(entityimage_timestamp);
    }

    public Kbarticle withEntityimage_timestamp(Long entityimage_timestamp) {
        Kbarticle _x = _copy();
        _x.changedFields = changedFields.add("entityimage_timestamp");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.kbarticle");
        _x.entityimage_timestamp = entityimage_timestamp;
        return _x;
    }

    @Property(name="entityimageid")
    @JsonIgnore
    public Optional<UUID> getEntityimageid() {
        return Optional.ofNullable(entityimageid);
    }

    public Kbarticle withEntityimageid(UUID entityimageid) {
        Kbarticle _x = _copy();
        _x.changedFields = changedFields.add("entityimageid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.kbarticle");
        _x.entityimageid = entityimageid;
        return _x;
    }

    @Property(name="number")
    @JsonIgnore
    public Optional<String> getNumber() {
        return Optional.ofNullable(number);
    }

    public Kbarticle withNumber(String number) {
        Checks.checkIsAscii(number);
        Kbarticle _x = _copy();
        _x.changedFields = changedFields.add("number");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.kbarticle");
        _x.number = number;
        return _x;
    }

    @Property(name="_subjectid_value")
    @JsonIgnore
    public Optional<UUID> get_subjectid_value() {
        return Optional.ofNullable(_subjectid_value);
    }

    public Kbarticle with_subjectid_value(UUID _subjectid_value) {
        Kbarticle _x = _copy();
        _x.changedFields = changedFields.add("_subjectid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.kbarticle");
        _x._subjectid_value = _subjectid_value;
        return _x;
    }

    @Property(name="statecode")
    @JsonIgnore
    public Optional<Integer> getStatecode() {
        return Optional.ofNullable(statecode);
    }

    public Kbarticle withStatecode(Integer statecode) {
        Kbarticle _x = _copy();
        _x.changedFields = changedFields.add("statecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.kbarticle");
        _x.statecode = statecode;
        return _x;
    }

    @Property(name="_transactioncurrencyid_value")
    @JsonIgnore
    public Optional<UUID> get_transactioncurrencyid_value() {
        return Optional.ofNullable(_transactioncurrencyid_value);
    }

    public Kbarticle with_transactioncurrencyid_value(UUID _transactioncurrencyid_value) {
        Kbarticle _x = _copy();
        _x.changedFields = changedFields.add("_transactioncurrencyid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.kbarticle");
        _x._transactioncurrencyid_value = _transactioncurrencyid_value;
        return _x;
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public Kbarticle withDescription(String description) {
        Checks.checkIsAscii(description);
        Kbarticle _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.kbarticle");
        _x.description = description;
        return _x;
    }

    @Property(name="_kbarticletemplateid_value")
    @JsonIgnore
    public Optional<UUID> get_kbarticletemplateid_value() {
        return Optional.ofNullable(_kbarticletemplateid_value);
    }

    public Kbarticle with_kbarticletemplateid_value(UUID _kbarticletemplateid_value) {
        Kbarticle _x = _copy();
        _x.changedFields = changedFields.add("_kbarticletemplateid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.kbarticle");
        _x._kbarticletemplateid_value = _kbarticletemplateid_value;
        return _x;
    }

    @Property(name="comments")
    @JsonIgnore
    public Optional<String> getComments() {
        return Optional.ofNullable(comments);
    }

    public Kbarticle withComments(String comments) {
        Checks.checkIsAscii(comments);
        Kbarticle _x = _copy();
        _x.changedFields = changedFields.add("comments");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.kbarticle");
        _x.comments = comments;
        return _x;
    }

    @Property(name="modifiedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedon() {
        return Optional.ofNullable(modifiedon);
    }

    public Kbarticle withModifiedon(OffsetDateTime modifiedon) {
        Kbarticle _x = _copy();
        _x.changedFields = changedFields.add("modifiedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.kbarticle");
        _x.modifiedon = modifiedon;
        return _x;
    }

    @Property(name="entityimage_url")
    @JsonIgnore
    public Optional<String> getEntityimage_url() {
        return Optional.ofNullable(entityimage_url);
    }

    public Kbarticle withEntityimage_url(String entityimage_url) {
        Checks.checkIsAscii(entityimage_url);
        Kbarticle _x = _copy();
        _x.changedFields = changedFields.add("entityimage_url");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.kbarticle");
        _x.entityimage_url = entityimage_url;
        return _x;
    }

    public Kbarticle withUnmappedField(String name, String value) {
        Kbarticle _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="createdonbehalfby")
    @JsonIgnore
    public SystemuserRequest getCreatedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), RequestHelper.getValue(unmappedFields, "createdonbehalfby"));
    }

    @NavigationProperty(name="KbArticle_Annotation")
    @JsonIgnore
    public AnnotationCollectionRequest getKbArticle_Annotation() {
        return new AnnotationCollectionRequest(
                        contextPath.addSegment("KbArticle_Annotation"), RequestHelper.getValue(unmappedFields, "KbArticle_Annotation"));
    }

    @NavigationProperty(name="KbArticle_BulkDeleteFailures")
    @JsonIgnore
    public BulkdeletefailureCollectionRequest getKbArticle_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(
                        contextPath.addSegment("KbArticle_BulkDeleteFailures"), RequestHelper.getValue(unmappedFields, "KbArticle_BulkDeleteFailures"));
    }

    @NavigationProperty(name="KbArticle_AsyncOperations")
    @JsonIgnore
    public AsyncoperationCollectionRequest getKbArticle_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("KbArticle_AsyncOperations"), RequestHelper.getValue(unmappedFields, "KbArticle_AsyncOperations"));
    }

    @NavigationProperty(name="KbArticle_ProcessSessions")
    @JsonIgnore
    public ProcesssessionCollectionRequest getKbArticle_ProcessSessions() {
        return new ProcesssessionCollectionRequest(
                        contextPath.addSegment("KbArticle_ProcessSessions"), RequestHelper.getValue(unmappedFields, "KbArticle_ProcessSessions"));
    }

    @NavigationProperty(name="KbArticle_DuplicateMatchingRecord")
    @JsonIgnore
    public DuplicaterecordCollectionRequest getKbArticle_DuplicateMatchingRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("KbArticle_DuplicateMatchingRecord"), RequestHelper.getValue(unmappedFields, "KbArticle_DuplicateMatchingRecord"));
    }

    @NavigationProperty(name="kbarticletemplateid")
    @JsonIgnore
    public KbarticletemplateRequest getKbarticletemplateid() {
        return new KbarticletemplateRequest(contextPath.addSegment("kbarticletemplateid"), RequestHelper.getValue(unmappedFields, "kbarticletemplateid"));
    }

    @NavigationProperty(name="createdby")
    @JsonIgnore
    public SystemuserRequest getCreatedby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), RequestHelper.getValue(unmappedFields, "createdby"));
    }

    @NavigationProperty(name="kbarticle_principalobjectattributeaccess")
    @JsonIgnore
    public PrincipalobjectattributeaccessCollectionRequest getKbarticle_principalobjectattributeaccess() {
        return new PrincipalobjectattributeaccessCollectionRequest(
                        contextPath.addSegment("kbarticle_principalobjectattributeaccess"), RequestHelper.getValue(unmappedFields, "kbarticle_principalobjectattributeaccess"));
    }

    @NavigationProperty(name="KbArticle_DuplicateBaseRecord")
    @JsonIgnore
    public DuplicaterecordCollectionRequest getKbArticle_DuplicateBaseRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("KbArticle_DuplicateBaseRecord"), RequestHelper.getValue(unmappedFields, "KbArticle_DuplicateBaseRecord"));
    }

    @NavigationProperty(name="KbArticle_SharepointDocumentLocation")
    @JsonIgnore
    public SharepointdocumentlocationCollectionRequest getKbArticle_SharepointDocumentLocation() {
        return new SharepointdocumentlocationCollectionRequest(
                        contextPath.addSegment("KbArticle_SharepointDocumentLocation"), RequestHelper.getValue(unmappedFields, "KbArticle_SharepointDocumentLocation"));
    }

    @NavigationProperty(name="organizationid")
    @JsonIgnore
    public OrganizationRequest getOrganizationid() {
        return new OrganizationRequest(contextPath.addSegment("organizationid"), RequestHelper.getValue(unmappedFields, "organizationid"));
    }

    @NavigationProperty(name="kbarticle_comments")
    @JsonIgnore
    public KbarticlecommentCollectionRequest getKbarticle_comments() {
        return new KbarticlecommentCollectionRequest(
                        contextPath.addSegment("kbarticle_comments"), RequestHelper.getValue(unmappedFields, "kbarticle_comments"));
    }

    @NavigationProperty(name="KbArticle_SyncErrors")
    @JsonIgnore
    public SyncerrorCollectionRequest getKbArticle_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("KbArticle_SyncErrors"), RequestHelper.getValue(unmappedFields, "KbArticle_SyncErrors"));
    }

    @NavigationProperty(name="subjectid")
    @JsonIgnore
    public SubjectRequest getSubjectid() {
        return new SubjectRequest(contextPath.addSegment("subjectid"), RequestHelper.getValue(unmappedFields, "subjectid"));
    }

    @NavigationProperty(name="transactioncurrencyid")
    @JsonIgnore
    public TransactioncurrencyRequest getTransactioncurrencyid() {
        return new TransactioncurrencyRequest(contextPath.addSegment("transactioncurrencyid"), RequestHelper.getValue(unmappedFields, "transactioncurrencyid"));
    }

    @NavigationProperty(name="modifiedby")
    @JsonIgnore
    public SystemuserRequest getModifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), RequestHelper.getValue(unmappedFields, "modifiedby"));
    }

    @NavigationProperty(name="modifiedonbehalfby")
    @JsonIgnore
    public SystemuserRequest getModifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), RequestHelper.getValue(unmappedFields, "modifiedonbehalfby"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Kbarticle patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Kbarticle _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Kbarticle put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Kbarticle _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Kbarticle _copy() {
        Kbarticle _x = new Kbarticle();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.articlexml = articlexml;
        _x._createdby_value = _createdby_value;
        _x.languagecode = languagecode;
        _x.versionnumber = versionnumber;
        _x.content = content;
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        _x.kbarticleid = kbarticleid;
        _x.entityimage = entityimage;
        _x.createdon = createdon;
        _x.title = title;
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        _x.exchangerate = exchangerate;
        _x.statuscode = statuscode;
        _x._modifiedby_value = _modifiedby_value;
        _x.importsequencenumber = importsequencenumber;
        _x.overriddencreatedon = overriddencreatedon;
        _x.keywords = keywords;
        _x._organizationid_value = _organizationid_value;
        _x.entityimage_timestamp = entityimage_timestamp;
        _x.entityimageid = entityimageid;
        _x.number = number;
        _x._subjectid_value = _subjectid_value;
        _x.statecode = statecode;
        _x._transactioncurrencyid_value = _transactioncurrencyid_value;
        _x.description = description;
        _x._kbarticletemplateid_value = _kbarticletemplateid_value;
        _x.comments = comments;
        _x.modifiedon = modifiedon;
        _x.entityimage_url = entityimage_url;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Kbarticle[");
        b.append("articlexml=");
        b.append(this.articlexml);
        b.append(", ");
        b.append("_createdby_value=");
        b.append(this._createdby_value);
        b.append(", ");
        b.append("languagecode=");
        b.append(this.languagecode);
        b.append(", ");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append(", ");
        b.append("content=");
        b.append(this.content);
        b.append(", ");
        b.append("_createdonbehalfby_value=");
        b.append(this._createdonbehalfby_value);
        b.append(", ");
        b.append("kbarticleid=");
        b.append(this.kbarticleid);
        b.append(", ");
        b.append("entityimage=");
        b.append(this.entityimage);
        b.append(", ");
        b.append("createdon=");
        b.append(this.createdon);
        b.append(", ");
        b.append("title=");
        b.append(this.title);
        b.append(", ");
        b.append("_modifiedonbehalfby_value=");
        b.append(this._modifiedonbehalfby_value);
        b.append(", ");
        b.append("exchangerate=");
        b.append(this.exchangerate);
        b.append(", ");
        b.append("statuscode=");
        b.append(this.statuscode);
        b.append(", ");
        b.append("_modifiedby_value=");
        b.append(this._modifiedby_value);
        b.append(", ");
        b.append("importsequencenumber=");
        b.append(this.importsequencenumber);
        b.append(", ");
        b.append("overriddencreatedon=");
        b.append(this.overriddencreatedon);
        b.append(", ");
        b.append("keywords=");
        b.append(this.keywords);
        b.append(", ");
        b.append("_organizationid_value=");
        b.append(this._organizationid_value);
        b.append(", ");
        b.append("entityimage_timestamp=");
        b.append(this.entityimage_timestamp);
        b.append(", ");
        b.append("entityimageid=");
        b.append(this.entityimageid);
        b.append(", ");
        b.append("number=");
        b.append(this.number);
        b.append(", ");
        b.append("_subjectid_value=");
        b.append(this._subjectid_value);
        b.append(", ");
        b.append("statecode=");
        b.append(this.statecode);
        b.append(", ");
        b.append("_transactioncurrencyid_value=");
        b.append(this._transactioncurrencyid_value);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("_kbarticletemplateid_value=");
        b.append(this._kbarticletemplateid_value);
        b.append(", ");
        b.append("comments=");
        b.append(this.comments);
        b.append(", ");
        b.append("modifiedon=");
        b.append(this.modifiedon);
        b.append(", ");
        b.append("entityimage_url=");
        b.append(this.entityimage_url);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
