package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.DuplicaterecordCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.GoalCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ProcesssessionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;
import microsoft.dynamics.crm.entity.request.BusinessunitRequest;
import microsoft.dynamics.crm.entity.request.PrincipalRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;
import microsoft.dynamics.crm.entity.request.TeamRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "_owningteam_value", 
    "overriddencreatedon", 
    "versionnumber", 
    "_createdby_value", 
    "timezoneruleversionnumber", 
    "_owningbusinessunit_value", 
    "_owninguser_value", 
    "_createdonbehalfby_value", 
    "queryentitytype", 
    "_modifiedby_value", 
    "modifiedon", 
    "utcconversiontimezonecode", 
    "createdon", 
    "importsequencenumber", 
    "fetchxml", 
    "name", 
    "goalrollupqueryid", 
    "statecode", 
    "statuscode", 
    "_modifiedonbehalfby_value", 
    "_ownerid_value"})
@JsonInclude(Include.NON_NULL)
public class Goalrollupquery extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.goalrollupquery";
    }

    @JsonProperty("_owningteam_value")
    protected UUID _owningteam_value;

    @JsonProperty("overriddencreatedon")
    protected OffsetDateTime overriddencreatedon;

    @JsonProperty("versionnumber")
    protected Long versionnumber;

    @JsonProperty("_createdby_value")
    protected UUID _createdby_value;

    @JsonProperty("timezoneruleversionnumber")
    protected Integer timezoneruleversionnumber;

    @JsonProperty("_owningbusinessunit_value")
    protected UUID _owningbusinessunit_value;

    @JsonProperty("_owninguser_value")
    protected UUID _owninguser_value;

    @JsonProperty("_createdonbehalfby_value")
    protected UUID _createdonbehalfby_value;

    @JsonProperty("queryentitytype")
    protected String queryentitytype;

    @JsonProperty("_modifiedby_value")
    protected UUID _modifiedby_value;

    @JsonProperty("modifiedon")
    protected OffsetDateTime modifiedon;

    @JsonProperty("utcconversiontimezonecode")
    protected Integer utcconversiontimezonecode;

    @JsonProperty("createdon")
    protected OffsetDateTime createdon;

    @JsonProperty("importsequencenumber")
    protected Integer importsequencenumber;

    @JsonProperty("fetchxml")
    protected String fetchxml;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("goalrollupqueryid")
    protected UUID goalrollupqueryid;

    @JsonProperty("statecode")
    protected Integer statecode;

    @JsonProperty("statuscode")
    protected Integer statuscode;

    @JsonProperty("_modifiedonbehalfby_value")
    protected UUID _modifiedonbehalfby_value;

    @JsonProperty("_ownerid_value")
    protected UUID _ownerid_value;

    protected Goalrollupquery() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderGoalrollupquery() {
        return new Builder();
    }

    public static final class Builder {
        private UUID _owningteam_value;
        private OffsetDateTime overriddencreatedon;
        private Long versionnumber;
        private UUID _createdby_value;
        private Integer timezoneruleversionnumber;
        private UUID _owningbusinessunit_value;
        private UUID _owninguser_value;
        private UUID _createdonbehalfby_value;
        private String queryentitytype;
        private UUID _modifiedby_value;
        private OffsetDateTime modifiedon;
        private Integer utcconversiontimezonecode;
        private OffsetDateTime createdon;
        private Integer importsequencenumber;
        private String fetchxml;
        private String name;
        private UUID goalrollupqueryid;
        private Integer statecode;
        private Integer statuscode;
        private UUID _modifiedonbehalfby_value;
        private UUID _ownerid_value;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder _owningteam_value(UUID _owningteam_value) {
            this._owningteam_value = _owningteam_value;
            this.changedFields = changedFields.add("_owningteam_value");
            return this;
        }

        public Builder overriddencreatedon(OffsetDateTime overriddencreatedon) {
            this.overriddencreatedon = overriddencreatedon;
            this.changedFields = changedFields.add("overriddencreatedon");
            return this;
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Builder _createdby_value(UUID _createdby_value) {
            this._createdby_value = _createdby_value;
            this.changedFields = changedFields.add("_createdby_value");
            return this;
        }

        public Builder timezoneruleversionnumber(Integer timezoneruleversionnumber) {
            this.timezoneruleversionnumber = timezoneruleversionnumber;
            this.changedFields = changedFields.add("timezoneruleversionnumber");
            return this;
        }

        public Builder _owningbusinessunit_value(UUID _owningbusinessunit_value) {
            this._owningbusinessunit_value = _owningbusinessunit_value;
            this.changedFields = changedFields.add("_owningbusinessunit_value");
            return this;
        }

        public Builder _owninguser_value(UUID _owninguser_value) {
            this._owninguser_value = _owninguser_value;
            this.changedFields = changedFields.add("_owninguser_value");
            return this;
        }

        public Builder _createdonbehalfby_value(UUID _createdonbehalfby_value) {
            this._createdonbehalfby_value = _createdonbehalfby_value;
            this.changedFields = changedFields.add("_createdonbehalfby_value");
            return this;
        }

        public Builder queryentitytype(String queryentitytype) {
            this.queryentitytype = queryentitytype;
            this.changedFields = changedFields.add("queryentitytype");
            return this;
        }

        public Builder _modifiedby_value(UUID _modifiedby_value) {
            this._modifiedby_value = _modifiedby_value;
            this.changedFields = changedFields.add("_modifiedby_value");
            return this;
        }

        public Builder modifiedon(OffsetDateTime modifiedon) {
            this.modifiedon = modifiedon;
            this.changedFields = changedFields.add("modifiedon");
            return this;
        }

        public Builder utcconversiontimezonecode(Integer utcconversiontimezonecode) {
            this.utcconversiontimezonecode = utcconversiontimezonecode;
            this.changedFields = changedFields.add("utcconversiontimezonecode");
            return this;
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Builder importsequencenumber(Integer importsequencenumber) {
            this.importsequencenumber = importsequencenumber;
            this.changedFields = changedFields.add("importsequencenumber");
            return this;
        }

        public Builder fetchxml(String fetchxml) {
            this.fetchxml = fetchxml;
            this.changedFields = changedFields.add("fetchxml");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder goalrollupqueryid(UUID goalrollupqueryid) {
            this.goalrollupqueryid = goalrollupqueryid;
            this.changedFields = changedFields.add("goalrollupqueryid");
            return this;
        }

        public Builder statecode(Integer statecode) {
            this.statecode = statecode;
            this.changedFields = changedFields.add("statecode");
            return this;
        }

        public Builder statuscode(Integer statuscode) {
            this.statuscode = statuscode;
            this.changedFields = changedFields.add("statuscode");
            return this;
        }

        public Builder _modifiedonbehalfby_value(UUID _modifiedonbehalfby_value) {
            this._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            this.changedFields = changedFields.add("_modifiedonbehalfby_value");
            return this;
        }

        public Builder _ownerid_value(UUID _ownerid_value) {
            this._ownerid_value = _ownerid_value;
            this.changedFields = changedFields.add("_ownerid_value");
            return this;
        }

        public Goalrollupquery build() {
            Goalrollupquery _x = new Goalrollupquery();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.goalrollupquery";
            _x._owningteam_value = _owningteam_value;
            _x.overriddencreatedon = overriddencreatedon;
            _x.versionnumber = versionnumber;
            _x._createdby_value = _createdby_value;
            _x.timezoneruleversionnumber = timezoneruleversionnumber;
            _x._owningbusinessunit_value = _owningbusinessunit_value;
            _x._owninguser_value = _owninguser_value;
            _x._createdonbehalfby_value = _createdonbehalfby_value;
            _x.queryentitytype = queryentitytype;
            _x._modifiedby_value = _modifiedby_value;
            _x.modifiedon = modifiedon;
            _x.utcconversiontimezonecode = utcconversiontimezonecode;
            _x.createdon = createdon;
            _x.importsequencenumber = importsequencenumber;
            _x.fetchxml = fetchxml;
            _x.name = name;
            _x.goalrollupqueryid = goalrollupqueryid;
            _x.statecode = statecode;
            _x.statuscode = statuscode;
            _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            _x._ownerid_value = _ownerid_value;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && goalrollupqueryid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(goalrollupqueryid, UUID.class));
        }
    }

    @Property(name="_owningteam_value")
    @JsonIgnore
    public Optional<UUID> get_owningteam_value() {
        return Optional.ofNullable(_owningteam_value);
    }

    public Goalrollupquery with_owningteam_value(UUID _owningteam_value) {
        Goalrollupquery _x = _copy();
        _x.changedFields = changedFields.add("_owningteam_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.goalrollupquery");
        _x._owningteam_value = _owningteam_value;
        return _x;
    }

    @Property(name="overriddencreatedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverriddencreatedon() {
        return Optional.ofNullable(overriddencreatedon);
    }

    public Goalrollupquery withOverriddencreatedon(OffsetDateTime overriddencreatedon) {
        Goalrollupquery _x = _copy();
        _x.changedFields = changedFields.add("overriddencreatedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.goalrollupquery");
        _x.overriddencreatedon = overriddencreatedon;
        return _x;
    }

    @Property(name="versionnumber")
    @JsonIgnore
    public Optional<Long> getVersionnumber() {
        return Optional.ofNullable(versionnumber);
    }

    public Goalrollupquery withVersionnumber(Long versionnumber) {
        Goalrollupquery _x = _copy();
        _x.changedFields = changedFields.add("versionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.goalrollupquery");
        _x.versionnumber = versionnumber;
        return _x;
    }

    @Property(name="_createdby_value")
    @JsonIgnore
    public Optional<UUID> get_createdby_value() {
        return Optional.ofNullable(_createdby_value);
    }

    public Goalrollupquery with_createdby_value(UUID _createdby_value) {
        Goalrollupquery _x = _copy();
        _x.changedFields = changedFields.add("_createdby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.goalrollupquery");
        _x._createdby_value = _createdby_value;
        return _x;
    }

    @Property(name="timezoneruleversionnumber")
    @JsonIgnore
    public Optional<Integer> getTimezoneruleversionnumber() {
        return Optional.ofNullable(timezoneruleversionnumber);
    }

    public Goalrollupquery withTimezoneruleversionnumber(Integer timezoneruleversionnumber) {
        Goalrollupquery _x = _copy();
        _x.changedFields = changedFields.add("timezoneruleversionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.goalrollupquery");
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        return _x;
    }

    @Property(name="_owningbusinessunit_value")
    @JsonIgnore
    public Optional<UUID> get_owningbusinessunit_value() {
        return Optional.ofNullable(_owningbusinessunit_value);
    }

    public Goalrollupquery with_owningbusinessunit_value(UUID _owningbusinessunit_value) {
        Goalrollupquery _x = _copy();
        _x.changedFields = changedFields.add("_owningbusinessunit_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.goalrollupquery");
        _x._owningbusinessunit_value = _owningbusinessunit_value;
        return _x;
    }

    @Property(name="_owninguser_value")
    @JsonIgnore
    public Optional<UUID> get_owninguser_value() {
        return Optional.ofNullable(_owninguser_value);
    }

    public Goalrollupquery with_owninguser_value(UUID _owninguser_value) {
        Goalrollupquery _x = _copy();
        _x.changedFields = changedFields.add("_owninguser_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.goalrollupquery");
        _x._owninguser_value = _owninguser_value;
        return _x;
    }

    @Property(name="_createdonbehalfby_value")
    @JsonIgnore
    public Optional<UUID> get_createdonbehalfby_value() {
        return Optional.ofNullable(_createdonbehalfby_value);
    }

    public Goalrollupquery with_createdonbehalfby_value(UUID _createdonbehalfby_value) {
        Goalrollupquery _x = _copy();
        _x.changedFields = changedFields.add("_createdonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.goalrollupquery");
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        return _x;
    }

    @Property(name="queryentitytype")
    @JsonIgnore
    public Optional<String> getQueryentitytype() {
        return Optional.ofNullable(queryentitytype);
    }

    public Goalrollupquery withQueryentitytype(String queryentitytype) {
        Checks.checkIsAscii(queryentitytype);
        Goalrollupquery _x = _copy();
        _x.changedFields = changedFields.add("queryentitytype");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.goalrollupquery");
        _x.queryentitytype = queryentitytype;
        return _x;
    }

    @Property(name="_modifiedby_value")
    @JsonIgnore
    public Optional<UUID> get_modifiedby_value() {
        return Optional.ofNullable(_modifiedby_value);
    }

    public Goalrollupquery with_modifiedby_value(UUID _modifiedby_value) {
        Goalrollupquery _x = _copy();
        _x.changedFields = changedFields.add("_modifiedby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.goalrollupquery");
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    @Property(name="modifiedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedon() {
        return Optional.ofNullable(modifiedon);
    }

    public Goalrollupquery withModifiedon(OffsetDateTime modifiedon) {
        Goalrollupquery _x = _copy();
        _x.changedFields = changedFields.add("modifiedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.goalrollupquery");
        _x.modifiedon = modifiedon;
        return _x;
    }

    @Property(name="utcconversiontimezonecode")
    @JsonIgnore
    public Optional<Integer> getUtcconversiontimezonecode() {
        return Optional.ofNullable(utcconversiontimezonecode);
    }

    public Goalrollupquery withUtcconversiontimezonecode(Integer utcconversiontimezonecode) {
        Goalrollupquery _x = _copy();
        _x.changedFields = changedFields.add("utcconversiontimezonecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.goalrollupquery");
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        return _x;
    }

    @Property(name="createdon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedon() {
        return Optional.ofNullable(createdon);
    }

    public Goalrollupquery withCreatedon(OffsetDateTime createdon) {
        Goalrollupquery _x = _copy();
        _x.changedFields = changedFields.add("createdon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.goalrollupquery");
        _x.createdon = createdon;
        return _x;
    }

    @Property(name="importsequencenumber")
    @JsonIgnore
    public Optional<Integer> getImportsequencenumber() {
        return Optional.ofNullable(importsequencenumber);
    }

    public Goalrollupquery withImportsequencenumber(Integer importsequencenumber) {
        Goalrollupquery _x = _copy();
        _x.changedFields = changedFields.add("importsequencenumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.goalrollupquery");
        _x.importsequencenumber = importsequencenumber;
        return _x;
    }

    @Property(name="fetchxml")
    @JsonIgnore
    public Optional<String> getFetchxml() {
        return Optional.ofNullable(fetchxml);
    }

    public Goalrollupquery withFetchxml(String fetchxml) {
        Checks.checkIsAscii(fetchxml);
        Goalrollupquery _x = _copy();
        _x.changedFields = changedFields.add("fetchxml");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.goalrollupquery");
        _x.fetchxml = fetchxml;
        return _x;
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public Goalrollupquery withName(String name) {
        Checks.checkIsAscii(name);
        Goalrollupquery _x = _copy();
        _x.changedFields = changedFields.add("name");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.goalrollupquery");
        _x.name = name;
        return _x;
    }

    @Property(name="goalrollupqueryid")
    @JsonIgnore
    public Optional<UUID> getGoalrollupqueryid() {
        return Optional.ofNullable(goalrollupqueryid);
    }

    public Goalrollupquery withGoalrollupqueryid(UUID goalrollupqueryid) {
        Goalrollupquery _x = _copy();
        _x.changedFields = changedFields.add("goalrollupqueryid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.goalrollupquery");
        _x.goalrollupqueryid = goalrollupqueryid;
        return _x;
    }

    @Property(name="statecode")
    @JsonIgnore
    public Optional<Integer> getStatecode() {
        return Optional.ofNullable(statecode);
    }

    public Goalrollupquery withStatecode(Integer statecode) {
        Goalrollupquery _x = _copy();
        _x.changedFields = changedFields.add("statecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.goalrollupquery");
        _x.statecode = statecode;
        return _x;
    }

    @Property(name="statuscode")
    @JsonIgnore
    public Optional<Integer> getStatuscode() {
        return Optional.ofNullable(statuscode);
    }

    public Goalrollupquery withStatuscode(Integer statuscode) {
        Goalrollupquery _x = _copy();
        _x.changedFields = changedFields.add("statuscode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.goalrollupquery");
        _x.statuscode = statuscode;
        return _x;
    }

    @Property(name="_modifiedonbehalfby_value")
    @JsonIgnore
    public Optional<UUID> get_modifiedonbehalfby_value() {
        return Optional.ofNullable(_modifiedonbehalfby_value);
    }

    public Goalrollupquery with_modifiedonbehalfby_value(UUID _modifiedonbehalfby_value) {
        Goalrollupquery _x = _copy();
        _x.changedFields = changedFields.add("_modifiedonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.goalrollupquery");
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        return _x;
    }

    @Property(name="_ownerid_value")
    @JsonIgnore
    public Optional<UUID> get_ownerid_value() {
        return Optional.ofNullable(_ownerid_value);
    }

    public Goalrollupquery with_ownerid_value(UUID _ownerid_value) {
        Goalrollupquery _x = _copy();
        _x.changedFields = changedFields.add("_ownerid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.goalrollupquery");
        _x._ownerid_value = _ownerid_value;
        return _x;
    }

    public Goalrollupquery withUnmappedField(String name, String value) {
        Goalrollupquery _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="owningteam")
    @JsonIgnore
    public TeamRequest getOwningteam() {
        return new TeamRequest(contextPath.addSegment("owningteam"), RequestHelper.getValue(unmappedFields, "owningteam"));
    }

    @NavigationProperty(name="goalrollupquery_actualint")
    @JsonIgnore
    public GoalCollectionRequest getGoalrollupquery_actualint() {
        return new GoalCollectionRequest(
                        contextPath.addSegment("goalrollupquery_actualint"), RequestHelper.getValue(unmappedFields, "goalrollupquery_actualint"));
    }

    @NavigationProperty(name="goal_rollupquery_actualmoney")
    @JsonIgnore
    public GoalCollectionRequest getGoal_rollupquery_actualmoney() {
        return new GoalCollectionRequest(
                        contextPath.addSegment("goal_rollupquery_actualmoney"), RequestHelper.getValue(unmappedFields, "goal_rollupquery_actualmoney"));
    }

    @NavigationProperty(name="goal_rollupquery_actualdecimal")
    @JsonIgnore
    public GoalCollectionRequest getGoal_rollupquery_actualdecimal() {
        return new GoalCollectionRequest(
                        contextPath.addSegment("goal_rollupquery_actualdecimal"), RequestHelper.getValue(unmappedFields, "goal_rollupquery_actualdecimal"));
    }

    @NavigationProperty(name="goal_rollupquery_customint")
    @JsonIgnore
    public GoalCollectionRequest getGoal_rollupquery_customint() {
        return new GoalCollectionRequest(
                        contextPath.addSegment("goal_rollupquery_customint"), RequestHelper.getValue(unmappedFields, "goal_rollupquery_customint"));
    }

    @NavigationProperty(name="goal_rollupquery_custommoney")
    @JsonIgnore
    public GoalCollectionRequest getGoal_rollupquery_custommoney() {
        return new GoalCollectionRequest(
                        contextPath.addSegment("goal_rollupquery_custommoney"), RequestHelper.getValue(unmappedFields, "goal_rollupquery_custommoney"));
    }

    @NavigationProperty(name="goal_rollupquery_customdecimal")
    @JsonIgnore
    public GoalCollectionRequest getGoal_rollupquery_customdecimal() {
        return new GoalCollectionRequest(
                        contextPath.addSegment("goal_rollupquery_customdecimal"), RequestHelper.getValue(unmappedFields, "goal_rollupquery_customdecimal"));
    }

    @NavigationProperty(name="goal_rollupquery_inprogressint")
    @JsonIgnore
    public GoalCollectionRequest getGoal_rollupquery_inprogressint() {
        return new GoalCollectionRequest(
                        contextPath.addSegment("goal_rollupquery_inprogressint"), RequestHelper.getValue(unmappedFields, "goal_rollupquery_inprogressint"));
    }

    @NavigationProperty(name="goal_rollupquery_inprogressmoney")
    @JsonIgnore
    public GoalCollectionRequest getGoal_rollupquery_inprogressmoney() {
        return new GoalCollectionRequest(
                        contextPath.addSegment("goal_rollupquery_inprogressmoney"), RequestHelper.getValue(unmappedFields, "goal_rollupquery_inprogressmoney"));
    }

    @NavigationProperty(name="goal_rollupquery_inprogressdecimal")
    @JsonIgnore
    public GoalCollectionRequest getGoal_rollupquery_inprogressdecimal() {
        return new GoalCollectionRequest(
                        contextPath.addSegment("goal_rollupquery_inprogressdecimal"), RequestHelper.getValue(unmappedFields, "goal_rollupquery_inprogressdecimal"));
    }

    @NavigationProperty(name="createdby")
    @JsonIgnore
    public SystemuserRequest getCreatedby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), RequestHelper.getValue(unmappedFields, "createdby"));
    }

    @NavigationProperty(name="createdonbehalfby")
    @JsonIgnore
    public SystemuserRequest getCreatedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), RequestHelper.getValue(unmappedFields, "createdonbehalfby"));
    }

    @NavigationProperty(name="modifiedby")
    @JsonIgnore
    public SystemuserRequest getModifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), RequestHelper.getValue(unmappedFields, "modifiedby"));
    }

    @NavigationProperty(name="modifiedonbehalfby")
    @JsonIgnore
    public SystemuserRequest getModifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), RequestHelper.getValue(unmappedFields, "modifiedonbehalfby"));
    }

    @NavigationProperty(name="GoalRollupQuery_DuplicateBaseRecord")
    @JsonIgnore
    public DuplicaterecordCollectionRequest getGoalRollupQuery_DuplicateBaseRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("GoalRollupQuery_DuplicateBaseRecord"), RequestHelper.getValue(unmappedFields, "GoalRollupQuery_DuplicateBaseRecord"));
    }

    @NavigationProperty(name="ownerid")
    @JsonIgnore
    public PrincipalRequest getOwnerid() {
        return new PrincipalRequest(contextPath.addSegment("ownerid"), RequestHelper.getValue(unmappedFields, "ownerid"));
    }

    @NavigationProperty(name="goalrollupquery_AsyncOperations")
    @JsonIgnore
    public AsyncoperationCollectionRequest getGoalrollupquery_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("goalrollupquery_AsyncOperations"), RequestHelper.getValue(unmappedFields, "goalrollupquery_AsyncOperations"));
    }

    @NavigationProperty(name="GoalRollupQuery_DuplicateMatchingRecord")
    @JsonIgnore
    public DuplicaterecordCollectionRequest getGoalRollupQuery_DuplicateMatchingRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("GoalRollupQuery_DuplicateMatchingRecord"), RequestHelper.getValue(unmappedFields, "GoalRollupQuery_DuplicateMatchingRecord"));
    }

    @NavigationProperty(name="goalrollupquery_ProcessSessions")
    @JsonIgnore
    public ProcesssessionCollectionRequest getGoalrollupquery_ProcessSessions() {
        return new ProcesssessionCollectionRequest(
                        contextPath.addSegment("goalrollupquery_ProcessSessions"), RequestHelper.getValue(unmappedFields, "goalrollupquery_ProcessSessions"));
    }

    @NavigationProperty(name="GoalRollupQuery_SyncErrors")
    @JsonIgnore
    public SyncerrorCollectionRequest getGoalRollupQuery_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("GoalRollupQuery_SyncErrors"), RequestHelper.getValue(unmappedFields, "GoalRollupQuery_SyncErrors"));
    }

    @NavigationProperty(name="owningbusinessunit")
    @JsonIgnore
    public BusinessunitRequest getOwningbusinessunit() {
        return new BusinessunitRequest(contextPath.addSegment("owningbusinessunit"), RequestHelper.getValue(unmappedFields, "owningbusinessunit"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Goalrollupquery patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Goalrollupquery _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Goalrollupquery put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Goalrollupquery _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Goalrollupquery _copy() {
        Goalrollupquery _x = new Goalrollupquery();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x._owningteam_value = _owningteam_value;
        _x.overriddencreatedon = overriddencreatedon;
        _x.versionnumber = versionnumber;
        _x._createdby_value = _createdby_value;
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        _x._owningbusinessunit_value = _owningbusinessunit_value;
        _x._owninguser_value = _owninguser_value;
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        _x.queryentitytype = queryentitytype;
        _x._modifiedby_value = _modifiedby_value;
        _x.modifiedon = modifiedon;
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        _x.createdon = createdon;
        _x.importsequencenumber = importsequencenumber;
        _x.fetchxml = fetchxml;
        _x.name = name;
        _x.goalrollupqueryid = goalrollupqueryid;
        _x.statecode = statecode;
        _x.statuscode = statuscode;
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        _x._ownerid_value = _ownerid_value;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Goalrollupquery[");
        b.append("_owningteam_value=");
        b.append(this._owningteam_value);
        b.append(", ");
        b.append("overriddencreatedon=");
        b.append(this.overriddencreatedon);
        b.append(", ");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append(", ");
        b.append("_createdby_value=");
        b.append(this._createdby_value);
        b.append(", ");
        b.append("timezoneruleversionnumber=");
        b.append(this.timezoneruleversionnumber);
        b.append(", ");
        b.append("_owningbusinessunit_value=");
        b.append(this._owningbusinessunit_value);
        b.append(", ");
        b.append("_owninguser_value=");
        b.append(this._owninguser_value);
        b.append(", ");
        b.append("_createdonbehalfby_value=");
        b.append(this._createdonbehalfby_value);
        b.append(", ");
        b.append("queryentitytype=");
        b.append(this.queryentitytype);
        b.append(", ");
        b.append("_modifiedby_value=");
        b.append(this._modifiedby_value);
        b.append(", ");
        b.append("modifiedon=");
        b.append(this.modifiedon);
        b.append(", ");
        b.append("utcconversiontimezonecode=");
        b.append(this.utcconversiontimezonecode);
        b.append(", ");
        b.append("createdon=");
        b.append(this.createdon);
        b.append(", ");
        b.append("importsequencenumber=");
        b.append(this.importsequencenumber);
        b.append(", ");
        b.append("fetchxml=");
        b.append(this.fetchxml);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("goalrollupqueryid=");
        b.append(this.goalrollupqueryid);
        b.append(", ");
        b.append("statecode=");
        b.append(this.statecode);
        b.append(", ");
        b.append("statuscode=");
        b.append(this.statuscode);
        b.append(", ");
        b.append("_modifiedonbehalfby_value=");
        b.append(this._modifiedonbehalfby_value);
        b.append(", ");
        b.append("_ownerid_value=");
        b.append(this._ownerid_value);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
