package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;
import java.util.UUID;

@JsonPropertyOrder({
    "@odata.type", 
    "connectionroleid", 
    "connectionroleassociationid", 
    "associatedconnectionroleid", 
    "versionnumber"})
@JsonInclude(Include.NON_NULL)
public class Connectionroleassociation extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.connectionroleassociation";
    }

    @JsonProperty("connectionroleid")
    protected UUID connectionroleid;

    @JsonProperty("connectionroleassociationid")
    protected UUID connectionroleassociationid;

    @JsonProperty("associatedconnectionroleid")
    protected UUID associatedconnectionroleid;

    @JsonProperty("versionnumber")
    protected Long versionnumber;

    protected Connectionroleassociation() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderConnectionroleassociation() {
        return new Builder();
    }

    public static final class Builder {
        private UUID connectionroleid;
        private UUID connectionroleassociationid;
        private UUID associatedconnectionroleid;
        private Long versionnumber;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder connectionroleid(UUID connectionroleid) {
            this.connectionroleid = connectionroleid;
            this.changedFields = changedFields.add("connectionroleid");
            return this;
        }

        public Builder connectionroleassociationid(UUID connectionroleassociationid) {
            this.connectionroleassociationid = connectionroleassociationid;
            this.changedFields = changedFields.add("connectionroleassociationid");
            return this;
        }

        public Builder associatedconnectionroleid(UUID associatedconnectionroleid) {
            this.associatedconnectionroleid = associatedconnectionroleid;
            this.changedFields = changedFields.add("associatedconnectionroleid");
            return this;
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Connectionroleassociation build() {
            Connectionroleassociation _x = new Connectionroleassociation();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.connectionroleassociation";
            _x.connectionroleid = connectionroleid;
            _x.connectionroleassociationid = connectionroleassociationid;
            _x.associatedconnectionroleid = associatedconnectionroleid;
            _x.versionnumber = versionnumber;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && connectionroleassociationid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(connectionroleassociationid, UUID.class));
        }
    }

    @Property(name="connectionroleid")
    @JsonIgnore
    public Optional<UUID> getConnectionroleid() {
        return Optional.ofNullable(connectionroleid);
    }

    public Connectionroleassociation withConnectionroleid(UUID connectionroleid) {
        Connectionroleassociation _x = _copy();
        _x.changedFields = changedFields.add("connectionroleid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.connectionroleassociation");
        _x.connectionroleid = connectionroleid;
        return _x;
    }

    @Property(name="connectionroleassociationid")
    @JsonIgnore
    public Optional<UUID> getConnectionroleassociationid() {
        return Optional.ofNullable(connectionroleassociationid);
    }

    public Connectionroleassociation withConnectionroleassociationid(UUID connectionroleassociationid) {
        Connectionroleassociation _x = _copy();
        _x.changedFields = changedFields.add("connectionroleassociationid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.connectionroleassociation");
        _x.connectionroleassociationid = connectionroleassociationid;
        return _x;
    }

    @Property(name="associatedconnectionroleid")
    @JsonIgnore
    public Optional<UUID> getAssociatedconnectionroleid() {
        return Optional.ofNullable(associatedconnectionroleid);
    }

    public Connectionroleassociation withAssociatedconnectionroleid(UUID associatedconnectionroleid) {
        Connectionroleassociation _x = _copy();
        _x.changedFields = changedFields.add("associatedconnectionroleid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.connectionroleassociation");
        _x.associatedconnectionroleid = associatedconnectionroleid;
        return _x;
    }

    @Property(name="versionnumber")
    @JsonIgnore
    public Optional<Long> getVersionnumber() {
        return Optional.ofNullable(versionnumber);
    }

    public Connectionroleassociation withVersionnumber(Long versionnumber) {
        Connectionroleassociation _x = _copy();
        _x.changedFields = changedFields.add("versionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.connectionroleassociation");
        _x.versionnumber = versionnumber;
        return _x;
    }

    public Connectionroleassociation withUnmappedField(String name, String value) {
        Connectionroleassociation _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Connectionroleassociation patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Connectionroleassociation _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Connectionroleassociation put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Connectionroleassociation _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Connectionroleassociation _copy() {
        Connectionroleassociation _x = new Connectionroleassociation();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.connectionroleid = connectionroleid;
        _x.connectionroleassociationid = connectionroleassociationid;
        _x.associatedconnectionroleid = associatedconnectionroleid;
        _x.versionnumber = versionnumber;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Connectionroleassociation[");
        b.append("connectionroleid=");
        b.append(this.connectionroleid);
        b.append(", ");
        b.append("connectionroleassociationid=");
        b.append(this.connectionroleassociationid);
        b.append(", ");
        b.append("associatedconnectionroleid=");
        b.append(this.associatedconnectionroleid);
        b.append(", ");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
