package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.complex.BooleanManagedProperty;
import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.BulkdeletefailureCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.DuplicaterecordCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.MailboxtrackingfolderCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PrincipalobjectattributeaccessCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ProcesssessionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.RoleCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;
import microsoft.dynamics.crm.entity.request.BusinessunitRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "_modifiedby_value", 
    "_createdonbehalfby_value", 
    "importsequencenumber", 
    "applicationid", 
    "createdon", 
    "utcconversiontimezonecode", 
    "applicationuserid", 
    "_businessunitid_value", 
    "statuscode", 
    "componentidunique", 
    "versionnumber", 
    "timezoneruleversionnumber", 
    "componentstate", 
    "applicationname", 
    "iscustomizable", 
    "overwritetime", 
    "_modifiedonbehalfby_value", 
    "solutionid", 
    "_createdby_value", 
    "ismanaged", 
    "applicationtype", 
    "modifiedon", 
    "statecode", 
    "overriddencreatedon"})
@JsonInclude(Include.NON_NULL)
public class Applicationuser extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.applicationuser";
    }

    @JsonProperty("_modifiedby_value")
    protected UUID _modifiedby_value;

    @JsonProperty("_createdonbehalfby_value")
    protected UUID _createdonbehalfby_value;

    @JsonProperty("importsequencenumber")
    protected Integer importsequencenumber;

    @JsonProperty("applicationid")
    protected UUID applicationid;

    @JsonProperty("createdon")
    protected OffsetDateTime createdon;

    @JsonProperty("utcconversiontimezonecode")
    protected Integer utcconversiontimezonecode;

    @JsonProperty("applicationuserid")
    protected UUID applicationuserid;

    @JsonProperty("_businessunitid_value")
    protected UUID _businessunitid_value;

    @JsonProperty("statuscode")
    protected Integer statuscode;

    @JsonProperty("componentidunique")
    protected UUID componentidunique;

    @JsonProperty("versionnumber")
    protected Long versionnumber;

    @JsonProperty("timezoneruleversionnumber")
    protected Integer timezoneruleversionnumber;

    @JsonProperty("componentstate")
    protected Integer componentstate;

    @JsonProperty("applicationname")
    protected String applicationname;

    @JsonProperty("iscustomizable")
    protected BooleanManagedProperty iscustomizable;

    @JsonProperty("overwritetime")
    protected OffsetDateTime overwritetime;

    @JsonProperty("_modifiedonbehalfby_value")
    protected UUID _modifiedonbehalfby_value;

    @JsonProperty("solutionid")
    protected UUID solutionid;

    @JsonProperty("_createdby_value")
    protected UUID _createdby_value;

    @JsonProperty("ismanaged")
    protected Boolean ismanaged;

    @JsonProperty("applicationtype")
    protected Integer applicationtype;

    @JsonProperty("modifiedon")
    protected OffsetDateTime modifiedon;

    @JsonProperty("statecode")
    protected Integer statecode;

    @JsonProperty("overriddencreatedon")
    protected OffsetDateTime overriddencreatedon;

    protected Applicationuser() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderApplicationuser() {
        return new Builder();
    }

    public static final class Builder {
        private UUID _modifiedby_value;
        private UUID _createdonbehalfby_value;
        private Integer importsequencenumber;
        private UUID applicationid;
        private OffsetDateTime createdon;
        private Integer utcconversiontimezonecode;
        private UUID applicationuserid;
        private UUID _businessunitid_value;
        private Integer statuscode;
        private UUID componentidunique;
        private Long versionnumber;
        private Integer timezoneruleversionnumber;
        private Integer componentstate;
        private String applicationname;
        private BooleanManagedProperty iscustomizable;
        private OffsetDateTime overwritetime;
        private UUID _modifiedonbehalfby_value;
        private UUID solutionid;
        private UUID _createdby_value;
        private Boolean ismanaged;
        private Integer applicationtype;
        private OffsetDateTime modifiedon;
        private Integer statecode;
        private OffsetDateTime overriddencreatedon;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder _modifiedby_value(UUID _modifiedby_value) {
            this._modifiedby_value = _modifiedby_value;
            this.changedFields = changedFields.add("_modifiedby_value");
            return this;
        }

        public Builder _createdonbehalfby_value(UUID _createdonbehalfby_value) {
            this._createdonbehalfby_value = _createdonbehalfby_value;
            this.changedFields = changedFields.add("_createdonbehalfby_value");
            return this;
        }

        public Builder importsequencenumber(Integer importsequencenumber) {
            this.importsequencenumber = importsequencenumber;
            this.changedFields = changedFields.add("importsequencenumber");
            return this;
        }

        public Builder applicationid(UUID applicationid) {
            this.applicationid = applicationid;
            this.changedFields = changedFields.add("applicationid");
            return this;
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Builder utcconversiontimezonecode(Integer utcconversiontimezonecode) {
            this.utcconversiontimezonecode = utcconversiontimezonecode;
            this.changedFields = changedFields.add("utcconversiontimezonecode");
            return this;
        }

        public Builder applicationuserid(UUID applicationuserid) {
            this.applicationuserid = applicationuserid;
            this.changedFields = changedFields.add("applicationuserid");
            return this;
        }

        public Builder _businessunitid_value(UUID _businessunitid_value) {
            this._businessunitid_value = _businessunitid_value;
            this.changedFields = changedFields.add("_businessunitid_value");
            return this;
        }

        public Builder statuscode(Integer statuscode) {
            this.statuscode = statuscode;
            this.changedFields = changedFields.add("statuscode");
            return this;
        }

        public Builder componentidunique(UUID componentidunique) {
            this.componentidunique = componentidunique;
            this.changedFields = changedFields.add("componentidunique");
            return this;
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Builder timezoneruleversionnumber(Integer timezoneruleversionnumber) {
            this.timezoneruleversionnumber = timezoneruleversionnumber;
            this.changedFields = changedFields.add("timezoneruleversionnumber");
            return this;
        }

        public Builder componentstate(Integer componentstate) {
            this.componentstate = componentstate;
            this.changedFields = changedFields.add("componentstate");
            return this;
        }

        public Builder applicationname(String applicationname) {
            this.applicationname = applicationname;
            this.changedFields = changedFields.add("applicationname");
            return this;
        }

        public Builder iscustomizable(BooleanManagedProperty iscustomizable) {
            this.iscustomizable = iscustomizable;
            this.changedFields = changedFields.add("iscustomizable");
            return this;
        }

        public Builder overwritetime(OffsetDateTime overwritetime) {
            this.overwritetime = overwritetime;
            this.changedFields = changedFields.add("overwritetime");
            return this;
        }

        public Builder _modifiedonbehalfby_value(UUID _modifiedonbehalfby_value) {
            this._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            this.changedFields = changedFields.add("_modifiedonbehalfby_value");
            return this;
        }

        public Builder solutionid(UUID solutionid) {
            this.solutionid = solutionid;
            this.changedFields = changedFields.add("solutionid");
            return this;
        }

        public Builder _createdby_value(UUID _createdby_value) {
            this._createdby_value = _createdby_value;
            this.changedFields = changedFields.add("_createdby_value");
            return this;
        }

        public Builder ismanaged(Boolean ismanaged) {
            this.ismanaged = ismanaged;
            this.changedFields = changedFields.add("ismanaged");
            return this;
        }

        public Builder applicationtype(Integer applicationtype) {
            this.applicationtype = applicationtype;
            this.changedFields = changedFields.add("applicationtype");
            return this;
        }

        public Builder modifiedon(OffsetDateTime modifiedon) {
            this.modifiedon = modifiedon;
            this.changedFields = changedFields.add("modifiedon");
            return this;
        }

        public Builder statecode(Integer statecode) {
            this.statecode = statecode;
            this.changedFields = changedFields.add("statecode");
            return this;
        }

        public Builder overriddencreatedon(OffsetDateTime overriddencreatedon) {
            this.overriddencreatedon = overriddencreatedon;
            this.changedFields = changedFields.add("overriddencreatedon");
            return this;
        }

        public Applicationuser build() {
            Applicationuser _x = new Applicationuser();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.applicationuser";
            _x._modifiedby_value = _modifiedby_value;
            _x._createdonbehalfby_value = _createdonbehalfby_value;
            _x.importsequencenumber = importsequencenumber;
            _x.applicationid = applicationid;
            _x.createdon = createdon;
            _x.utcconversiontimezonecode = utcconversiontimezonecode;
            _x.applicationuserid = applicationuserid;
            _x._businessunitid_value = _businessunitid_value;
            _x.statuscode = statuscode;
            _x.componentidunique = componentidunique;
            _x.versionnumber = versionnumber;
            _x.timezoneruleversionnumber = timezoneruleversionnumber;
            _x.componentstate = componentstate;
            _x.applicationname = applicationname;
            _x.iscustomizable = iscustomizable;
            _x.overwritetime = overwritetime;
            _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            _x.solutionid = solutionid;
            _x._createdby_value = _createdby_value;
            _x.ismanaged = ismanaged;
            _x.applicationtype = applicationtype;
            _x.modifiedon = modifiedon;
            _x.statecode = statecode;
            _x.overriddencreatedon = overriddencreatedon;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && applicationuserid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(applicationuserid, UUID.class));
        }
    }

    @Property(name="_modifiedby_value")
    @JsonIgnore
    public Optional<UUID> get_modifiedby_value() {
        return Optional.ofNullable(_modifiedby_value);
    }

    public Applicationuser with_modifiedby_value(UUID _modifiedby_value) {
        Applicationuser _x = _copy();
        _x.changedFields = changedFields.add("_modifiedby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.applicationuser");
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    @Property(name="_createdonbehalfby_value")
    @JsonIgnore
    public Optional<UUID> get_createdonbehalfby_value() {
        return Optional.ofNullable(_createdonbehalfby_value);
    }

    public Applicationuser with_createdonbehalfby_value(UUID _createdonbehalfby_value) {
        Applicationuser _x = _copy();
        _x.changedFields = changedFields.add("_createdonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.applicationuser");
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        return _x;
    }

    @Property(name="importsequencenumber")
    @JsonIgnore
    public Optional<Integer> getImportsequencenumber() {
        return Optional.ofNullable(importsequencenumber);
    }

    public Applicationuser withImportsequencenumber(Integer importsequencenumber) {
        Applicationuser _x = _copy();
        _x.changedFields = changedFields.add("importsequencenumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.applicationuser");
        _x.importsequencenumber = importsequencenumber;
        return _x;
    }

    @Property(name="applicationid")
    @JsonIgnore
    public Optional<UUID> getApplicationid() {
        return Optional.ofNullable(applicationid);
    }

    public Applicationuser withApplicationid(UUID applicationid) {
        Applicationuser _x = _copy();
        _x.changedFields = changedFields.add("applicationid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.applicationuser");
        _x.applicationid = applicationid;
        return _x;
    }

    @Property(name="createdon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedon() {
        return Optional.ofNullable(createdon);
    }

    public Applicationuser withCreatedon(OffsetDateTime createdon) {
        Applicationuser _x = _copy();
        _x.changedFields = changedFields.add("createdon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.applicationuser");
        _x.createdon = createdon;
        return _x;
    }

    @Property(name="utcconversiontimezonecode")
    @JsonIgnore
    public Optional<Integer> getUtcconversiontimezonecode() {
        return Optional.ofNullable(utcconversiontimezonecode);
    }

    public Applicationuser withUtcconversiontimezonecode(Integer utcconversiontimezonecode) {
        Applicationuser _x = _copy();
        _x.changedFields = changedFields.add("utcconversiontimezonecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.applicationuser");
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        return _x;
    }

    @Property(name="applicationuserid")
    @JsonIgnore
    public Optional<UUID> getApplicationuserid() {
        return Optional.ofNullable(applicationuserid);
    }

    public Applicationuser withApplicationuserid(UUID applicationuserid) {
        Applicationuser _x = _copy();
        _x.changedFields = changedFields.add("applicationuserid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.applicationuser");
        _x.applicationuserid = applicationuserid;
        return _x;
    }

    @Property(name="_businessunitid_value")
    @JsonIgnore
    public Optional<UUID> get_businessunitid_value() {
        return Optional.ofNullable(_businessunitid_value);
    }

    public Applicationuser with_businessunitid_value(UUID _businessunitid_value) {
        Applicationuser _x = _copy();
        _x.changedFields = changedFields.add("_businessunitid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.applicationuser");
        _x._businessunitid_value = _businessunitid_value;
        return _x;
    }

    @Property(name="statuscode")
    @JsonIgnore
    public Optional<Integer> getStatuscode() {
        return Optional.ofNullable(statuscode);
    }

    public Applicationuser withStatuscode(Integer statuscode) {
        Applicationuser _x = _copy();
        _x.changedFields = changedFields.add("statuscode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.applicationuser");
        _x.statuscode = statuscode;
        return _x;
    }

    @Property(name="componentidunique")
    @JsonIgnore
    public Optional<UUID> getComponentidunique() {
        return Optional.ofNullable(componentidunique);
    }

    public Applicationuser withComponentidunique(UUID componentidunique) {
        Applicationuser _x = _copy();
        _x.changedFields = changedFields.add("componentidunique");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.applicationuser");
        _x.componentidunique = componentidunique;
        return _x;
    }

    @Property(name="versionnumber")
    @JsonIgnore
    public Optional<Long> getVersionnumber() {
        return Optional.ofNullable(versionnumber);
    }

    public Applicationuser withVersionnumber(Long versionnumber) {
        Applicationuser _x = _copy();
        _x.changedFields = changedFields.add("versionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.applicationuser");
        _x.versionnumber = versionnumber;
        return _x;
    }

    @Property(name="timezoneruleversionnumber")
    @JsonIgnore
    public Optional<Integer> getTimezoneruleversionnumber() {
        return Optional.ofNullable(timezoneruleversionnumber);
    }

    public Applicationuser withTimezoneruleversionnumber(Integer timezoneruleversionnumber) {
        Applicationuser _x = _copy();
        _x.changedFields = changedFields.add("timezoneruleversionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.applicationuser");
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        return _x;
    }

    @Property(name="componentstate")
    @JsonIgnore
    public Optional<Integer> getComponentstate() {
        return Optional.ofNullable(componentstate);
    }

    public Applicationuser withComponentstate(Integer componentstate) {
        Applicationuser _x = _copy();
        _x.changedFields = changedFields.add("componentstate");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.applicationuser");
        _x.componentstate = componentstate;
        return _x;
    }

    @Property(name="applicationname")
    @JsonIgnore
    public Optional<String> getApplicationname() {
        return Optional.ofNullable(applicationname);
    }

    public Applicationuser withApplicationname(String applicationname) {
        Checks.checkIsAscii(applicationname);
        Applicationuser _x = _copy();
        _x.changedFields = changedFields.add("applicationname");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.applicationuser");
        _x.applicationname = applicationname;
        return _x;
    }

    @Property(name="iscustomizable")
    @JsonIgnore
    public Optional<BooleanManagedProperty> getIscustomizable() {
        return Optional.ofNullable(iscustomizable);
    }

    public Applicationuser withIscustomizable(BooleanManagedProperty iscustomizable) {
        Applicationuser _x = _copy();
        _x.changedFields = changedFields.add("iscustomizable");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.applicationuser");
        _x.iscustomizable = iscustomizable;
        return _x;
    }

    @Property(name="overwritetime")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverwritetime() {
        return Optional.ofNullable(overwritetime);
    }

    public Applicationuser withOverwritetime(OffsetDateTime overwritetime) {
        Applicationuser _x = _copy();
        _x.changedFields = changedFields.add("overwritetime");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.applicationuser");
        _x.overwritetime = overwritetime;
        return _x;
    }

    @Property(name="_modifiedonbehalfby_value")
    @JsonIgnore
    public Optional<UUID> get_modifiedonbehalfby_value() {
        return Optional.ofNullable(_modifiedonbehalfby_value);
    }

    public Applicationuser with_modifiedonbehalfby_value(UUID _modifiedonbehalfby_value) {
        Applicationuser _x = _copy();
        _x.changedFields = changedFields.add("_modifiedonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.applicationuser");
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        return _x;
    }

    @Property(name="solutionid")
    @JsonIgnore
    public Optional<UUID> getSolutionid() {
        return Optional.ofNullable(solutionid);
    }

    public Applicationuser withSolutionid(UUID solutionid) {
        Applicationuser _x = _copy();
        _x.changedFields = changedFields.add("solutionid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.applicationuser");
        _x.solutionid = solutionid;
        return _x;
    }

    @Property(name="_createdby_value")
    @JsonIgnore
    public Optional<UUID> get_createdby_value() {
        return Optional.ofNullable(_createdby_value);
    }

    public Applicationuser with_createdby_value(UUID _createdby_value) {
        Applicationuser _x = _copy();
        _x.changedFields = changedFields.add("_createdby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.applicationuser");
        _x._createdby_value = _createdby_value;
        return _x;
    }

    @Property(name="ismanaged")
    @JsonIgnore
    public Optional<Boolean> getIsmanaged() {
        return Optional.ofNullable(ismanaged);
    }

    public Applicationuser withIsmanaged(Boolean ismanaged) {
        Applicationuser _x = _copy();
        _x.changedFields = changedFields.add("ismanaged");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.applicationuser");
        _x.ismanaged = ismanaged;
        return _x;
    }

    @Property(name="applicationtype")
    @JsonIgnore
    public Optional<Integer> getApplicationtype() {
        return Optional.ofNullable(applicationtype);
    }

    public Applicationuser withApplicationtype(Integer applicationtype) {
        Applicationuser _x = _copy();
        _x.changedFields = changedFields.add("applicationtype");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.applicationuser");
        _x.applicationtype = applicationtype;
        return _x;
    }

    @Property(name="modifiedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedon() {
        return Optional.ofNullable(modifiedon);
    }

    public Applicationuser withModifiedon(OffsetDateTime modifiedon) {
        Applicationuser _x = _copy();
        _x.changedFields = changedFields.add("modifiedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.applicationuser");
        _x.modifiedon = modifiedon;
        return _x;
    }

    @Property(name="statecode")
    @JsonIgnore
    public Optional<Integer> getStatecode() {
        return Optional.ofNullable(statecode);
    }

    public Applicationuser withStatecode(Integer statecode) {
        Applicationuser _x = _copy();
        _x.changedFields = changedFields.add("statecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.applicationuser");
        _x.statecode = statecode;
        return _x;
    }

    @Property(name="overriddencreatedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverriddencreatedon() {
        return Optional.ofNullable(overriddencreatedon);
    }

    public Applicationuser withOverriddencreatedon(OffsetDateTime overriddencreatedon) {
        Applicationuser _x = _copy();
        _x.changedFields = changedFields.add("overriddencreatedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.applicationuser");
        _x.overriddencreatedon = overriddencreatedon;
        return _x;
    }

    public Applicationuser withUnmappedField(String name, String value) {
        Applicationuser _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="createdby")
    @JsonIgnore
    public SystemuserRequest getCreatedby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), RequestHelper.getValue(unmappedFields, "createdby"));
    }

    @NavigationProperty(name="createdonbehalfby")
    @JsonIgnore
    public SystemuserRequest getCreatedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), RequestHelper.getValue(unmappedFields, "createdonbehalfby"));
    }

    @NavigationProperty(name="modifiedby")
    @JsonIgnore
    public SystemuserRequest getModifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), RequestHelper.getValue(unmappedFields, "modifiedby"));
    }

    @NavigationProperty(name="modifiedonbehalfby")
    @JsonIgnore
    public SystemuserRequest getModifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), RequestHelper.getValue(unmappedFields, "modifiedonbehalfby"));
    }

    @NavigationProperty(name="businessunitid")
    @JsonIgnore
    public BusinessunitRequest getBusinessunitid() {
        return new BusinessunitRequest(contextPath.addSegment("businessunitid"), RequestHelper.getValue(unmappedFields, "businessunitid"));
    }

    @NavigationProperty(name="applicationuser_SyncErrors")
    @JsonIgnore
    public SyncerrorCollectionRequest getApplicationuser_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("applicationuser_SyncErrors"), RequestHelper.getValue(unmappedFields, "applicationuser_SyncErrors"));
    }

    @NavigationProperty(name="applicationuser_DuplicateMatchingRecord")
    @JsonIgnore
    public DuplicaterecordCollectionRequest getApplicationuser_DuplicateMatchingRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("applicationuser_DuplicateMatchingRecord"), RequestHelper.getValue(unmappedFields, "applicationuser_DuplicateMatchingRecord"));
    }

    @NavigationProperty(name="applicationuser_DuplicateBaseRecord")
    @JsonIgnore
    public DuplicaterecordCollectionRequest getApplicationuser_DuplicateBaseRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("applicationuser_DuplicateBaseRecord"), RequestHelper.getValue(unmappedFields, "applicationuser_DuplicateBaseRecord"));
    }

    @NavigationProperty(name="applicationuser_AsyncOperations")
    @JsonIgnore
    public AsyncoperationCollectionRequest getApplicationuser_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("applicationuser_AsyncOperations"), RequestHelper.getValue(unmappedFields, "applicationuser_AsyncOperations"));
    }

    @NavigationProperty(name="applicationuser_MailboxTrackingFolders")
    @JsonIgnore
    public MailboxtrackingfolderCollectionRequest getApplicationuser_MailboxTrackingFolders() {
        return new MailboxtrackingfolderCollectionRequest(
                        contextPath.addSegment("applicationuser_MailboxTrackingFolders"), RequestHelper.getValue(unmappedFields, "applicationuser_MailboxTrackingFolders"));
    }

    @NavigationProperty(name="applicationuser_ProcessSession")
    @JsonIgnore
    public ProcesssessionCollectionRequest getApplicationuser_ProcessSession() {
        return new ProcesssessionCollectionRequest(
                        contextPath.addSegment("applicationuser_ProcessSession"), RequestHelper.getValue(unmappedFields, "applicationuser_ProcessSession"));
    }

    @NavigationProperty(name="applicationuser_BulkDeleteFailures")
    @JsonIgnore
    public BulkdeletefailureCollectionRequest getApplicationuser_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(
                        contextPath.addSegment("applicationuser_BulkDeleteFailures"), RequestHelper.getValue(unmappedFields, "applicationuser_BulkDeleteFailures"));
    }

    @NavigationProperty(name="applicationuser_PrincipalObjectAttributeAccesses")
    @JsonIgnore
    public PrincipalobjectattributeaccessCollectionRequest getApplicationuser_PrincipalObjectAttributeAccesses() {
        return new PrincipalobjectattributeaccessCollectionRequest(
                        contextPath.addSegment("applicationuser_PrincipalObjectAttributeAccesses"), RequestHelper.getValue(unmappedFields, "applicationuser_PrincipalObjectAttributeAccesses"));
    }

    @NavigationProperty(name="applicationuserrole")
    @JsonIgnore
    public RoleCollectionRequest getApplicationuserrole() {
        return new RoleCollectionRequest(
                        contextPath.addSegment("applicationuserrole"), RequestHelper.getValue(unmappedFields, "applicationuserrole"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Applicationuser patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Applicationuser _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Applicationuser put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Applicationuser _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Applicationuser _copy() {
        Applicationuser _x = new Applicationuser();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x._modifiedby_value = _modifiedby_value;
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        _x.importsequencenumber = importsequencenumber;
        _x.applicationid = applicationid;
        _x.createdon = createdon;
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        _x.applicationuserid = applicationuserid;
        _x._businessunitid_value = _businessunitid_value;
        _x.statuscode = statuscode;
        _x.componentidunique = componentidunique;
        _x.versionnumber = versionnumber;
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        _x.componentstate = componentstate;
        _x.applicationname = applicationname;
        _x.iscustomizable = iscustomizable;
        _x.overwritetime = overwritetime;
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        _x.solutionid = solutionid;
        _x._createdby_value = _createdby_value;
        _x.ismanaged = ismanaged;
        _x.applicationtype = applicationtype;
        _x.modifiedon = modifiedon;
        _x.statecode = statecode;
        _x.overriddencreatedon = overriddencreatedon;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Applicationuser[");
        b.append("_modifiedby_value=");
        b.append(this._modifiedby_value);
        b.append(", ");
        b.append("_createdonbehalfby_value=");
        b.append(this._createdonbehalfby_value);
        b.append(", ");
        b.append("importsequencenumber=");
        b.append(this.importsequencenumber);
        b.append(", ");
        b.append("applicationid=");
        b.append(this.applicationid);
        b.append(", ");
        b.append("createdon=");
        b.append(this.createdon);
        b.append(", ");
        b.append("utcconversiontimezonecode=");
        b.append(this.utcconversiontimezonecode);
        b.append(", ");
        b.append("applicationuserid=");
        b.append(this.applicationuserid);
        b.append(", ");
        b.append("_businessunitid_value=");
        b.append(this._businessunitid_value);
        b.append(", ");
        b.append("statuscode=");
        b.append(this.statuscode);
        b.append(", ");
        b.append("componentidunique=");
        b.append(this.componentidunique);
        b.append(", ");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append(", ");
        b.append("timezoneruleversionnumber=");
        b.append(this.timezoneruleversionnumber);
        b.append(", ");
        b.append("componentstate=");
        b.append(this.componentstate);
        b.append(", ");
        b.append("applicationname=");
        b.append(this.applicationname);
        b.append(", ");
        b.append("iscustomizable=");
        b.append(this.iscustomizable);
        b.append(", ");
        b.append("overwritetime=");
        b.append(this.overwritetime);
        b.append(", ");
        b.append("_modifiedonbehalfby_value=");
        b.append(this._modifiedonbehalfby_value);
        b.append(", ");
        b.append("solutionid=");
        b.append(this.solutionid);
        b.append(", ");
        b.append("_createdby_value=");
        b.append(this._createdby_value);
        b.append(", ");
        b.append("ismanaged=");
        b.append(this.ismanaged);
        b.append(", ");
        b.append("applicationtype=");
        b.append(this.applicationtype);
        b.append(", ");
        b.append("modifiedon=");
        b.append(this.modifiedon);
        b.append(", ");
        b.append("statecode=");
        b.append(this.statecode);
        b.append(", ");
        b.append("overriddencreatedon=");
        b.append(this.overriddencreatedon);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
