package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "AttributeMappings"})
@JsonInclude(Include.NON_NULL)
public class RetrievePrincipalSyncAttributeMappingsResponse implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("AttributeMappings")
    protected List<AttributeMapping> attributeMappings;

    @JsonProperty("AttributeMappings@nextLink")
    protected String attributeMappingsNextLink;

    protected RetrievePrincipalSyncAttributeMappingsResponse() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.RetrievePrincipalSyncAttributeMappingsResponse";
    }

    @Property(name="AttributeMappings")
    @JsonIgnore
    public CollectionPage<AttributeMapping> getAttributeMappings() {
        return new CollectionPage<AttributeMapping>(contextPath, AttributeMapping.class, this.attributeMappings, Optional.ofNullable(attributeMappingsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="AttributeMappings")
    @JsonIgnore
    public CollectionPage<AttributeMapping> getAttributeMappings(HttpRequestOptions options) {
        return new CollectionPage<AttributeMapping>(contextPath, AttributeMapping.class, this.attributeMappings, Optional.ofNullable(attributeMappingsNextLink), Collections.emptyList(), options);
    }

    public RetrievePrincipalSyncAttributeMappingsResponse withUnmappedField(String name, String value) {
        RetrievePrincipalSyncAttributeMappingsResponse _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<AttributeMapping> attributeMappings;
        private String attributeMappingsNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder attributeMappings(List<AttributeMapping> attributeMappings) {
            this.attributeMappings = attributeMappings;
            this.changedFields = changedFields.add("AttributeMappings");
            return this;
        }

        public Builder attributeMappings(AttributeMapping... attributeMappings) {
            return attributeMappings(Arrays.asList(attributeMappings));
        }

        public Builder attributeMappingsNextLink(String attributeMappingsNextLink) {
            this.attributeMappingsNextLink = attributeMappingsNextLink;
            this.changedFields = changedFields.add("AttributeMappings");
            return this;
        }

        public RetrievePrincipalSyncAttributeMappingsResponse build() {
            RetrievePrincipalSyncAttributeMappingsResponse _x = new RetrievePrincipalSyncAttributeMappingsResponse();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.RetrievePrincipalSyncAttributeMappingsResponse";
            _x.attributeMappings = attributeMappings;
            _x.attributeMappingsNextLink = attributeMappingsNextLink;
            return _x;
        }
    }

    private RetrievePrincipalSyncAttributeMappingsResponse _copy() {
        RetrievePrincipalSyncAttributeMappingsResponse _x = new RetrievePrincipalSyncAttributeMappingsResponse();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.attributeMappings = attributeMappings;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("RetrievePrincipalSyncAttributeMappingsResponse[");
        b.append("AttributeMappings=");
        b.append(this.attributeMappings);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
