package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.enums.AttributeTypeCode;

@JsonPropertyOrder({
    "@odata.type", 
    "AttributeOf", 
    "AttributeType", 
    "AttributeTypeName", 
    "ColumnNumber", 
    "Description", 
    "DisplayName", 
    "DeprecatedVersion", 
    "IntroducedVersion", 
    "EntityLogicalName", 
    "IsAuditEnabled", 
    "IsCustomAttribute", 
    "IsPrimaryId", 
    "IsPrimaryName", 
    "IsValidForCreate", 
    "IsValidForRead", 
    "IsValidForUpdate", 
    "CanBeSecuredForRead", 
    "CanBeSecuredForCreate", 
    "CanBeSecuredForUpdate", 
    "IsSecured", 
    "IsRetrievable", 
    "IsFilterable", 
    "IsSearchable", 
    "IsManaged", 
    "IsGlobalFilterEnabled", 
    "IsSortableEnabled", 
    "LinkedAttributeId", 
    "LogicalName", 
    "IsCustomizable", 
    "IsRenameable", 
    "IsValidForAdvancedFind", 
    "IsValidForForm", 
    "IsRequiredForForm", 
    "IsValidForGrid", 
    "RequiredLevel", 
    "CanModifyAdditionalSettings", 
    "SchemaName", 
    "ExternalName", 
    "IsLogical", 
    "IsDataSourceSecret", 
    "InheritsFrom", 
    "CreatedOn", 
    "ModifiedOn", 
    "SourceType", 
    "AutoNumberFormat", 
    "MetadataId", 
    "HasChanged"})
@JsonInclude(Include.NON_NULL)
public class ComplexAttributeMetadata implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("AttributeOf")
    protected String attributeOf;

    @JsonProperty("AttributeType")
    protected AttributeTypeCode attributeType;

    @JsonProperty("AttributeTypeName")
    protected AttributeTypeDisplayName attributeTypeName;

    @JsonProperty("ColumnNumber")
    protected Integer columnNumber;

    @JsonProperty("Description")
    protected Label description;

    @JsonProperty("DisplayName")
    protected Label displayName;

    @JsonProperty("DeprecatedVersion")
    protected String deprecatedVersion;

    @JsonProperty("IntroducedVersion")
    protected String introducedVersion;

    @JsonProperty("EntityLogicalName")
    protected String entityLogicalName;

    @JsonProperty("IsAuditEnabled")
    protected BooleanManagedProperty isAuditEnabled;

    @JsonProperty("IsCustomAttribute")
    protected Boolean isCustomAttribute;

    @JsonProperty("IsPrimaryId")
    protected Boolean isPrimaryId;

    @JsonProperty("IsPrimaryName")
    protected Boolean isPrimaryName;

    @JsonProperty("IsValidForCreate")
    protected Boolean isValidForCreate;

    @JsonProperty("IsValidForRead")
    protected Boolean isValidForRead;

    @JsonProperty("IsValidForUpdate")
    protected Boolean isValidForUpdate;

    @JsonProperty("CanBeSecuredForRead")
    protected Boolean canBeSecuredForRead;

    @JsonProperty("CanBeSecuredForCreate")
    protected Boolean canBeSecuredForCreate;

    @JsonProperty("CanBeSecuredForUpdate")
    protected Boolean canBeSecuredForUpdate;

    @JsonProperty("IsSecured")
    protected Boolean isSecured;

    @JsonProperty("IsRetrievable")
    protected Boolean isRetrievable;

    @JsonProperty("IsFilterable")
    protected Boolean isFilterable;

    @JsonProperty("IsSearchable")
    protected Boolean isSearchable;

    @JsonProperty("IsManaged")
    protected Boolean isManaged;

    @JsonProperty("IsGlobalFilterEnabled")
    protected BooleanManagedProperty isGlobalFilterEnabled;

    @JsonProperty("IsSortableEnabled")
    protected BooleanManagedProperty isSortableEnabled;

    @JsonProperty("LinkedAttributeId")
    protected UUID linkedAttributeId;

    @JsonProperty("LogicalName")
    protected String logicalName;

    @JsonProperty("IsCustomizable")
    protected BooleanManagedProperty isCustomizable;

    @JsonProperty("IsRenameable")
    protected BooleanManagedProperty isRenameable;

    @JsonProperty("IsValidForAdvancedFind")
    protected BooleanManagedProperty isValidForAdvancedFind;

    @JsonProperty("IsValidForForm")
    protected Boolean isValidForForm;

    @JsonProperty("IsRequiredForForm")
    protected Boolean isRequiredForForm;

    @JsonProperty("IsValidForGrid")
    protected Boolean isValidForGrid;

    @JsonProperty("RequiredLevel")
    protected AttributeRequiredLevelManagedProperty requiredLevel;

    @JsonProperty("CanModifyAdditionalSettings")
    protected BooleanManagedProperty canModifyAdditionalSettings;

    @JsonProperty("SchemaName")
    protected String schemaName;

    @JsonProperty("ExternalName")
    protected String externalName;

    @JsonProperty("IsLogical")
    protected Boolean isLogical;

    @JsonProperty("IsDataSourceSecret")
    protected Boolean isDataSourceSecret;

    @JsonProperty("InheritsFrom")
    protected String inheritsFrom;

    @JsonProperty("CreatedOn")
    protected OffsetDateTime createdOn;

    @JsonProperty("ModifiedOn")
    protected OffsetDateTime modifiedOn;

    @JsonProperty("SourceType")
    protected Integer sourceType;

    @JsonProperty("AutoNumberFormat")
    protected String autoNumberFormat;

    @JsonProperty("MetadataId")
    protected UUID metadataId;

    @JsonProperty("HasChanged")
    protected Boolean hasChanged;

    protected ComplexAttributeMetadata() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.ComplexAttributeMetadata";
    }

    @Property(name="AttributeOf")
    @JsonIgnore
    public Optional<String> getAttributeOf() {
        return Optional.ofNullable(attributeOf);
    }

    public ComplexAttributeMetadata withAttributeOf(String attributeOf) {
        Checks.checkIsAscii(attributeOf);
        ComplexAttributeMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexAttributeMetadata");
        _x.attributeOf = attributeOf;
        return _x;
    }

    @Property(name="AttributeType")
    @JsonIgnore
    public Optional<AttributeTypeCode> getAttributeType() {
        return Optional.ofNullable(attributeType);
    }

    public ComplexAttributeMetadata withAttributeType(AttributeTypeCode attributeType) {
        ComplexAttributeMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexAttributeMetadata");
        _x.attributeType = attributeType;
        return _x;
    }

    @Property(name="AttributeTypeName")
    @JsonIgnore
    public Optional<AttributeTypeDisplayName> getAttributeTypeName() {
        return Optional.ofNullable(attributeTypeName);
    }

    public ComplexAttributeMetadata withAttributeTypeName(AttributeTypeDisplayName attributeTypeName) {
        ComplexAttributeMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexAttributeMetadata");
        _x.attributeTypeName = attributeTypeName;
        return _x;
    }

    @Property(name="ColumnNumber")
    @JsonIgnore
    public Optional<Integer> getColumnNumber() {
        return Optional.ofNullable(columnNumber);
    }

    public ComplexAttributeMetadata withColumnNumber(Integer columnNumber) {
        ComplexAttributeMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexAttributeMetadata");
        _x.columnNumber = columnNumber;
        return _x;
    }

    @Property(name="Description")
    @JsonIgnore
    public Optional<Label> getDescription() {
        return Optional.ofNullable(description);
    }

    public ComplexAttributeMetadata withDescription(Label description) {
        ComplexAttributeMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexAttributeMetadata");
        _x.description = description;
        return _x;
    }

    @Property(name="DisplayName")
    @JsonIgnore
    public Optional<Label> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public ComplexAttributeMetadata withDisplayName(Label displayName) {
        ComplexAttributeMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexAttributeMetadata");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="DeprecatedVersion")
    @JsonIgnore
    public Optional<String> getDeprecatedVersion() {
        return Optional.ofNullable(deprecatedVersion);
    }

    public ComplexAttributeMetadata withDeprecatedVersion(String deprecatedVersion) {
        Checks.checkIsAscii(deprecatedVersion);
        ComplexAttributeMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexAttributeMetadata");
        _x.deprecatedVersion = deprecatedVersion;
        return _x;
    }

    @Property(name="IntroducedVersion")
    @JsonIgnore
    public Optional<String> getIntroducedVersion() {
        return Optional.ofNullable(introducedVersion);
    }

    public ComplexAttributeMetadata withIntroducedVersion(String introducedVersion) {
        Checks.checkIsAscii(introducedVersion);
        ComplexAttributeMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexAttributeMetadata");
        _x.introducedVersion = introducedVersion;
        return _x;
    }

    @Property(name="EntityLogicalName")
    @JsonIgnore
    public Optional<String> getEntityLogicalName() {
        return Optional.ofNullable(entityLogicalName);
    }

    public ComplexAttributeMetadata withEntityLogicalName(String entityLogicalName) {
        Checks.checkIsAscii(entityLogicalName);
        ComplexAttributeMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexAttributeMetadata");
        _x.entityLogicalName = entityLogicalName;
        return _x;
    }

    @Property(name="IsAuditEnabled")
    @JsonIgnore
    public Optional<BooleanManagedProperty> getIsAuditEnabled() {
        return Optional.ofNullable(isAuditEnabled);
    }

    public ComplexAttributeMetadata withIsAuditEnabled(BooleanManagedProperty isAuditEnabled) {
        ComplexAttributeMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexAttributeMetadata");
        _x.isAuditEnabled = isAuditEnabled;
        return _x;
    }

    @Property(name="IsCustomAttribute")
    @JsonIgnore
    public Optional<Boolean> getIsCustomAttribute() {
        return Optional.ofNullable(isCustomAttribute);
    }

    public ComplexAttributeMetadata withIsCustomAttribute(Boolean isCustomAttribute) {
        ComplexAttributeMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexAttributeMetadata");
        _x.isCustomAttribute = isCustomAttribute;
        return _x;
    }

    @Property(name="IsPrimaryId")
    @JsonIgnore
    public Optional<Boolean> getIsPrimaryId() {
        return Optional.ofNullable(isPrimaryId);
    }

    public ComplexAttributeMetadata withIsPrimaryId(Boolean isPrimaryId) {
        ComplexAttributeMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexAttributeMetadata");
        _x.isPrimaryId = isPrimaryId;
        return _x;
    }

    @Property(name="IsPrimaryName")
    @JsonIgnore
    public Optional<Boolean> getIsPrimaryName() {
        return Optional.ofNullable(isPrimaryName);
    }

    public ComplexAttributeMetadata withIsPrimaryName(Boolean isPrimaryName) {
        ComplexAttributeMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexAttributeMetadata");
        _x.isPrimaryName = isPrimaryName;
        return _x;
    }

    @Property(name="IsValidForCreate")
    @JsonIgnore
    public Optional<Boolean> getIsValidForCreate() {
        return Optional.ofNullable(isValidForCreate);
    }

    public ComplexAttributeMetadata withIsValidForCreate(Boolean isValidForCreate) {
        ComplexAttributeMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexAttributeMetadata");
        _x.isValidForCreate = isValidForCreate;
        return _x;
    }

    @Property(name="IsValidForRead")
    @JsonIgnore
    public Optional<Boolean> getIsValidForRead() {
        return Optional.ofNullable(isValidForRead);
    }

    public ComplexAttributeMetadata withIsValidForRead(Boolean isValidForRead) {
        ComplexAttributeMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexAttributeMetadata");
        _x.isValidForRead = isValidForRead;
        return _x;
    }

    @Property(name="IsValidForUpdate")
    @JsonIgnore
    public Optional<Boolean> getIsValidForUpdate() {
        return Optional.ofNullable(isValidForUpdate);
    }

    public ComplexAttributeMetadata withIsValidForUpdate(Boolean isValidForUpdate) {
        ComplexAttributeMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexAttributeMetadata");
        _x.isValidForUpdate = isValidForUpdate;
        return _x;
    }

    @Property(name="CanBeSecuredForRead")
    @JsonIgnore
    public Optional<Boolean> getCanBeSecuredForRead() {
        return Optional.ofNullable(canBeSecuredForRead);
    }

    public ComplexAttributeMetadata withCanBeSecuredForRead(Boolean canBeSecuredForRead) {
        ComplexAttributeMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexAttributeMetadata");
        _x.canBeSecuredForRead = canBeSecuredForRead;
        return _x;
    }

    @Property(name="CanBeSecuredForCreate")
    @JsonIgnore
    public Optional<Boolean> getCanBeSecuredForCreate() {
        return Optional.ofNullable(canBeSecuredForCreate);
    }

    public ComplexAttributeMetadata withCanBeSecuredForCreate(Boolean canBeSecuredForCreate) {
        ComplexAttributeMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexAttributeMetadata");
        _x.canBeSecuredForCreate = canBeSecuredForCreate;
        return _x;
    }

    @Property(name="CanBeSecuredForUpdate")
    @JsonIgnore
    public Optional<Boolean> getCanBeSecuredForUpdate() {
        return Optional.ofNullable(canBeSecuredForUpdate);
    }

    public ComplexAttributeMetadata withCanBeSecuredForUpdate(Boolean canBeSecuredForUpdate) {
        ComplexAttributeMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexAttributeMetadata");
        _x.canBeSecuredForUpdate = canBeSecuredForUpdate;
        return _x;
    }

    @Property(name="IsSecured")
    @JsonIgnore
    public Optional<Boolean> getIsSecured() {
        return Optional.ofNullable(isSecured);
    }

    public ComplexAttributeMetadata withIsSecured(Boolean isSecured) {
        ComplexAttributeMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexAttributeMetadata");
        _x.isSecured = isSecured;
        return _x;
    }

    @Property(name="IsRetrievable")
    @JsonIgnore
    public Optional<Boolean> getIsRetrievable() {
        return Optional.ofNullable(isRetrievable);
    }

    public ComplexAttributeMetadata withIsRetrievable(Boolean isRetrievable) {
        ComplexAttributeMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexAttributeMetadata");
        _x.isRetrievable = isRetrievable;
        return _x;
    }

    @Property(name="IsFilterable")
    @JsonIgnore
    public Optional<Boolean> getIsFilterable() {
        return Optional.ofNullable(isFilterable);
    }

    public ComplexAttributeMetadata withIsFilterable(Boolean isFilterable) {
        ComplexAttributeMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexAttributeMetadata");
        _x.isFilterable = isFilterable;
        return _x;
    }

    @Property(name="IsSearchable")
    @JsonIgnore
    public Optional<Boolean> getIsSearchable() {
        return Optional.ofNullable(isSearchable);
    }

    public ComplexAttributeMetadata withIsSearchable(Boolean isSearchable) {
        ComplexAttributeMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexAttributeMetadata");
        _x.isSearchable = isSearchable;
        return _x;
    }

    @Property(name="IsManaged")
    @JsonIgnore
    public Optional<Boolean> getIsManaged() {
        return Optional.ofNullable(isManaged);
    }

    public ComplexAttributeMetadata withIsManaged(Boolean isManaged) {
        ComplexAttributeMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexAttributeMetadata");
        _x.isManaged = isManaged;
        return _x;
    }

    @Property(name="IsGlobalFilterEnabled")
    @JsonIgnore
    public Optional<BooleanManagedProperty> getIsGlobalFilterEnabled() {
        return Optional.ofNullable(isGlobalFilterEnabled);
    }

    public ComplexAttributeMetadata withIsGlobalFilterEnabled(BooleanManagedProperty isGlobalFilterEnabled) {
        ComplexAttributeMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexAttributeMetadata");
        _x.isGlobalFilterEnabled = isGlobalFilterEnabled;
        return _x;
    }

    @Property(name="IsSortableEnabled")
    @JsonIgnore
    public Optional<BooleanManagedProperty> getIsSortableEnabled() {
        return Optional.ofNullable(isSortableEnabled);
    }

    public ComplexAttributeMetadata withIsSortableEnabled(BooleanManagedProperty isSortableEnabled) {
        ComplexAttributeMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexAttributeMetadata");
        _x.isSortableEnabled = isSortableEnabled;
        return _x;
    }

    @Property(name="LinkedAttributeId")
    @JsonIgnore
    public Optional<UUID> getLinkedAttributeId() {
        return Optional.ofNullable(linkedAttributeId);
    }

    public ComplexAttributeMetadata withLinkedAttributeId(UUID linkedAttributeId) {
        ComplexAttributeMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexAttributeMetadata");
        _x.linkedAttributeId = linkedAttributeId;
        return _x;
    }

    @Property(name="LogicalName")
    @JsonIgnore
    public Optional<String> getLogicalName() {
        return Optional.ofNullable(logicalName);
    }

    public ComplexAttributeMetadata withLogicalName(String logicalName) {
        Checks.checkIsAscii(logicalName);
        ComplexAttributeMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexAttributeMetadata");
        _x.logicalName = logicalName;
        return _x;
    }

    @Property(name="IsCustomizable")
    @JsonIgnore
    public Optional<BooleanManagedProperty> getIsCustomizable() {
        return Optional.ofNullable(isCustomizable);
    }

    public ComplexAttributeMetadata withIsCustomizable(BooleanManagedProperty isCustomizable) {
        ComplexAttributeMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexAttributeMetadata");
        _x.isCustomizable = isCustomizable;
        return _x;
    }

    @Property(name="IsRenameable")
    @JsonIgnore
    public Optional<BooleanManagedProperty> getIsRenameable() {
        return Optional.ofNullable(isRenameable);
    }

    public ComplexAttributeMetadata withIsRenameable(BooleanManagedProperty isRenameable) {
        ComplexAttributeMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexAttributeMetadata");
        _x.isRenameable = isRenameable;
        return _x;
    }

    @Property(name="IsValidForAdvancedFind")
    @JsonIgnore
    public Optional<BooleanManagedProperty> getIsValidForAdvancedFind() {
        return Optional.ofNullable(isValidForAdvancedFind);
    }

    public ComplexAttributeMetadata withIsValidForAdvancedFind(BooleanManagedProperty isValidForAdvancedFind) {
        ComplexAttributeMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexAttributeMetadata");
        _x.isValidForAdvancedFind = isValidForAdvancedFind;
        return _x;
    }

    @Property(name="IsValidForForm")
    @JsonIgnore
    public Optional<Boolean> getIsValidForForm() {
        return Optional.ofNullable(isValidForForm);
    }

    public ComplexAttributeMetadata withIsValidForForm(Boolean isValidForForm) {
        ComplexAttributeMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexAttributeMetadata");
        _x.isValidForForm = isValidForForm;
        return _x;
    }

    @Property(name="IsRequiredForForm")
    @JsonIgnore
    public Optional<Boolean> getIsRequiredForForm() {
        return Optional.ofNullable(isRequiredForForm);
    }

    public ComplexAttributeMetadata withIsRequiredForForm(Boolean isRequiredForForm) {
        ComplexAttributeMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexAttributeMetadata");
        _x.isRequiredForForm = isRequiredForForm;
        return _x;
    }

    @Property(name="IsValidForGrid")
    @JsonIgnore
    public Optional<Boolean> getIsValidForGrid() {
        return Optional.ofNullable(isValidForGrid);
    }

    public ComplexAttributeMetadata withIsValidForGrid(Boolean isValidForGrid) {
        ComplexAttributeMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexAttributeMetadata");
        _x.isValidForGrid = isValidForGrid;
        return _x;
    }

    @Property(name="RequiredLevel")
    @JsonIgnore
    public Optional<AttributeRequiredLevelManagedProperty> getRequiredLevel() {
        return Optional.ofNullable(requiredLevel);
    }

    public ComplexAttributeMetadata withRequiredLevel(AttributeRequiredLevelManagedProperty requiredLevel) {
        ComplexAttributeMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexAttributeMetadata");
        _x.requiredLevel = requiredLevel;
        return _x;
    }

    @Property(name="CanModifyAdditionalSettings")
    @JsonIgnore
    public Optional<BooleanManagedProperty> getCanModifyAdditionalSettings() {
        return Optional.ofNullable(canModifyAdditionalSettings);
    }

    public ComplexAttributeMetadata withCanModifyAdditionalSettings(BooleanManagedProperty canModifyAdditionalSettings) {
        ComplexAttributeMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexAttributeMetadata");
        _x.canModifyAdditionalSettings = canModifyAdditionalSettings;
        return _x;
    }

    @Property(name="SchemaName")
    @JsonIgnore
    public Optional<String> getSchemaName() {
        return Optional.ofNullable(schemaName);
    }

    public ComplexAttributeMetadata withSchemaName(String schemaName) {
        Checks.checkIsAscii(schemaName);
        ComplexAttributeMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexAttributeMetadata");
        _x.schemaName = schemaName;
        return _x;
    }

    @Property(name="ExternalName")
    @JsonIgnore
    public Optional<String> getExternalName() {
        return Optional.ofNullable(externalName);
    }

    public ComplexAttributeMetadata withExternalName(String externalName) {
        Checks.checkIsAscii(externalName);
        ComplexAttributeMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexAttributeMetadata");
        _x.externalName = externalName;
        return _x;
    }

    @Property(name="IsLogical")
    @JsonIgnore
    public Optional<Boolean> getIsLogical() {
        return Optional.ofNullable(isLogical);
    }

    public ComplexAttributeMetadata withIsLogical(Boolean isLogical) {
        ComplexAttributeMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexAttributeMetadata");
        _x.isLogical = isLogical;
        return _x;
    }

    @Property(name="IsDataSourceSecret")
    @JsonIgnore
    public Optional<Boolean> getIsDataSourceSecret() {
        return Optional.ofNullable(isDataSourceSecret);
    }

    public ComplexAttributeMetadata withIsDataSourceSecret(Boolean isDataSourceSecret) {
        ComplexAttributeMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexAttributeMetadata");
        _x.isDataSourceSecret = isDataSourceSecret;
        return _x;
    }

    @Property(name="InheritsFrom")
    @JsonIgnore
    public Optional<String> getInheritsFrom() {
        return Optional.ofNullable(inheritsFrom);
    }

    public ComplexAttributeMetadata withInheritsFrom(String inheritsFrom) {
        Checks.checkIsAscii(inheritsFrom);
        ComplexAttributeMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexAttributeMetadata");
        _x.inheritsFrom = inheritsFrom;
        return _x;
    }

    @Property(name="CreatedOn")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedOn() {
        return Optional.ofNullable(createdOn);
    }

    public ComplexAttributeMetadata withCreatedOn(OffsetDateTime createdOn) {
        ComplexAttributeMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexAttributeMetadata");
        _x.createdOn = createdOn;
        return _x;
    }

    @Property(name="ModifiedOn")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedOn() {
        return Optional.ofNullable(modifiedOn);
    }

    public ComplexAttributeMetadata withModifiedOn(OffsetDateTime modifiedOn) {
        ComplexAttributeMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexAttributeMetadata");
        _x.modifiedOn = modifiedOn;
        return _x;
    }

    @Property(name="SourceType")
    @JsonIgnore
    public Optional<Integer> getSourceType() {
        return Optional.ofNullable(sourceType);
    }

    public ComplexAttributeMetadata withSourceType(Integer sourceType) {
        ComplexAttributeMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexAttributeMetadata");
        _x.sourceType = sourceType;
        return _x;
    }

    @Property(name="AutoNumberFormat")
    @JsonIgnore
    public Optional<String> getAutoNumberFormat() {
        return Optional.ofNullable(autoNumberFormat);
    }

    public ComplexAttributeMetadata withAutoNumberFormat(String autoNumberFormat) {
        Checks.checkIsAscii(autoNumberFormat);
        ComplexAttributeMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexAttributeMetadata");
        _x.autoNumberFormat = autoNumberFormat;
        return _x;
    }

    @Property(name="MetadataId")
    @JsonIgnore
    public Optional<UUID> getMetadataId() {
        return Optional.ofNullable(metadataId);
    }

    public ComplexAttributeMetadata withMetadataId(UUID metadataId) {
        ComplexAttributeMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexAttributeMetadata");
        _x.metadataId = metadataId;
        return _x;
    }

    @Property(name="HasChanged")
    @JsonIgnore
    public Optional<Boolean> getHasChanged() {
        return Optional.ofNullable(hasChanged);
    }

    public ComplexAttributeMetadata withHasChanged(Boolean hasChanged) {
        ComplexAttributeMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexAttributeMetadata");
        _x.hasChanged = hasChanged;
        return _x;
    }

    public ComplexAttributeMetadata withUnmappedField(String name, String value) {
        ComplexAttributeMetadata _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String attributeOf;
        private AttributeTypeCode attributeType;
        private AttributeTypeDisplayName attributeTypeName;
        private Integer columnNumber;
        private Label description;
        private Label displayName;
        private String deprecatedVersion;
        private String introducedVersion;
        private String entityLogicalName;
        private BooleanManagedProperty isAuditEnabled;
        private Boolean isCustomAttribute;
        private Boolean isPrimaryId;
        private Boolean isPrimaryName;
        private Boolean isValidForCreate;
        private Boolean isValidForRead;
        private Boolean isValidForUpdate;
        private Boolean canBeSecuredForRead;
        private Boolean canBeSecuredForCreate;
        private Boolean canBeSecuredForUpdate;
        private Boolean isSecured;
        private Boolean isRetrievable;
        private Boolean isFilterable;
        private Boolean isSearchable;
        private Boolean isManaged;
        private BooleanManagedProperty isGlobalFilterEnabled;
        private BooleanManagedProperty isSortableEnabled;
        private UUID linkedAttributeId;
        private String logicalName;
        private BooleanManagedProperty isCustomizable;
        private BooleanManagedProperty isRenameable;
        private BooleanManagedProperty isValidForAdvancedFind;
        private Boolean isValidForForm;
        private Boolean isRequiredForForm;
        private Boolean isValidForGrid;
        private AttributeRequiredLevelManagedProperty requiredLevel;
        private BooleanManagedProperty canModifyAdditionalSettings;
        private String schemaName;
        private String externalName;
        private Boolean isLogical;
        private Boolean isDataSourceSecret;
        private String inheritsFrom;
        private OffsetDateTime createdOn;
        private OffsetDateTime modifiedOn;
        private Integer sourceType;
        private String autoNumberFormat;
        private UUID metadataId;
        private Boolean hasChanged;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder attributeOf(String attributeOf) {
            this.attributeOf = attributeOf;
            this.changedFields = changedFields.add("AttributeOf");
            return this;
        }

        public Builder attributeType(AttributeTypeCode attributeType) {
            this.attributeType = attributeType;
            this.changedFields = changedFields.add("AttributeType");
            return this;
        }

        public Builder attributeTypeName(AttributeTypeDisplayName attributeTypeName) {
            this.attributeTypeName = attributeTypeName;
            this.changedFields = changedFields.add("AttributeTypeName");
            return this;
        }

        public Builder columnNumber(Integer columnNumber) {
            this.columnNumber = columnNumber;
            this.changedFields = changedFields.add("ColumnNumber");
            return this;
        }

        public Builder description(Label description) {
            this.description = description;
            this.changedFields = changedFields.add("Description");
            return this;
        }

        public Builder displayName(Label displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("DisplayName");
            return this;
        }

        public Builder deprecatedVersion(String deprecatedVersion) {
            this.deprecatedVersion = deprecatedVersion;
            this.changedFields = changedFields.add("DeprecatedVersion");
            return this;
        }

        public Builder introducedVersion(String introducedVersion) {
            this.introducedVersion = introducedVersion;
            this.changedFields = changedFields.add("IntroducedVersion");
            return this;
        }

        public Builder entityLogicalName(String entityLogicalName) {
            this.entityLogicalName = entityLogicalName;
            this.changedFields = changedFields.add("EntityLogicalName");
            return this;
        }

        public Builder isAuditEnabled(BooleanManagedProperty isAuditEnabled) {
            this.isAuditEnabled = isAuditEnabled;
            this.changedFields = changedFields.add("IsAuditEnabled");
            return this;
        }

        public Builder isCustomAttribute(Boolean isCustomAttribute) {
            this.isCustomAttribute = isCustomAttribute;
            this.changedFields = changedFields.add("IsCustomAttribute");
            return this;
        }

        public Builder isPrimaryId(Boolean isPrimaryId) {
            this.isPrimaryId = isPrimaryId;
            this.changedFields = changedFields.add("IsPrimaryId");
            return this;
        }

        public Builder isPrimaryName(Boolean isPrimaryName) {
            this.isPrimaryName = isPrimaryName;
            this.changedFields = changedFields.add("IsPrimaryName");
            return this;
        }

        public Builder isValidForCreate(Boolean isValidForCreate) {
            this.isValidForCreate = isValidForCreate;
            this.changedFields = changedFields.add("IsValidForCreate");
            return this;
        }

        public Builder isValidForRead(Boolean isValidForRead) {
            this.isValidForRead = isValidForRead;
            this.changedFields = changedFields.add("IsValidForRead");
            return this;
        }

        public Builder isValidForUpdate(Boolean isValidForUpdate) {
            this.isValidForUpdate = isValidForUpdate;
            this.changedFields = changedFields.add("IsValidForUpdate");
            return this;
        }

        public Builder canBeSecuredForRead(Boolean canBeSecuredForRead) {
            this.canBeSecuredForRead = canBeSecuredForRead;
            this.changedFields = changedFields.add("CanBeSecuredForRead");
            return this;
        }

        public Builder canBeSecuredForCreate(Boolean canBeSecuredForCreate) {
            this.canBeSecuredForCreate = canBeSecuredForCreate;
            this.changedFields = changedFields.add("CanBeSecuredForCreate");
            return this;
        }

        public Builder canBeSecuredForUpdate(Boolean canBeSecuredForUpdate) {
            this.canBeSecuredForUpdate = canBeSecuredForUpdate;
            this.changedFields = changedFields.add("CanBeSecuredForUpdate");
            return this;
        }

        public Builder isSecured(Boolean isSecured) {
            this.isSecured = isSecured;
            this.changedFields = changedFields.add("IsSecured");
            return this;
        }

        public Builder isRetrievable(Boolean isRetrievable) {
            this.isRetrievable = isRetrievable;
            this.changedFields = changedFields.add("IsRetrievable");
            return this;
        }

        public Builder isFilterable(Boolean isFilterable) {
            this.isFilterable = isFilterable;
            this.changedFields = changedFields.add("IsFilterable");
            return this;
        }

        public Builder isSearchable(Boolean isSearchable) {
            this.isSearchable = isSearchable;
            this.changedFields = changedFields.add("IsSearchable");
            return this;
        }

        public Builder isManaged(Boolean isManaged) {
            this.isManaged = isManaged;
            this.changedFields = changedFields.add("IsManaged");
            return this;
        }

        public Builder isGlobalFilterEnabled(BooleanManagedProperty isGlobalFilterEnabled) {
            this.isGlobalFilterEnabled = isGlobalFilterEnabled;
            this.changedFields = changedFields.add("IsGlobalFilterEnabled");
            return this;
        }

        public Builder isSortableEnabled(BooleanManagedProperty isSortableEnabled) {
            this.isSortableEnabled = isSortableEnabled;
            this.changedFields = changedFields.add("IsSortableEnabled");
            return this;
        }

        public Builder linkedAttributeId(UUID linkedAttributeId) {
            this.linkedAttributeId = linkedAttributeId;
            this.changedFields = changedFields.add("LinkedAttributeId");
            return this;
        }

        public Builder logicalName(String logicalName) {
            this.logicalName = logicalName;
            this.changedFields = changedFields.add("LogicalName");
            return this;
        }

        public Builder isCustomizable(BooleanManagedProperty isCustomizable) {
            this.isCustomizable = isCustomizable;
            this.changedFields = changedFields.add("IsCustomizable");
            return this;
        }

        public Builder isRenameable(BooleanManagedProperty isRenameable) {
            this.isRenameable = isRenameable;
            this.changedFields = changedFields.add("IsRenameable");
            return this;
        }

        public Builder isValidForAdvancedFind(BooleanManagedProperty isValidForAdvancedFind) {
            this.isValidForAdvancedFind = isValidForAdvancedFind;
            this.changedFields = changedFields.add("IsValidForAdvancedFind");
            return this;
        }

        public Builder isValidForForm(Boolean isValidForForm) {
            this.isValidForForm = isValidForForm;
            this.changedFields = changedFields.add("IsValidForForm");
            return this;
        }

        public Builder isRequiredForForm(Boolean isRequiredForForm) {
            this.isRequiredForForm = isRequiredForForm;
            this.changedFields = changedFields.add("IsRequiredForForm");
            return this;
        }

        public Builder isValidForGrid(Boolean isValidForGrid) {
            this.isValidForGrid = isValidForGrid;
            this.changedFields = changedFields.add("IsValidForGrid");
            return this;
        }

        public Builder requiredLevel(AttributeRequiredLevelManagedProperty requiredLevel) {
            this.requiredLevel = requiredLevel;
            this.changedFields = changedFields.add("RequiredLevel");
            return this;
        }

        public Builder canModifyAdditionalSettings(BooleanManagedProperty canModifyAdditionalSettings) {
            this.canModifyAdditionalSettings = canModifyAdditionalSettings;
            this.changedFields = changedFields.add("CanModifyAdditionalSettings");
            return this;
        }

        public Builder schemaName(String schemaName) {
            this.schemaName = schemaName;
            this.changedFields = changedFields.add("SchemaName");
            return this;
        }

        public Builder externalName(String externalName) {
            this.externalName = externalName;
            this.changedFields = changedFields.add("ExternalName");
            return this;
        }

        public Builder isLogical(Boolean isLogical) {
            this.isLogical = isLogical;
            this.changedFields = changedFields.add("IsLogical");
            return this;
        }

        public Builder isDataSourceSecret(Boolean isDataSourceSecret) {
            this.isDataSourceSecret = isDataSourceSecret;
            this.changedFields = changedFields.add("IsDataSourceSecret");
            return this;
        }

        public Builder inheritsFrom(String inheritsFrom) {
            this.inheritsFrom = inheritsFrom;
            this.changedFields = changedFields.add("InheritsFrom");
            return this;
        }

        public Builder createdOn(OffsetDateTime createdOn) {
            this.createdOn = createdOn;
            this.changedFields = changedFields.add("CreatedOn");
            return this;
        }

        public Builder modifiedOn(OffsetDateTime modifiedOn) {
            this.modifiedOn = modifiedOn;
            this.changedFields = changedFields.add("ModifiedOn");
            return this;
        }

        public Builder sourceType(Integer sourceType) {
            this.sourceType = sourceType;
            this.changedFields = changedFields.add("SourceType");
            return this;
        }

        public Builder autoNumberFormat(String autoNumberFormat) {
            this.autoNumberFormat = autoNumberFormat;
            this.changedFields = changedFields.add("AutoNumberFormat");
            return this;
        }

        public Builder metadataId(UUID metadataId) {
            this.metadataId = metadataId;
            this.changedFields = changedFields.add("MetadataId");
            return this;
        }

        public Builder hasChanged(Boolean hasChanged) {
            this.hasChanged = hasChanged;
            this.changedFields = changedFields.add("HasChanged");
            return this;
        }

        public ComplexAttributeMetadata build() {
            ComplexAttributeMetadata _x = new ComplexAttributeMetadata();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.ComplexAttributeMetadata";
            _x.attributeOf = attributeOf;
            _x.attributeType = attributeType;
            _x.attributeTypeName = attributeTypeName;
            _x.columnNumber = columnNumber;
            _x.description = description;
            _x.displayName = displayName;
            _x.deprecatedVersion = deprecatedVersion;
            _x.introducedVersion = introducedVersion;
            _x.entityLogicalName = entityLogicalName;
            _x.isAuditEnabled = isAuditEnabled;
            _x.isCustomAttribute = isCustomAttribute;
            _x.isPrimaryId = isPrimaryId;
            _x.isPrimaryName = isPrimaryName;
            _x.isValidForCreate = isValidForCreate;
            _x.isValidForRead = isValidForRead;
            _x.isValidForUpdate = isValidForUpdate;
            _x.canBeSecuredForRead = canBeSecuredForRead;
            _x.canBeSecuredForCreate = canBeSecuredForCreate;
            _x.canBeSecuredForUpdate = canBeSecuredForUpdate;
            _x.isSecured = isSecured;
            _x.isRetrievable = isRetrievable;
            _x.isFilterable = isFilterable;
            _x.isSearchable = isSearchable;
            _x.isManaged = isManaged;
            _x.isGlobalFilterEnabled = isGlobalFilterEnabled;
            _x.isSortableEnabled = isSortableEnabled;
            _x.linkedAttributeId = linkedAttributeId;
            _x.logicalName = logicalName;
            _x.isCustomizable = isCustomizable;
            _x.isRenameable = isRenameable;
            _x.isValidForAdvancedFind = isValidForAdvancedFind;
            _x.isValidForForm = isValidForForm;
            _x.isRequiredForForm = isRequiredForForm;
            _x.isValidForGrid = isValidForGrid;
            _x.requiredLevel = requiredLevel;
            _x.canModifyAdditionalSettings = canModifyAdditionalSettings;
            _x.schemaName = schemaName;
            _x.externalName = externalName;
            _x.isLogical = isLogical;
            _x.isDataSourceSecret = isDataSourceSecret;
            _x.inheritsFrom = inheritsFrom;
            _x.createdOn = createdOn;
            _x.modifiedOn = modifiedOn;
            _x.sourceType = sourceType;
            _x.autoNumberFormat = autoNumberFormat;
            _x.metadataId = metadataId;
            _x.hasChanged = hasChanged;
            return _x;
        }
    }

    private ComplexAttributeMetadata _copy() {
        ComplexAttributeMetadata _x = new ComplexAttributeMetadata();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.attributeOf = attributeOf;
        _x.attributeType = attributeType;
        _x.attributeTypeName = attributeTypeName;
        _x.columnNumber = columnNumber;
        _x.description = description;
        _x.displayName = displayName;
        _x.deprecatedVersion = deprecatedVersion;
        _x.introducedVersion = introducedVersion;
        _x.entityLogicalName = entityLogicalName;
        _x.isAuditEnabled = isAuditEnabled;
        _x.isCustomAttribute = isCustomAttribute;
        _x.isPrimaryId = isPrimaryId;
        _x.isPrimaryName = isPrimaryName;
        _x.isValidForCreate = isValidForCreate;
        _x.isValidForRead = isValidForRead;
        _x.isValidForUpdate = isValidForUpdate;
        _x.canBeSecuredForRead = canBeSecuredForRead;
        _x.canBeSecuredForCreate = canBeSecuredForCreate;
        _x.canBeSecuredForUpdate = canBeSecuredForUpdate;
        _x.isSecured = isSecured;
        _x.isRetrievable = isRetrievable;
        _x.isFilterable = isFilterable;
        _x.isSearchable = isSearchable;
        _x.isManaged = isManaged;
        _x.isGlobalFilterEnabled = isGlobalFilterEnabled;
        _x.isSortableEnabled = isSortableEnabled;
        _x.linkedAttributeId = linkedAttributeId;
        _x.logicalName = logicalName;
        _x.isCustomizable = isCustomizable;
        _x.isRenameable = isRenameable;
        _x.isValidForAdvancedFind = isValidForAdvancedFind;
        _x.isValidForForm = isValidForForm;
        _x.isRequiredForForm = isRequiredForForm;
        _x.isValidForGrid = isValidForGrid;
        _x.requiredLevel = requiredLevel;
        _x.canModifyAdditionalSettings = canModifyAdditionalSettings;
        _x.schemaName = schemaName;
        _x.externalName = externalName;
        _x.isLogical = isLogical;
        _x.isDataSourceSecret = isDataSourceSecret;
        _x.inheritsFrom = inheritsFrom;
        _x.createdOn = createdOn;
        _x.modifiedOn = modifiedOn;
        _x.sourceType = sourceType;
        _x.autoNumberFormat = autoNumberFormat;
        _x.metadataId = metadataId;
        _x.hasChanged = hasChanged;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ComplexAttributeMetadata[");
        b.append("AttributeOf=");
        b.append(this.attributeOf);
        b.append(", ");
        b.append("AttributeType=");
        b.append(this.attributeType);
        b.append(", ");
        b.append("AttributeTypeName=");
        b.append(this.attributeTypeName);
        b.append(", ");
        b.append("ColumnNumber=");
        b.append(this.columnNumber);
        b.append(", ");
        b.append("Description=");
        b.append(this.description);
        b.append(", ");
        b.append("DisplayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("DeprecatedVersion=");
        b.append(this.deprecatedVersion);
        b.append(", ");
        b.append("IntroducedVersion=");
        b.append(this.introducedVersion);
        b.append(", ");
        b.append("EntityLogicalName=");
        b.append(this.entityLogicalName);
        b.append(", ");
        b.append("IsAuditEnabled=");
        b.append(this.isAuditEnabled);
        b.append(", ");
        b.append("IsCustomAttribute=");
        b.append(this.isCustomAttribute);
        b.append(", ");
        b.append("IsPrimaryId=");
        b.append(this.isPrimaryId);
        b.append(", ");
        b.append("IsPrimaryName=");
        b.append(this.isPrimaryName);
        b.append(", ");
        b.append("IsValidForCreate=");
        b.append(this.isValidForCreate);
        b.append(", ");
        b.append("IsValidForRead=");
        b.append(this.isValidForRead);
        b.append(", ");
        b.append("IsValidForUpdate=");
        b.append(this.isValidForUpdate);
        b.append(", ");
        b.append("CanBeSecuredForRead=");
        b.append(this.canBeSecuredForRead);
        b.append(", ");
        b.append("CanBeSecuredForCreate=");
        b.append(this.canBeSecuredForCreate);
        b.append(", ");
        b.append("CanBeSecuredForUpdate=");
        b.append(this.canBeSecuredForUpdate);
        b.append(", ");
        b.append("IsSecured=");
        b.append(this.isSecured);
        b.append(", ");
        b.append("IsRetrievable=");
        b.append(this.isRetrievable);
        b.append(", ");
        b.append("IsFilterable=");
        b.append(this.isFilterable);
        b.append(", ");
        b.append("IsSearchable=");
        b.append(this.isSearchable);
        b.append(", ");
        b.append("IsManaged=");
        b.append(this.isManaged);
        b.append(", ");
        b.append("IsGlobalFilterEnabled=");
        b.append(this.isGlobalFilterEnabled);
        b.append(", ");
        b.append("IsSortableEnabled=");
        b.append(this.isSortableEnabled);
        b.append(", ");
        b.append("LinkedAttributeId=");
        b.append(this.linkedAttributeId);
        b.append(", ");
        b.append("LogicalName=");
        b.append(this.logicalName);
        b.append(", ");
        b.append("IsCustomizable=");
        b.append(this.isCustomizable);
        b.append(", ");
        b.append("IsRenameable=");
        b.append(this.isRenameable);
        b.append(", ");
        b.append("IsValidForAdvancedFind=");
        b.append(this.isValidForAdvancedFind);
        b.append(", ");
        b.append("IsValidForForm=");
        b.append(this.isValidForForm);
        b.append(", ");
        b.append("IsRequiredForForm=");
        b.append(this.isRequiredForForm);
        b.append(", ");
        b.append("IsValidForGrid=");
        b.append(this.isValidForGrid);
        b.append(", ");
        b.append("RequiredLevel=");
        b.append(this.requiredLevel);
        b.append(", ");
        b.append("CanModifyAdditionalSettings=");
        b.append(this.canModifyAdditionalSettings);
        b.append(", ");
        b.append("SchemaName=");
        b.append(this.schemaName);
        b.append(", ");
        b.append("ExternalName=");
        b.append(this.externalName);
        b.append(", ");
        b.append("IsLogical=");
        b.append(this.isLogical);
        b.append(", ");
        b.append("IsDataSourceSecret=");
        b.append(this.isDataSourceSecret);
        b.append(", ");
        b.append("InheritsFrom=");
        b.append(this.inheritsFrom);
        b.append(", ");
        b.append("CreatedOn=");
        b.append(this.createdOn);
        b.append(", ");
        b.append("ModifiedOn=");
        b.append(this.modifiedOn);
        b.append(", ");
        b.append("SourceType=");
        b.append(this.sourceType);
        b.append(", ");
        b.append("AutoNumberFormat=");
        b.append(this.autoNumberFormat);
        b.append(", ");
        b.append("MetadataId=");
        b.append(this.metadataId);
        b.append(", ");
        b.append("HasChanged=");
        b.append(this.hasChanged);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
