package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "Name", 
    "Value", 
    "DataType", 
    "DisplayName", 
    "Description", 
    "SolutionUniqueName", 
    "HelpUrl", 
    "Category", 
    "Type", 
    "State"})
@JsonInclude(Include.NON_NULL)
public class AppSettingDetail implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("Name")
    protected String name;

    @JsonProperty("Value")
    protected String value;

    @JsonProperty("DataType")
    protected Integer dataType;

    @JsonProperty("DisplayName")
    protected String displayName;

    @JsonProperty("Description")
    protected String description;

    @JsonProperty("SolutionUniqueName")
    protected String solutionUniqueName;

    @JsonProperty("HelpUrl")
    protected String helpUrl;

    @JsonProperty("Category")
    protected Integer category;

    @JsonProperty("Type")
    protected Integer type;

    @JsonProperty("State")
    protected Integer state;

    protected AppSettingDetail() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.AppSettingDetail";
    }

    @Property(name="Name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public AppSettingDetail withName(String name) {
        Checks.checkIsAscii(name);
        AppSettingDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.AppSettingDetail");
        _x.name = name;
        return _x;
    }

    @Property(name="Value")
    @JsonIgnore
    public Optional<String> getValue() {
        return Optional.ofNullable(value);
    }

    public AppSettingDetail withValue(String value) {
        Checks.checkIsAscii(value);
        AppSettingDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.AppSettingDetail");
        _x.value = value;
        return _x;
    }

    @Property(name="DataType")
    @JsonIgnore
    public Optional<Integer> getDataType() {
        return Optional.ofNullable(dataType);
    }

    public AppSettingDetail withDataType(Integer dataType) {
        AppSettingDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.AppSettingDetail");
        _x.dataType = dataType;
        return _x;
    }

    @Property(name="DisplayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public AppSettingDetail withDisplayName(String displayName) {
        Checks.checkIsAscii(displayName);
        AppSettingDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.AppSettingDetail");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="Description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public AppSettingDetail withDescription(String description) {
        Checks.checkIsAscii(description);
        AppSettingDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.AppSettingDetail");
        _x.description = description;
        return _x;
    }

    @Property(name="SolutionUniqueName")
    @JsonIgnore
    public Optional<String> getSolutionUniqueName() {
        return Optional.ofNullable(solutionUniqueName);
    }

    public AppSettingDetail withSolutionUniqueName(String solutionUniqueName) {
        Checks.checkIsAscii(solutionUniqueName);
        AppSettingDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.AppSettingDetail");
        _x.solutionUniqueName = solutionUniqueName;
        return _x;
    }

    @Property(name="HelpUrl")
    @JsonIgnore
    public Optional<String> getHelpUrl() {
        return Optional.ofNullable(helpUrl);
    }

    public AppSettingDetail withHelpUrl(String helpUrl) {
        Checks.checkIsAscii(helpUrl);
        AppSettingDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.AppSettingDetail");
        _x.helpUrl = helpUrl;
        return _x;
    }

    @Property(name="Category")
    @JsonIgnore
    public Optional<Integer> getCategory() {
        return Optional.ofNullable(category);
    }

    public AppSettingDetail withCategory(Integer category) {
        AppSettingDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.AppSettingDetail");
        _x.category = category;
        return _x;
    }

    @Property(name="Type")
    @JsonIgnore
    public Optional<Integer> getType() {
        return Optional.ofNullable(type);
    }

    public AppSettingDetail withType(Integer type) {
        AppSettingDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.AppSettingDetail");
        _x.type = type;
        return _x;
    }

    @Property(name="State")
    @JsonIgnore
    public Optional<Integer> getState() {
        return Optional.ofNullable(state);
    }

    public AppSettingDetail withState(Integer state) {
        AppSettingDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.AppSettingDetail");
        _x.state = state;
        return _x;
    }

    public AppSettingDetail withUnmappedField(String name, String value) {
        AppSettingDetail _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String name;
        private String value;
        private Integer dataType;
        private String displayName;
        private String description;
        private String solutionUniqueName;
        private String helpUrl;
        private Integer category;
        private Integer type;
        private Integer state;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("Name");
            return this;
        }

        public Builder value(String value) {
            this.value = value;
            this.changedFields = changedFields.add("Value");
            return this;
        }

        public Builder dataType(Integer dataType) {
            this.dataType = dataType;
            this.changedFields = changedFields.add("DataType");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("DisplayName");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("Description");
            return this;
        }

        public Builder solutionUniqueName(String solutionUniqueName) {
            this.solutionUniqueName = solutionUniqueName;
            this.changedFields = changedFields.add("SolutionUniqueName");
            return this;
        }

        public Builder helpUrl(String helpUrl) {
            this.helpUrl = helpUrl;
            this.changedFields = changedFields.add("HelpUrl");
            return this;
        }

        public Builder category(Integer category) {
            this.category = category;
            this.changedFields = changedFields.add("Category");
            return this;
        }

        public Builder type(Integer type) {
            this.type = type;
            this.changedFields = changedFields.add("Type");
            return this;
        }

        public Builder state(Integer state) {
            this.state = state;
            this.changedFields = changedFields.add("State");
            return this;
        }

        public AppSettingDetail build() {
            AppSettingDetail _x = new AppSettingDetail();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.AppSettingDetail";
            _x.name = name;
            _x.value = value;
            _x.dataType = dataType;
            _x.displayName = displayName;
            _x.description = description;
            _x.solutionUniqueName = solutionUniqueName;
            _x.helpUrl = helpUrl;
            _x.category = category;
            _x.type = type;
            _x.state = state;
            return _x;
        }
    }

    private AppSettingDetail _copy() {
        AppSettingDetail _x = new AppSettingDetail();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.name = name;
        _x.value = value;
        _x.dataType = dataType;
        _x.displayName = displayName;
        _x.description = description;
        _x.solutionUniqueName = solutionUniqueName;
        _x.helpUrl = helpUrl;
        _x.category = category;
        _x.type = type;
        _x.state = state;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AppSettingDetail[");
        b.append("Name=");
        b.append(this.name);
        b.append(", ");
        b.append("Value=");
        b.append(this.value);
        b.append(", ");
        b.append("DataType=");
        b.append(this.dataType);
        b.append(", ");
        b.append("DisplayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("Description=");
        b.append(this.description);
        b.append(", ");
        b.append("SolutionUniqueName=");
        b.append(this.solutionUniqueName);
        b.append(", ");
        b.append("HelpUrl=");
        b.append(this.helpUrl);
        b.append(", ");
        b.append("Category=");
        b.append(this.category);
        b.append(", ");
        b.append("Type=");
        b.append(this.type);
        b.append(", ");
        b.append("State=");
        b.append(this.state);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
