package microsoft.dynamics.crm.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Translationprocess;
import microsoft.dynamics.crm.entity.collection.request.ProcesssessionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.WorkflowlogCollectionRequest;

@JsonIgnoreType
public class TranslationprocessRequest extends EntityRequest<Translationprocess> {

    public TranslationprocessRequest(ContextPath contextPath, Optional<Object> value) {
        super(Translationprocess.class, contextPath, value, false);
    }

    public SyncerrorRequest translationProcess_SyncErrors(String syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("TranslationProcess_SyncErrors").addKeys(new NameValue(syncerrorid.toString())), Optional.empty());
    }

    public SyncerrorCollectionRequest translationProcess_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("TranslationProcess_SyncErrors"), Optional.empty());
    }

    public KnowledgearticleRequest knowledgearticleid() {
        return new KnowledgearticleRequest(contextPath.addSegment("knowledgearticleid"), Optional.empty());
    }

    public SystemuserRequest modifiedbyname() {
        return new SystemuserRequest(contextPath.addSegment("modifiedbyname"), Optional.empty());
    }

    public WorkflowlogRequest workflowlogs_translationprocess(String workflowlogid) {
        return new WorkflowlogRequest(contextPath.addSegment("workflowlogs_translationprocess").addKeys(new NameValue(workflowlogid.toString())), Optional.empty());
    }

    public WorkflowlogCollectionRequest workflowlogs_translationprocess() {
        return new WorkflowlogCollectionRequest(
                        contextPath.addSegment("workflowlogs_translationprocess"), Optional.empty());
    }

    public WorkflowRequest processid() {
        return new WorkflowRequest(contextPath.addSegment("processid"), Optional.empty());
    }

    public SystemuserRequest modifiedonbehalfbyname() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfbyname"), Optional.empty());
    }

    public SystemuserRequest createdbyname() {
        return new SystemuserRequest(contextPath.addSegment("createdbyname"), Optional.empty());
    }

    public SystemuserRequest createdonbehalfbyname() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfbyname"), Optional.empty());
    }

    public OrganizationRequest organizationid() {
        return new OrganizationRequest(contextPath.addSegment("organizationid"), Optional.empty());
    }

    public ProcesssessionRequest translationProcess_ProcessSessions(String processsessionid) {
        return new ProcesssessionRequest(contextPath.addSegment("TranslationProcess_ProcessSessions").addKeys(new NameValue(processsessionid.toString())), Optional.empty());
    }

    public ProcesssessionCollectionRequest translationProcess_ProcessSessions() {
        return new ProcesssessionCollectionRequest(
                        contextPath.addSegment("TranslationProcess_ProcessSessions"), Optional.empty());
    }

    public TransactioncurrencyRequest transactioncurrencyid() {
        return new TransactioncurrencyRequest(contextPath.addSegment("transactioncurrencyid"), Optional.empty());
    }

    public ProcessstageRequest activestageid() {
        return new ProcessstageRequest(contextPath.addSegment("activestageid"), Optional.empty());
    }

}
