package microsoft.dynamics.crm.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Sdkmessagefilter;
import microsoft.dynamics.crm.entity.collection.request.SdkmessageprocessingstepCollectionRequest;

@JsonIgnoreType
public class SdkmessagefilterRequest extends EntityRequest<Sdkmessagefilter> {

    public SdkmessagefilterRequest(ContextPath contextPath, Optional<Object> value) {
        super(Sdkmessagefilter.class, contextPath, value, false);
    }

    public OrganizationRequest organizationid() {
        return new OrganizationRequest(contextPath.addSegment("organizationid"), Optional.empty());
    }

    public SdkmessageprocessingstepRequest sdkmessagefilterid_sdkmessageprocessingstep(String sdkmessageprocessingstepid) {
        return new SdkmessageprocessingstepRequest(contextPath.addSegment("sdkmessagefilterid_sdkmessageprocessingstep").addKeys(new NameValue(sdkmessageprocessingstepid.toString())), Optional.empty());
    }

    public SdkmessageprocessingstepCollectionRequest sdkmessagefilterid_sdkmessageprocessingstep() {
        return new SdkmessageprocessingstepCollectionRequest(
                        contextPath.addSegment("sdkmessagefilterid_sdkmessageprocessingstep"), Optional.empty());
    }

    public SystemuserRequest modifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), Optional.empty());
    }

    public SystemuserRequest createdby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), Optional.empty());
    }

    public SystemuserRequest createdonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), Optional.empty());
    }

    public SdkmessageRequest sdkmessageid() {
        return new SdkmessageRequest(contextPath.addSegment("sdkmessageid"), Optional.empty());
    }

    public SystemuserRequest modifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), Optional.empty());
    }

}
