package microsoft.dynamics.crm.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Pluginassembly;
import microsoft.dynamics.crm.entity.collection.request.PlugintypeCollectionRequest;

@JsonIgnoreType
public class PluginassemblyRequest extends EntityRequest<Pluginassembly> {

    public PluginassemblyRequest(ContextPath contextPath, Optional<Object> value) {
        super(Pluginassembly.class, contextPath, value, false);
    }

    public SystemuserRequest createdby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), Optional.empty());
    }

    public PlugintypeRequest pluginassembly_plugintype(String plugintypeid) {
        return new PlugintypeRequest(contextPath.addSegment("pluginassembly_plugintype").addKeys(new NameValue(plugintypeid.toString())), Optional.empty());
    }

    public PlugintypeCollectionRequest pluginassembly_plugintype() {
        return new PlugintypeCollectionRequest(
                        contextPath.addSegment("pluginassembly_plugintype"), Optional.empty());
    }

    public OrganizationRequest organizationid() {
        return new OrganizationRequest(contextPath.addSegment("organizationid"), Optional.empty());
    }

    public SystemuserRequest modifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), Optional.empty());
    }

    public SystemuserRequest createdonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), Optional.empty());
    }

    public SystemuserRequest modifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), Optional.empty());
    }

}
