package microsoft.dynamics.crm.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.FunctionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Mobileofflineprofileitem;
import microsoft.dynamics.crm.entity.collection.request.MobileofflineprofileitemassociationCollectionRequest;

@JsonIgnoreType
public class MobileofflineprofileitemRequest extends EntityRequest<Mobileofflineprofileitem> {

    public MobileofflineprofileitemRequest(ContextPath contextPath, Optional<Object> value) {
        super(Mobileofflineprofileitem.class, contextPath, value, false);
    }

    public SystemuserRequest createdonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), Optional.empty());
    }

    public MobileofflineprofileRequest regardingobjectid() {
        return new MobileofflineprofileRequest(contextPath.addSegment("regardingobjectid"), Optional.empty());
    }

    public MobileofflineprofileitemassociationRequest mobileOfflineProfileItem_MobileOfflineProfileItemAssociation(String mobileofflineprofileitemassociationid) {
        return new MobileofflineprofileitemassociationRequest(contextPath.addSegment("MobileOfflineProfileItem_MobileOfflineProfileItemAssociation").addKeys(new NameValue(mobileofflineprofileitemassociationid.toString())), Optional.empty());
    }

    public MobileofflineprofileitemassociationCollectionRequest mobileOfflineProfileItem_MobileOfflineProfileItemAssociation() {
        return new MobileofflineprofileitemassociationCollectionRequest(
                        contextPath.addSegment("MobileOfflineProfileItem_MobileOfflineProfileItemAssociation"), Optional.empty());
    }

    public SystemuserRequest modifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), Optional.empty());
    }

    public OrganizationRequest organizationid() {
        return new OrganizationRequest(contextPath.addSegment("organizationid"), Optional.empty());
    }

    public SystemuserRequest modifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), Optional.empty());
    }

    public SavedqueryRequest profileitemrule() {
        return new SavedqueryRequest(contextPath.addSegment("profileitemrule"), Optional.empty());
    }

    public SystemuserRequest createdby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), Optional.empty());
    }

    @Function(name = "RetrieveUnpublished")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<Mobileofflineprofileitem> retrieveUnpublished() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<Mobileofflineprofileitem>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrieveUnpublished"), Mobileofflineprofileitem.class, _parameters);
    }

}
