package microsoft.dynamics.crm.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Fieldpermission;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;

@JsonIgnoreType
public class FieldpermissionRequest extends EntityRequest<Fieldpermission> {

    public FieldpermissionRequest(ContextPath contextPath, Optional<Object> value) {
        super(Fieldpermission.class, contextPath, value, false);
    }

    public SyncerrorRequest fieldPermission_SyncErrors(String syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("FieldPermission_SyncErrors").addKeys(new NameValue(syncerrorid.toString())), Optional.empty());
    }

    public SyncerrorCollectionRequest fieldPermission_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("FieldPermission_SyncErrors"), Optional.empty());
    }

    public FieldsecurityprofileRequest fieldsecurityprofileid() {
        return new FieldsecurityprofileRequest(contextPath.addSegment("fieldsecurityprofileid"), Optional.empty());
    }

    public SolutionRequest solution_fieldpermission() {
        return new SolutionRequest(contextPath.addSegment("solution_fieldpermission"), Optional.empty());
    }

}
